/******************************************************************************
 *                    Copyright 2014-2017 aQuantia Corporation
 *                    Confidential and Proprietary
 *
 * $File: aqdiag.h $
 *
 * $Revision: $
 *
 * $DateTime: $
 *
 * $Author:   $
 *
 ******************************************************************************/
#include <linux/kernel.h>
#include <linux/version.h>
#include <linux/device.h>
#include <linux/pci.h>
#include <linux/ioctl.h>
#include <linux/wait.h>
#include <linux/spinlock.h>
#include <linux/idr.h>
#include <linux/slab.h>
#include <linux/stat.h>
#include <asm/uaccess.h>

#include "../include/linux_ioctl.h"

#ifndef UINT64_MAX
#define UINT64_MAX ~0ULL
#endif

#define AQDIAG_MAX_DEVS 256

enum int_type {
    LEGACY_INTERRUPT = 0,
    MSI = 1,
    MSIX = 2
};

struct aqdiag_interrupts {
	enum int_type type;
	int num;
	struct msix_entry *msix_entries;
	struct aqdiag_vector *vecs;
	void (*disable)(struct pci_dev*);
};

struct aqdiag_vector {
	spinlock_t lock;
	atomic_t count;
	uint64_t last;
	uint64_t min;
	uint64_t max;
	wait_queue_head_t wait;
	unsigned irq;
	int index;
	char name[16];
};

enum aqdiag_state {
	AQDSTATE_REMOVING,
};

struct aqdiag_dev {
	struct pci_dev *pdev;
	struct aqdiag_interrupts interrupts;
	struct kobject *sysfs_bars;
	struct aqdiag_bar *sysfs_bar[PCI_ROM_RESOURCE]; // 6 BARs excl. ROM

	struct kobject *sysfs_mem;
	struct idr memreg_idr;
	struct mutex memreg_lock;
	struct list_head mem_regions;

	int minor;
	struct device dev;
	struct list_head devices;
	unsigned long state;
};

struct aqdiag_memreg {
	int index;
	void *vaddr; //in-kernel
	dma_addr_t paddr;
	uint32_t size;
	uint32_t real_size;
	/* struct vmarea *mapping; */
	struct aqdiag_dev *dev;
	struct list_head list;
	struct kobject kobj;
	struct bin_attribute mmap_attr;
};

struct aqdiag_bar {
	struct kobject kobj;
	/* struct resource *res; */
	int index;
	phys_addr_t addr;
	phys_addr_t len;
};

extern struct kobj_type memreg_type;

extern int aqdiag_create_attrs(struct aqdiag_dev *dev);
extern void aqdiag_del_attrs(struct aqdiag_dev *dev);
extern int aqdiag_publish_memreg(struct aqdiag_memreg *memreg);
extern void aqdiag_hide_memreg(struct aqdiag_memreg *memreg);
extern int aqdiag_init_interrupts(struct aqdiag_dev *dev);
extern void aqdiag_free_irqs(struct aqdiag_dev *dev);
extern int aqdiag_req_int(struct aqdiag_dev *dev, struct aqdiag_req_int __user *req);
extern void aqdiag_cancel_req(struct aqdiag_dev *dev);
