<?php

class XMLAPICommand
{
    const ParaALL = "255";
    const ParaUnknown = "127";

	const MV_Package_VD_StartInit =
	"
	<MV_Package_VD_StartInit type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <LD_ID type='U16'>%LD_ID%</LD_ID>
	  <Init_Type type='U8'>%Init_Type%</Init_Type>
	</MV_Package_VD_StartInit>
	";

    const MV_Package_VD_StartCC =
	"
	<MV_Package_VD_StartCC type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <LD_ID type='U16'>%LD_ID%</LD_ID>
	  <Type type='U8'>%Type%</Type>
	</MV_Package_VD_StartCC>
	";

	const MV_PackageVD_GetInfo =
	"
	<MV_Package_VD_GetInfo type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
        <PackageVD_Info type='struct PackageVD_Info'>
            <RequestHeader type='struct RequestHeader'>
		        <requestType type='U8'>%requestType%</requestType>
		        <startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
		        <numRequested type='U16'>%numRequested%</numRequested>
            </RequestHeader>
        </PackageVD_Info>
	</MV_Package_VD_GetInfo>
	";

    const MV_Package_VD_GetConfig =
    "
    <MV_Package_VD_GetConfig type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
        <PVD_Config type='struct PVD_Config'>
            <RequestHeader type='struct RequestHeader'>
		        <requestType type='U8'>%requestType%</requestType>
		        <startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
		        <numRequested type='U16'>%numRequested%</numRequested>
            </RequestHeader>
        </PVD_Config>
	</MV_Package_VD_GetConfig>
    ";

    const MV_Package_VD_Create =
    "
    <MV_Package_VD_Create type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
        <Create_Package_VD_Param type='struct Create_Package_VD_Param'>
            <RaidMode type='U8'>%RaidMode%</RaidMode>
            <PDCount type='U8'>%PDCount%</PDCount>
            <PDIDs type='U16'>%PDIDs%</PDIDs>
            <SubVDCount type='U8'>%SubVDCount%</SubVDCount>
            <StripeBlockSize type='U16'>%StripeBlockSize%</StripeBlockSize>
            <NumParityDisk type='U8'>%NumParityDisk%</NumParityDisk>
            <CachePolicy type='U8'>%CachePolicy%</CachePolicy>
            <DiskCache type='U8'>%DiskCache%</DiskCache>
            <InitializationOption type='U8'>%InitializationOption%</InitializationOption>
            <Name type='U8'>%Name%</Name>
            <RoundingScheme type='U8'>%RoundingScheme%</RoundingScheme>
        </Create_Package_VD_Param>
	</MV_Package_VD_Create>
    ";

	const MV_Package_VD_Delete =
	"
	<MV_Package_VD_Delete type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<LD_ID type='U16'>%LD_ID%</LD_ID>
	        <deleteMBR type='U8'>%deleteMBR%</deleteMBR>
	</MV_Package_VD_Delete>
	";

	const MV_Package_VD_StartRebuild =
	"
	<MV_Package_VD_StartRebuild type='function'>
	    <AdapterID type='U8'>%AdapterID%</AdapterID>
		<RebuildParam type='struct Rebuild_Param' >
			<ID type='MV_U16'>%ID%</ID>
			<RebuildType type='MV_U8'>%RebuildType%</RebuildType>
			<PDCount type='MV_U8'>%PDCount%</PDCount>
			<PDIDs type='U16'>%PDIDs%</PDIDs>
		</RebuildParam>
	</MV_Package_VD_StartRebuild>
	";

    const MV_Package_VD_StartMigration =
	"
	<MV_Package_VD_StartMigration type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <CreateLDParam type='struct CreateLDParam'>
	    <LDID type='U16'>%LDID%</LDID>
	    <RaidMode type='U8'>%RaidMode%</RaidMode>
	    <NumParityDisk type='U8'>%NumParityDisk%</NumParityDisk>
	    <HDCount type='U8'>%HDCount%</HDCount>
	    <HDIDs type='U16'>%HDIDs%</HDIDs>
	  </CreateLDParam>
	</MV_Package_VD_StartMigration>
	";

    const MV_Package_VD_Get_Size =
	"
	<MV_Package_VD_Get_Size type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <CreateLDParam type='struct CreateLDParam'>
	    <LDID type='U16'>%LDID%</LDID>
	    <RaidMode type='U8'>%RaidMode%</RaidMode>
	    <NumParityDisk type='U8'>%NumParityDisk%</NumParityDisk>
	    <HDCount type='U8'>%HDCount%</HDCount>
	    <HDIDs type='U16'>%HDIDs%</HDIDs>
	  </CreateLDParam>
	</MV_Package_VD_Get_Size>
	";

	const MV_Package_VD_BGAControl =
	"
	<MV_Package_VD_BGAControl type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <ID type='U16'>%ID%</ID>
	  <Actions type='U8'>%Actions%</Actions>
	</MV_Package_VD_BGAControl>
	";

	const MV_Package_VD_SetConfig =
	"
	<MV_Package_VD_SetConfig type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<LD_ID type='U16'>%LD_ID%</LD_ID>
		<Package_Config type='struct Package_Config'>
			<CacheMode type='U8'>%CacheMode%</CacheMode>
			<WriteCacheOn type='U8'>%WriteCacheOn%</WriteCacheOn>
			<LDID type='U16'>%LDID%</LDID>
			<Name type='U8'>%Name%</Name>
		</Package_Config>
	</MV_Package_VD_SetConfig>
	";

    const MV_StringEncode =
    "
        <MV_StringEncode type='function'>
	        <szsource>%sztarget%</szsource>
        </MV_StringEncode>
    ";

    const MV_StringDecode =
    "
        <MV_StringDecode type='function'>
	        <sztarget>%sztarget%</sztarget>
        </MV_StringDecode>
    ";

    const MV_Adapter_Set_OEM_Data =
    "
        <MV_Adapter_Set_OEM_Data type='function'>
	    <AdapterID type='U8'>%AdapterID%</AdapterID>
	    <id type='U8'>%id%</id>
	    <type type='U8'>%type%</type>
	    <value type='U8'>%value%</value>
        </MV_Adapter_Set_OEM_Data>
        ";

    const MV_Adapter_Get_OEM_Data = 
    "
        <MV_Adapter_Get_OEM_Data type='function'>
            <AdapterID type='U8'>%AdapterID%</AdapterID>
	    <id type='U8'>%id%</id>
	    <type type='U8'>%type%</type>
	    <value type='U8'>%value%</value>
        </MV_Adapter_Get_OEM_Data>
        ";

    const MV_Adapter_Get_OEM_Data_Ver =
    "
        <MV_Adapter_Get_OEM_Data_Ver type='function'>
            <AdapterID type='U8'>%AdapterID%</AdapterID>
        </MV_Adapter_Get_OEM_Data_Ver>
        ";

    const MV_Adapter_Get_OEM_Info =
    "
        <MV_Adapter_Get_OEM_Info type='function'>
            <AdapterID type='U8'>%AdapterID%</AdapterID>
        </MV_Adapter_Get_OEM_Info>
        ";
    
	const MV_HyperDuo_Intelligent_Init =
    "
        <MV_HyperDuo_Intelligent_Init>
            <AdapterID type='U8'>%AdapterID%</AdapterID>
            <HyperDuo_ID>%HyperDuo_ID%</HyperDuo_ID>
        <MV_HyperDuo_Intelligent_Init>
        ";

    const MV_API_RescanAdapter =
    "
         <MV_API_RescanAdapter type='function'>
          </MV_API_RescanAdapter >
        ";
    
    const MV_SSD_GetFWImgVersion =
    "
        <MV_SSD_GetFWImgVersion type='function'>
                    <AdapterID type='U8'>%AdapterID%</AdapterID>
                    <filepath type='U8'>%filepath%</filepath>
        </MV_SSD_GetFWImgVersion>
        ";

    const MV_SSD_Download_Firmware =
    "
        <MV_SSD_Download_Firmware type='function'>
                     <AdapterID type='U8'>%AdapterID%</AdapterID>
                    <filepath type='U8'>%filepath%</filepath>
                    <force type='U8'>%force%</force>
        </MV_SSD_Download_Firmware>
        ";

    const MV_SSD_Version =
    "<MV_SSD_Version  type='function'>
             <AdapterID type='U8'>%AdapterID%</AdapterID>
        </MV_SSD_Version>
        ";

    const MV_SSD_AdapterCount =
    "
        <MV_SSD_AdapterCount  type='function'>
                     <AdapterID type='U8'>%AdapterID%</AdapterID>
        </MV_SSD_AdapterCount>
        ";

    const MV_SSD_AdapterInfo =
    "
        <MV_SSD_AdapterInfo  type='function'>
             <AdapterID type='U8'>%AdapterID%</AdapterID>
        </MV_SSD_AdapterInfo>
        ";

    const MV_SSD_CreateFlashDuo =
    "
        <MV_SSD_CreateFlashDuo  type='function'>
             <AdapterID type='U8'>%AdapterID%</AdapterID>
             <startLBA type='U32'>%startLBA%</startLBA>
             <length type='U32'>%length%</length>
        </MV_SSD_CreateFlashDuo>
        ";

    const MV_SSD_CreateHyperSSD =
    "
        <MV_SSD_CreateHyperSSD  type='function'>
             <AdapterID type='U8'>%AdapterID%</AdapterID>
             <startLBA type='U32'>%startLBA%</startLBA>
             <length type='U32'>%length%</length>
        </MV_SSD_CreateHyperSSD>
         ";

    const MV_SSD_CreateSSD =
    "
        <MV_SSD_CreateSSD  type='function'>
             <AdapterID type='U8'>%AdapterID%</AdapterID>
             <startLBA type='U32'>%startLBA%</startLBA>
             <length type='U32'>%length%</length>
        </MV_SSD_CreateSSD>
        ";

    const MV_SSD_CreateStandBy =
    "
        <MV_SSD_CreateStandBy  type='function'>
             <AdapterID type='U8'>%AdapterID%</AdapterID>
             <startLBA type='U32'>%startLBA%</startLBA>
             <length type='U32'>%length%</length>
        </MV_SSD_CreateStandBy>
        ";

    const MV_SSD_DeletePartition =
    "
        <MV_SSD_DeletePartition  type='function'>
             <AdapterID type='U8'>%AdapterID%</AdapterID>
             <partitionID type='U32'>%partitionID%</partitionID>
             <type type='U8'>%type%</type>
        </MV_SSD_DeletePartition>
        ";

    const MV_SSD_GetAvailableFreeDisk =
    "
        <MV_SSD_GetAvailableFreeDisk  type='function'>
            <AdapterID type='U8'>%AdapterID%</AdapterID>
            <disk_info_Request type='struct Info_Request'>
                <RequestHeader type='struct RequestHeader'>
                  <requestType type='U8'>%requestType%</requestType>
                  <startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
                  <numRequested type='U16'>%numRequested%</numRequested>
                </RequestHeader>
            </disk_info_Request>
        </MV_SSD_GetAvailableFreeDisk>
        ";

    const MV_SSD_GetPartitionList =
    "
        <MV_SSD_GetPartitionList  type='function'>
             <AdapterID type='U8'>%AdapterID%</AdapterID>
             <partition_list_Request type='struct Info_Request'>
                  <RequestHeader type='struct RequestHeader'>
                      <requestType type='U8'>%requestType%</requestType>
                      <startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
                      <numRequested type='U16'>%numRequested%</numRequested>
                 </RequestHeader>
            </partition_list_Request>
        </MV_SSD_GetPartitionList>
        ";

    const MV_SSD_GetHyperSSDList =
    "
        <MV_SSD_GetHyperSSDList type='function'>
             <AdapterID type='U8'>%AdapterID%</AdapterID>
             <hyperssd_list_Request type='struct Info_Request'>
                  <RequestHeader type='struct RequestHeader'>
                      <requestType type='U8'>%requestType%</requestType>
                      <startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
                      <numRequested type='U16'>%numRequested%</numRequested>
                 </RequestHeader>
             </hyperssd_list_Request>
        </MV_SSD_GetHyperSSDList>
        ";

   /* const MV_SSD_GetPartition_Link =
    "
        <MV_SSD_GetPartition_Link  type='function'>
             <AdapterID type='U8'>%AdapterID%</AdapterID>
             <partition_link_Request type='struct Info_Request'>
                      <RequestHeader type='struct RequestHeader'>
                          <requestType type='U8'>%requestType%</requestType>
                          <startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
                          <numRequested type='U16'>%numRequested%</numRequested>
                     </RequestHeader>
             </partition_link_Request>
        </MV_SSD_GetPartition_Link>
        ";
*/
    const MV_SSD_LinkHyper =
    "
        <MV_SSD_LinkHyper  type='function'>
             <AdapterID type='U8'>%AdapterID%</AdapterID>
             <partition type='U32'>%partition%</partition>
             <disk_info_t type='struct disk_info_t'>
                  <disk_number>%disk_number%</disk_number>
                  <model>%model%</model>
                  <serial>%serial%</serial>
             </disk_info_t>
        </MV_SSD_LinkHyper>
        ";

    const MV_SSD_RemoveLinkHyper =
    "
        <MV_SSD_RemoveLinkHyper  type='function'>
             <AdapterID type='U8'>%AdapterID%</AdapterID>
             <partition type='U8'>%partition%</partition>
        </MV_SSD_RemoveLinkHyper>
        ";

    const MV_SSD_GetSetting =
    "
        <MV_SSD_GetSetting  type='function'>
             <AdapterID type='U8'>%AdapterID%</AdapterID>
        </MV_SSD_GetSetting>
        ";

    const MV_SSD_SetSetting =
    "
        <MV_SSD_SetSetting  type='function'>
             <AdapterID type='U8'>%AdapterID%</AdapterID>
             <ssd_api_setting type='struct disk_info_t'>
                  <hyper_watermark type='U8'>%hyper_watermark%</hyper_watermark>
                  <hyper_policy type='U8'>%hyper_policy%</hyper_policy>
                  <cache_policy type='U8'>%cache_policy%</cache_policy>
             </ssd_api_setting>
        </MV_SSD_SetSetting>
        ";

    const MV_AES_ForcePDOnline =
    "<MV_AES_ForcePDOnline type='function'>
             <AdapterID type='U8'>%AdapterID%</AdapterID>
             <PDID type='U8'>%PDID%</PDID>
             <Percentage type='U8'>%Percentage%</Percentage>
             <AES_Entry_Config type='struct AES_Entry_Config'>
                  <entry_id type=='U16'>%entry_id%</entry_id>
                  <key_length type=='U8'>%key_length%</key_length>
                  <key_content type=='U8'>%key_content%</key_content>
                  <user_auth type=='U8'>%user_auth%</user_auth>
            </AES_Entry_Config>
        </MV_AES_ForcePDOnline>
        ";
    
    const MV_AES_SetLink =
    "
        <MV_AES_SetLink type='function'>
             <AdapterID type='U8'>%AdapterID%</AdapterID>
             <entry_link type='struct entry_link'>
                 <port_id type='U16'>%port_id%</port_id>
                 <entry type='U16'>%entry_id%</entry>
                 <user_auth type='U8'>%user_auth%</user_auth>
             </entry_link>
        </MV_AES_SetLink>
        ";

    const MV_AES_ClearLink =
    "
        <MV_AES_ClearLink type='function'>
                  <AdapterID type='U8'>%AdapterID%</AdapterID>
                  <port_id type='U16'>%port_id%</port_id>
        </MV_AES_ClearLink>
        ";
    
    const MV_AES_SetPortConfig =
    "
        <MV_AES_SetPortConfig type='function'>
                  <AdapterID type='U8'>%AdapterID%</AdapterID>
                 <AES_Port_Config type='struct AES_Port_Config'>
                         <port_id type='U16'>%port_id%</port_id>
                         <aes_enable type='U8'>%aes_enable%</aes_enable>
                 </AES_Port_Config>
        </MV_AES_SetPortConfig>
        ";

    const MV_AES_ChangePwd =
    "
        <MV_AES_ChangePwd type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
          <AES_Change_Passwd type='struct AES_Change_Passwd'>
                 <entry_id type='U16'>%entry_id%</entry_id>
                 <old_user_auth type='U8'>%old_user_auth%</old_user_auth>
                 <new_user_auth type='U8'>%new_user_auth%</new_user_auth>
          </AES_Change_Passwd>
        </MV_AES_ChangePwd>
        ";
    const MV_AES_SetEntryConfig  =
    "
	<MV_AES_SetEntryConfig  type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <AES_Entry_Config type='struct AES_Entry_Config'>
                 <entry_id type='U16'>%entry_id%</entry_id>
                 <key_length type='U8'>%key_length%</key_length>
                 <key_content type='U8'>%key_content%</key_content>
                 <user_auth type='U8'>%user_auth%</user_auth>
         </AES_Entry_Config>
	</MV_AES_SetEntryConfig >
	";

    const MV_AES_GetEntryInfo =
    "
        <MV_AES_GetEntryInfo type='function'>
         <AdapterID type='U8'>%AdapterID%</AdapterID>
        </MV_AES_GetEntryInfo>
    "
    ;

    const MV_AES_GetPortConfig =
	"
	<MV_AES_GetPortConfig type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <AES_Port_Config_Request type='struct Info_Request'>
	    <RequestHeader type='struct RequestHeader'>
	      <requestType type='U8'>%requestType%</requestType>
	      <startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
	      <numRequested type='U16'>%numRequested%</numRequested>
	    </RequestHeader>
	  </AES_Port_Config_Request>
	</MV_AES_GetPortConfig>
	";

    const MV_AES_GetEntryConfig =
	"
	<MV_AES_GetEntryConfig type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <AES_Entry_Config_Request type='struct Info_Request'>
	    <RequestHeader type='struct RequestHeader'>
	      <requestType type='U8'>%requestType%</requestType>
	      <startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
	      <numRequested type='U16'>%numRequested%</numRequested>
	    </RequestHeader>
	  </AES_Entry_Config_Request>
	</MV_AES_GetEntryConfig>
	";

    const MV_SYS_GetSubDirList =
    "
        <MV_SYS_GetSubDirList>
            <ParentFolder>%ParentFolder%</ParentFolder>
        </MV_SYS_GetSubDirList>
        ";
    
    const MV_HyperDuo_Delete=
    "
        <MV_HyperDuo_Delete type='function'>
            <AdapterID type='U8'>%AdapterID%</AdapterID>
            <HyperDuo_ID type='U16'>%HyperDuo_ID%</HyperDuo_ID>
	    <deleteMBR type='U8'>%deleteMBR%</deleteMBR>
        </MV_HyperDuo_Delete>
        ";

    const MV_HyperDuo_Available=
    "
        <MV_HyperDuo_Available type='function'>
            <AdapterID type='U8'>%AdapterID%</AdapterID>
        </MV_HyperDuo_Available>
        ";

    const MV_Accelerator_UpdateSSDVolFreeSize =
    "
        <MV_Accelerator_UpdateSSDVolFreeSize>
        </MV_Accelerator_ UpdateSSDVolFreeSize >
        ";
    
    const MV_SSD_SupportHDD =
    "
        <MV_SSD_SupportHDD>
        </MV_SSD_SupportHDD>
        ";
    const MV_Accelerator_UpdateAPP =
    "
        <MV_Accelerator_UpdateAPP type='function'>
            <AppID type='U32'>%AppID%</AppID>
        </MV_Accelerator_UpdateAPP>
        ";
    
	const MV_HyperHDD_GetMaxSize = 
	"
	<MV_HyperHDD_GetMaxSize type='function'>
        <AdapterID type='U8'>%AdapterID%</AdapterID>
		<Hyper_Free_Info type='struct Hyper_Free_Info'>
			<ID type='U16'>%ID%</ID>
		</Hyper_Free_Info> 
	</MV_HyperHDD_GetMaxSize>
	";
	
        const MV_HyperHDD_Create =
        "
	<MV_HyperHDD_Create type='function'>
                   <AdapterID type='U8'>%AdapterID%</AdapterID>
                    <HyperHDDCreate type='struct HyperHDDCreate'>
                             <HyperWaterMark>%HyperWaterMark%</HyperWaterMark>
                             <RaidMode>%RaidMode%</RaidMode>
                             <SSDCount>%SSDCount%</SSDCount>
                             <SSDIDs>%SSDIDs%</SSDIDs>
                             <HDCount>%HDCount%</HDCount>
                             <HDIDs type='U16'>%HDIDs%</HDIDs>
                             <Size type='U64'>%Size%</Size>
                             <KeepData type='U8'>%KeepData%</KeepData>
                   </HyperHDDCreate>
        </MV_HyperHDD_Create>
	";

    const MV_Accelerator_AddValidVolumeTaskForAccelerate =
    "
    <MV_Accelerator_AddValidVolumeTaskForAccelerate type='function'>
    </MV_Accelerator_AddValidVolumeTaskForAccelerate>
    ";

	const MV_Accelerator_StartScanAPP = 
	"
	<MV_Accelerator_StartScanAPP type='function'>
	</MV_Accelerator_StartScanAPP>
	";

    const MV_Accelerator_Maintain =
	"
	<MV_Accelerator_Maintain type='function'>
	</MV_Accelerator_Maintain>
	";

    const MV_Accelerator_GetStatus =
	"
	<MV_Accelerator_GetStatus type='function'>
	</MV_Accelerator_GetStatus>
	";
	
	const MV_Accelerator_GetValidVolume=
	"
	<MV_Accelerator_GetValidVolume type='function'>
	</MV_Accelerator_GetValidVolume>
	";

	
    const MV_Accelerator_IsRunning =
    "
        <MV_Accelerator_IsRunning type='function'>               
        </MV_Accelerator_IsRunning >
    ";

    const MV_Accelerator_StartTaskInDB =
    "
        <MV_Accelerator_StartTaskInDB type='function'>
        </MV_Accelerator_StartTaskInDB >
    ";

    const MV_Accelerator_AutoSelectApp=
	"
	<MV_Accelerator_AutoSelectApp type='function'>
            <Volume type='U8'>%Volume%</Volume>
	</MV_Accelerator_AutoSelectApp>
	";

    const MV_Accelerator_Stop =
    "
        <MV_Accelerator_Stop type='function'>
        </MV_Accelerator_Stop >
    ";

    const MV_Accelerator_Pause =
    "
        <MV_Accelerator_Pause type='function'>
        </MV_Accelerator_Pause >
    ";

    const MV_Accelerator_Resume =
    "
        <MV_Accelerator_Resume type='function'>
        </MV_Accelerator_Resume >
    ";

    const MV_Accelerator_ScanApp =
    "
        <MV_Accelerator_ScanApp type='function'>
        </MV_Accelerator_ScanApp >
    ";

    const MV_Accelerator_IsScanningApp =
    "
        <MV_Accelerator_IsScanningApp type='function'>
        </MV_Accelerator_IsScanningApp >
    ";

    const MV_Accelerator_Info =
    "
        <MV_Accelerator_Info type='function'>
        </MV_Accelerator_Info >
    ";

	const MV_LD_DG_QuickCreate =
	"
	<MV_LD_DG_QuickCreate type='function'>
        <AdapterID type='U8'>%AdapterID%</AdapterID>
        <Type type='U8'>%Type%</Type>
        </MV_LD_DG_QuickCreate >
	";
	
	const MV_LD_GetDefaultPara =
	"
	<MV_LD_GetDefaultPara type='function'>
        <AdapterID type='U8'>%AdapterID%</AdapterID>
	</MV_LD_GetDefaultPara>
	";
	
	const MV_SSD_GetVolumeAllocation =
	"
	<MV_SSD_GetVolumeAllocation type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<OpLevel type='U16'>%OpLevel%</OpLevel>
		<CreateParam type='struct Create_LD_Param'>
			<RaidMode type='U8'>%RaidMode%</RaidMode>
			<HDCount type='U8'>%HDCount%</HDCount>
			<HDIDs type='U16'>%HDIDs%</HDIDs>
		</CreateParam>
    </MV_SSD_GetVolumeAllocation>
	";
	
	const MV_LD_Report =
	"
	<MV_LD_Report  type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
        <LD_ID type='U16'>%LD_ID%</LD_ID>
    </MV_LD_Report>
	";
	
	const MV_SSD_UpdateIMG =
	"
	<MV_SSD_UpdateIMG type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
	    <Actions type='U8'>%Actions%</Actions>
	    <Type type='U8'>%Type%</Type>
	    <filepath type='U8'>%filepath%</filepath>
	</MV_SSD_UpdateIMG>
	";
	
	const MV_SSD_GetVolumnInfo = 
	"
	<MV_SSD_GetVolumnInfo type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
        <Info_Request type='struct Info_Request'>
            <RequestHeader type='struct RequestHeader'>
				<requestType type='U8'>%requestType%</requestType>
				<startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
				<numRequested type='U16'>%numRequested%</numRequested>
            </RequestHeader>
        </Info_Request>
    </MV_SSD_GetVolumnInfo>
	";
	
	const MV_SSD_GetCurrentCreatePara =
	"
	<MV_SSD_GetCurrentCreatePara type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
	</MV_SSD_GetCurrentCreatePara>
	";
	
	const MV_SSD_GetInfo =
	"
	<MV_SSD_GetInfo type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
        <SSD_Info_Request type='struct  SSD_Info_Request'>
            <RequestHeader type='struct RequestHeader'>
				<requestType type='U8'>%requestType%</requestType>
				<startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
				<numRequested type='U16'>%numRequested%</numRequested>
			</RequestHeader>
		</SSD_Info_Request>
    </MV_SSD_GetInfo>
	";
	
	const MV_SSD_GetStatusALL =
	"
	<MV_SSD_GetStatusALL type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
    </MV_SSD_GetStatusALL>
	";
	
	const MV_SSD_CreateVD =
	"
	<MV_SSD_CreateVD  type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<Percentage type='U8'>%Percentage%</Percentage>
		<RaidMode type='U8'>%RaidMode%</RaidMode>
	</MV_SSD_CreateVD>
	";
	
	const MV_SSD_SetPercentage_Single =
	"
	<MV_SSD_SetPercentageSingle type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<DeviceID type='U8'>%DeviceID%</DeviceID>
		<Percentage type='U8'>%Percentage%</Percentage>
	</MV_SSD_SetPercentageSingle> 
	";

	const MV_SSDVolume_GetMaxSize =
	"
	<MV_SSDVolume_GetMaxSize type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<OpLevel type='U16'>%OpLevel%</OpLevel>
		<CreateParam type='struct Create_LD_Param'>
			<RaidMode type='U8'>%RaidMode%</RaidMode>
			<HDCount type='U8'>%HDCount%</HDCount>
			<HDIDs type='U16'>%HDIDs%</HDIDs>
		</CreateParam>
	</MV_SSDVolume_GetMaxSize>
	";
	
	const MV_LogonUser=
	"
	<MV_LogonUser type='function'>
	        <lpszUsername>%lpszUsername%</lpszUsername>
	        <lpszDomain>%lpszDomain%</lpszDomain>
	        <lpszPassword>%lpszPassword%</lpszPassword>
	</MV_LogonUser>
	";
	const MV_SendEmail=
	"
	<MV_SendEmail type='function'>
	        <lpszSMTPServer>%lpszSMTPServer%</lpszSMTPServer>
	        <lpszUser>%lpszUser%</lpszUser>
	        <lpszPassword>%lpszPassword%</lpszPassword>
	        <lpIsSSL type='U8'>%lpIsSSL%</lpIsSSL>
		<lpszSubject>%lpszSubject%</lpszSubject>
	        <lpszRecipient>%lpszRecipient%</lpszRecipient>
	        <lpszBody>%lpszBody%</lpszBody>
	</MV_SendEmail>
	";
	
	const MV_GetUserGroup=
	"
	<MV_GetUserGroup type='function'>
	        <lpszUsername>%lpszUsername%</lpszUsername>
	        <lpszDomain>%lpszDomain%</lpszDomain>
	</MV_GetUserGroup>
	";
	
	//bios flash related
	const MV_Flash_Option = 
	"
	<MV_Flash_Option type='function'>
	    <AdapterID>%AdapterID%</AdapterID>
	    <Actions>%Actions%</Actions>
	    <Type>%Type%</Type>
	    <filepath>%filepath%</filepath>
	</MV_Flash_Option>
	";
	
	const MV_BIOS_Version = 
	"
	<MV_BIOS_Version type='function'>
	    <filepath>%filepath%</filepath>
	</MV_BIOS_Version>
	";
	
	const MV_BIN_Version = 
	"
	<MV_BIN_Version type='function'>
	    <AdapterID type='U8'>%AdapterID%</AdapterID>
	    <filepath type='U8'>%filepath%</filepath>
	    <Type type='U8'>%Type%</Type>
	</MV_BIN_Version>
	";

	//DG Cmd
	
	const MV_DG_Create = 
	"
	<MV_DG_Create  type='function'>
		<AdapterID>%AdapterID%</AdapterID>
		<CreateOrModifyDGParam type='struct CreateOrModifyDGParam' >
			<Name type='U8'>%Name%</Name>
			<RaidMode type='MV_U8'>%RaidMode%</RaidMode>
			<SubVDCount type='MV_U8'>%SubVDCount%</SubVDCount>
			<NumParityDisk type='MV_U8'>%NumParityDisk%</NumParityDisk>
			<StripeBlockSize type='MV_U16'>%StripeBlockSize%</StripeBlockSize>
			<Size type='U64'>%Size%</Size>
			<BlockSize type='MV_U32'>%BlockSize%</BlockSize>
			<InitializationOption type='MV_U8'>%InitializationOption%</InitializationOption>
			<PDCount type='MV_U8'>%PDCount%</PDCount>
			<PDIDs type='U16'>%PDIDs%</PDIDs>
		</CreateOrModifyDGParam>
	</MV_DG_Create>
	";

	const MV_DG_GetSizeOnly = 
	"
	<MV_DG_GetSizeOnly  type='function'>
		<AdapterID>%AdapterID%</AdapterID>
		<CreateOrModifyDGParam type='struct CreateOrModifyDGParam' >
			<DGID type='MV_U16'>%DGID%</DGID>
			<Name type='U8'>%Name%</Name>
			<RaidMode type='MV_U8'>%RaidMode%</RaidMode>
			<SubVDCount type='MV_U8'>%SubVDCount%</SubVDCount>
			<NumParityDisk type='MV_U8'>%NumParityDisk%</NumParityDisk>
			<StripeBlockSize type='MV_U16'>%StripeBlockSize%</StripeBlockSize>
			<Size type='U64'>%Size%</Size>
			<BlockSize type='MV_U32'>%BlockSize%</BlockSize>
			<InitializationOption type='MV_U8'>%InitializationOption%</InitializationOption>
			<PDCount type='MV_U8'>%PDCount%</PDCount>
			<PDIDs type='U16'>%PDIDs%</PDIDs>
		</CreateOrModifyDGParam>
	</MV_DG_GetSizeOnly>
	";
	
    const MV_DG_Modify =
    "
    <MV_DG_Modify type='function'>
    	<AdapterID>%AdapterID%</AdapterID>
    	<CreateOrModifyDGParam type='struct CreateOrModifyDGParam'>
    		<DGID type='MV_U16'>%DGID%</DGID>
    		<Name type='U8'>%Name%</Name>
			<RaidMode type='MV_U8'>%RaidMode%</RaidMode>
			<SubVDCount type='MV_U8'>%SubVDCount%</SubVDCount>
			<NumParityDisk type='MV_U8'>%NumParityDisk%</NumParityDisk>
			<StripeBlockSize type='MV_U16'>%StripeBlockSize%</StripeBlockSize>
			<Size type='U64'>%Size%</Size>
			<BlockSize type='MV_U32'>%BlockSize%</BlockSize>
			<InitializationOption type='MV_U8'>%InitializationOption%</InitializationOption>
			<PDCount type='MV_U8'>%PDCount%</PDCount>
			<PDIDS type='U16'>%PDIDS%</PDIDS>
		</CreateOrModifyDGParam>
	</MV_DG_Modify>
	";	

	const MV_DG_GetInfo = 
	"
	<MV_DG_GetInfo type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<DG_Info_Request type='struct DG_Info_Request'>
		    <RequestHeader type='struct RequestHeader'>
		      <requestType type='U8'>%requestType%</requestType>
		      <startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
		      <numRequested type='U16'>%numRequested%</numRequested>
		    </RequestHeader>
    	</DG_Info_Request>
	</MV_DG_GetInfo>
	";
	
	const MV_DG_Delete = 
	"
	<MV_DG_Delete type='function'>
		<AdapterID>%AdapterID%</AdapterID>
		<DG_ID type='MV_U16'>%DG_ID%</DG_ID>
	</MV_DG_Delete>
	";
	
	
    const MV_LD_DG_StartRebuild = 
	"
	<MV_LD_DG_StartRebuild type='function'>
		<AdapterID>%AdapterID%</AdapterID>
		<RebuildParam type='struct Rebuild_Param' >
			<ID type='MV_U16'>%ID%</ID>
			<RebuildType type='MV_U8'>%RebuildType%</RebuildType>
			<PDCount type='MV_U8'>%PDCount%</PDCount>
			<PDIDs type='U16'>%PDIDs%</PDIDs>
		</RebuildParam>
	</MV_LD_DG_StartRebuild>
	";
	
	const DG_StartConsistencyCheck = 
	"
	<MV_DG_StartConsistencyCheck type='function'>
		<AdapterID>%AdapterID%</AdapterID>
		<DG_ID type='MV_U16'>%DG_ID%</DG_ID>
		<Type type='MV_U8'>%Type%</Type>
	</MV_DG_StartConsistencyCheck>
	";
		
    const MV_DG_StartINIT = 
	"
	<MV_DG_StartINIT type='function'>
		<AdapterID>%AdapterID%</AdapterID>
		<DG_ID type='MV_U16'>%DG_ID%</DG_ID>
		<Init_Type type='MV_U8'>%Init_Type%</Init_Type>
	</MV_DG_StartINIT>
	";
	
 
    const MV_DG_StartMigration = 
	"
	<MV_DG_StartMigration type='function'>
		<AdapterID>%AdapterID%</AdapterID>
		<MigrateDG type='struct CreateOrModify_DG_Param' >
			<DGID type='MV_U16'>%DGID%</DGID>
			<RaidMode type='MV_U8'>%RaidMode%</RaidMode>
			<NumParityDisk type='MV_U8'>%NumParityDisk%</NumParityDisk>
			<PDCount type='MV_U8'>%PDCount%</PDCount>
			<PDIDs type='U16'>%PDIDs%</PDIDs>
		</MigrateDG>
	</MV_DG_StartMigration>
	";
	
    const MV_DG_BGAControl = 
	"
	<MV_DG_BGAControl type='function'>
		<AdapterID type='MV_U8'>%AdapterID%</AdapterID>
		<DG_ID type='MV_U16'>%DG_ID%</DG_ID>
		<Actions type='MV_U8'>%Actions%</Actions>
	</MV_DG_BGAControl>
	";
	
	const MV_DG_GetConfig=
	" 
    <MV_DG_GetConfig type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<DG_Config_Request type='struct DG_Config_Request'>
		    <RequestHeader type='struct RequestHeader'>
		      <requestType type='U8'>%requestType%</requestType>
		      <startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
		      <numRequested type='U16'>%numRequested%</numRequested>
		    </RequestHeader>
    	</DG_Config_Request>
    </MV_DG_GetConfig>
    ";
	
	const MV_DG_SetConfig = 
	" 
	<MV_DG_SetConfig type='function'>
   		<AdapterID type='MV_U8'>%AdapterID%</AdapterID>
		<DG_ID type='MV_U16'>%DGID%</DG_ID>
		<Config type='struct DG_Config'>
			<DGID type='MV_U16'>%DGID%</DGID>
			<Name type='MV_U16'>%Name%</Name>
			<WriteCacheOn type='MV_BOOLEAN'>%WriteCacheOn%</WriteCacheOn>
		</Config>
	</MV_DG_SetConfig>
	";
	
	const MV_LD_Create_OnDG = 
	"
	 <MV_LD_Create_OnDG type='function'>
   	     <AdapterID type='MV_U8'>%AdapterID%</AdapterID>
	     <CreateOrModifyVDParam type='struct Create_LD_Param'>
		    <DGID type='U16'>%DGID%</DGID>
		    <Name type='U8'>%Name%</Name>
		    <StripeBlockSize type='U16'>%StripeBlockSize%</StripeBlockSize>
		    <Size type='U64'>%Size%</Size>
		    <DGSlotNum type='U8'>%DGSlotNum%</DGSlotNum>		    
		    <RoundingScheme type='U8'>%RoundingScheme%</RoundingScheme>
		    <CachePolicy type='U8'>%CachePolicy%</CachePolicy>
		    <InitializationOption type='U8'>%InitializationOption%</InitializationOption>
		    <SectorCoefficient type='U8'>%SectorCoefficient%</SectorCoefficient>
		 </CreateOrModifyVDParam>
	</MV_LD_Create_OnDG>
	";
	//LD Cmd
	
	const MV_LD_GetStatus=
	" 
    <MV_LD_GetStatus type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<LD_Status_Request type='struct LD_Status_Request'>
		    <RequestHeader type='struct RequestHeader'>
		      <requestType type='U8'>%requestType%</requestType>
		      <startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
		      <numRequested type='U16'>%numRequested%</numRequested>
		    </RequestHeader>
    	</LD_Status_Request>
    </MV_LD_GetStatus>
    ";
	
	const MV_LD_GetConfig=
	" 
	<MV_LD_GetConfig type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<LD_Config_Request type='struct LD_Config_Request'>
		    <RequestHeader type='struct RequestHeader'>
		      <requestType type='U8'>%requestType%</requestType>
		      <startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
		      <numRequested type='U16'>%numRequested%</numRequested>
		    </RequestHeader>
		</LD_Config_Request>
	</MV_LD_GetConfig>
    ";
	
	const MV_LD_GetInfo = 
	"
	<MV_LD_GetInfo type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<LD_Info_Request type='struct LD_Info_Request'>
		    <RequestHeader type='struct RequestHeader'>
		      <requestType type='U8'>%requestType%</requestType>
		      <startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
		      <numRequested type='U16'>%numRequested%</numRequested>
		    </RequestHeader>
  		</LD_Info_Request>
	</MV_LD_GetInfo>
	";
	
	const MV_LD_SetConfig = 
	" 
	<MV_LD_SetConfig type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<LD_ID type='U16'>%LD_ID%</LD_ID>
		<LDConfig type='struct LD_Config'>
			<CacheMode type='U8'>%CacheMode%</CacheMode>
			<AutoRebuildOn type='U8'>%AutoRebuildOn%</AutoRebuildOn>
			<Status type='U8'>%Status%</Status>
			<LDID type='U16'>%LDID%</LDID>
			<Name type='U8'>%Name%</Name>
			<HypperWaterMark type='U8'>%HypperWaterMark%</HypperWaterMark>
		</LDConfig>
	</MV_LD_SetConfig>
	";
	
	const MV_LD_Import = 
	"
	<MV_LD_Import type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
  		<LD_ID type='U16'>%LD_ID%</LD_ID>
	</MV_LD_Import>
	"; 
	
	//HD

	const MV_PD_GET_SMART_INFO =
	"
	<MV_PD_GET_SMART_INFO type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
  		<HD_ID type='U16'>%HD_ID%</HD_ID>
	</MV_PD_GET_SMART_INFO>
	";

	const MV_PD_GetHDInfo =
	"
	<MV_PD_GetHDInfo type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<HD_Info_Request type='struct HD_Info_Request'>
			<RequestHeader type='struct RequestHeader'>
				<requestType type='U8'>%requestType%</requestType>
				<startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
				<numRequested type='U16'>%numRequested%</numRequested>
			</RequestHeader>
		</HD_Info_Request>
	</MV_PD_GetHDInfo>
	";
	
	const MV_PD_GetFreeSpaceInfo = 
	"
	<MV_PD_GetFreeSpaceInfo type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<HD_FreeSpaceInfo_Request type='struct HD_FreeSpaceInfo_Request'>
			<RequestHeader type='struct RequestHeader'>
				<requestType type='U8'>%requestType%</requestType>
				<startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
				<numRequested type='U16'>%numRequested%</numRequested>
			</RequestHeader>
		</HD_FreeSpaceInfo_Request>
	</MV_PD_GetFreeSpaceInfo>
	";
	
	const MV_PD_GetConfig = 
	" 
	<MV_PD_GetConfig type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<HD_Config_Request type='struct HD_Config_Request'>
			<RequestHeader type='struct RequestHeader'>
				<requestType type='U8'>%requestType%</requestType>
				<startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
				<numRequested type='U16'>%numRequested%</numRequested>
			</RequestHeader>
		</HD_Config_Request>
	</MV_PD_GetConfig>
	";
	
	const MV_PD_GetRCT = 
	"
	<MV_PD_GetRCT type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<HD_ID type='U16'>%HD_ID%</HD_ID>
		<n type='U32'>%Num%</n>
		<s type='U32'>%Start%</s>
		<e type='U32'>%End%</e>
	</MV_PD_GetRCT>
	"; 

	const MV_PD_RCT_GetCount =
	"
	<MV_PD_RCT_GetCount type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<HD_ID type='U16'>%HD_ID%</HD_ID>
	</MV_PD_RCT_GetCount>
	";
	
	const MV_PD_GetMPStatus = 
	" 
	<MV_PD_GetMPStatus type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<HD_MP_Status_Request type='struct HD_MP_Status_Request'>
			<RequestHeader type='struct RequestHeader'>
				<requestType type='U8'>%requestType%</requestType>
				<startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
				<numRequested type='U16'>%numRequested%</numRequested>
			</RequestHeader>
		</HD_MP_Status_Request>
	</MV_PD_GetMPStatus>
	";
	
	const MV_PD_GetHDRaidStatus = 
	" 
	<MV_PD_GetHDRaidStatus type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<HD_RAID_Status_Request type='struct HD_RAID_Status_Request'>
			<RequestHeader type='struct RequestHeader'>
				<requestType type='U8'>%requestType%</requestType>
				<startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
				<numRequested type='U16'>%numRequested%</numRequested>
			</RequestHeader>
		</HD_RAID_Status_Request>
	</MV_PD_GetHDRaidStatus>
	";
	
	const MV_PD_SetConfig = 
	" 
	<MV_PD_SetConfig type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <HD_ID type='U16'>%HD_ID%</HD_ID>
	  <Config type='struct HD_Config'>
	      <WriteCacheOn type='U8'>%WriteCacheOn%</WriteCacheOn>
	      <SMARTOn type='U8'>%SMARTOn%</SMARTOn>
	      <Online type='U8'>%Online%</Online>
	      <DriveSpeed type='U8'>%DriveSpeed%</DriveSpeed>
	      <HDID type='U16'>%HDID%</HDID>
	    </Config>
	</MV_PD_SetConfig>
	";
	
	const MV_PD_SetHDStatus = 
	"
	<MV_PD_SetHDStatus type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<HD_ID type='U16'>%HD_ID%</HD_ID>
		<Action type='U8'>%Action%</Action>
	</MV_PD_SetHDStatus>
	";
	
	const MV_PD_WipeHDMDD = 
	"
	<MV_PD_WipeHDMDD type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<HD_ID type='U16'>%HD_ID%</HD_ID>
		<Force type='U8'>%Force%</Force>
	</MV_PD_WipeHDMDD>
	"
	;
	
	//pd bga control
	const MV_PD_StartDataScrub = 
	"
	<MV_PD_StartDataScrub type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<HD_ID type='U16'>%HD_ID%</HD_ID>
	</MV_PD_StartDataScrub>
	"
	;
	
	const MV_PD_GetBGAStatus = 
	"
	<MV_PD_GetBGAStatus type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<HD_BGA_Status_Request type='struct HD_BGA_Status'>
			<RequestHeader type='struct RequestHeader'>
				<requestType type='U8'>%requestType%</requestType>
				<startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
				<numRequested type='U16'>%numRequested%</numRequested>
			</RequestHeader>
		</HD_BGA_Status_Request>
	</MV_PD_GetBGAStatus>
	"
	;
	
	const MV_PD_BGAControl = 
	"
	<MV_PD_BGAControl type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<HD_ID type='U16'>%HD_ID%</HD_ID>
		<Action type='U8'>%Action%</Action>
	</MV_PD_BGAControl>
	"
	;
	
	const MV_PD_StartMediaPatrol = 
	"
	<MV_PD_StartMediaPatrol type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <HD_ID type='U16'>%HD_ID%</HD_ID>
	</MV_PD_StartMediaPatrol>
	";
	
	const MV_LocateArrayDevice = 
	"
	<MV_LocateArrayDevice type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <deviceType type='U8'>%deviceType%</deviceType>
	  <deviceId type='U16'>%deviceId%</deviceId>
	  <ledStatus type='U8'>%ledStatus%</ledStatus>
	</MV_LocateArrayDevice>
	";
	
	//Encl
	
	const MV_ENC_GetEnclosureInfo =
	"
	<MV_ENC_GetEnclosureInfo type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <Enclosure_Info_Request type='struct Enclosure_Info_Request'>
			<RequestHeader type='struct RequestHeader'>
				<requestType type='U8'>%requestType%</requestType>
				<startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
				<numRequested type='U16'>%numRequested%</numRequested>
			</RequestHeader>
	  </Enclosure_Info_Request>
	</MV_ENC_GetEnclosureInfo>
	";
	
	const MV_ENC_GetElementInfo =
	"
	<MV_ENC_GetElementInfo type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <ENC_ID type='U16'>%ENC_ID%</ENC_ID>
	</MV_ENC_GetElementInfo>
	";
	
	const MV_ENC_GetElementConfig =
	"
	<MV_ENC_GetElementConfig type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <ENC_ID type='U16'>%ENC_ID%</ENC_ID>
	</MV_ENC_GetElementConfig>
	";
	
	const MV_ENC_SetElementConfig =
	"
	<MV_ENC_SetElementConfig type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <ENC_ID type='U16'>%ENC_ID%</ENC_ID>
	  <Config type='struct EncElement_Config'>
	      <type type='U8'>%type%</type>
	      <highCriticalThreshold type='U8'>%highCriticalThreshold%</highCriticalThreshold>
	      <highWarningThreshold type='U8'>%highWarningThreshold%</highWarningThreshold>
	      <lowCriticalThreshold type='U8'>%lowCriticalThreshold%</lowCriticalThreshold>
	      <lowWarningThreshold type='U8'>%lowWarningThreshold%</lowWarningThreshold>
	  </Config>
	</MV_ENC_SetElementConfig>
	";
	
	//block
	
	const MV_BLK_GetInfo = 
	"
	<MV_BLK_GetInfo type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<Block_Info_Request type='struct Block_Info_Request'>
			<RequestHeader type='struct RequestHeader'>
				<requestType type='U8'>%requestType%</requestType>
				<startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
				<numRequested type='U16'>%numRequested%</numRequested>
			</RequestHeader>
		</Block_Info_Request>
	</MV_BLK_GetInfo>
	";
	
	//event
	
	const ZA_MV_EVT_GetEvents = 
	"
	<ZA_MV_EVT_GetEvents type='function'>
	  <n type='U32'>%Num%</n>
	  <s type='U32'>%Start%</s>
	</ZA_MV_EVT_GetEvents>
	";
	
	const ZA_MV_EVT_GetChangeCounters = 
	"
	<ZA_MV_EVT_GetChangeCounters type='function'>
	</ZA_MV_EVT_GetChangeCounters>
	";
	
	const ZA_MV_EVT_Reset = 
	"
	<ZA_MV_EVT_Reset type='function'>
	</ZA_MV_EVT_Reset>
	";
	
	//HBA
	
	const MV_Adapter_GetInfo = 
	"
	<MV_Adapter_GetInfo type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	</MV_Adapter_GetInfo>
	";
	
	const MV_Adapter_GetConfig = 
	"<MV_Adapter_GetConfig type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
	</MV_Adapter_GetConfig>";
	
	const MV_Adapter_GetCount = 
	' 
	<MV_Adapter_GetCount type="function">
	</MV_Adapter_GetCount>
	';
	
	const MV_Adapter_SetConfig = 
	" 
	<MV_Adapter_SetConfig type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<AdapterConfig type='struct Adapter_Config_V2'>
			<AlarmOn type='U8'>%AlarmOn%</AlarmOn>
			<AutoRebuildOn type='U8'>%AutoRebuildOn%</AutoRebuildOn>
			<BGARate type='U8'>%BGARate%</BGARate>
			<PollSMARTStatus type='U8'>%PollSMARTStatus%</PollSMARTStatus>			
			<MediaPatrolRate type='U8'>%MediaPatrolRate%</MediaPatrolRate>
			<CopyBack type='U8'>%CopyBack%</CopyBack>
			<SyncRate type='U8'>%SyncRate%</SyncRate>
			<InitRate type='U8'>%InitRate%</InitRate>
			<RebuildRate type='U8'>%RebuildRate%</RebuildRate>
			<MigrationRate type='U8'>%MigrationRate%</MigrationRate>
			<CopybackRate type='U8'>%CopybackRate%</CopybackRate>
			<InterruptCoalescing type='U8'>%InterruptCoalescing%</InterruptCoalescing>
			<ModuleConsolidate type='U8'>%ModuleConsolidate%</ModuleConsolidate>
		</AdapterConfig>
	</MV_Adapter_SetConfig>
	";

	const MV_AdapterMute =
	'
	<MV_AdapterMute type="function">
            <AdapterID type="U8">%AdapterID%</AdapterID>
	</MV_AdapterMute>
	';

	const MV_BBU_SetThreshold = 
	" 
	<MV_BBU_SetThreshold  type='function'>
		<AdapterID type='MV_U8'>%AdapterID%</AdapterID>
		<tempLowerBound type='MV_U16'>%tempLowerBound%</tempLowerBound>
		<tempUpperBound type='MV_U16'>%tempUpperBound%</tempUpperBound>
		<volLowerBound type='MV_U16'>%volLowerBound%</volLowerBound>
		<volUpperBound type='MV_U16'>%volUpperBound%</volUpperBound>
	</MV_BBU_SetThreshold>
	";
	//bga
	const MV_LD_StartINIT = 
	" 
	<MV_LD_StartINIT type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <LD_ID type='U16'>%LD_ID%</LD_ID>
	  <Init_Type type='U8'>%Init_Type%</Init_Type>
	</MV_LD_StartINIT>
	";
	
	const MV_LD_BGAControl = 
	" 
	<MV_LD_BGAControl type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <LD_ID type='U16'>%LD_ID%</LD_ID>
	  <Actions type='U8'>%Actions%</Actions>
	</MV_LD_BGAControl>
	";
	
	//create ld

    //   Type =>0  raid0,  1  raid ,   2 HyperDuo, HyperDuoMode =>HyperDuo safe/capacity
	const MV_LD_QuickCreate = 
	" 
	<MV_LD_QuickCreate type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<Type type='U8'>%Type%</Type>
                <HyperDuoMode  type='U8'>%HyperDuoMode %</HyperDuoMode >
	</MV_LD_QuickCreate>
	";
	const MV_LD_Create = 
	" 
	<MV_LD_Create type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<CreateLDParam type='struct Create_LD_Param'>
			<RaidMode type='U8'>%RaidMode%</RaidMode>
			<HDCount type='U8'>%HDCount%</HDCount>
			<RoundingScheme type='U8'>%RoundingScheme%</RoundingScheme>
			<SubLDCount type='U8'>%SubLDCount%</SubLDCount>
			<StripeBlockSize type='U16'>%StripeBlockSize%</StripeBlockSize>
			<Raid6Redundancy type='U8'>%Raid6Redundancy%</Raid6Redundancy>
			<CachePolicy type='U8'>%CachePolicy%</CachePolicy>
			<InitializationOption type='U8'>%InitializationOption%</InitializationOption>
			<HDIDs type='U16'>%HDIDs%</HDIDs>
			<NumParityDisk type='U8'>%NumParityDisk%</NumParityDisk>
			<SectorCoefficient  type='U8'>%SectorCoefficient%</SectorCoefficient>
			<Name type='U8'>%Name%</Name>
			<Size type='U64'>%Size%</Size>
			<HypperWaterMark type='U8'>%HypperWaterMark%</HypperWaterMark>
		</CreateLDParam>
	</MV_LD_Create>
	";
	
	//delete ld
	const MV_LD_Delete =
	" 
	<MV_LD_Delete type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
	    <LD_ID type='U16'>%LD_ID%</LD_ID>
	    <deleteMBR type='U16'>%deleteMBR%</deleteMBR>
	</MV_LD_Delete>
	";
	
	const MV_LD_GetMaxSize = //StripeBlockSize??
	"
	<MV_LD_GetMaxSize type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<CreateLDParam type='struct Create_LD_Param'>
			<RaidMode type='U8'>%RaidMode%</RaidMode>
			<HDCount type='U8'>%HDCount%</HDCount>
			<RoundingScheme type='U8'>%RoundingScheme%</RoundingScheme>
			<SubLDCount type='U8'>%SubLDCount%</SubLDCount>
			<StripeBlockSize type='U16'>%StripeBlockSize%</StripeBlockSize>
			<Raid6Redundancy type='U8'>%Raid6Redundancy%</Raid6Redundancy>
			<CachePolicy type='U8'>%CachePolicy%</CachePolicy>
			<InitializationOption type='U8'>%InitializationOption%</InitializationOption>
			<SectorCoefficient  type='U8'>%SectorCoefficient%</SectorCoefficient>
			<NumParityDisk type='U8'>%NumParityDisk%</NumParityDisk>
			<HDIDs type='U16'>%HDIDs%</HDIDs>
			<Name type='U8'>%Name%</Name>
			<Size type='U64'>%Size%</Size>
		</CreateLDParam>
	</MV_LD_GetMaxSize>
	";
	
	const MV_LD_StartRebuild =
	"
	<MV_LD_StartRebuild type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <LD_ID type='U16'>%LD_ID%</LD_ID>
	  <Rebuild_HD_ID type='U8'>%Rebuild_HD_ID%</Rebuild_HD_ID>
	</MV_LD_StartRebuild>
	";
	
	const MV_LD_StartConsistencyCheck = 
	"
	<MV_LD_StartConsistencyCheck type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <LD_ID type='U16'>%LD_ID%</LD_ID>
	  <Type type='U8'>%Type%</Type>
	</MV_LD_StartConsistencyCheck>
	";
	
	const MV_LD_StartMigration = 
	"
	<MV_LD_StartMigration type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  <CreateLDParam type='struct Create_LD_Param'>
	    <RaidMode type='U8'>%RaidMode%</RaidMode>
	    <HDCount type='U8'>%HDCount%</HDCount>
	    <LDID type='U16'>%LDID%</LDID>
	    <HDIDs type='U16'>%HDIDs%</HDIDs>
	    <NumParityDisk type='U8'>%NumParityDisk%</NumParityDisk>
	  </CreateLDParam>
	</MV_LD_StartMigration>
	";
	
	const MV_LD_GetMigratedLdSize = 
	"
	<MV_LD_GetMigratedLdSize type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<CreateLDParam type='struct Create_LD_Param'>
			<RaidMode type='U8'>%RaidMode%</RaidMode>
			<HDCount type='U8'>%HDCount%</HDCount>
			<LDID type='U16'>%LDID%</LDID>
			<HDIDs type='U16'>%HDIDs%</HDIDs>
			<NumParityDisk type='U8'>%NumParityDisk%</NumParityDisk>
		</CreateLDParam>reateLDParam>
	</MV_LD_GetMigratedLdSize>
	";
	
	const MV_LD_GetTargetLDInfo = 
	"
	<MV_LD_GetTargetLDInfo type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<LD_ID type='U16'>%LD_ID%</LD_ID>
	</MV_LD_GetTargetLDInfo>
	";
	
	const MV_PD_GetMBRInfo =
	"
	<MV_PD_GetMBRInfo type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<HD_MBR_Info_Request type='struct HD_MBR_Info_Request'>
			<RequestHeader type='struct RequestHeader'>
				<requestType type='U8'>%requestType%</requestType>
				<startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
				<numRequested type='U16'>%numRequested%</numRequested>
			</RequestHeader>
		</HD_MBR_Info_Request>
    </MV_PD_GetMBRInfo>
	";
	
	//spare
	const MV_PD_Spare2FreeHD =
	" 
	<MV_PD_Spare2FreeHD type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<HD_ID type='U16'>%HD_ID%</HD_ID>
	</MV_PD_Spare2FreeHD>
	";
	
	const MV_PD_Get_FreeList =
	"
	<MV_PD_Get_FreeList type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	</MV_Adapter_GetInfo>
	";
	
	const MV_PD_FreeHD2GlobalSpare =
	" 
	<MV_PD_FreeHD2GlobalSpare type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<HD_ID type='U16'>%HD_ID%</HD_ID>
	</MV_PD_FreeHD2GlobalSpare>
	";
	
	const MV_PD_FreeHD2DGSpare =
	" 
	<MV_PD_FreeHD2DGSpare type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<HD_ID type='U16'>%HD_ID%</HD_ID>
		<DG_ID type='U16'>%DG_ID%</DG_ID>
	</MV_PD_FreeHD2DGSpare>
	";
		
	const MV_PD_FreeHD2LDSpare = 
	"
	<MV_PD_FreeHD2LDSpare type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<HD_ID type='U16'>%HD_ID%</HD_ID>
		<LD_ID type='U16'>%LD_ID%</LD_ID>
	</MV_PD_FreeHD2LDSpare>
	";
	
	//expender
	const MV_PD_GetExpanderInfo = 
	"
	<MV_PD_GetExpanderInfo type='function'>
	  <AdapterID type='U8'>%AdapterID%</AdapterID>
	  	<Exp_Info_Request type='struct Exp_Info_Request'>
			<RequestHeader type='struct RequestHeader'>
				<requestType type='U8'>%requestType%</requestType>
				<startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
				<numRequested type='U16'>%numRequested%</numRequested>
			</RequestHeader>
		</Exp_Info_Request>
	</MV_PD_GetExpanderInfo>
	";
	
	//pm
	const MV_PD_GetPMInfo = 
	"
	<MV_PD_GetPMInfo type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<PM_Info_Request type='struct PM_Info_Request'>
			<RequestHeader type='struct RequestHeader'>
				<requestType type='U8'>%requestType%</requestType>
				<startingIndexOrId type='U16'>%startingIndexOrId%</startingIndexOrId>
				<numRequested type='U16'>%numRequested%</numRequested>
			</RequestHeader>
		</PM_Info_Request>
	</MV_PD_GetPMInfo>
	";
	
	//BBU
	const MV_BBU_GetInfo = 
	"
	<MV_BBU_GetInfo type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
	</MV_BBU_GetInfo>
	";
	
	const MV_BBU_ChangePower = 
	"
	<MV_BBU_ChangePower type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<action type='U8'>%action%</action>
	</MV_BBU_ChangePower>
	";
	/*
	const MV_BBU_SetMaxCapacity = 
	"
	<MV_BBU_SetMaxCapacity type='function'>	
		<AdapterID type='U8'>%AdapterID%</AdapterID>	
		<BBU_ID type='U16'>%BBU_ID%</BBU_ID>
		<maxCapacity type='MV_U16'>%maxCapacity%</maxCapacity>
	</MV_BBU_SetMaxCapacity>
	";
	*/
	//system 
	const  MV_SetDriverMode = 
	"
	<MV_SetDriverMode type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
		<Mode type='U32'>%Mode%</Mode>
	</MV_SetDriverMode>
	";
	
	const MV_GetDriverMode = 
	"
	<MV_GetDriverMode type='function'>
		<AdapterID type='U8'>%AdapterID%</AdapterID>
	</MV_GetDriverMode>
	";
	
	const ZA_Module_GetInfo = 
	"
    <ZA_Module_GetInfo type='function'>
    </ZA_Module_GetInfo>
    ";
	
	const MV_API_Info = 
	"
	<MV_API_Info type='function'>
	</MV_API_Info>
	";
	
	const MV_API_Version = 
	"
	<MV_API_Version type='function'>
	</MV_API_Version>
	";
	
	
	const MV_GetUserName = 
	"
	<MV_GetUserName type='function'>
	</MV_GetUserName>
	";
	private $Command;
	private $Result;	
	private $xmlHandler;
		
	public function setCommand($Command)
	{
		$this->Command = $Command;
	}
	
	public function getCommand()
	{
		return $this->Command;
	}
	
	public function setCommandPara($paraName,$paraVal)
	{
		if (($prePos = strpos($this->Command, "<" . $paraName)) !== false) {
			if (($postPos = strpos($this->Command, "</" . $paraName)) !== false) {
				$sub1 = substr($this->Command, 0, $prePos+1);
				$sub2 = substr($this->Command, $postPos);
				$sub3 = substr($this->Command, $prePos+1, $postPos - $prePos);
				$subPos = strpos($sub3, ">");
				
				//for new backend
				//new backend may not interpret special charactor such as '<', '>', ...etc
				$this->Command = $sub1 . substr($sub3, 0, $subPos) . "><![CDATA[" . $paraVal . "]]>" . $sub2;
				//for old backend
				//$this->Command = $sub1 . substr($sub3, 0, $subPos) . ">" . $paraVal . $sub2;
			}
		}
		else 
		{
			$this->Command = str_ireplace("%" . $paraName .  "%","" . $paraVal,$this->Command);
		}
	}
	
	//issue Command
	public function issueCommand()
	{
		$XMLRet = false;
		$retry_time = 0;
		$retVal = 1;
		
		while (4 > $retry_time && 0 != $retVal)
		{
		
		try {
			ini_set('max_execution_time', 180);
            if($this->Command && strlen($this->Command) > 0) {
                //if (!zRaidApi( $this->Command, $XMLRet ))
					//return false;
		$XMLRet = zRaidApi( $this->Command, $XMLRet );//remove return value check, php7 get $XMLRet failed, use function return instead
            } else {
                return false;
            }
                        
                        
            $XMLRet=iconv("UTF-8","UTF-8//IGNORE",$XMLRet);
			$this->Result = new SimpleXMLElement($XMLRet);
			
			$retVal = intval($this->Result->RetVal);
			
			if($retVal == 0 && isset($this->xmlHandler))
			{
				$this->xmlHandler->handle($this->Result);
				break;
			}else if($retVal == 31){//#define ERR_PASS_THROUGH_BUSY (ERR_GENERIC + 29)
                break;
            }else {
				$retry_time ++;
			}
		}
		catch (Exception $e)
		{
			//var_dump($XMLRet);
			return false;
		}
		}
		
		return true;
	}
	
	//for debug
	public function setResult($Result)
	{
		$this->Result = $Result;
	}
	//for debug
	
	public function getResult()
	{
		return $this->Result;
	}

        public function getRetVal()
        {
            if(isset($this->Result) && isset($this->Result->RetVal)) {
                return intval($this->Result->RetVal);
            }
            
            return 1;
        }
	
	public function setXmlHandler($handler)
	{
		$this->xmlHandler = $handler;
	}
	
	public function getXmlHandler()
	{
		return $this->xmlHandler;
	}
}
?>
