<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
*/

/**
 * Description of DBDataAccessclass
 *
 * @author hank
 */
abstract class SQLite3DataAccess implements DataAccess {
    protected $db;
    protected $tblName;

    protected abstract function createObj();

    //update the values of elements which can be found by keys array
    //matching the name and value
    public function update($dataArray) {
        //convert it to updator sql
        if(isset($dataArray['myvalues']) && sizeof($dataArray['myvalues']) > 0) {
            $first = true;
            $sql = "UPDATE " . $this->tblName . " ";
            $sql .= "SET ";

            foreach($dataArray['myvalues'] as $colName=>$value) {
                if($first) {
                    $sql .= $colName . "=" . $value . " ";
                    $first = false;
                }
                else {
                    $sql .= ", " . $colName . "=" . $value . "";
                }
            }

            if(isset($dataArray['mykeys'])) {
                $sql .= ' WHERE ';
                $first = true;
                foreach($dataArray['mykeys'] as $colName=>$value) {
                    if($first) {
                        $sql .= $colName . "=" . $value . " ";
                        $first = false;
                    }
                    else {
                        $sql .= " AND " . $colName . "=" . $value . "";
                    }
                }
            }

            $sql .= ";";

            return $this->inner_exec($sql);
        }
        else {
            return false;
        }
    }
    //insert the values of element
    public function insert($dataArray) {
        if(isset($dataArray['myvalues']) && sizeof($dataArray['myvalues']) > 0) {
            $sql = "INSERT INTO " . $this->tblName . " ";
            $keys = array_keys($dataArray['myvalues']);
            $values = array_values($dataArray['myvalues']);

            $sql.= "(";
            $first = true;
            foreach($keys as $colName) {
                if($first) {
                    $sql .= $colName . " ";
                    $first = false;
                }
                else {
                    $sql .= ", $colName";
                }
            }

            $sql .= ") VALUES(";

            $first = true;
            foreach($values as $colValue) {
                if($first) {
                    $sql .= "$colValue ";
                    $first = false;
                }
                else {
                    $sql .= ", $colValue";
                }
            }

            $sql .= ");";

            return $this->inner_exec($sql);
        }
        else {
            return false;
        }
    }


    //return Objects which can be found by keys array matching the name and value
    public function query($dataArray) {
        $sql = "SELECT * FROM " . $this->tblName;

        if(isset($dataArray['mykeys']) && (!empty($dataArray['mykeys']))) {
            $sql .= ' WHERE ';
            $first = true;
            foreach($dataArray['mykeys'] as $colName=>$value) {
                if($first) {
                    $sql .= $colName . "=" . $value . " ";
                    $first = false;
                }
                else {
                    $sql .= " AND " . $colName . "=" . $value . "";
                }
            }
        }

        if(isset($dataArray['mysortkeys']) && (!empty($dataArray['mysortkeys']))) {
            $sql .= ' ORDER BY ';
            $first = true;

            foreach($dataArray['mysortkeys'] as $colName=>$value) {
                if($first) {
                    $sql .= $colName . " " . $value . " ";
                    $first = false;
                }
                else {
                    $sql .= " , " . $colName . " " . $value . "";
                }
            }
        }

        $result = $this->inner_query($sql);
        if($result) {
            $retArr = array();
            while($row = $result->fetchArray()) {
                $obj = $this->createObj();
                $obj->setFromArray($row);
                $retArr[] = $obj;
            }

            $result->finalize();
        }

        return $retArr;
    }

    //delete xml element which can be found by keys array matching the name and value
    public function delete($dataArray) {
        $sql = "DELETE FROM " . $this->tblName;

        if(isset($dataArray['mykeys'])) {
            $sql .= ' WHERE ';
            $first = true;
            foreach($dataArray['mykeys'] as $colName=>$value) {
                if($first) {
                    $sql .= $colName . "=" . $value . " ";
                    $first = false;
                }
                else {
                    $sql .= " AND " . $colName . "=" . $value . "";
                }
            }
        }

        $sql .= ";";

        return $this->inner_exec($sql);
    }

    public function getOne($dataArray)
    {
        $res = $this->query($dataArray);

        if(sizeof($res) > 0)
         	return $res[0];
         return null;
    }

    protected function escapeText($txtVolume) {
        return "'$txtVolume'";
    }

    protected function escapeLikeText($txt, $escapeChar) {
        $cArr = str_split($txt);
        $ret = "";
        
        foreach($cArr as $c) {
            if($c == '%' || $c == '_') {
                $ret .= $escapeChar;
            }
            if($c == '\'') {
                $ret .= '\'';
            }
            
            $ret .= $c;
        }

        return $ret;
    }

    protected function inner_query($sql) {
        while(true) {
            $res = $this->db->query($sql);
            if($res !== false) {
                return $res;
            } else {
                $errCode = $this->db->lastErrorCode();
                if($errCode == 5 || $errCode == 6) {
                    usleep(10);
                    continue;
                } else {
                    break;
                }
            }
        }
        return false;
    }

    protected function inner_exec($sql) {
        while(true) {
            $res = $this->db->exec($sql);
            if($res !== false) {
                return $res;
            } else {
                $errCode = $this->db->lastErrorCode();
                if($errCode == 5 || $errCode == 6) {
                    usleep(10);
                    continue;
                } else {
                    break;
                }
            }
        }
        return false;
    }
}
?>
