//
//  hwInterfaceLinux.h
//  SimpleDriver
//
//  Created by Egor Pomozov on 07.12.14.
//  Copyright (c) 2014 Aquantia Corp. All rights reserved.
//
//  Linux-specific parts split from SimpleControl.h
//
#ifndef hwInterfaceLinux_
#define hwInterfaceLinux_

#ifndef NOPYTHON
#include <Python.h>
#endif

#include <stdbool.h>
typedef bool boolean_t;
#define FALSE false
#define TRUE true

#define EXIT_SUCCESS 0

#define FAILED(r) (r != EXIT_SUCCESS)
#define SUCCEEDED(r) (r == EXIT_SUCCESS)

// bcopy("Attempting re-initialize in HW_Initialize()", HW_ErrorMessage, ERROR_MESSAGE_SIZE)
#define STRING_COPY(var,size,msg) bcopy(msg, var, size)
// snprintf( HW_ErrorMessage, ERROR_MESSAGE_SIZE, "Failed to initialize driver in HW_Initialize() 0x%08X", res);
#define STRING_PRINTF(...) snprintf(__VA_ARGS__)
#define FUNCTION_NAME __FUNCTION__

//Add WIN32 compatibility
#define HRESULT int32_t

#define S_OK EXIT_SUCCESS
#define E_FAIL EXIT_FAILURE

#define UNREFERENCED_PARAMETER(x)

#define LOBYTE(x) (x & 0xFF)
#define HIBYTE(x) ((x >> 8) & 0xFF)

#define LOWORD(x) (x & 0xFFFF)
#define HIWORD(x) ((x >> 16) & 0xFFFF)

#define LODWORD(x) (((uint32_t *)&x)[0])
#define HIDWORD(x) (((uint32_t *)&x)[1])

#endif //hwInterfaceLinux_
