/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.gui.GuiUtils;

public class LoadingWindow {
    public static final String EDITOR_LOAD = "Initializing";
    public static final String LOADING_PDT_TEXT = "Loading PDT";
    public static final String IMPORT_MESSAGE_TEXT = "Importing sensors";
    public static final String LOADING_DATA_TEXT = "Loading data";
    private static Display display;
    private static LoadingWindow _instance;
    protected Shell shell;
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Label lblMsg;
    private Task _currentTask = null;
    private Label lblWait;

    public static void main(String[] args) {
        display = Display.getDefault();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    LoadingWindow window = LoadingWindow.instance();
                    window.open();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static LoadingWindow instance() {
        if (_instance == null) {
            _instance = new LoadingWindow();
        }
        return _instance;
    }

    private LoadingWindow() {
        display = Display.getDefault();
    }

    private void open() {
        if (this._currentTask == null) {
            return;
        }
        display = Display.getDefault();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed() && this._currentTask != null) {
            if (display.readAndDispatch()) continue;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.close();
        }
    }

    private void refresh() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (LoadingWindow.this._currentTask != null && LoadingWindow.this.lblMsg != null && !LoadingWindow.this.lblMsg.isDisposed()) {
                    LoadingWindow.this.lblMsg.setText(LoadingWindow.this._currentTask.getDescription());
                }
            }
        });
    }

    private void showMessage() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (LoadingWindow.this.shell == null || LoadingWindow.this.shell.isDisposed()) {
                    LoadingWindow.this.open();
                }
            }
        });
        this.refresh();
    }

    public void runTask(Task task) {
        if (this._currentTask != null) {
            throw new UnsupportedOperationException("Cannot run a new task before the previous has ended");
        }
        this._currentTask = task;
        new Thread(task).start();
        this.showMessage();
    }

    private void taskEnded() {
        this._currentTask = null;
    }

    public boolean isOpened() {
        return this.shell != null && !this.shell.isDisposed();
    }

    public void waitForTask() throws InterruptedException {
        while (this._currentTask != null) {
            Thread.sleep(200L);
        }
    }

    protected void createContents() {
        this.shell = new Shell(67584);
        this.shell.setText("Loading");
        this.shell.setImage(SWTResourceManager.getImage(LoadingWindow.class, "/resources/Intel.ico"));
        GuiUtils.setGridLayoutToComposite((Composite)this.shell, 2);
        Composite composite = GuiUtils.addCompositeToComposite((Composite)this.shell, 2048, 131072, 4, false, true, 1, 3, 1);
        Label label = GuiUtils.addLabelToComposite("", composite, 0, 16384, 0x1000000, false, false, 1, 3);
        Label lblNewLabel = GuiUtils.addLabelToComposite("Intel\u00ae Integrated Sensor Solution\r\nPlatform Description Table (PDT) Editor", (Composite)this.shell, 0, 4, 0x1000000, true, false, 1, 1);
        this.lblMsg = GuiUtils.addLabelToComposite("", (Composite)this.shell, 0, 4, 0x1000000, true, false, 1, 1);
        this.lblWait = GuiUtils.addLabelToComposite("Please wait...", (Composite)this.shell, 4, 16384, 128, true, false, 1, 1);
        label.setImage(SWTResourceManager.getImage(LoadingWindow.class, "/resources/intelLogo.PNG"));
        lblNewLabel.setFont(SWTResourceManager.getFont("Segoe UI", 12, 1));
        this.lblMsg.setFont(SWTResourceManager.getFont("Segoe UI", 11, 0));
        this.lblWait.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        this.formToolkit.adapt(composite);
        this.formToolkit.paintBordersFor(composite);
        this.formToolkit.adapt((Control)label, true, true);
        this.shell.setSize(this.shell.computeSize(-1, -1));
        this.shell.setLocation(GuiUtils.getMiddleLocation(this.shell, display));
        this.refresh();
    }

    public static abstract class Task
    implements Runnable {
        private String _description;
        private boolean _success = true;

        public abstract void process();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.process();
            }
            catch (Throwable e) {
                this.setSuccess(false);
                StringBuilder msgCandidate = new StringBuilder("Failed to load the PDT Editor.");
                if (e.getMessage().contains("Invalid thread access")) {
                    msgCandidate.append("\nException:");
                    for (StackTraceElement element : e.getStackTrace()) {
                        msgCandidate.append("\n" + element.toString());
                    }
                }
                if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                    msgCandidate.append(": " + e.getMessage());
                }
                final String msg = msgCandidate.toString();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageBox messageBox = new MessageBox(new Shell(), 33);
                        messageBox.setText("PDT Editor Loading Failure");
                        messageBox.setMessage(msg);
                        messageBox.open();
                    }
                });
            }
            finally {
                LoadingWindow.instance().taskEnded();
            }
        }

        public Task(String description) {
            this._description = description;
        }

        public String getDescription() {
            return this._description;
        }

        public void setSuccess(boolean value) {
            this._success = value;
        }

        public boolean isSuccessfull() {
            return this._success;
        }
    }
}

