<?php
include_once("../phpsrc/action/ActionVDBGABase.class.php");
class ActionCheckLD extends ActionVDBGABase
{
	protected $LD_ID;
	protected $Type;
	
	protected function initActionPara()
	{
		$this->LD_ID = getRequestPara("LDID");
		$this->Type = getRequestPara("CheckType");
	}
	
	protected function doCheckAndFix()
	{
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_LD_StartConsistencyCheck);
		$this->ApiCmd->setCommandPara("AdapterID",$this->getAdapterID());
		$this->ApiCmd->setCommandPara("LD_ID",$this->LD_ID);
		$this->ApiCmd->setCommandPara("Type",$this->Type);
		$this->ApiCmd->issueCommand();
		
		if ($this->ApiCmd->getResult()->RetVal . "") {
			$this->setLDCmdXmlRetFail();
		}
		else {
			$this->setLDCmdXmlRetSuccess();
		}
	}

	protected function doAction()
	{
		$cmdName = trim(getRequestPara("cmdName"));
        $this->setFlags();

        if (getRequestPara(self::ToStopMP) == null
            && $this->isRunningMP) {
            $YesUrl = getBaseURL() . PHPPageName::CmdPageName
				. "?cmdName=" . $cmdName ;
			$YesUrl .=  "&LDID" . "=" . $this->LD_ID . "&CheckType" . "=" . $this->Type . "&HBAID=" . $this->getAdapterID();
			$YesUrl .=  "&" . self::ToStopMP  . "= 1";

            $NoUrl = $this->getNoPageURL();

			$this->xmlRet = new ContXMLRet();
            if ($this->Type == ConsistencyCheck_Type::CONSISTENCYCHECK_FIX) {
                $this->xmlRet->Msg = AlertMsg::LDFIX_STOP_MP;
            } else {
                $this->xmlRet->Msg = AlertMsg::LDCHECK_STOP_MP;
            }
			$this->xmlRet->YesUrl = $YesUrl;
			$this->xmlRet->NoUrl = $NoUrl;
			$this->xmlRet->YesUrlType = XMLRetUrlType::CmdUrl;
			$this->xmlRet->NoUrlType = XMLRetUrlType::PageUrl;
            return;
        }
        
		$this->doCheckAndFix();
	}
}
?>