<?php
class CreateLDMaxSize extends BaseFactory
{
	private $HDIDs = array();
	private $RaidMode;
	private $NumParityDisk = 0;
	
	public function addHDID($HDID)
	{
		$this->HDIDs[] = $HDID;
	}
	
	public function setNumParityDisk($NumParityDisk)
	{
		$this->NumParityDisk = $NumParityDisk;
	}
	
	public function setRaidMode($RaidMode)
	{
		$this->RaidMode = $RaidMode;
	}
	
	public function toGetMaxSize()
	{
		$HDCount = sizeof($this->HDIDs);
		
		if ($HDCount == 0) {
			return;
		}
		
		$HDs = "";
		foreach ($this->HDIDs as $HD)
		{
			$HDs .= " " . $HD;
		}
		
		$CmdLDGetMax = new XMLAPICommand();
		$CmdLDGetMax->setCommand(XMLAPICommand::MV_LD_GetMaxSize);
		$CmdLDGetMax->setCommandPara("RaidMode",$this->RaidMode);
		$CmdLDGetMax->setCommandPara("HDCount",$HDCount);
		$CmdLDGetMax->setCommandPara("RoundingScheme",Rounding_Scheme::ROUNDING_SCHEME_NONE);
		$CmdLDGetMax->setCommandPara("SubLDCount",0);
		$CmdLDGetMax->setCommandPara("StripeBlockSize",64);
		$CmdLDGetMax->setCommandPara("Raid6Redundancy",0);
		$CmdLDGetMax->setCommandPara("CachePolicy",0);
		$CmdLDGetMax->setCommandPara("InitializationOption",0);
		$CmdLDGetMax->setCommandPara("HDIDs",trim($HDs));
		$CmdLDGetMax->setCommandPara("Name","Name");
		$CmdLDGetMax->setCommandPara("Size",0);
		$CmdLDGetMax->setCommandPara("SectorCoefficient",LDSectorSize::SectorSize512B);
		$CmdLDGetMax->setCommandPara("NumParityDisk",$this->NumParityDisk);
		
		$handler = new LdCreateMaxSizeXmlHandler();
		$this->runCommand($CmdLDGetMax->getCommand(), $handler);
	}
	
	public function createObject()
	{
		//won't used in this
		return 0;
	}
	
	public function setRequestSender()
	{
		$this->reqSender = new BaseSingleRequestSender();
	}
}
?>