<?php
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
*/

/**
 * Description of AcceleratorTaskDataAccessclass
 *
 * @author hank
 */
class ApplicationFileDataAccess extends SQLite3DataAccess {
    //put your code here
    protected function createObj() {
        return new ApplicationFile();
    }

    public function  __construct() {
        global $db;
        $this->tblName = "TBL_APP_FILE";
        $this->db = $db;
    }

    public function addFileForApp($file)
    {
        $myvalues = array();
        
        $myvalues['FILE_PATH'] = $this->escapeText($file->getFilePath());
        $myvalues['FILE_SIZE'] = ($file->getFileSize());
        $myvalues['LAST_MODIFIED_TIME'] = $file->getLastModifiedTime();
        $myvalues['PIN_STATUS'] = $file->getPinStatus();
        $myvalues['FILE_TYPE'] = $file->getFileType();
        $myvalues['APP_FK_ID'] = $file->getAppID();

        $dataArray = array("myvalues"=>$myvalues);

        return $this->insert($dataArray);
    }

    public function findFileByID($keyId)
    {
         $dataArray = array("mykeys" => array("KEY_ID"=>$keyId));         
         
         return $this->getOne($dataArray);
    }

    public function deleteFileForApp($appId)
    {
        $dataArray = array("mykeys" => array("APP_FK_ID"=>$appId));
        return $this->delete($dataArray);
    }

    public function deleteFileById($keyId)
    {
        $dataArray = array("mykeys" => array("KEY_ID"=>$keyId));
        return $this->delete($dataArray);
    }

    public function findFileByAppID($appId)
    {
        $dataArray = array("mykeys" => array("APP_FK_ID"=>$appId));

         return $this->query($dataArray);
    }

    public function checkFileExistInDB($path, $whetherCheckParent=false)
    {
        $arr = explode("\\", $path);
        $pathList = array();
        $ret = false;

        if($whetherCheckParent) {
            for($i = 1; $i <= sizeof($arr); $i++)
            {
                $newArr = array_slice($arr, 0, $i);
                $pathList[] = $this->escapeLikeText(implode("\\", $newArr), "|");
            }
        } else {
            $pathList[] = $this->escapeLikeText($path, "|");
        }
        
        $sql = "SELECT * FROM " . " TBL_APP_FILE " . " WHERE ";

        for($i = 0; $i < sizeof($pathList); $i++)
        {
            if($i != 0) {
                $sql .= " OR ";
            }
            $sql .= " FILE_PATH LIKE '$pathList[$i]' ESCAPE '|'";
        }

        $result = $this->inner_query($sql);
        if($result) {
            $retArr = array();
            while($row = $result->fetchArray()) {
                $ret = true;
                break;
            }
            $result->finalize();
        }

        return $ret;
    }

    public function checkSubFileExistInDB($path)
    {
        $arr = explode("\\", $path);
        $pathList = array();
        $ret = false;

        $pathList[] = $this->escapeLikeText($path, "|");

        $sql = "SELECT * FROM " . " TBL_APP_FILE " . " WHERE ";

        for($i = 0; $i < sizeof($pathList); $i++)
        {
            if($i != 0) {
                $sql .= " OR ";
            }
            $sql .= " FILE_PATH LIKE '%$pathList[$i]%' ESCAPE '|'";
        }

        $result = $this->inner_query($sql);
        if($result) {
            $retArr = array();
            while($row = $result->fetchArray()) {
                $ret = true;
                break;
            }
            $result->finalize();
        }

        return $ret;
    }
}
?>
