<?php

class BBU
{
	private $status;
	private $prev_status;
	private $featureSupport;
	private $temperature;
	private $voltage;
	private $supportMaxCapacity;
	private $supportMinCapacity;
	private $maxCapacity;
	private $curCapacity;
	private $time_to_empty;
	private $time_to_full;
	private $percentage;	
	private $ID;
	private $recharge_cycle;
	private $percent_to_charge;
	private $volt_lowerbound;
	private $volt_upperbound;
	private $temp_lowerbound;
	private $temp_upperbound;
	
	public function setStatus($status)
	{
		$this->status = $status;
	}
	public function getStatus()
	{
		return $this->status;
	}
		
	public function setFeatureSupport($featureSupport)
	{
		$this->featureSupport = $featureSupport;
	}
	public function getFeatureSupport()
	{
		return $this->featureSupport;
	}
	
	public function setTemperature($temperature)
	{
		$this->temperature = $temperature;
	}
	public function getTemperature()
	{
		return $this->temperature;
	}
	
	public function setVoltage($voltage)
	{
		$this->voltage = $voltage;
	}
	public function getVoltage()
	{
		return $this->voltage;
	}
	
	public function setSupportMinCapacity($supportMinCapacity)
	{
		$this->supportMinCapacity = $supportMinCapacity;
	}
	public function getSupportMinCapacity()
	{
		return $this->supportMinCapacity;
	}
	
	public function setSupportMaxCapacity($supportMaxCapacity)
	{
		$this->supportMaxCapacity = $supportMaxCapacity;
	}
	public function getSupportMaxCapacity()
	{
		return $this->supportMaxCapacity;
	}
	
	public function setMaxCapacity($maxCapacity)
	{
		$this->maxCapacity = $maxCapacity;
	}
	public function getMaxCapacity()
	{
		return $this->maxCapacity;
	}
	
	public function setCurCapacity($curCapacity)
	{
		$this->curCapacity = $curCapacity;
	}
	public function getCurCapacity()
	{
		return $this->curCapacity;
	}
	
	public function setTimeToEmpty($time_to_empty)
	{
		$this->time_to_empty = $time_to_empty;
	}
	public function getTimeToEmpty()
	{
		return $this->time_to_empty;
	}
	
	public function setTimeToFull($time_to_full)
	{
		$this->time_to_full = $time_to_full;
	}
	public function getTimeToFull()
	{
		return $this->time_to_full;
	}
	
	public function setPercentage($percentage)
	{
		$this->percentage = $percentage;
	}
	public function getPercentage()
	{
		return $this->percentage;
	}
	
	public function setID($ID)
	{
		$this->ID = $ID;
	}
	public function getID()
	{
		return $this->ID;
	}
	
	public function getPrev_status()
	{
		return $this->prev_status;
	}
	
	public function getPercent_to_charge()
	{
		return $this->percent_to_charge;
	}
	
	public function getRecharge_cycle()
	{
		return $this->recharge_cycle;
	}
	
	public function getTemp_upperbound()
	{
		return $this->temp_upperbound;
	}
	
	public function getTemp_lowerbound()
	{
		return $this->temp_lowerbound;
	}
	
	public function getVolt_upperbound()
	{
		return $this->volt_upperbound;
	}
	
	public function getVolt_lowerbound()
	{
		return $this->volt_lowerbound;
	}
	
	public function supportTemperature()
	{
		return $this->featureSupport & BBUFeature::BBU_SENSOR_TEMPERATURE ;
	}
	
	public function supportVoltage()
	{
		return $this->featureSupport & BBUFeature::BBU_SENSOR_VOLTAGE ;
	}
	
	public function supportEcapacity()
	{
		return $this->featureSupport & BBUFeature::BBU_SENSOR_ECAPACITY ;
	}
	
	public function setBBUFromXML($BBU)
	{
		if (isset($BBU->percentage)) {
			$this->percentage = trim($BBU->percentage);
		}		
		if (isset($BBU->time_to_full)) {
			$this->time_to_full = trim($BBU->time_to_full);
		}		
		if (isset($BBU->time_to_empty)) {
			$this->time_to_empty = trim($BBU->time_to_empty);
		}				
		if (isset($BBU->curCapacity)) {
			$this->curCapacity = trim($BBU->curCapacity);
		}
		if (isset($BBU->maxCapacity)) {
			$this->maxCapacity = trim($BBU->maxCapacity);
		}
		if (isset($BBU->supportMaxCapacity)) {
			$this->supportMaxCapacity = trim($BBU->supportMaxCapacity);
		}
		if (isset($BBU->supportMinCapacity)) {
			$this->supportMinCapacity = trim($BBU->supportMinCapacity);
		}
		if (isset($BBU->voltage)) {
			$this->voltage = trim($BBU->voltage);
		}
		if (isset($BBU->temperature)) {
			$this->temperature = trim($BBU->temperature);
		}
		if (isset($BBU->featureSupport)) {
			$this->featureSupport = trim($BBU->featureSupport);
		}
		if (isset($BBU->status)) {
			$this->status = trim($BBU->status);
		}
		if (isset($BBU->prev_status)) {
			$this->prev_status = trim($BBU->prev_status);
		}
		if (isset($BBU->volt_lowerbound)) {
			$this->volt_lowerbound = trim($BBU->volt_lowerbound);
		}
		if (isset($BBU->volt_upperbound)) {
			$this->volt_upperbound = trim($BBU->volt_upperbound);
		}
		if (isset($BBU->temp_lowerbound)) {
			$this->temp_lowerbound = trim($BBU->temp_lowerbound);
		}
		if (isset($BBU->temp_upperbound)) {
			$this->temp_upperbound = trim($BBU->temp_upperbound);
		}
		if (isset($BBU->percent_to_charge)) {
			$this->percent_to_charge = trim($BBU->percent_to_charge);
		}
		if (isset($BBU->recharge_cycle)) {
			$this->recharge_cycle = trim($BBU->recharge_cycle);
		}

	}
}

?>