<?php
//include_once("PageDisplayer.class.php");

class PgCheckDisplayer extends BGAPageDisplayer
{
	protected function setDisplayInfo()
	{
		if ($this->cmdPara != null) {
			$CheckType = getUrlPropertyValue($this->cmdPara,'CheckType');
			$this->smarty->assign('CheckType',$CheckType);
		}
		
		$this->setPageName(Target::CheckPage . ".tpl");
		$this->smarty->assign("ScheduledBgaType",ScheduledBGAType::LD_BGA_CONSISTENCY_CHECK);
	}
	
	protected function setInfo()
	{
		$ID = getRequestPara('ID');
		$VdNotOnDg = getRequestPara('VdNotOnDg');
		$PackageVD = getRequestPara('PackageVD');
		
		if ($ID == null || trim($ID) === "") {
			$this->displayDefaultPage(Target::getSystemSubPage);
			return;
		}
		
		$smarty = $this->smarty;
		
		$container="";
    	if ($VdNotOnDg) {
    		$container = new CtnLdDetail();
    		$smarty->assign("VdNotOnDg",$VdNotOnDg);
    	} else {
            if ($PackageVD) {
                $container = new CtnPackageVDDetail();
                $smarty->assign("PackageVD",$PackageVD);
            } else {
                $container = new CtnLdOnDg();
            }
    	}
    	$container->setAdapterID($this->getAdapterID());
		$container->setLDID($ID);
		$container->toGetLDInfo();
		$container->toGetLDConfig();
		$container->toGetLDStatus();
		$container->smartyAssign($smarty);
		$container->initContainer();
		
		$ldlst = $container->getBase()->getBaseClasses();
		if (!sizeof($ldlst)) {
			/*
			if ($type == 'saveModify') {
				$this->displayDefaultPage(Target::BgaSchedulePage);
			}
			else
			{
				//check for LD does not exist
				//if not exists ,jump to Ld List Page
				$this->displayDefaultPage(Target::LdListPage);
			}
			return;
			*/
			$Name = gettext('VD Not Exist');
			$smarty->assign('VDNotExist',1);
			$this->displayDefaultPage(Target::getSystemSubPage);
			return;
		}
		else {
			$ldDetail = array_shift($ldlst);
			$Name = $ldDetail->getName();
			//$adpID = $ldDetail->getAdapterID();
			//$this->setHBAID($adpID);
		}
		
    	//$checkOnly = gettext(LdBgaStatus::LD_BGA_CONSISTENCY_CHECK_STR);
    	$checkFix = gettext("Raid1 SYNCH");
    	$CancelAlert = gettext(AlertMsg::CHECK_CANCEL)."?";
    	
    	$CheckOptions = 
			array(
				//ConsistencyCheck_Type::CONSISTENCYCHECK_ONLY=>$checkOnly,
				ConsistencyCheck_Type::CONSISTENCYCHECK_FIX =>$checkFix
			);
			
		$smarty->assign("ID",$ID);
	    $smarty->assign("HBAID",$this->getAdapterID());
		$smarty->assign("LdName",$Name);
		$smarty->assign("CheckOptions",$CheckOptions);
    	$smarty->assign("CancelAlert",$CancelAlert);
	}
}
?>