<?php
define("UNIT_K",1024);
define("UNIT_KILO",1024);
define("GET_ALL",255);

define("INVALID_ID",0xFF); // for old driver
define("UNDEFINED_ID",0xFFFF);
//disable mail support
define("MAIL_SUPPORT",1);
define("MAC_LOCAL_MAIL_SUPPORT",0);
	
include_once("../phpsrc/version.php");

/*
// code for disable mail support
if (file_exists('../phpsrc/SupportMail.php')) {
	include_once("../phpsrc/SupportMail.php");
}
if (file_exists('../phpsrc/NotSupportMail.php')) {
	include_once("../phpsrc/NotSupportMail.php");
}
*/

/*be carefull, the error reporting should be never set for product site*/
//define('STRICT_ERROR_REPORTING', true);
if (defined('STRICT_ERROR_REPORTING') && STRICT_ERROR_REPORTING == true) {
  @ini_set('display_errors', '1');
  error_reporting(E_ALL);
} else {
  error_reporting(0);
}

init_date_time();

function init_date_time()
{
	date_default_timezone_set('UTC');
	$date = DateTime::createFromFormat("YmdHis", getNow(). "", new DateTimeZone(date_default_timezone_get()));
	date_timezone_set($date, timezone_open('UTC'));
}


class HyperSSDCachePolicy {
    const CACHE_POLICY_WRITE_BACK = 1;
    const CACHE_POLICY_WRITE_THROUGH = 2;

    public function getPolicyStr($policy) {
        
    }

}

class HyperSSDStatus {
    const HYPERSSD_STATUS_DISK_BIND = 1;
    const HYPERSSD_STATUS_DISK_BIND_STR = "Disk binded";
    const HYPERSSD_STATUS_REBUILDING = 2;
    const HYPERSSD_STATUS_REBUILDING_STR = "Rebuilding";
    const HYPERSSD_STATUS_DISK_MISSING = 4;
    const HYPERSSD_STATUS_DISK_MISSING_STR = "Disk missing";
    const HYPERSSD_STATUS_NON_REBUILT = 8;
    const HYPERSSD_STATUS_NON_REBUILT_STR = "Reboot required";
    const HYPERSSD_STATUS_NOBIND_STR = "Non-Disk Binded";

    public function getStatusStr($status) {
        if ($status & self::HYPERSSD_STATUS_DISK_BIND) {
            if ($status & self::HYPERSSD_STATUS_REBUILDING)
                return self::HYPERSSD_STATUS_REBUILDING_STR;
            else if ($status & self::HYPERSSD_STATUS_NON_REBUILT)
                return self::HYPERSSD_STATUS_NON_REBUILT_STR;
            else
                return self::HYPERSSD_STATUS_DISK_BIND_STR;
        } else if ($status & self::HYPERSSD_STATUS_DISK_MISSING) {
            return self::HYPERSSD_STATUS_DISK_MISSING_STR;
        } else {
            return self::HYPERSSD_STATUS_NOBIND_STR;
        }
    }
}

class SSDAdapterFeatures {
    const HBA_FEATURES_TURBO_STANDBY = 0x0001;
    const HBA_FEATURES_TURBO_STANDBY_STR = "Turbo Standby";
    const HBA_FEATURES_TURBO_HIBERNATION = 0x0002;
    const HBA_FEATURES_TURBO_HIBERNATION_STR = "Turbo Hibernation";
    const HBA_FEATURES_HYPER_SSD = 0x0004;
    const HBA_FEATURES_HYPER_SSD_STR = "Hyper SSD";
    const HBA_FEATURES_UNKNOWN_STR = "Unknown";

    public function getStatusStr($status) {
        $str = "";
        if ($status & self::HBA_FEATURES_TURBO_STANDBY)
            $str = self::HBA_FEATURES_TURBO_STANDBY_STR . ",";
        if ($status & self::HBA_FEATURES_TURBO_HIBERNATION)
            $str .= self::HBA_FEATURES_TURBO_HIBERNATION_STR . ",";
        if ($status & self::HBA_FEATURES_HYPER_SSD)
            $str .= self::HBA_FEATURES_HYPER_SSD_STR . ",";
        
        $str = substr($str, 0, strlen($str)-1);
        if ($str == "") $str = "N/A";
        
        return $str;
    }
}

class SSDPartitionType
{
    const SSD = 0;
    const SSD_STR = "SSD";
    const TURBO_BOOT = 1;
    const TURBO_BOOT_STR = "Turbo boot";
    const TURBO_STANDBY = 2;
    const TURBO_STANDBY_STR = "Turbo standby";
    const TURBO_HIBERNATION = 3;
    const TURBO_HIBERNATION_STR = "Turbo hibernation";
    const RECOVER_CD = 4;
    const RECOVER_CD_STR = "Recover CD";
    const HYPER_SSD = 5;
    const HYPER_SSD_STR = "HyperSSD";
    const TYPE_UNKNOWN_STR = "Invalid";

    public function getPartitionTypeStr($type)
    {
        switch($type)
        {
            case self::SSD:
                return self::SSD_STR;
            case self::TURBO_BOOT:
                return self::TURBO_BOOT_STR;
            case self::TURBO_STANDBY:
                return self::TURBO_STANDBY_STR;
            case self::TURBO_HIBERNATION:
                return self::TURBO_HIBERNATION_STR;
            case self::RECOVER_CD:
                return self::RECOVER_CD_STR;
            case self::HYPER_SSD:
                return self::HYPER_SSD_STR;
            default:
                return self::TYPE_UNKNOWN_STR;
        }
    }

}

class SSDStatus
{
	const SSD_UNCONFIGED = 31;
	const SSD_UNCONFIGED_STR = "Unconfigured";
	const SSD_CONFIGED = 32;
	const SSD_CONFIGED_STR = "Configured";
	const SSD_FORMATTING = 33;
	const SSD_FORMATTING_STR = "Formatting";
	const SSD_STATUS_UNKNOWN_STR = "Unknown status";

	const SSD_STATUS_ASSIGNED_IMG = "SSD_Drive_Green.gif";//configured SSD
	const SSD_STATUS_FREE_IMG = "SSD_Drive_Blue.gif";//free SSD

	const SSD_STATUS_SAFEMODE_IMG = "SSD_Drive_Safemode.gif";//SSD in safe mode

	public static function getSSDStatusStr($status){
		switch ($status)
		{
			case self::SSD_CONFIGED :
				return self::SSD_CONFIGED_STR;
			case self::SSD_UNCONFIGED :
				return self::SSD_UNCONFIGED_STR;
			case self::SSD_FORMATTING :
				return self::SSD_FORMATTING_STR ;
			default:
				return self::SSD_STATUS_UNKNOWN_STR;
		}
	}

	public static function getSSDImg($status, $safemode){
		if ($safemode == 1)
			return self::SSD_STATUS_SAFEMODE_IMG ;
		switch ($status)
		{
			case self::SSD_CONFIGED :
				return self::SSD_STATUS_ASSIGNED_IMG ;
			case self::SSD_UNCONFIGED :
				return self::SSD_STATUS_FREE_IMG ;
			default:
				return self::SSD_STATUS_FREE_IMG;
		}
	}
}

class AcceleratorTaskStatus {
    const STATUS_NOT_RUN = 0;
    const STATUS_RUNNING = 1;
    const STATUS_PAUSED = 2;
    const STATUS_STOPPED = 3;
    const STATUS_FAILED = 4;
    const STATUS_REQUIRE_REBOOT = 5;
    const STATUS_FAILED_AFTER_REBOOT = 6;
    const STATUS_SUCCEEDED = 7;
    const STATUS_SUCCEEDED_AFTER_REBOOT = 8;
}

class AcceleratorTaskType {
    const TASK_TYPE_PREPARE = 1;
    const TASK_TYPE_PREPARE_STR = "Preparing";
    const TASK_TYPE_PIN_APP = 2;
    const TASK_TYPE_PIN_APP_STR = "Accelerating";
    const TASK_TYPE_UNPIN_APP = 3;
    const TASK_TYPE_UNPIN_APP_STR = "Decelerating";
    const TASK_TYPE_TRIM = 4;
    const TASK_TYPE_TRIM_STR = "Trim";
    
    public function getTaskType($type) {
    	switch ($type) {
    		case self::TASK_TYPE_PREPARE :
    			return self::TASK_TYPE_PREPARE_STR ;
    		case self::TASK_TYPE_PIN_APP :
    			return self::TASK_TYPE_PIN_APP_STR ;
    		case self::TASK_TYPE_UNPIN_APP :
    			return self::TASK_TYPE_UNPIN_APP_STR ;
    		case self::TASK_TYPE_TRIM :
    			return self::TASK_TYPE_TRIM_STR ;
			default:
				return "Unknown type";
    	}
    }
}

class AcceleratorState
{
	const ACCELERATOR_STATE_NONE = 0;
	const ACCELERATOR_STATE_NONE_STR = "none";
	const ACCELERATOR_STATE_RUNNING = 1;
	const ACCELERATOR_STATE_RUNNING_STR = "running";	
	const ACCELERATOR_STATE_PAUSED = 2;
	const ACCELERATOR_STATE_PAUSED_STR = "paused";
	const ACCELERATOR_STATE_AUTOPAUSED = 3;
	const ACCELERATOR_STATE_AUTOPAUSED_STR = "auto paused";
        const ACCELERATOR_STATE_ABORTED = 4;
	const ACCELERATOR_STATE_ABORTED_STR = "aborted";

	public static function getStateStr($stateInt)
	{
		$RetStr = "";
		switch ($stateInt)
		{
			case self::ACCELERATOR_STATE_NONE :
				$RetStr = self::ACCELERATOR_STATE_NONE_STR;
				break;
			case self::ACCELERATOR_STATE_RUNNING :
				$RetStr = self::ACCELERATOR_STATE_RUNNING_STR;
				break;
			case self::ACCELERATOR_STATE_ABORTED :
				$RetStr = self::ACCELERATOR_STATE_ABORTED_STR;
				break;
			case self::ACCELERATOR_STATE_PAUSED :
				$RetStr = self::ACCELERATOR_STATE_PAUSED_STR;
				break;
			case self::ACCELERATOR_STATE_AUTOPAUSED :
				$RetStr = self::ACCELERATOR_STATE_AUTOPAUSED_STR;
				break;
			default:
				$RetStr = self::ACCELERATOR_STATE_NONE_STR;
		}
		return $RetStr;
	}
}

class PinStatus {
    const STATUS_UNPINNED = 0;
    const STATUS_PINNED = 1;
    const STATUS_PINNED_STR = "Accelerated";
    const STATUS_TO_PIN_AFTER_REBOOT = 2;
    const STATUS_TO_PIN_AFTER_REBOOT_STR = "To accelerate after reboot";
    const STATUS_TO_UNPIN_AFTER_REBOOT = 3;
    const STATUS_TO_UNPIN_AFTER_REBOOT_STR = "To decelerate after reboot";
    const STATUS_PIN_FAILED = 4;
    const STATUS_PIN_FAILED_STR = "Accelerate failed";
    const STATUS_UNPIN_FAILED = 5;
    const STATUS_UNPIN_FAILED_STR = "Decelerate failed";
    const STATUS_PIN_FAILED_AFTER_REBOOT = 6;
    const STATUS_PIN_FAILED_AFTER_REBOOT_STR = "Accelerate failed after reboot";
    const STATUS_UNPIN_FAILED_AFTER_REBOOT = 7;
    const STATUS_UNPIN_FAILED_AFTER_REBOOT_STR = "Decelerate failed after reboot";
    
    public function getPinStatus($status) {
    	switch ($status) {
    		case self::STATUS_PINNED :
    			return self::STATUS_PINNED_STR;
    		case self::STATUS_PIN_FAILED :
    			return self::STATUS_PIN_FAILED_STR ;
    		case self::STATUS_PIN_FAILED_AFTER_REBOOT :
    			return self::STATUS_PIN_FAILED_AFTER_REBOOT_STR ;
    		case self::STATUS_TO_PIN_AFTER_REBOOT :
    			return self::STATUS_TO_PIN_AFTER_REBOOT_STR ;
    		case self::STATUS_TO_UNPIN_AFTER_REBOOT :
    			return self::STATUS_TO_UNPIN_AFTER_REBOOT_STR ;
    		case self::STATUS_UNPIN_FAILED :
    			return self::STATUS_UNPIN_FAILED_STR ;
    		case self::STATUS_UNPIN_FAILED_AFTER_REBOOT :
    			return self::STATUS_UNPIN_FAILED_AFTER_REBOOT_STR ;
    		default:
    			return "";
    	}
    }
    
}

class AppStatus {
    const STATUS_NONE = 0;
    const STATUS_SYNCING = 1;
    const STATUS_SYNCING_STR = "Synchronizing";
    const STATUS_NOT_SYNC = 2;
    const STATUS_NOT_SYNC_STR = "Not Synchronized";
    const STATUS_PINNING = 3;
    const STATUS_PINNING_STR = "Accelerating";
    const STATUS_UNPINNING = 4;
    const STATUS_UNPINNING_STR = "Decelerating";
    const STATUS_TO_PIN_ON_QUEUE = 5;
    const STATUS_TO_PIN_ON_QUEUE_STR = "Waiting to be accelerated";
    const STATUS_TO_UNPIN_ON_QUEUE = 6;
    const STATUS_TO_UNPIN_ON_QUEUE_STR = "Waiting to be decelerated";
    const STATUS_PINNING_PAUSED = 7;
    const STATUS_PINNING_PAUSED_STR = "Accelerating paused";
    const STATUS_UNPINNING_PAUSED = 8;
    const STATUS_UNPINNING_PAUSED_STR = "Decelerating paused";
    
    public function getAppStatus($status) {
    	switch ($status) {
    		case self::STATUS_NOT_SYNC :
    			return self::STATUS_NOT_SYNC_STR ;
    		case self::STATUS_PINNING :
    			return self::STATUS_PINNING_STR;
    		case self::STATUS_UNPINNING :
    			return self::STATUS_UNPINNING_STR;
    		case self::STATUS_TO_PIN_ON_QUEUE :
    			return self::STATUS_TO_PIN_ON_QUEUE_STR ;
    		case self::STATUS_TO_UNPIN_ON_QUEUE :
    			return self::STATUS_TO_UNPIN_ON_QUEUE_STR ;
    		case self::STATUS_PINNING_PAUSED :
    			return self::STATUS_PINNING_PAUSED_STR ;
    		case self::STATUS_UNPINNING_PAUSED :
    			return self::STATUS_UNPINNING_PAUSED_STR ;
    		default:
    			return "";
    	}
    }
    
}

class AppType{
    const TYPE_COMMON_APP = 0;
    const TYPE_OS = 1;
    const TYPE_PREFETECH = 2;
    const TYPE_FIXED = 4;
    const TYPE_AUTO = 8;
    const TYPE_CUSTOM = 16;
    const TYPE_COMMON_FILE = 32;
}

class SSDNANDType
{
	const SLC_TYPE = 0x00;
	const MLC_TYPE = 0x01;
	const SLC_TYPE_STR = "SLC";
	const MLC_TYPE_STR = "MLC";
	const UNKNOWN_NANDTYPE_STR = "Unknown";

	public static function getTypeStr($type)
	{
		switch ($type)
		{
			case self::SLC_TYPE :
				return self::SLC_TYPE_STR;
			case self::MLC_TYPE :
				return self::MLC_TYPE_STR;
			default:
				return self::UNKNOWN_NANDTYPE_STR;
		}

	}
}

class SSDCreateVolumeStatus
{
	const CREATE_VD_UNREADY = 11;
	const CREATE_VD_RUNNING =12;
	const CREATE_VD_SUCCESS = 13;
	const CREATE_VD_FAIL = 14;
	const CREATE_VD_FAIL_STR = "Error: Failed";
	const CREATE_VD_FORMAT_SSD_FAIL = 15;
	const CREATE_VD_FORMAT_SSD_FAIL_STR = "Error: SSD module format failed";
	const CREATE_VD_PD_INFO_FAIL = 16;
	const CREATE_VD_PD_INFO_FAIL_STR = "Error: Get SSD module info failed";
	const CREATE_VD_ADAPTER_INFO_FAIL = 17;
	const CREATE_VD_ADAPTER_INFO_FAIL_STR = "Error: Get adapter info failed";

	public static function getErrorMsg($errorCode)
	{
		switch ($errorCode){
			case self::CREATE_VD_FAIL :
				return self::CREATE_VD_FAIL_STR;
			case self::CREATE_VD_FAIL :
				return self::CREATE_VD_FAIL_STR;
			case self::CREATE_VD_FORMAT_SSD_FAIL :
				return self::CREATE_VD_FORMAT_SSD_FAIL_STR;
			case self::CREATE_VD_PD_INFO_FAIL :
				return self::CREATE_VD_PD_INFO_FAIL_STR;
			case self::CREATE_VD_ADAPTER_INFO_FAIL :
				return self::CREATE_VD_ADAPTER_INFO_FAIL_STR;
			default :
				return self::CREATE_VD_FAIL_STR;
		}

	}
}

class SSDDriveMode
{
	const SSD_UNKNOWN_DATA_PROTECTION = 0;
	const SSSD_UNKNOWN_DATA_PROTECTION_STR = "Unknown";
	const SSD_NO_DATA_PROTECTION = 1;
	const SSD_NO_DATA_PROTECTION_STR = "None (RAID0)";
	const SSD_ENABLE_DATA_PROTECTION = 2;
	const SSD_ENABLE_DATA_PROTECTION_STR = "Enable (RAID5)";
}

class SSDOpeatingLevel
{
	const SSD_UNKNOWN_WRITE_PERFORMANCE = 0;
	const SSD_UNKNOWN_WRITE_PERFORMANCE_STR = "Unknown";
	const SSD_STANDARD_WRITE_PERFORMANCE = 80;	// default
	const SSD_STANDARD_WRITE_PERFORMANCE_STR = "Standard (requires 20% of volume capacity)";
	const SSD_STANDARD_WRITE_PERFORMANCE_STR_SHORT = "Standard";
	const SSD_MAXIMUM_WRITE_PERFORMANCE = 50	;
	const SSD_MAXIMUM_WRITE_PERFORMANCE_STR = "Maximum (requires 50% of volume capacity)";
	const SSD_MAXIMUM_WRITE_PERFORMANCE_STR_SHORT = "Maximum";

	public static function getOplevelStr($opLevel)
	{
		switch ($opLevel)
		{
			case self::SSD_STANDARD_WRITE_PERFORMANCE :
				return self::SSD_STANDARD_WRITE_PERFORMANCE_STR_SHORT ;
			case self::SSD_MAXIMUM_WRITE_PERFORMANCE :
				return self::SSD_MAXIMUM_WRITE_PERFORMANCE_STR_SHORT;
			default:
				return self::SSD_UNKNOWN_WRITE_PERFORMANCE_STR ;

		}

	}
}

class AESKeyLength
{
	const MV_AES_KEY_CLEAR = 0;
	const MV_AES_KEY_CLEAR_STR = "None";
	const MV_AES_KEY_128 = 16;
	const MV_AES_KEY_128_STR = "128 bit";
	const MV_AES_KEY_256 = 32;
	const MV_AES_KEY_256_STR = "256 bit";
	const MV_AES_KEY_PERSIST = 0xFF;
	const MV_AES_KEY_PERSIST_STR = "Persist";

	public static function getKeyLengthStr($key_length)
	{
		switch ($key_length)
		{
			case self::MV_AES_KEY_128:
				return self::MV_AES_KEY_128_STR;
			case self::MV_AES_KEY_256:
				return self::MV_AES_KEY_256_STR;
			case self::MV_AES_KEY_PERSIST:
			default:
				return self::MV_AES_KEY_PERSIST_STR;
		}
	}
}

class AESCryptoStatus
{
    const HD_AES_CRYPTO_DISK = 1;
    const HD_AES_KEY_MATCHED = 2;

    const HD_AES_CRYPTO_STR = "Crypto Disk";
    const HD_AES_KEY_MISMATCHED_STR = "Crypto Disk(cipher mismatched)";
    const HD_AES_PLAINDISK = "Plain Disk";

    public static function getAesCryptoStatusStr($status)
    {
        switch ($status)
        {
            case self::HD_AES_CRYPTO_DISK | self::HD_AES_KEY_MATCHED:
                return self::HD_AES_CRYPTO_STR;
            case self::HD_AES_CRYPTO_DISK:
                return self::HD_AES_KEY_MISMATCHED_STR;
            default:
                return self::HD_AES_PLAINDISK;
        }        
    }
}

class RebuildParam
{
	const REBUILD_VD = 1;
	const REBUILD_DG = 2;
}

class LEDStatus
{
	const SGPIO_LED_LOW = 0;
	/*const SGPIO_LED_HIGH = 1;
	const SGPIO_LED_BLINK_A = 2;
	const SGPIO_LED_BLINK_INVRT_A = 3;
	const SGPIO_LED_BLINK_SOF = 4;
	const SGPIO_LED_BLINK_EOF = 5;
	const SGPIO_LED_BLINK_B = 6;
	const SGPIO_LED_BLINK_INVRT_B = 7;*/

	const LED_ON_IMG = "ledon.gif";
	const LED_OFF_IMG = "ledoff.gif";
	const LED_BLINK_IMG = "ledblink.gif";

	public static function GetLEDImg ($StatusInt)
	{
		switch ($StatusInt)
		{
			case self::SGPIO_LED_LOW:
				return self::LED_OFF_IMG;
			default:
				return self::LED_ON_IMG;
		}
	}
}

class LEDType
{
	const SGPIO_LED_ACTIVITY = 0;
	const SGPIO_LED_LOCATE = 1;
	const SGPIO_LED_ERROR = 2;
	const SGPIO_LED_ALL = 0xff;
}

class ENCStatus
{
	const STATUS_NOT_EXIST = 0;
	const STATUS_NOT_EXIST_STR = "Not exist";

	const ENC_STATUS_OK = 1;
	const ENC_STATUS_OK_STR = "OK";

	const ENC_STATUS_UNSTABLE = 2;
	const ENC_STATUS_UNSTABLE_STR = "Unstable";

	public static function GetStatusStr($statusInt)
	{
		switch ($statusInt)
		{
			case self::ENC_STATUS_OK :
				return self::ENC_STATUS_OK_STR ;
			case self::ENC_STATUS_UNSTABLE :
				return self::ENC_STATUS_UNSTABLE_STR ;
			default:
				return "Unknown"; // (" . $statusInt . ")
		}
	}
}

class ENCType
{
	const ENC_TYPE_UNKNOW = 0;
	const ENC_TYPE_UNKNOW_STR = "Unknown";

	const ENC_TYPE_SATA = 1;
	const ENC_TYPE_SATA_STR = "SATA Enclosure";

	const ENC_TYPE_SAS = 2;
	const ENC_TYPE_SAS_STR = "SAS Enclosure";

	public static function GetTypeStr($typeInt)
	{
		switch ($typeInt)
		{
			case self::ENC_TYPE_SAS :
				return self::ENC_TYPE_SAS_STR ;
			case self::ENC_TYPE_SATA :
				return self::ENC_TYPE_SATA_STR ;
			default:
				return "Unknown (" . $typeInt . ")";
		}
	}
}

class ENCElementStatus
{
	const SES2_ELEMENT_STATUS_UNSUPPORT = 0;
	const SES2_ELEMENT_STATUS_UNSUPPORT_STR = "Unsupport";
	const SES2_ELEMENT_STATUS_OK = 1;
	const SES2_ELEMENT_STATUS_OK_STR = "OK";
	const SES2_ELEMENT_STATUS_CRITICAL = 2;
	const SES2_ELEMENT_STATUS_CRITICAL_STR = "Critical";
	const SES2_ELEMENT_STATUS_NONCRITICAL = 3;
	const SES2_ELEMENT_STATUS_NONCRITICAL_STR = "Not critical";
	const SES2_ELEMENT_STATUS_UNRECOVERABLE = 4;
	const SES2_ELEMENT_STATUS_UNRECOVERABLE_STR = "Unrecoverable";
	const SES2_ELEMENT_STATUS_NOTINSTALL = 5;
	const SES2_ELEMENT_STATUS_NOTINSTALL_STR = "Not installed";
	const SES2_ELEMENT_STATUS_UNKNOWN = 6;
	const SES2_ELEMENT_STATUS_UNKNOWN_STR = "Unknown";
	const SES2_ELEMENT_STATUS_NOTAVAILABLE = 7;
	const SES2_ELEMENT_STATUS_NOTAVAILABLE_STR = "Not available";
	const SES2_ELEMENT_STATUS_ACCESSALLOWED = 8;
	const SES2_ELEMENT_STATUS_ACCESSALLOWED_STR = "Access allowed";

	public static function getENCElementStatus($statusInt)
	{
		switch ($statusInt)
		{
			case self::SES2_ELEMENT_STATUS_OK ;
				return self::SES2_ELEMENT_STATUS_OK_STR;
			case self::SES2_ELEMENT_STATUS_ACCESSALLOWED :
				return self::SES2_ELEMENT_STATUS_ACCESSALLOWED_STR ;
			case self::SES2_ELEMENT_STATUS_CRITICAL :
				return self::SES2_ELEMENT_STATUS_CRITICAL_STR ;
			case self::SES2_ELEMENT_STATUS_NONCRITICAL :
				return self::SES2_ELEMENT_STATUS_NONCRITICAL_STR ;
			case self::SES2_ELEMENT_STATUS_NOTAVAILABLE :
				return self::SES2_ELEMENT_STATUS_NOTAVAILABLE_STR ;
			case self::SES2_ELEMENT_STATUS_NOTINSTALL :
				return self::SES2_ELEMENT_STATUS_NOTINSTALL_STR ;
			case self::SES2_ELEMENT_STATUS_UNRECOVERABLE :
				return self::SES2_ELEMENT_STATUS_UNRECOVERABLE_STR ;
			case self::SES2_ELEMENT_STATUS_UNSUPPORT :
				return self::SES2_ELEMENT_STATUS_UNSUPPORT_STR ;
			default:
				return self::SES2_ELEMENT_STATUS_UNKNOWN_STR ." (" . $statusInt . ")";
		}
	}
}

//belows not localized
class ENCElementWarnBit
{
	const ENC_POWERSUPPLY_TEMPWARN = 4;
	const ENC_POWERSUPPLY_TEMPWARN_STR = "Over temperature warning";
	const ENC_POWERSUPPLY_HOTSWAP = 128;
	const ENC_POWERSUPPLY_HOTSWAP_STR = "Hot swappable";
	const ENC_POWERSUPPLY_DCOVERCURRENT = 3;
	const ENC_POWERSUPPLY_DCOVERCURRENT_STR = "DC over current";
	const ENC_POWERSUPPLY_DCOVER = 2;
	const ENC_POWERSUPPLY_DCOVER_STR = "DC over voltage";
	const ENC_POWERSUPPLY_DCUNDER = 1;
	const ENC_POWERSUPPLY_DCUNDER_STR = "DC under voltage";

	const ENC_TEMPSENSOR_UTWARN = 1;
	const ENC_TEMPSENSOR_UTWARN_STR = "Under temperature warning";
	const ENC_TEMPSENSOR_UTFAIL = 2;
	const ENC_TEMPSENSOR_UTFAIL_STR = "Under temperature failure";
	const ENC_TEMPSENSOR_OTWARN = 4;
	const ENC_TEMPSENSOR_OTWARN_STR = "Over temperature warning";
	const ENC_TEMPSENSOR_OTFAIL = 8;
	const ENC_TEMPSENSOR_OTFAIL_STR = "Over temperature failure";

	const ENC_VOLTAGESENSOR_WARNOVER = 8;
	const ENC_VOLTAGESENSOR_WARNOVER_STR = "Over voltage warning";
	const ENC_VOLTAGESENSOR_WARNUNDER = 4;
	const ENC_VOLTAGESENSOR_WARNUNDER_STR = "Under voltage warning";
	const ENC_VOLTAGESENSOR_CRITOVER = 2;
	const ENC_VOLTAGESENSOR_CRITOVER_STR = "Critical over voltage";
	const ENC_VOLTAGESENSOR_CRITUNDER = 1;
	const ENC_VOLTAGESENSOR_CRITUNDER_STR = "Critical under voltage";

	public static function getENCElementWarnBit($typeInt, $warnInt)
	{
		$RetVal = "No warning";
		switch ($typeInt)
		{
			case ENCElementType::ENC_ELEMENTTYPE_POWERSUPPLY :
				if ($warnInt & self::ENC_POWERSUPPLY_HOTSWAP)
				{
					$RetVal = self::ENC_POWERSUPPLY_TEMPWARN_STR ;
				} elseif ($warnInt & self::ENC_POWERSUPPLY_TEMPWARN)
				{
					$RetVal = self::ENC_POWERSUPPLY_TEMPWARN_STR ;
				} elseif ($warnInt & self::ENC_POWERSUPPLY_DCOVER)
				{
					$RetVal = self::ENC_POWERSUPPLY_DCOVER_STR ;
				} elseif ($warnInt & self::ENC_POWERSUPPLY_DCUNDER)
				{
					$RetVal = self::ENC_POWERSUPPLY_DCUNDER_STR ;
				}
			case ENCElementType::ENC_ELEMENTTYPE_COOLING :
				break;
			case ENCElementType::ENC_ELEMENTTYPE_TEMPERATURE :
				if ($warnInt & self::ENC_TEMPSENSOR_OTFAIL)
					$RetVal = self::ENC_TEMPSENSOR_OTFAIL_STR ;
				elseif ($warnInt & self::ENC_TEMPSENSOR_OTWARN)
					$RetVal = self::ENC_TEMPSENSOR_OTWARN_STR ;
				elseif ($warnInt & self::ENC_TEMPSENSOR_UTFAIL)
					$RetVal = self::ENC_TEMPSENSOR_UTFAIL_STR ;
				elseif ($warnInt & self::ENC_TEMPSENSOR_UTWARN)
					$RetVal = self::ENC_TEMPSENSOR_UTWARN_STR ;
		}
		return $RetVal;
	}
}

class ENCFan
{
	const FANSTOP = 0;
	const FANSTOP_STR = "Stop";
	const FANLOWEST = 1;
	const FANLOWEST_STR = "At lowest speed";
	const FANLOWER = 2;
	const FANLOWER_STR = "At lower speed";
	const FANLOW = 3;
	const FANLOW_STR = "At low speed";
	const FANNORMAL = 4;
	const FANNORMAL_STR = "At normal speed";
	const FANHIGH = 5;
	const FANHIGH_STR = "At high speed";
	const FANHIGHER = 6;
	const FANHIGHER_STR = "At higher speed";
	const FANHIGHEST = 7;
	const FANHIGHEST_STR = "At highest speed";

	public static function GetFanSpeedLevel($speed) {
		switch ($speed) {
			case self::FANSTOP :
				return self::FANSTOP_STR ;
			case self::FANLOWEST :
				return self::FANLOWEST_STR ;
			case self::FANLOWER :
				return self::FANLOWER_STR ;
			case self::FANLOW :
				return self::FANLOW_STR ;
			case self::FANNORMAL :
				return self::FANNORMAL_STR ;
			case self::FANHIGH :
				return self::FANHIGH_STR ;
			case self::FANHIGHER :
				return self::FANHIGHER_STR ;
			case self::FANHIGHEST :
				return self::FANHIGHEST_STR ;
			default:
				break;
		}
	}
}
class ENCElementImg
{
	const POWER_OK_IMG = "power.gif";
	const POWER_WARN_IMG = "power_warn.gif";
	const POWER_CRITICAL_IMG = "power_critical.gif";
	const POWER_DISABLE_IMG = "power_disable.gif";

	const ENC_COOLING_IMG = "fanon.gif";
	const ENC_COOLING_STOP_IMG = "fanoff.gif";

	const ENC_TPR_IMG = "tpr.gif";
	const ENC_VOL_IMG = "vol.gif";

	public static function GetPowerImg($status)
	{
		switch ($status)
		{
			case ENCElementStatus::SES2_ELEMENT_STATUS_CRITICAL :
				return self::POWER_CRITICAL_IMG ;
			case ENCElementStatus::SES2_ELEMENT_STATUS_OK :
				return self::POWER_OK_IMG ;
			default :
				return self::POWER_CRITICAL_IMG ;
		}
	}

	public static function GetFanImg($status)
	{
		if (($status != ENCElementStatus::SES2_ELEMENT_STATUS_OK
		     && $status != ENCElementStatus::SES2_ELEMENT_STATUS_CRITICAL
		     && $status != ENCElementStatus::SES2_ELEMENT_STATUS_NONCRITICAL
		     && $status != ENCElementStatus::SES2_ELEMENT_STATUS_ACCESSALLOWED)
		     )
		{
			return self::ENC_COOLING_STOP_IMG ;
		} else {
			return self::ENC_COOLING_IMG ;
		}
	}

}

class ENCElementType
{
	const ENCUNKNOW_STR = "Unknown";
	const ENC_ELEMENTTYPE_UNKNOWN = 0;

	const POWERSUPPLY_STR = "Power";
	const ENC_ELEMENTTYPE_POWERSUPPLY = 2;

	const COOLING_STR = "Fan";
	const ENC_ELEMENTTYPE_COOLING = 3;

	const TEMPERATURE_STR = "Temperature sensor";
	const ENC_ELEMENTTYPE_TEMPERATURE = 4;

	const DOORLOCK_STR = "DoorLock";
	const ENC_ELEMENTTYPE_DOORLOCK = 5;

	const AUDIBLEALARM_STR = "Alarm";
	const ENC_ELEMENTTYPE_AUDIBLEALARM = 6;

	const DISPLAY_STR = "Display";
	const ENC_ELEMENTTYPE_DISPLAY = 12;

	const VOLTAGESENSOR_STR = "Voltage sensor";
	const ENC_ELEMENTTYPE_VOLTAGESENSOR = 18;

	public static function GetTypeStr($typeInt)
	{
		switch ($typeInt)
		{
			case self::ENC_ELEMENTTYPE_POWERSUPPLY :
				return self::POWERSUPPLY_STR ;
			case self::ENC_ELEMENTTYPE_COOLING :
				return self::COOLING_STR ;
			case self::ENC_ELEMENTTYPE_TEMPERATURE :
				return self::TEMPERATURE_STR ;
			case self::ENC_ELEMENTTYPE_VOLTAGESENSOR :
				return self::VOLTAGESENSOR_STR ;
			default:
				return "Unknown (" . $typeInt . ")";
		}
	}
}

class RAIDMode
{
	const RAID0 = "RAID 0";
	const RAID0_L = "RAID 0 (striping)";
	const LD_MODE_RAID0 = 0;

	const RAID1 = "RAID 1";
	const LD_MODE_RAID1 = 0x1;

	const RAID1E = "RAID 1E";
	const LD_MODE_RAID1E = 0x11;

	const RAID5 = "RAID 5";
	const RAID5_L = "RAID 5 (parity)";
	const LD_MODE_RAID5 = 0x5;

	const RAID6 = "RAID 6";
	const LD_MODE_RAID6 = 0x6;

	const JBOD = "JBOD";
	const LD_MODE_JBOD = 0x0f;

	const RAID10 = "RAID 10";
	const LD_MODE_RAID10 = 0x10;

	const RAID50 = "RAID 50";
	const LD_MODE_RAID50 = 0x50;

	const RAID60 = "RAID 60";
	const LD_MODE_RAID60 = 0x60;

	const HyperHDD = "HyperDuo";
	const HDDSPAN = "Capacity";
	const HDDSPAN_L = "HyperDuo (Capacity)";
	const LD_MODE_HyperHDD = 0x0a;

	const HDDMirror = "Safe";
	const HDDMirror_L = "HyperDuo (Safe)";
	const LD_MODE_RAID_HDD_MIRROR = 0x0b;

	const Hybrid = "Hybrid";
	const Hybrid_L = "Hybrid(hypper hibrid)";
	const LD_MODE_RAID_HDD_MIRROR_HYBRID = 0x0c;

	public static function GetSSDVolumeRAIDModeStr($raidMode)
	{
		switch ($raidMode)
		{
			case self::LD_MODE_RAID0 :
				return self::RAID0_L;
			case self::LD_MODE_RAID5:
				return self::RAID5_L;
			case self::LD_MODE_RAID1 :
				return self::RAID1;
			case self::LD_MODE_RAID1E :
				return self::RAID1E;
			case self::LD_MODE_RAID6 :
				return self::RAID6;
			case self::LD_MODE_JBOD :
				return self::JBOD;
			case self::LD_MODE_RAID10 :
				return self::RAID10;
			case self::LD_MODE_RAID50 :
				return self::RAID50;
			case self::LD_MODE_RAID60 :
				return self::RAID60;
			case self::LD_MODE_HyperHDD :
				return self::HDDSPAN;
			case self::LD_MODE_RAID_HDD_MIRROR :
				return self::HDDMirror;
			case self::LD_MODE_RAID_HDD_MIRROR_HYBRID :
				return self::Hybrid;
			default:
				return "Unknown (" . $raidMode . ")";
		}
	}

	public static function GetRAIDModeStr($raidMode)
	{
		switch ($raidMode)
		{
			case self::LD_MODE_RAID0 :
				return self::RAID0;
			case self::LD_MODE_RAID1 :
				return self::RAID1;
			case self::LD_MODE_RAID1E :
				return self::RAID1E;
			case self::LD_MODE_RAID5 :
				return self::RAID5;
			case self::LD_MODE_RAID6 :
				return self::RAID6;
			case self::LD_MODE_JBOD :
				return self::JBOD;
			case self::LD_MODE_RAID10 :
				return self::RAID10;
			case self::LD_MODE_RAID50 :
				return self::RAID50;
			case self::LD_MODE_RAID60 :
				return self::RAID60;
			case self::LD_MODE_HyperHDD :
				return self::HyperHDD;
			case self::LD_MODE_RAID_HDD_MIRROR_HYBRID :
				return self::Hybrid;
			default:
				return "Unknown (" . $raidMode . ")";
		}
	}


	public static function GetHyperHddSubModeStr($subMode)
	{
		switch ($subMode)
		{
			case self::LD_MODE_RAID_HDD_MIRROR:
				return self::HDDMirror;
			case self::LD_MODE_HyperHDD :
			default:
				return self::HDDSPAN;
		}
	}
}

class DGStatus
{
	const DG_STATUS_FUNCTIONAL = 0;
	const DG_STATUS_FUNCTIONAL_STR = "Functional";
	const DG_STATUS_PD_MISSING = 1;
	const DG_STATUS_PD_MISSING_STR = "PD Missing";
	const DG_STATUS_PD_OFFLINE =2;
	const DG_STATUS_PD_OFFLINE_STR = "PD offline";

	const DG_IMG_FUNCTIONAL = "Array_Online.gif";
	const DG_IMG_PD_Missing = "Array_Degrade.gif";
	const DG_IMG_PD_Offline = "Array_Degrade.gif";
	//const DG_IMG_Offline = "Array_Offline.gif";
	//const DG_IMG_Partiallyoptimal = "Array_Partiallyoptimal.gif";
	//const DG_IMG_Foreign = "Array_Foreign.gif";

	public static function getDGImg($StatusInt)
	{
		$RetStr = "";
		switch ($StatusInt)
		{
			case self::DG_STATUS_FUNCTIONAL :
				$RetStr = self::DG_IMG_FUNCTIONAL ;
				break;
			case self::DG_STATUS_PD_MISSING  :
				$RetStr = self::DG_IMG_PD_Missing ;
				break;
			case self::DG_STATUS_PD_OFFLINE :
				$RetStr = self::DG_IMG_PD_Offline ;
				break;
			default :
				$RetStr = self::DG_IMG_FUNCTIONAL ;
				break;
		}
		return $RetStr;
	}


	public static function getDGStatusStr($StatusInt)
	{
		$RetStr = "";
		switch ($StatusInt)
		{
			case DGStatus::DG_STATUS_FUNCTIONAL  :
				$RetStr = DGStatus::DG_STATUS_FUNCTIONAL_STR ;
				break;
			case DGStatus::DG_STATUS_PD_MISSING  :
				$RetStr = DGStatus::DG_STATUS_PD_MISSING_STR ;
				break;
			case self::DG_STATUS_PD_OFFLINE :
				$RetStr = DGStatus::DG_STATUS_PD_OFFLINE_STR ;
				break;
			default :
				$RetStr = "Unknown";
				break;
		}
		return $RetStr;
	}


}

class LDStatus
{
	const LD_STATUS_FUNCTIONAL = 0;
	const LD_STATUS_FUNCTIONAL_STR = "Functional";
	const LD_STATUS_DEGRADED = 1;
	const LD_STATUS_DEGRADED_STR = "Degraded";
	const LD_STATUS_DELETED = 2;
	const LD_STATUS_DELETED_STR = "Deleted";
	const LD_STATUS_MISSING = 3;
	const LD_STATUS_MISSING_STR = "Missing";
	const LD_STATUS_OFFLINE = 4;
	const LD_STATUS_OFFLINE_STR = "Offline";
	const LD_STATUS_PARTIALLYOPTIMAL = 5;
	const LD_STATUS_PARTIALLYOPTIMAL_STR = "Partial Optimal";
	const LD_STATUS_FOREIGN = 6;
	const LD_STATUS_FOREIGN_STR = "Foreign";
	const LD_STATUS_IMPORTABLE = 7;
	const LD_STATUS_IMPORTABLE_STR = "Importable Foreign";
	const LD_STATUS_NOT_IMPORTABLE = 8;
	const LD_STATUS_NOT_IMPORTABLE_STR = "Not Importable Foreign";
	const LD_STATUS_MIGRATION = 9;
	const LD_STATUS_MIGRATION_STR = "Migrating";
	const LD_STATUS_REBUILDING = 10;
	const LD_STATUS_REBUILDING_STR = "Rebuilding";
	const LD_STATUS_CONFLICTED = 11;
	const LD_STATUS_CONFLICTED_STR = "Conflicted";
	const LD_STATUS_DEGRADE_PLUGIN = 12;
	const LD_STATUS_DEGRADE_PLUGIN_STR = "Degrade Plugin";
	const HYPERHDD_STATUS_REBUILD_STR = "Initializing";
    const LD_STATUS_HYPER_UNINIT  = 13; // this specail status only for magni
    const LD_STATUS_HYPER_UNINIT_STR  = "Hyper uninit";
    const LD_STATUS_HYPER_USING_TABLE = 14;
    const LD_STATUS_HYPER_USING_TABLE_STR = "Using table";
    const LD_STATUS_INITIALIZED = 15;
    const LD_STATUS_INITIALIZED_STR = "functional and initialized";
	//const LD_STATUS_INVALID = 0xff;
	//const LD_STATUS_INVALID_STR = 0xff;

	const LD_IMG_Online = "RAID_online.gif";
	const LD_IMG_Online_Bga = "RAID_online_bga.gif";
	const LD_IMG_Degrade = "RAID_degrade.gif";
	const LD_IMG_Degrade_Bga = "RAID_degrade_bga.gif";
	const LD_IMG_Offline = "RAID_offline.gif";
	const LD_IMG_Partiallyoptimal = "RAID_partiallyoptimal.gif";
	const LD_IMG_Partiallyoptimal_Bga = "RAID_partiallyoptimal_bga.gif";
	const LD_IMG_Foreign = "RAID_foreign.gif";
	const LD_IMG_Conflict = "RAID_conflict.gif";

	public static function getHyperHDDStatus($StatusInt)
	{
		if ($StatusInt == self::LD_STATUS_DEGRADED ) {
			return self::HYPERHDD_STATUS_REBUILD_STR ;
		} else {
			return self::getLDStatusStr($StatusInt);
		}
	}
	
	public static function getLDImg($StatusInt, $BGAStatusInt=0)
	{
		$RetStr = "";
		switch ($StatusInt)
		{
			case self::LD_STATUS_INITIALIZED:
			case self::LD_STATUS_FUNCTIONAL :
				if ($BGAStatusInt != LdBgaState::LD_BGA_STATE_NONE)
					$RetStr = self::LD_IMG_Online_Bga ;
				else
					$RetStr = self::LD_IMG_Online ;
				break;
			case self::LD_STATUS_DEGRADED  :
            case self::LD_STATUS_HYPER_USING_TABLE:
				if ($BGAStatusInt != LdBgaState::LD_BGA_STATE_NONE)
					$RetStr = self::LD_IMG_Degrade_Bga ;
				else
					$RetStr = self::LD_IMG_Degrade ;
				break;
			case self::LD_STATUS_OFFLINE :
				$RetStr = self::LD_IMG_Offline;
				break;
			case self::LD_STATUS_PARTIALLYOPTIMAL :
				if ($BGAStatusInt != LdBgaState::LD_BGA_STATE_NONE)
					$RetStr = self::LD_IMG_Partiallyoptimal_Bga ;
				else
					$RetStr = self::LD_IMG_Partiallyoptimal;
				break;
			case self::LD_STATUS_FOREIGN :
			case self::LD_STATUS_IMPORTABLE :
			case self::LD_STATUS_NOT_IMPORTABLE :
				$RetStr = self::LD_IMG_Foreign;
				break;
			case self::LD_STATUS_CONFLICTED:
				$RetStr = self::LD_IMG_Conflict;
				break;
			case self::LD_STATUS_DEGRADE_PLUGIN:
				$RetStr = self::LD_IMG_Degrade;
				break;
			//case self::LD_STATUS_MIGRATION :
			//	$RetStr = self::LD_IMG_Online_Bga ;
				//break;
			default :
				$RetStr = self::LD_IMG_Foreign ;
				break;
		}
		return $RetStr;
	}

	public static function getSSDVolumeStatusStrFont($StatusInt)
	{
		switch ($StatusInt)
		{
			case self::LD_STATUS_FUNCTIONAL :
				return "green"; //green
			case self::LD_STATUS_DEGRADED :
			case self::LD_STATUS_PARTIALLYOPTIMAL :
				return "orange";
			case self::LD_STATUS_OFFLINE :
				return "red"; //red
			default :
				return "#000000";
		}
	}


	public static function getLDStatusStr($StatusInt)
	{
		$RetStr = "";
		switch ($StatusInt)
		{
			case self::LD_STATUS_FUNCTIONAL :
				$RetStr = self::LD_STATUS_FUNCTIONAL_STR;
				break;
			case self::LD_STATUS_DEGRADED  :
				$RetStr = self::LD_STATUS_DEGRADED_STR;
				break;
			case self::LD_STATUS_DELETED  :
				$RetStr = self::LD_STATUS_DELETED_STR;
				break;
			case self::LD_STATUS_MISSING :
				$RetStr = self::LD_STATUS_MISSING_STR;
				break;
			case self::LD_STATUS_OFFLINE :
				$RetStr = self::LD_STATUS_OFFLINE_STR;
				break;
			case self::LD_STATUS_PARTIALLYOPTIMAL :
				$RetStr = self::LD_STATUS_PARTIALLYOPTIMAL_STR;
				break;
			case self::LD_STATUS_FOREIGN :
				$RetStr = self::LD_STATUS_FOREIGN_STR;
				break;
			case self::LD_STATUS_IMPORTABLE :
				$RetStr = self::LD_STATUS_IMPORTABLE_STR ;
				break;
			case self::LD_STATUS_NOT_IMPORTABLE :
				$RetStr = self::LD_STATUS_NOT_IMPORTABLE_STR ;
				break;
			case self::LD_STATUS_CONFLICTED :
				$RetStr = self::LD_STATUS_CONFLICTED_STR ;
				break;
			case self::LD_STATUS_DEGRADE_PLUGIN:
				$RetStr = self::LD_STATUS_DEGRADE_PLUGIN_STR;
				break;
            case self::LD_STATUS_HYPER_USING_TABLE:
				$RetStr = self::LD_STATUS_HYPER_USING_TABLE_STR;
				break;
			case self::LD_STATUS_INITIALIZED:
				$RetStr = self::LD_STATUS_INITIALIZED_STR;
				break;
		/*	case self::LD_STATUS_MIGRATION :
				$RetStr = self::LD_STATUS_MIGRATION_STR;
				break;*/
			default :
				$RetStr = "Unknown";
				break;
		}
		return $RetStr;
	}
}

class LdBgaStatus
{
	const LD_BGA_NONE = 0;
	const LD_BGA_NONE_STR = "None";
	const LD_BGA_REBUILD = 1;
	const LD_BGA_REBUILD_STR = "Rebuild";
	const LD_BGA_CONSISTENCY_FIX = 2;
	const LD_BGA_CONSISTENCY_FIX_STR = "Consistency Fix";
	const LD_BGA_CONSISTENCY_CHECK = 4;
	const LD_BGA_CONSISTENCY_CHECK_STR = "Consistency Check";
	const LD_BGA_INIT_QUICK = 8;
	const LD_BGA_INIT_QUICK_STR = "Fast Initialization";
	const LD_BGA_INIT_BACK = 16;
	const LD_BGA_INIT_BACK_STR = "Background Initialization";
	const LD_BGA_MIGRATION = 32;
	const LD_BGA_MIGRATION_STR = "Migration";
	const LD_BGA_INIT_FORE = 64;
	const LD_BGA_INIT_FORE_STR = "Foreground Initialization";
	const LD_BGA_COPYBACK =128;
	const LD_BGA_COPYBACK_STR = "Copy Back";
	const LD_BGA_DEFECT_FIXING =256;
	const LD_BGA_DEFECT_FIXING_STR = "Defect Fixing";
	const LD_BGA_MEDIA_PATROL =512;
	const LD_BGA_MEDIA_PATROL_STR = "Media Patrol";
	const LD_BGA_MIGRATION_EXT =1024;
	const LD_BGA_MIGRATION_EXT_STR = "Migration ext";
	const LD_BGA_UNKNOWN_STR = "Unknown bga action";
	const HYPERHDD_REBUILD_STR = "Initialize";

	
	public static function getHyperHDDBgaStatusStr($Status)
	{
		if ($Status == self::LD_BGA_REBUILD) {
			return self::HYPERHDD_REBUILD_STR ;
		} else {
			return self::getLdBgaStatusStr($Status);
		}
	}
	
	public static function getHyperHDDBgaStr($Status)
	{
		if ($Status == self::LD_BGA_REBUILD) {
			return self::HYPERHDD_REBUILD_STR ;
		} else {
			return self::getLdBgaString($Status);
		}
	}
	
	public static function getLdBgaStatusStr($Status)
	{
		$RetStr = "";
		switch ($Status)
		{
			case self::LD_BGA_NONE :
				$RetStr = self::LD_BGA_NONE_STR;
				break;
			case self::LD_BGA_REBUILD :
				$RetStr = self::LD_BGA_REBUILD_STR;
				break;
			case self::LD_BGA_CONSISTENCY_FIX :
				$RetStr = self::LD_BGA_CONSISTENCY_FIX_STR;
				break;
			case self::LD_BGA_CONSISTENCY_CHECK :
				$RetStr = self::LD_BGA_CONSISTENCY_CHECK_STR;
				break;
			case self::LD_BGA_INIT_QUICK :
				$RetStr = self::LD_BGA_INIT_QUICK_STR;
				break;
			case self::LD_BGA_INIT_BACK :
				$RetStr = self::LD_BGA_INIT_BACK_STR;
				break;
			case self::LD_BGA_MIGRATION :
				$RetStr = self::LD_BGA_MIGRATION_STR;
				break;
			case self::LD_BGA_INIT_FORE :
				$RetStr = self::LD_BGA_INIT_FORE_STR;
				break;
			case self::LD_BGA_COPYBACK :
				$RetStr = self::LD_BGA_COPYBACK_STR;
				break;
			case self::LD_BGA_DEFECT_FIXING :
				$RetStr = self::LD_BGA_DEFECT_FIXING_STR;
				break;
			case self::LD_BGA_MEDIA_PATROL :
				$RetStr = self::LD_BGA_MEDIA_PATROL_STR;
				break;
			case self::LD_BGA_MIGRATION_EXT :
				$RetStr = self::LD_BGA_MIGRATION_EXT_STR;
				break;
			default:
				$RetStr = self::LD_BGA_UNKNOWN_STR ;
		}
		return $RetStr;
	}

	public static function getLdBgaString($status)
	{
		$RetStr = '';
		switch ($status)
		{
			case self::LD_BGA_NONE :
				$RetStr = 'None';
				break;
			case self::LD_BGA_REBUILD :
				$RetStr = 'Rebuild';
				break;
			case self::LD_BGA_CONSISTENCY_FIX :
				$RetStr = 'Consistency fix';
				break;
			case self::LD_BGA_CONSISTENCY_CHECK :
				$RetStr = 'Consistency check';
				break;
			case self::LD_BGA_INIT_QUICK :
				$RetStr = 'Quick initialization';
				break;
			case self::LD_BGA_INIT_BACK :
				$RetStr = 'Background initialization';
				break;
			case self::LD_BGA_MIGRATION :
				$RetStr = 'Migration';
				break;
			case self::LD_BGA_INIT_FORE :
				$RetStr = 'Foreground initialization';
				break;
			case self::LD_BGA_COPYBACK :
				$RetStr = 'Copy back';
				break;
			default:
				$RetStr = 'Unknown bga action';
		}
		return $RetStr;
	}
}

class LdBgaState
{
	const LD_BGA_STATE_NONE = 0;
	const LD_BGA_STATE_NONE_STR = "none";
	const LD_BGA_STATE_RUNNING = 1;
	const LD_BGA_STATE_RUNNING_STR = "running";
	const LD_BGA_STATE_ABORTED = 2;
	const LD_BGA_STATE_ABORTED_STR = "aborted";
	const LD_BGA_STATE_PAUSED = 3;
	const LD_BGA_STATE_PAUSED_STR = "paused";
	const LD_BGA_STATE_AUTOPAUSED = 4;
	const LD_BGA_STATE_AUTOPAUSED_STR = "auto paused";
	const LD_BGA_STATE_DDF_PENDING = 128;
	const LD_BGA_STATE_DDF_PENDING_STR = "DDF pending";

	public static function getLdBgaStateStr($BgaStateInt)
	{
		$RetStr = "";
		switch ($BgaStateInt)
		{
			case self::LD_BGA_STATE_NONE :
				$RetStr = self::LD_BGA_STATE_NONE_STR;
				break;
			case self::LD_BGA_STATE_RUNNING :
				$RetStr = self::LD_BGA_STATE_RUNNING_STR;
				break;
			case self::LD_BGA_STATE_ABORTED :
				$RetStr = self::LD_BGA_STATE_ABORTED_STR;
				break;
			case self::LD_BGA_STATE_PAUSED :
				$RetStr = self::LD_BGA_STATE_PAUSED_STR;
				break;
			case self::LD_BGA_STATE_AUTOPAUSED :
				$RetStr = self::LD_BGA_STATE_AUTOPAUSED_STR;
				break;
			case self::LD_BGA_STATE_DDF_PENDING :
				$RetStr = self::LD_BGA_STATE_DDF_PENDING_STR;
				break;
			default:
				$RetStr = self::LD_BGA_STATE_NONE_STR;
		}
		return $RetStr;
	}
}

class BgaControl
{
	const BGA_CONTROL_START = 0;
	const BGA_CONTROL_START_STR = "start";
	const BGA_CONTROL_RESTART = 1;
	const BGA_CONTROL_RESTART_STR = "restart";
	const BGA_CONTROL_PAUSE = 2;
	const BGA_CONTROL_PAUSE_STR = "pause";
	const BGA_CONTROL_RESUME = 3;
	const BGA_CONTROL_RESUME_STR = "resume";
	const BGA_CONTROL_ABORT = 4;
	const BGA_CONTROL_ABORT_STR = "stop";
	const BGA_CONTROL_COMPLETE = 5;
	const BGA_CONTROL_COMPLETE_STR = "complete";
	const BGA_CONTROL_IN_PROCESS = 6;
	const BGA_CONTROL_IN_PROCESS_STR = "inprogress";
	const BGA_CONTROL_TERMINATE_IMMEDIATE = 7;
	const BGA_CONTROL_TERMINATE_IMMEDIATE_STR = "term";
	const BGA_CONTROL_AUTO_PAUSE = 8;
	const BGA_CONTROL_AUTO_PAUSE_STR = "autopause";

	public static function getBgaControlValue($str)
	{
		switch ($str)
		{
			case self::BGA_CONTROL_START_STR :
				return self::BGA_CONTROL_START;
			case self::BGA_CONTROL_RESTART_STR  :
				return self::BGA_CONTROL_RESTART;
			case self::BGA_CONTROL_PAUSE_STR :
				return self::BGA_CONTROL_PAUSE;
			case self::BGA_CONTROL_RESUME_STR  :
				return self::BGA_CONTROL_RESUME ;
			case self::BGA_CONTROL_ABORT_STR  :
				return self::BGA_CONTROL_ABORT ;
			case self::BGA_CONTROL_COMPLETE_STR  :
				return self::BGA_CONTROL_COMPLETE ;
			case self::BGA_CONTROL_IN_PROCESS_STR  :
				return self::BGA_CONTROL_IN_PROCESS ;
			case self::BGA_CONTROL_TERMINATE_IMMEDIATE_STR  :
				return self::BGA_CONTROL_TERMINATE_IMMEDIATE ;

		}

		return 0;
	}
}

class BGARate
{
	const MAX_BGA_RATE = 0xFA;

	public static function RateToPercentage($rate)
	{
		return round($rate * 100 / self::MAX_BGA_RATE);
	}

	public static function PercentageToRate($per)
	{
		return round($per * self::MAX_BGA_RATE / 100);
	}
}

class BgaRateRange
{
	const MaxBgaRate = 250;
	const MinBgaRate = 0;
}

class BlockFlag
{
	const INVALID = 0;
	const VALID = 1;
	const ASSIGNED = 2;
	const BLOCK_FLAG_REBUILDING = 4;
	const BLOCK_FLAG_TEMP_ASSIGN = 8;
}

class LDCacheMode
{
	const WRITEBACK_ENABLE = 0;
	const WRITEBACK_ENABLE_STR = "On(Performance)";
	const WRITEBACK_ENABLE_STATUS_STR = "On";

	const WRITETHRU_ENABLE = 1;
	const WRITETHRU_ENABLE_STR = "Off(Reliable)";
	const WRITETHRU_ENABLE_STATUS_STR = "Off";

	const ADAPTIVE_ENABLE = 2;
	const ADAPTIVE_ENABLE_STR = "Auto";

	const AUTO_ENABLE = 8;
	const AUTO_ENABLE_STR = "Auto";

	const WRITE_POLICY_FILTER = 11;

	const LOOKAHEAD_ENABLE = 4;
	const LOOKAHEAD_ENABLE_STR = "Read Ahead";
	const NO_LOOKAHEAD_STR = "No Read Ahead";

	public static function getWriteCacheModeStr($wCache){
		$Str = "";
		if ($wCache & self::AUTO_ENABLE) {//clear 'auto' bit
			$wCache &= ~self::AUTO_ENABLE;
		}
		if ($wCache == self::WRITEBACK_ENABLE) {
			$Str .= self::WRITEBACK_ENABLE_STATUS_STR ;
		} elseif ($wCache == self::WRITETHRU_ENABLE) {
			$Str .= self::WRITETHRU_ENABLE_STATUS_STR ;
		}
		return $Str;
	}
}

class LDStripeSize
{
	const StripeSize16K = 16;
	const StripeSize16KStr = "16K";
	const StripeSize32K = 32;
	const StripeSize32KStr = "32K";
	const StripeSize64K = 64;
	const StripeSize64KStr = "64K";
	const StripeSize128K = 128;
	const StripeSize128KStr = "128K";
	const StripeSize256K = 256;
	const StripeSize256KStr = "256K";
	const StripeSize512K = 512;
	const StripeSize512KStr = "512K";
	const StripeSize1024K = 1024;
	const StripeSize1024KStr = "1024K";
}

class LDSectorSize
{
	const SectorSize512B = 1;
	const SectorSize512BStr = "512B";
	const SectorSize1024B = 2;
	const SectorSize1024BStr = "1024B";
	const SectorSize2048B = 4;
	const SectorSize2048BStr = "2048B";
	const SectorSize4096B = 8;
	const SectorSize4096BStr = "4096B";
}

class EventRel
{
	const LD_EVENT = 1;
	const HD_EVENT = 2;
	const ADAPTER_EVENT = 4;
	const EXPANDER_EVENT = 8;
	const MDD_EVENT = 16;
	const BSL_EVENT = 32;

}

define("EVENTALL",EventRel::HD_EVENT | EventRel::LD_EVENT |
				EventRel::ADAPTER_EVENT | EventRel::MDD_EVENT |
				EventRel::BSL_EVENT | EventRel::EXPANDER_EVENT);

class EventNotifyType
{
	const NOTIFY_LEVEL_COUNT = 3;
	const ERROR = 4;
	const ERROR_STR = 'Error';
	const WARNING = 2;
	const WARNING_STR = 'Warning';
	const INFO = 1;
	const INFO_STR = 'Info';

	private $minServerity;
	private $maxServerity;

	public static function getEventNotifyTypeStr($Type)
	{
		switch ($Type)
		{
			case self::ERROR:
				return self::ERROR_STR ;
			case self::WARNING :
				return self::WARNING_STR ;
			case self::INFO :
				return self::INFO_STR  ;
			default:
				return 'None';
		}
	}
}

class DeviceType
{
	const DEVICE_TYPE_NONE = 0;
	const DEVICE_TYPE_NONE_STR = "None";
	const DEVICE_TYPE_HD = 1;
	const DEVICE_TYPE_HD_STR = "Physical Disk";
	const DEVICE_TYPE_PM = 2;
	const DEVICE_TYPE_PM_STR = "Port Multiplier";
	const DEVICE_TYPE_EXPANDER = 3;
	const DEVICE_TYPE_EXPANDER_STR = "Expander";
	const DEVICE_TYPE_TAPE = 4;
	const DEVICE_TYPE_TAPE_STR = "Tape";
	const DEVICE_TYPE_PRINTER = 5;
	const DEVICE_TYPE_PRINTER_STR = "Printer";
	const DEVICE_TYPE_PROCESSOR = 6;
	const DEVICE_TYPE_PROCESSOR_STR = "Processor";
	const DEVICE_TYPE_WRITE_ONCE = 7;
	const DEVICE_TYPE_WRITE_ONCE_STR = "Write Once Device";
	const DEVICE_TYPE_CD_DVD = 8;
	const DEVICE_TYPE_CD_DVD_STR = "CD/DVD";
	const DEVICE_TYPE_OPTICAL_MEMORY = 9;
	const DEVICE_TYPE_OPTICAL_MEMORY_STR = "Optical Memory";
	const DEVICE_TYPE_MEDIA_CHANGER = 10;
	const DEVICE_TYPE_MEDIA_CHANGER_STR = "Media Changer";
	const DEVICE_TYPE_ENCLOSURE = 11;
	const DEVICE_TYPE_ENCLOSURE_STR = "Enclosure";
	const DEVICE_TYPE_I2C_ENCLOSURE = 12;
	const DEVICE_TYPE_I2C_ENCLOSURE_STR = "I2C Enclosure";
	const DEVICE_TYPE_PORT = 0xff;
	const DEVICE_TYPE_PORT_STR = "HBA";

	const DEVICE_TYPE_UNKNOWN_STR = "Unknown Device";

	public static function getDeviceTypeStr($DeviceType)
	{
		switch ($DeviceType)
		{
			case self::DEVICE_TYPE_NONE :
				return self::DEVICE_TYPE_NONE_STR;
			case self::DEVICE_TYPE_HD :
				return self::DEVICE_TYPE_HD_STR;
			case self::DEVICE_TYPE_PM :
				return self::DEVICE_TYPE_PM_STR;
			case self::DEVICE_TYPE_EXPANDER :
				return self::DEVICE_TYPE_EXPANDER_STR;
			case self::DEVICE_TYPE_TAPE :
				return self::DEVICE_TYPE_TAPE_STR;
			case self::DEVICE_TYPE_PRINTER :
				return self::DEVICE_TYPE_PRINTER_STR;
			case self::DEVICE_TYPE_PROCESSOR :
				return self::DEVICE_TYPE_PROCESSOR_STR;
			case self::DEVICE_TYPE_WRITE_ONCE :
				return self::DEVICE_TYPE_WRITE_ONCE_STR;
			case self::DEVICE_TYPE_CD_DVD :
				return self::DEVICE_TYPE_CD_DVD_STR;
			case self::DEVICE_TYPE_OPTICAL_MEMORY :
				return self::DEVICE_TYPE_OPTICAL_MEMORY_STR;
			case self::DEVICE_TYPE_MEDIA_CHANGER :
				return self::DEVICE_TYPE_MEDIA_CHANGER_STR;
			case self::DEVICE_TYPE_ENCLOSURE :
				return self::DEVICE_TYPE_ENCLOSURE_STR;
			case self::DEVICE_TYPE_I2C_ENCLOSURE :
			case self::DEVICE_TYPE_PORT :
				return self::DEVICE_TYPE_PORT_STR;
			default:
				return self::DEVICE_TYPE_UNKNOWN_STR;
		}
	}
}

class HdSetStatus
{
	const HD_STATUS_SETONLINE = 0;
	const HD_STATUS_SETOFFLINE = 1;
	const HD_STATUS_FORCESETOFFLINE = 2;
	const HD_STATUS_SETFREE = 3;

	const HD_STATUS_INVALID = 0xff;
}

class HdStatus
{
	const HD_STATUS_FREE = 1;
	const HD_STATUS_ASSIGNED = 2;
	const HD_STATUS_SPARE = 4;
	const HD_STATUS_OFFLINE = 8;
	const HD_STATUS_SMARTCHECKING = 16;
	const HD_STATUS_MP = 32;
	const HD_STATUS_DEDICATED_SPARE = 64;
	const HD_STATUS_FOREIGN = 128;

	const HD_STATUS_ASSIGNED_IMG = "Drive_Green.gif";//configured
	const HD_SSD_STATUS_ASSIGNED_IMG = "SSD_Drive_Green.gif";//configured
	const HD_STATUS_ASSIGNED_SPARE_IMG = "Drive_Green_Spare.gif";//configured spare
	const HD_STATUS_FREE_IMG = "Drive_Blue.gif";//free
	const HD_SSD_STATUS_FREE_IMG = "SSD_Drive_Blue.gif";//free
	const HD_STATUS_SPARE_IMG = "Drive_Spare.gif";//free
	const HD_STATUS_OFFLINE_IMG = "Drive_Offline.gif";//offline
	const HD_SSD_STATUS_OFFLINE_IMG = "SSD_Drive_Offline.gif";//offline
	const HD_STATUS_FOREIGN_IMG = "Drive_Foreign.gif";//foreign

	const HD_STATUS_ASSIGNED_STR = 'Configured';
	const HD_STATUS_FREE_STR = 'Unconfigured';
	const HD_STATUS_OFFLINE_STR = 'Offline';
	const HD_STATUS_FOREIGN_STR = 'Foreign';

	public static function getHDStatusStr($status)
	{
		$RetStr = "";
		if (HdStatus::HD_STATUS_FREE & $status) {
			$RetStr .= self::HD_STATUS_FREE_STR;
		}
		else if (HdStatus::HD_STATUS_ASSIGNED & $status)
		{
			$RetStr .= self::HD_STATUS_ASSIGNED_STR;
		}
		else if (HdStatus::HD_STATUS_OFFLINE & $status)
		{
			$RetStr .= self::HD_STATUS_OFFLINE_STR;
		}
		else// if (HdStatus::HD_STATUS_FOREIGN & $status)  //default
		{
			$RetStr .= self::HD_STATUS_FOREIGN_STR;
		}
		return $RetStr;
	}

	/*
	public static function getHDImg($StatusInt)
	{
		$RetImg = "";
		switch ($StatusInt)
		{
			case self::HD_STATUS_ASSIGNED :
				$RetImg = self::HD_STATUS_ASSIGNED_IMG;
				break;
			case self::HD_STATUS_FREE :
				$RetImg = self::HD_STATUS_FREE_IMG;
				break;
			case self::HD_STATUS_OFFLINE :
				$RetImg = self::HD_STATUS_OFFLINE_IMG;
				break;
			default:
				$RetImg = self::HD_STATUS_OFFLINE_IMG;
				break;
		}
		return $RetImg;
	}
	*/
}
class HdBgaStatus
{
	const HD_BGA_NONE = 0;
	const HD_BGA_NONE_STR = 'None';
	const HD_BGA_MP = 1;
	const HD_BGA_MP_STR = 'Media Patrol';
	const HD_BGA_TYPE_DATASCRUB = 2;
	const HD_BGA_TYPE_DATASCRUB_STR = 'Data Scrub';

	public static function getHdBgaStatusStr($Status)
	{
		$RetStr = "";
		switch ($Status)
		{
			case self::HD_BGA_MP :
				$RetStr = self::HD_BGA_MP_STR;
				break;
			case self::HD_BGA_TYPE_DATASCRUB :
				$RetStr = self::HD_BGA_TYPE_DATASCRUB_STR ;
				break;
			default:
				$RetStr = self::HD_BGA_NONE_STR;
		}
		return $RetStr;
	}
}

class HdBgaState   //the same as LdBgaState
{
	const HD_BGA_STATE_NONE = 0;
	const HD_BGA_STATE_NONE_STR = "none";
	const HD_BGA_STATE_RUNNING = 1;
	const HD_BGA_STATE_RUNNING_STR = "running";
	const HD_BGA_STATE_ABORTED = 2;
	const HD_BGA_STATE_ABORTED_STR = "aborted";
	const HD_BGA_STATE_PAUSED = 3;
	const HD_BGA_STATE_PAUSED_STR = "paused";
	const HD_BGA_STATE_AUTOPAUSED = 4;
	const HD_BGA_STATE_AUTOPAUSED_STR = "auto paused";
	const HD_BGA_STATE_DDF_PENDING = 128;
	const HD_BGA_STATE_DDF_PENDING_STR = "DDF pending";

	public static function getHdBgaStatusStr($Status)
	{
		$RetStr = "";
		switch ($Status)
		{
			case self::HD_BGA_STATE_NONE  :
				$RetStr = self::HD_BGA_STATE_NONE_STR;
				break;
			case self::HD_BGA_STATE_RUNNING :
				$RetStr = self::HD_BGA_STATE_RUNNING_STR;
				break;
			case self::HD_BGA_STATE_ABORTED  :
				$RetStr = self::HD_BGA_STATE_ABORTED_STR ;
				break;
			case self::HD_BGA_STATE_AUTOPAUSED  :
				$RetStr = self::HD_BGA_STATE_AUTOPAUSED_STR ;
				break;
			case self::HD_BGA_STATE_PAUSED  :
				$RetStr = self::HD_BGA_STATE_PAUSED_STR ;
				break;
			case self::HD_BGA_STATE_DDF_PENDING  :
				$RetStr = self::HD_BGA_STATE_DDF_PENDING_STR ;
				break;
			default:
				$RetStr = self::HD_BGA_STATE_NONE_STR;
		}
		return $RetStr;
	}

}


class HdType
{
	const HD_TYPE_SATA = 1;
	const SATA_HD = "SATA";

	const HD_TYPE_PATA = 2;
	const PATA_HD = "PATA";

	const HD_TYPE_SAS = 4;
	const SAS_HD = "SAS";

	const HD_TYPE_ATAPI = 8;
	const ATAPI_HD = "ATAPI";

	const HD_TYPE_TAPE = 16;
	const TAPE_HD = "TAPE";

	const HD_TYPE_SES = 32;
	const SES_HD = "SES";

	const UNKNOWN_HD = "Unknown";

	public static function getHdTypeStr($HDTypeInt)
	{
		$Ret = "";
		if ($HDTypeInt & self::HD_TYPE_SATA ) {
			$Ret = self::SATA_HD;
		}
		elseif ($HDTypeInt & self::HD_TYPE_PATA ) {
			$Ret = self::PATA_HD;
		}
		elseif ($HDTypeInt & self::HD_TYPE_SAS) {
			$Ret = self::SAS_HD;
		}
		else {
			$Ret = self::UNKNOWN_HD;
		}

		// The following flags are in addtion to the above ones.
		if ($HDTypeInt & self::HD_TYPE_ATAPI ) {
			$Ret .= " " . self::ATAPI_HD;
		}
		elseif ($HDTypeInt & self::HD_TYPE_TAPE ) {
			$Ret .= " " . self::TAPE_HD;
		}
		elseif ($HDTypeInt & self::HD_TYPE_SES ) {
			$Ret .= " " . self::SES_HD;
		}

		return $Ret;
	}
}

// PD's Protocol/Connection type (used by new driver)
class DCType
{
	const DC_ATA = 1;
	const DC_SCSI = 2;
	const DC_SERIAL = 4;
	const DC_PARALLEL = 8;
	const DC_ATAPI = 16;
	const DC_SGPIO = 32;

	public static function getDCTypeStr($DCType)
	{
		$Ret = "";
		if ((self::DC_ATA & $DCType) && (self::DC_SERIAL & $DCType)) {
			$Ret = "SATA";
		}else if ((self::DC_ATA & $DCType) && (self::DC_PARALLEL & $DCType)) {
			$Ret = "PATA";
		}else if ((self::DC_SCSI & $DCType) && (self::DC_SERIAL & $DCType)) {
			$Ret = "SAS";
		}

		/*
		if (self::DC_ATAPI & $DCType) {
			$Ret .= ' ' . 'ATAPI';
		}
		*/

		return $Ret;
	}
}

// PD's Device type defined in SCSI-III specification (used by new driver)
class DTType
{
	const DT_DIRECT_ACCESS_BLOCK = 0x00;
	const DT_DIRECT_ACCESS_BLOCK_STR = 'PD';
	const DT_SEQ_ACCESS = 0x01;
	const DT_SEQ_ACCESS_STR = 'TAPE';
	const DT_PRINTER = 0x02;
	const DT_PRINTER_STR = 'PRINTER';
	const DT_PROCESSOR = 0x03;
	const DT_WRITE_ONCE = 0x04;
	const DT_CD_DVD = 0x05;
	const DT_CD_DVD_STR = 'CD_DVD';
	const DT_OPTICAL_MEMORY = 0x07;
	const DT_MEDIA_CHANGER = 0x08;
	const DT_STORAGE_ARRAY_CTRL = 0x0C;
	const DT_ENCLOSURE = 0x0D;
	const DT_ENCLOSURE_STR = 'ENCLOSURE';
	// The following are defined by Marvell
	const DT_EXPANDER = 0x20;
	const DT_PM = 0x21;

	public static function getDTType($DTType)
	{
		if (self::DT_DIRECT_ACCESS_BLOCK == $DTType) {
			return self::DT_DIRECT_ACCESS_BLOCK_STR;
		}else if (self::DT_SEQ_ACCESS == $DTType) {
			return self::DT_SEQ_ACCESS_STR;
		}else if (self::DT_PRINTER == $DTType) {
			return self::DT_PRINTER_STR;
		}else if (self::DT_CD_DVD == $DTType) {
			return self::DT_CD_DVD_STR;
		}else if (self::DT_ENCLOSURE == $DTType) {
			return self::DT_ENCLOSURE_STR;
		}else {
			return "unknown";
		}
	}
}

class PdState
{
	const PD_STATE_ONLINE = 1;
	const PD_STATE_FAILED = 2;
	const PD_STATE_REBUILDING = 4;
	const PD_STATE_TRANSITION = 8;
	const PD_STATE_SMART_ERROR = 16;
	const PD_STATE_READ_ERROR = 32;
	const PD_STATE_MISSING = 64;
}

class HdSpeed
{
	const HD_SPEED_1_5G = 1;
	const HD_SPEED_3G = 2;
	const HD_SPEED_6G = 3;
	const HD_SPEED_12G = 4;
}

class HdFeature
{
	const HD_FEATURE_NCQ = 1;
	const STR_HD_FEATURE_NCQ = "NCQ";
	const HD_FEATURE_TCQ = 2;
	const STR_HD_FEATURE_TCQ = "TCQ";
	const HD_FEATURE_1_5G = 4;
	const STR_HD_FEATURE_1_5G = "1.5Gb/s";
	const HD_FEATURE_3G = 8;
	const STR_HD_FEATURE_3G = "3Gb/s";
	const HD_FEATURE_WRITE_CACHE = 16;
	const STR_HD_FEATURE_WRITE_CACHE = "Write Cache";
	const HD_FEATURE_48BITS = 32;
	const STR_HD_FEATURE_48BITS = "48Bits";
	const HD_FEATURE_SMART = 64;
	const STR_HD_FEATURE_SMART = "Smart";
	const HD_FEATURE_6G = 128;
	const STR_HD_FEATURE_6G = "6Gb/s";
	const HD_FEATURE_12G = 1024;
	const STR_HD_FEATURE_12G = "12Gb/s";
        const HD_FEATURE_TRIM = 512;
        const STR_HD_FEATURE_TRIM = "Trim";

	public static function getHdFeatureStr($Feature)
	{
		switch ($Feature)
		{
			case self::HD_FEATURE_1_5G :
				return self::STR_HD_FEATURE_1_5G ;
			case self::HD_FEATURE_NCQ :
				return self::STR_HD_FEATURE_NCQ ;
			case self::HD_FEATURE_TCQ :
				return self::STR_HD_FEATURE_TCQ ;
			case self::HD_FEATURE_3G :
				return self::STR_HD_FEATURE_3G ;
			case self::HD_FEATURE_WRITE_CACHE :
				return self::STR_HD_FEATURE_WRITE_CACHE ;
			case self::HD_FEATURE_48BITS :
				return self::STR_HD_FEATURE_48BITS ;
			case self::HD_FEATURE_SMART :
				return self::STR_HD_FEATURE_SMART ;
			case self::HD_FEATURE_6G :
				return self::STR_HD_FEATURE_6G ;
			default:
				return "Unknown";
		}
	}
}

//RCT entry flag
class RCTFlag
{
	/* request type related */
	const EH_READ_VERIFY_REQ_ERROR = 1; /* Read or Read Verify request is failed. */
	const STR_EH_READ_VERIFY_REQ_ERROR = "read error";
	const EH_WRITE_REQ_ERROR = 2;  /* Write request is failed */
	const STR_EH_WRITE_REQ_ERROR = "write error";
	/* error type related */
	const EH_MEDIA_ERROR = 8; /* Media Error or timeout */
	const STR_EH_MEDIA_ERROR = "media error";
	const EH_LOGICAL_ERROR = 16; /* Logical Error because of BGA activity. */
	const STR_EH_LOGICAL_ERROR = "logical error";
}

//Support LD Raid Mode

class SupportLdRaidMode
{
	const SUPPORT_LD_MODE_RAID0 = 1;
	const SUPPORT_LD_MODE_RAID1 = 2;
	const SUPPORT_LD_MODE_RAID10 = 4;
	const SUPPORT_LD_MODE_RAID1E = 8;
	const SUPPORT_LD_MODE_RAID5 = 16;
	const SUPPORT_LD_MODE_RAID6 = 32;
	const SUPPORT_LD_MODE_RAID50 = 64;
	const SUPPORT_LD_MODE_JBOD = 128;
	const SUPPORT_LD_MODE_RAID60 = 256;
	const SUPPORT_LD_MODE_CROSS_SATA_SSD = 512;
	const SUPPORT_LD_MODE_HYPPER_HDD_MIRROR = 1024;
    const SUPPORT_LD_MODE_HYBRID_HDD_MIRROR = 2048;
}

class SupportStripeSize
{
	const STRIPE_SIZE_16 = 1;
	const STRIPE_SIZE_32 = 2;
	const STRIPE_SIZE_64 = 4;
	const STRIPE_SIZE_128 = 8;
	const STRIPE_SIZE_256 = 16;
	const STRIPE_SIZE_512 = 32;
	const STRIPE_SIZE_1024 = 64;
}

class PCIESpeed
{
	const PCIE_SPEED_UNKNOWN = 0;
	const PCIE_SPEED_GEN_I = 1;
	const PCIE_SPEED_GEN_II = 2;
	const PCIE_SPEED_GEN_III = 3;

	const PCIE_SPEED_UNKNOWN_STR = "Unknown";
	const PCIE_SPEED_GEN_I_STR = "2.5Gb/s";
	const PCIE_SPEED_GEN_II_STR = "5Gb/s";
	const PCIE_SPEED_GEN_III_STR = "8Gb/s";

	public static function getPCIESpeedStr($speed)
	{
		switch($speed)
		{
			case self::PCIE_SPEED_GEN_I:
				return self::PCIE_SPEED_GEN_I_STR;
			case self::PCIE_SPEED_GEN_II:
				return self::PCIE_SPEED_GEN_II_STR;
			case self::PCIE_SPEED_GEN_III:
				return self::PCIE_SPEED_GEN_III_STR;
			default:
				return self::PCIE_SPEED_UNKNOWN_STR;
		}
	}
}

class HBAFeature
{
	const FEATURE_BGA_REBUILD_SUPPORT = 1;
	const FEATURE_BGA_BKINIT_SUPPORT = 2;
	const FEATURE_BGA_SYNC_SUPPORT = 4;
	const FEATURE_BGA_MIGRATION_SUPPORT = 8;
	const FEATURE_BGA_MEDIAPATROL_SUPPORT = 16;
	const FEATURE_BGA_FEINIT_SUPPORT = 32;
	const FEATURE_BGA_COPY_BACK_SUPPORT = 64;
	const FEATURE_PD_OF_SAME_TYPE_WHEN_CREATE_VD = 128;
}

//advance features
class HBAAdvFeature
{
	const ADV_FEATURE_EVENT_WITH_SENSE_CODE = 0x1;
	const ADV_FEATURE_BIG_STRTPE_SUPPORT = 0x2;
	const ADV_FEATURE_BIOS_OPTION_SUPPORT = 0x4;
	const ADV_FEATURE_HAS_BBU = 0x8;
	const ADV_FEATURE_CONFIG_IN_FLASH = 0x10;
	const ADV_FEATURE_CPU_EFFICIENCY_SUPPORT = 0x20;
	const ADV_FEATURE_NO_MUTIL_VD_PER_PD = 0x40;
	const ADV_FEATURE_SPC_4_BUFFER = 0x80;
	const ADV_FEATURE_SES_DIRECT = 0x100;
	const ADV_FEATURE_MODULE_CONSOLIDATE = 0x200;
	const ADV_FEATURE_IMAGE_HEALTH = 0x400;
	const ADV_FEATURE_SATA_PHY_CTRL_BY_PORT = 0x800;
	const ADV_FEATURE_CRYPTO_SUPPORT = 0x1000;
	const ADV_FEATURE_OS_TIME_SUPPORT = 0x2000;
	const ADV_FEATURE_NO_VD_WRITE_CACHE_SUPPORT = 0x4000;
	const ADV_FEATURE_NO_VD_READ_CACHE_SUPPORT = 0x8000;
	const ADV_FEATURE_NO_HD_SMART_SUPPORT = 0x10000;
	const ADV_FEATURE_NO_VD_ROUNDING_SUPPORT = 0x20000;
	const ADV_FEATURE_NO_HD_SETFREE_SUPPORT = 0x40000;
	const ADV_FEATURE_NO_HD_WRITE_CACHE_SUPPORT = 0x80000;
    const ADV_FEATURE_NO_ENC_SUPPORT = 0x100000;// Magni not support encloure
    const ADV_FEATURE_NO_BGA_RATE_CHANGE = 0x200000;// Magni lite support bga but can not change rate
    const ADV_FEATURE_AES_PARTITION = 0x400000;// check aes percentage
	const ADV_FEATURE_HYPERDUO_INTELLIGENT_INIT = 0x800000;
    const ADV_FEATURE_NO_SPARE_SUPPORT = 0x1000000;
    const ADV_FEATURE_HYBRID_SWITCH_SUPPORT = 0x2000000;
}

//BBU features
class BBUFeature
{
	const BBU_SENSOR_TEMPERATURE = 1;
	const BBU_SENSOR_VOLTAGE = 2;
	const BBU_SENSOR_ECAPACITY = 4;
}

class BBUStatus
{
	const BBU_STATUS_NOT_PRESENT = 0x0000;
	const BBU_STATUS_NOT_PRESENT_STR = "not present";
	const BBU_STATUS_PRESENT = 0x0001;
	const BBU_STATUS_PRESENT_STR = "present";
	const BBU_STATUS_LOW_BATTERY = 0x0002;
	const BBU_STATUS_LOW_BATTERY_STR = "low battery";
	const BBU_STATUS_CHARGING = 0x0004;
	const BBU_STATUS_CHARGING_STR = "charging";
	const BBU_STATUS_FULL_CHARGED = 0x0008;
	const BBU_STATUS_FULL_CHARGED_STR = "full charged";
	const BBU_STATUS_DISCHARGE = 0x0010;
	const BBU_STATUS_DISCHARGE_STR = "discharging";
	const BBU_STATUS_RELEARN = 0x0020;
	const BBU_STATUS_RELEARN_STR = "relearn";
	const BBU_STATUS_OVER_TEMP_WARNING = 0x0040;
	const BBU_STATUS_OVER_TEMP_WARNING_STR = "over temperature warning";
	const BBU_STATUS_OVER_TEMP_ERROR = 0x0080;
	const BBU_STATUS_OVER_TEMP_ERROR_STR = "over temperature error";
	const BBU_STATUS_UNDER_TEMP_WARNING = 0x0100;
	const BBU_STATUS_UNDER_TEMP_WARNING_STR = "under temperature warning";
	const BBU_STATUS_UNDER_TEMP_ERROR = 0x0200;
	const BBU_STATUS_UNDER_TEMP_ERROR_STR = "under temperature error";
	const BBU_STATUS_OVER_VOLT_WARNING = 0x0400;
	const BBU_STATUS_OVER_VOLT_WARNING_STR = "over voltage warning";
	const BBU_STATUS_OVER_VOLT_ERROR = 0x0800;
	const BBU_STATUS_OVER_VOLT_ERROR_STR = "over voltage error";
	const BBU_STATUS_UNDER_VOLT_WARNING = 0x1000;
	const BBU_STATUS_UNDER_VOLT_WARNING_STR = "under voltage warning";
	const BBU_STATUS_UNDER_VOLT_ERROR = 0x2000;
	const BBU_STATUS_UNDER_VOLT_ERROR_STR = "under voltage error";
        const BBU_STATUS_GREATER_LOWERBOUND = 0x4000;
        const BBU_STATUS_GREATER_LOWERBOUND_STR="greater lowerbound";
        const BBU_STATUS_POWER_STOP_ALL =0x8000;
        const BBU_STATUS_POWER_STOP_ALL_STR="power stop all";

	public static function getBBUStatusStr($Status, $time_to_full, $time_to_empty)
	{
		$Str = "";
		if ($Status == self::BBU_STATUS_NOT_PRESENT ) {
			$Str = self::BBU_STATUS_NOT_PRESENT_STR ;
		} else {
			if ($Status & self::BBU_STATUS_LOW_BATTERY)
				$Str .= self::BBU_STATUS_LOW_BATTERY_STR . ", ";
			if ($Status & self::BBU_STATUS_FULL_CHARGED)
				$Str .= self::BBU_STATUS_FULL_CHARGED_STR . ", ";
			if ($Status & self::BBU_STATUS_DISCHARGE)
				$Str .= self::BBU_STATUS_DISCHARGE_STR . " and " . $time_to_empty . " minutes to empty" . ", ";
			if ($Status & self::BBU_STATUS_CHARGING)
				$Str .= self::BBU_STATUS_CHARGING_STR . " and " . $time_to_full . " minutes to full" . ", ";
			if ($Status & self::BBU_STATUS_RELEARN)
				$Str .= self::BBU_STATUS_RELEARN_STR . ", ";
			if ($Status & self::BBU_STATUS_OVER_TEMP_WARNING)
				$Str .= self::BBU_STATUS_OVER_TEMP_WARNING_STR . ", ";
			if ($Status & self::BBU_STATUS_OVER_TEMP_ERROR)
				$Str .= self::BBU_STATUS_OVER_TEMP_ERROR_STR . ", ";
			if ($Status & self::BBU_STATUS_UNDER_TEMP_WARNING)
				$Str .= self::BBU_STATUS_UNDER_TEMP_WARNING_STR . ", ";
			if ($Status & self::BBU_STATUS_UNDER_TEMP_ERROR)
				$Str .= self::BBU_STATUS_UNDER_TEMP_ERROR_STR . ", ";
			if ($Status & self::BBU_STATUS_OVER_VOLT_WARNING)
				$Str .= self::BBU_STATUS_OVER_VOLT_WARNING_STR . ", ";
			if ($Status & self::BBU_STATUS_OVER_VOLT_ERROR)
				$Str .= self::BBU_STATUS_OVER_VOLT_ERROR_STR . ", ";
			if ($Status & self::BBU_STATUS_UNDER_VOLT_WARNING)
				$Str .= self::BBU_STATUS_UNDER_VOLT_WARNING_STR . ", ";
			if ($Status & self::BBU_STATUS_UNDER_VOLT_ERROR)
				$Str .= self::BBU_STATUS_UNDER_VOLT_ERROR_STR . ", ";
                        if ($Status & self::BBU_STATUS_GREATER_LOWERBOUND)
                                $Str .= self::BBU_STATUS_GREATER_LOWERBOUND_STR . ", ";
                        if ($Status & self::BBU_STATUS_POWER_STOP_ALL)
                                $Str .= self::BBU_STATUS_POWER_STOP_ALL_STR . ", ";
			if (strlen($Str) > 2)
				$Str = substr($Str, 0, (strlen($Str)-2)); // get rid of last ", ".
		}
		if (strlen($Str) < 2){
                        if ($Status & self::BBU_STATUS_PRESENT)
			    $Str = "Ok";
                        else
                            $Str = "Unknown";
                }
		return $Str;
	}
}

class QuickCreateType
{
	const CREATE_PERFORMANCE = 0;
	const CREATE_RELIABILITY = 1;
}

//initilization type

class InitType
{
	const INIT_QUICK = 0;
	const INIT_FULLFOREGROUND = 1;
	const INIT_FULLBACKGROUND = 2;
	const INIT_NONE = 3;
}

class Rounding_Scheme
{
	const ROUNDING_SCHEME_NONE = 0;
	const ROUNDING_SCHEME_1GB = 1;
	const ROUNDING_SCHEME_10GB = 2;
}

class ConsistencyCheck_Type
{
	const CONSISTENCYCHECK_ONLY = 0;
	const CONSISTENCYCHECK_FIX = 1;
}

//event class
class EventSeverity
{
	const SEVERITY_UNKNOWN = 0;
	const SEVERITY_OTHER = 1;
	const SEVERITY_INFO = 2;
	const SEVERITY_WARNING = 3;  /* used when its appropriate to let the
					  user decide if action is needed */
	const SEVERITY_MINOR = 4;  /* indicate action is needed, but the
					  situation is not serious at this time */
	const SEVERITY_MAJOR = 5 ; /* indicate action is needed NOW */
	const SEVERITY_CRITICAL = 6;  /* indicate action is needed NOW and the
					  scope is broad */
	const SEVERITY_FATAL = 7;  /* indicate an error occurred, but it's too
				  late to take remedial action */

	const SEVERITY_WARNING_IMG = "EventLog_warning.gif";
	const SEVERITY_CRITICAL_IMG = "EventLog_critical.gif";
	const SEVERITY_INFO_IMG = "EventLog_info.gif";
	const SEVERITY_UNKNOWN_IMG = "EventLog_unknown.gif";

	const SEVERITY_WARNING_TITLE = "Warning";
	const SEVERITY_CRITICAL_TITLE = "Error";
	const SEVERITY_INFO_TITLE = "Info";
	const SEVERITY_UNKNOWN_TITLE = "Unknown";

	public static function getSeverityImg($SeverityInt)
	{
		//four level for event list display
		if ($SeverityInt == self::SEVERITY_UNKNOWN) {
			return self::SEVERITY_UNKNOWN_IMG;
		}else if (self::SEVERITY_OTHER <= $SeverityInt && self::SEVERITY_INFO >= $SeverityInt) {
			return self::SEVERITY_INFO_IMG;
		}else if (self::SEVERITY_WARNING <= $SeverityInt && self::SEVERITY_MINOR >= $SeverityInt) {
			return self::SEVERITY_WARNING_IMG;
		}else if (self::SEVERITY_MAJOR <= $SeverityInt && self::SEVERITY_FATAL >= $SeverityInt) {
			return self::SEVERITY_CRITICAL_IMG;
		}else {
			return self::SEVERITY_UNKNOWN_IMG;
		}
	}

	public static function getSeverityTitle($SeverityInt)
	{
		//four level for event list display
		if ($SeverityInt == self::SEVERITY_UNKNOWN) {
			return self::SEVERITY_UNKNOWN_TITLE;
		}else if (self::SEVERITY_OTHER <= $SeverityInt && self::SEVERITY_INFO >= $SeverityInt) {
			return self::SEVERITY_INFO_TITLE;
		}else if (self::SEVERITY_WARNING <= $SeverityInt && self::SEVERITY_MINOR >= $SeverityInt) {
			return self::SEVERITY_WARNING_TITLE;
		}else if (self::SEVERITY_MAJOR <= $SeverityInt && self::SEVERITY_FATAL >= $SeverityInt) {
			return self::SEVERITY_CRITICAL_TITLE;
		}else {
			return self::SEVERITY_UNKNOWN_TITLE;
		}
	}

	public static function getSeverityRegion($eventNotifyLevel)
	{
		//for event notify
		//return array with element 0 for min severity and element 1 for max severity
		//[minSeverity,maxSeverity] included close region

		if ($eventNotifyLevel == EventNotifyType::ERROR ) {
			return array(self::SEVERITY_MAJOR, self::SEVERITY_FATAL);
		}
		if ($eventNotifyLevel == EventNotifyType::WARNING ) {
			return array(self::SEVERITY_WARNING, self::SEVERITY_MINOR);
		}
		if ($eventNotifyLevel == EventNotifyType::INFO ) {
			return array(self::SEVERITY_OTHER, self::SEVERITY_INFO);
		}
		else
		{
			return array(-1,-1);
		}
	}
}

class EventClass
{
	const EVT_CLASS_ADAPTER = 0;
	const EVT_CLASS_ADAPTER_STR = "Adapter Event";
	const EVT_CLASS_LD = 1;
	const EVT_CLASS_LD_STR = "VD Event";
	const EVT_CLASS_HD = 2;
	const EVT_CLASS_HD_STR = "PD Event";
	const EVT_CLASS_PM = 3;
	const EVT_CLASS_PM_STR = "PM Event";
	const EVT_CLASS_EXPANDER = 4;
	const EVT_CLASS_EXPANDER_STR = "Expander Event";
	const EVT_CLASS_MDD = 5;
	const EVT_CLASS_MDD_STR = "MDD Event";
	const EVT_CLASS_BSL = 6;
	const EVT_CLASS_BSL_STR = "BSL Event";
	const EVT_CLASS_SAS = 7;		// SAS, mainly for SAS topology
	const EVT_CLASS_SAS_STR = "SAS Event";
	const EVT_CLASS_ENCL = 8;		// Enclosure
	const EVT_CLASS_ENCL_STR = "Enclosure Event";
	const EVT_CLASS_BAT = 9 ;      // Battery
	const EVT_CLASS_BAT_STR = "Battery Event";
	const EVT_CLASS_FLASH = 10;      // Flash memory
	const EVT_CLASS_FLASH_STR = "Flash memory Event";
	const EVT_CLASS_CACHE = 11;      // Cache related
	const EVT_CLASS_CACHE_STR = "Cache related Event";
	const EVT_CLASS_MISC = 12;      // For other miscellaneous events
	const EVT_CLASS_MISC_STR = "Miscellaneous";
	const EVT_CLASS_ARRAY = 13;
	const EVT_CLASS_ARRAY_STR = "Array Event";
	const EVT_CLASS_SSD = 14;
	const EVT_CLASS_SSD_STR = "SSD Event";
	const EVT_CLASS_OEM = 15;
	const EVT_CLASS_OEM_STR = "Monitor Event";
	const EVT_CLASS_UNKNOWN = "Unknown Event Class";

	public static function getEventClassStr($EventClassInt)
	{
		switch ($EventClassInt)
		{
			case self::EVT_CLASS_ADAPTER :
				return self::EVT_CLASS_ADAPTER_STR ;
			case self::EVT_CLASS_LD :
				return self::EVT_CLASS_LD_STR ;
			case self::EVT_CLASS_HD :
				return self::EVT_CLASS_HD_STR ;
			case self::EVT_CLASS_PM :
				return self::EVT_CLASS_PM_STR ;
			case self::EVT_CLASS_EXPANDER :
				return self::EVT_CLASS_EXPANDER_STR ;
			case self::EVT_CLASS_MDD :
				return self::EVT_CLASS_MDD_STR ;
			case self::EVT_CLASS_BSL :
				return self::EVT_CLASS_BSL_STR ;
			case self::EVT_CLASS_SAS :
				return self::EVT_CLASS_SAS_STR ;
			case self::EVT_CLASS_ENCL :
				return self::EVT_CLASS_ENCL_STR ;
			case self::EVT_CLASS_BAT :
				return self::EVT_CLASS_BAT_STR ;
			case self::EVT_CLASS_FLASH :
				return self::EVT_CLASS_FLASH_STR ;
			case self::EVT_CLASS_CACHE :
				return self::EVT_CLASS_CACHE_STR ;
			case self::EVT_CLASS_MISC :
				return self::EVT_CLASS_MISC_STR ;
			case self::EVT_CLASS_ARRAY :
				return self::EVT_CLASS_ARRAY_STR ;
			case self::EVT_CLASS_SSD :
				return self::EVT_CLASS_SSD_STR ;
			case self::EVT_CLASS_OEM :
				return self::EVT_CLASS_OEM_STR ;
			default:
				return self::EVT_CLASS_UNKNOWN;
		}
	}
}

class AcceleratorError {
    const MV_ACCELERATOR_ERR_NONE = 0;
    const MV_ACCELERATOR_ERR_NONE_STR = "Accelerator error: no error";
    const MV_ACCELERATOR_ERR_FAIL = 1;
    const MV_ACCELERATOR_ERR_FAIL_STR = "Accelerator error: failed";
    const MV_ACCELERATOR_ERR_RUNNING = 2;
    const MV_ACCELERATOR_ERR_RUNNING_STR = "Accelerator error:background activity running";
    const MV_ACCELERATOR_INVALID_VOLUME = 3;
    const MV_ACCELERATOR_INVALID_VOLUME_STR = "Accelerator error: invalid volume";
    const MV_ACCELERATOR_ERR_UNKNOWN_STR = "Accelerator error: unknown Error";

    public static function getErrStr($ErrorCode) {
        switch ($ErrorCode) {
            case self::MV_ACCELERATOR_ERR_NONE :
                return self::MV_ACCELERATOR_ERR_NONE_STR;
            case self::MV_ACCELERATOR_ERR_FAIL :
                return self::MV_ACCELERATOR_ERR_FAIL;
            case self::MV_ACCELERATOR_ERR_RUNNING :
                return self::MV_ACCELERATOR_ERR_RUNNING_STR;
            case self::MV_ACCELERATOR_INVALID_VOLUME :
                return self::MV_ACCELERATOR_INVALID_VOLUME_STR;
            default:
                return self::MV_ACCELERATOR_ERR_UNKNOWN_STR ;
        }
    }
}

class SSDError
{
        const ERR_NONE = 0;
	const ERR_NONE_STR = "Error: no error";
        const ERR_FAIL = 1;
        const ERR_FAIL_STR = "Error: failed";
        const ERR_UNKNOWN = 2;
        const ERR_UNKNOWN_STR = "Error: Unknown Error";
        const ERR_NO_RESOURCE = 3;
	const ERR_NO_RESOURCE_STR = "Error: Resource not available";
        const ERR_REQ_OUT_OF_RANGE = 4;
	const ERR_REQ_OUT_OF_RANGE_STR = "Error: Data out of range";
        const ERR_INVALID_REQUEST = 5;
	const ERR_INVALID_REQUEST_STR = "Error: Invalid request";
        const ERR_INVALID_PARAMETER = 6;
	const ERR_INVALID_PARAMETER_STR = "Error: Invalid request parameter";
        const ERR_NOT_SUPPORTED = 7;
	const ERR_NOT_SUPPORTED_STR = "Error: Not supported";
        const ERR_HBA_INFO_CORRUPT = 8;  // HBA Information is corrupt, unable to update values.
        const ERR_HBA_INFO_CORRUPT_STR = "Error: HBA Information is corrupt";
        const ERR_INVALID_ADAPTER_ID = 9;
	const ERR_INVALID_ADAPTER_ID_STR = "Error: Invalid adapter id";
        const ERR_INVALID_PARTITION_ID = 10;
        const ERR_INVALID_PARTITION_ID_STR = "Error: Invalid partition id";
        const ERR_IOCTL_NO_RESOURCE = 11;
        const ERR_IOCTL_NO_RESOURCE_STR = "Error: IOCTL resource not available";
        const ERR_REQUIRE_REBOOT = 12;
        const ERR_REQUIRE_REBOOT_STR = "Error: Reboot required";
        const ERR_DEVICE_NOT_READY = 13;
        const ERR_DEVICE_NOT_READY_STR = "Error: Device not ready";
        const ERR_INVALID_WERU_NUMBER = 14;
        const ERR_INVALID_WERU_NUMBER_STR = "Error: Invalid WERU number";
        const ERR_BUFFER_NOT_ENOUGH = 15;
        const ERR_BUFFER_NOT_ENOUGH_STR = "Error: No enough buffer";
        const ERR_TRAN_NOT_SYNC = 16;
        const ERR_TRAN_NOT_SYNC_STR = "Error: Tran not sync";
        const ERR_INVALID_IMAGE = 17;
        const ERR_INVALID_IMAGE_STR = "Error: Invalid image";
        const ERR_IMAGE_VERSION_TOO_OLD = 18;
        const ERR_IMAGE_VERSION_TOO_OLD_STR = "Error: Image version is too old";
        const ERR_FLASH_IMAGE = 19;
        const ERR_FLASH_IMAGE_STR = "Error: Flash image error";

	public static function getErrStr($ErrorCode)
	{
		switch ($ErrorCode)
		{
			case self::ERR_NONE : return self::ERR_NONE_STR;
			case self::ERR_FAIL : return self::ERR_FAIL_STR;
			case self::ERR_UNKNOWN : return self::ERR_UNKNOWN_STR;
			case self::ERR_NO_RESOURCE : return self::ERR_NO_RESOURCE_STR;
			case self::ERR_REQ_OUT_OF_RANGE : return self::ERR_REQ_OUT_OF_RANGE_STR;
			case self::ERR_INVALID_REQUEST : return self::ERR_INVALID_REQUEST_STR;
			case self::ERR_INVALID_PARAMETER : return self::ERR_INVALID_PARAMETER_STR;
			case self::ERR_NOT_SUPPORTED : return self::ERR_NOT_SUPPORTED_STR;
			case self::ERR_HBA_INFO_CORRUPT : return self::ERR_HBA_INFO_CORRUPT_STR;
			case self::ERR_INVALID_ADAPTER_ID : return self::ERR_INVALID_ADAPTER_ID_STR;
			case self::ERR_INVALID_PARTITION_ID : return self::ERR_INVALID_PARTITION_ID_STR;
			case self::ERR_IOCTL_NO_RESOURCE : return self::ERR_IOCTL_NO_RESOURCE_STR;
			case self::ERR_REQUIRE_REBOOT : return self::ERR_REQUIRE_REBOOT_STR;
			case self::ERR_DEVICE_NOT_READY : return self::ERR_DEVICE_NOT_READY_STR;
			case self::ERR_INVALID_WERU_NUMBER : return self::ERR_INVALID_WERU_NUMBER_STR;
			case self::ERR_BUFFER_NOT_ENOUGH : return self::ERR_BUFFER_NOT_ENOUGH_STR;
			case self::ERR_TRAN_NOT_SYNC : return self::ERR_TRAN_NOT_SYNC_STR;
			case self::ERR_INVALID_IMAGE : return self::ERR_INVALID_IMAGE_STR;
			case self::ERR_IMAGE_VERSION_TOO_OLD : return self::ERR_IMAGE_VERSION_TOO_OLD_STR;
			case self::ERR_FLASH_IMAGE : return self::ERR_FLASH_IMAGE_STR;
                        
			default:
				return self::ERR_UNKNOWN_STR ;
		}
	}
}

class ComError
{
	const ERR_GENERIC = 2;
	const ERR_GENERIC_STR = "Error: Generic Error";
	const ERR_RAID = 50;
	const ERR_RAID_STR = "Error: RAID Error";
	const ERR_CORE = 100;
	const ERR_CORE_STR = "Error: Core error";
	const ERR_API = 150;
	const ERR_API_STR = "Error: API error";
	const ERR_FLO = 200;
	const ERR_FLO_STR = "Error: FLO error";
	const ERR_NONE = 0;
	const ERR_NONE_STR = "Error: no error";
	const ERR_FAIL = 1;
	const ERR_FAIL_STR = "Error: failed";
	const ERR_UNKNOWN = 3;
	const ERR_UNKNOWN_STR = "Error: Unknown Error";
	const ERR_NO_RESOURCE = 4;
	const ERR_NO_RESOURCE_STR = "Error: Resource not available";
	const ERR_REQ_OUT_OF_RANGE = 5;
	const ERR_REQ_OUT_OF_RANGE_STR = "Error: Data out of range";
	const ERR_INVALID_REQUEST = 6;
	const ERR_INVALID_REQUEST_STR = "Error: Invalid request";
	const ERR_INVALID_PARAMETER = 7;
	const ERR_INVALID_PARAMETER_STR = "Error: Invalid request parameter";
	const ERR_INVALID_LD_ID = 8;
	const ERR_INVALID_LD_ID_STR = "Error: Invalid virtual disk id";
	const ERR_INVALID_HD_ID = 9;
	const ERR_INVALID_HD_ID_STR = "Error: Invalid physical disk id";
	const ERR_INVALID_EXP_ID = 10;
	const ERR_INVALID_EXP_ID_STR = "Error: Invalid expander id";
	const ERR_INVALID_PM_ID = 11;
	const ERR_INVALID_PM_ID_STR = "Error: Invalid port multiplexer id";
	const ERR_INVALID_BLOCK_ID = 12;
	const ERR_INVALID_BLOCK_ID_STR = "Error: Invalid block disk id";
	const ERR_INVALID_ADAPTER_ID = 13;
	const ERR_INVALID_ADAPTER_ID_STR = "Error: Invalid adapter id";
	const ERR_INVALID_RAID_MODE = 14;
	const ERR_INVALID_RAID_MODE_STR = "Error: Invalid RAID level";
	const ERR_INVALID_ENC_ID = 15;
	const ERR_INVALID_ENC_ID_STR = "Error: Invalid enclosure id";
	const ERR_INVALID_BU_ID = 16;
	const ERR_INVALID_BU_ID_STR = "Error: Invalid BBU id";
	const ERR_INVALID_DG_ID = 17;
	const ERR_INVALID_DG_ID_STR = "Error: Invalid array id";
	const ERR_INVALID_ENC_ELEMENT_ID = 18;
	const ERR_INVALID_ENC_ELEMENT_ID_STR = "Error: Invalid enclosure element id";
	const ERR_NOT_SUPPORTED = 19;
	const ERR_NOT_SUPPORTED_STR = "Error: Not supported";
	const ERR_DRIVER_SENSOR = 20;
	const ERR_DRIVER_SENSOR_STR = "Error: Link time out";
	const ERR_INVALID_KEY_PRESENT = 21;
	const ERR_INVALID_KEY_PRESENT_STR = "Error: Can not add key due to key present";
	const ERR_INVALID_KEY_ABSENT = 22;
	const ERR_INVALID_KEY_ABSENT_STR = "Error: Can not enable due to key absent";
	const ERR_COMMAND_PHASE_ERROR = 23;
	const ERR_COMMAND_PHASE_ERROR_STR = "Error: Davinci diagnostic command phase error";
	const ERR_DATA_PHASE_ERROR = 24;
	const ERR_DATA_PHASE_ERROR_STR = "Error: Davinci diagnostic data phase error";
	const ERR_STATUS_PHASE_ERROR = 25;
	const ERR_STATUS_PHASE_ERROR_STR = "Error: Davinci diagnostic status phase error";
	const ERR_STATUS_PHASE_PHASE_ERROR = 26;
	const ERR_STATUS_PHASE_PHASE_ERROR_STR = "Error: Davinci diagnostic status phase returns phase error";
	const ERR_STATUS_PHASE_CMD_ERROR = 27;
	const ERR_STATUS_PHASE_CMD_ERROR_STR = "Error: Davinci diagnostic status phase returns command error";

	const ERR_TARGET_IN_LD_FUNCTIONAL = 51;
	const ERR_TARGET_IN_LD_FUNCTIONAL_STR = "Error: Target physical disk is part of the virtual disk and is functional";
	const ERR_TARGET_NO_ENOUGH_SPACE = 52;
	const ERR_TARGET_NO_ENOUGH_SPACE_STR = "Error: Target disk doesn't have enough space";
	const ERR_HD_IS_NOT_SPARE = 53;
	const ERR_HD_IS_NOT_SPARE_STR = "Error: Specified physical disk is not a spare disk";
	const ERR_HD_IS_SPARE = 54;
	const ERR_HD_IS_SPARE_STR = "Error: Specified physical disk is a spare disk";
	const ERR_HD_NOT_EXIST = 55;
	const ERR_HD_NOT_EXIST_STR = "Error: Specified physical disk doesn't exist";
	const ERR_HD_IS_ASSIGNED_ALREADY = 56;
	const ERR_HD_IS_ASSIGNED_ALREADY_STR = "Error: Specified physical disk is assigned to a virtual disk";
	const ERR_INVALID_HD_COUNT = 57;
	const ERR_INVALID_HD_COUNT_STR = "Error: Invalid physical disk count";
	const ERR_LD_NOT_READY = 58;
	const ERR_LD_NOT_READY_STR = "Error: Virtual disk is not ready to receive command";
	const ERR_LD_NOT_EXIST = 59;
	const ERR_LD_NOT_EXIST_STR = "Error: Specified virtual disk doesn't exist";
	const ERR_LD_IS_FUNCTIONAL = 60;
	const ERR_LD_IS_FUNCTIONAL_STR = "Error: Specified virtual disk is functional";
	const ERR_HAS_BGA_IN_VD = 61;
	const ERR_HAS_BGA_IN_VD_STR = "Error: Virtual disk currently has BGA";
	const ERR_NO_BGA_ACTIVITY = 62;
	const ERR_NO_BGA_ACTIVITY_STR = "Error: No BGA";
	const ERR_BGA_RUNNING = 63;
	const ERR_BGA_RUNNING_STR = "Error: BGA is running";
	const ERR_RAID_NO_AVAILABLE_ID = 64;
	const ERR_RAID_NO_AVAILABLE_ID_STR = "Error: Internal error, no virtual disk id available";
	const ERR_LD_NO_ATAPI = 65;
	const ERR_LD_NO_ATAPI_STR = "Error: Can not create Virtual disk with ATAPI disk";
	const ERR_INVALID_RAID6_PARITY_DISK_COUNT = 66;
	const ERR_INVALID_RAID6_PARITY_DISK_COUNT_STR = "Error: Invalid # of parity disks for RAID6 or RAID60";
	const ERR_INVALID_BLOCK_SIZE = 67;
	const ERR_INVALID_BLOCK_SIZE_STR = "Error: Invalid block size";
	const ERR_MIGRATION_NOT_NEED = 68;
	const ERR_MIGRATION_NOT_NEED_STR = "Error: Migration is not necessary";
	const ERR_STRIPE_BLOCK_SIZE_MISMATCH = 69;
	const ERR_STRIPE_BLOCK_SIZE_MISMATCH_STR = "Error: Stripe block size mismatch";
	const ERR_MIGRATION_NOT_SUPPORT = 70;
	const ERR_MIGRATION_NOT_SUPPORT_STR = "Error: Migration is not supported";
	const ERR_LD_NOT_FULLY_INITED = 71;
	const ERR_LD_NOT_FULLY_INITED_STR = "Error: Virtual disk is not fully initialized";
	const ERR_LD_NAME_INVALID = 72;
	const ERR_LD_NAME_INVALID_STR = "Error: Virtual disk name is invalid";
	const ERR_HD_TYPE_MISMATCH = 73;
	const ERR_HD_TYPE_MISMATCH_STR = "Error: Physical disk type mismatch";
	const ERR_HD_SECTOR_SIZE_MISMATCH = 74;
	const ERR_HD_SECTOR_SIZE_MISMATCH_STR = "Error: Physical disk sector size mismatch";
	const ERR_NO_LD_IN_DG = 75;
	const ERR_NO_LD_IN_DG_STR = "Error: No virtual disk in array";
	const ERR_HAS_LD_IN_DG = 76;
	const ERR_HAS_LD_IN_DG_STR = "Error: Has virtual disk in array";
	const ERR_NO_ROOM_FOR_SPARE = 77;
	const ERR_NO_ROOM_FOR_SPARE_STR = "Error: Disk space is too small to be assigned as spare drive";
	const ERR_SPARE_IS_IN_MULTI_DG = 78;
	const ERR_SPARE_IS_IN_MULTI_DG_STR = "Error: Disk is already assigned as a spare drive for an array";
	const ERR_DG_HAS_MISSING_PD = 79;
	const ERR_DG_HAS_MISSING_PD_STR = "Error: Disk is missing from an array";
	const ERR_LD_NOT_IMPORTABLE = 80;
	const ERR_LD_NOT_IMPORTABLE_STR = "Error: Virtual disk is not importable";
	const ERR_HAS_MIGRATION_ON_DG = 81;
	const ERR_HAS_MIGRATION_ON_DG_STR = "Error: Another array is currently doing migration. Only one migration is allowed at any time";
	const ERR_HAS_BGA_IN_DG = 82;
	const ERR_HAS_BGA_IN_DG_STR = "Error: Array currently has BGA";
	const ERR_HD_CANNOT_SET_DOWN = 83;
	const ERR_HD_CANNOT_SET_DOWN_STR = "Error: Physical disk cannot be set down";
	const ERR_HD_NOT_OFFLINE = 84;
    const ERR_HD_NOT_OFFLINE_STR = "Error: physical disk is not offline.";
	const ERR_LD_STATUS_WRONG = 85;
    const ERR_LD_STATUS_WRONG_STR = "Error: virtual disk status is not right.";
	const ERR_LD_NOT_REPORTABLE = 86;
    const ERR_LD_NOT_REPORTABLE_STR = "Error: virtual disk can not be reported.";
	const ERR_RAID_NOT_REDUNDANT = 87;
    const ERR_RAID_NOT_REDUNDANT_STR = "Error: target is not redundant RAID.";
    const ERR_MP_RUNNING = 88;
    const ERR_MP_RUNNING_STR = "Error: Raid allows one media patrol only.";
    const ERR_SPARE_IS_IN_USED = 89;
    const ERR_SPARE_IS_IN_USED_STR = "Error: target spare disk is using.";

	const ERR_INVALID_MATCH_ID = 151;
	const ERR_INVALID_MATCH_ID_STR = "Error: Adapter id and device id doesn't match";
	const ERR_INVALID_HDCOUNT = 152;
	const ERR_INVALID_HDCOUNT_STR = "Error: Invalid physical disk count";
	const ERR_INVALID_BGA_ACTION = 153;
	const ERR_INVALID_BGA_ACTION_STR = "Error: Invalid BGA action";
	const ERR_HD_IN_DIFF_CARD = 154;
	const ERR_HD_IN_DIFF_CARD_STR = "Error: Specified physical disk(s) are on different adapter";
	const ERR_INVALID_FLASH_TYPE = 155;
	const ERR_INVALID_FLASH_TYPE_STR = "Error: Invalid flash type";
	const ERR_INVALID_FLASH_ACTION = 156;
	const ERR_INVALID_FLASH_ACTION_STR = "Error: Invalid flash action";
	const ERR_TOO_FEW_EVENT = 157;
	const ERR_TOO_FEW_EVENT_STR = "Error: Too few events";
	const ERR_VD_HAS_RUNNING_OS = 158;
	const ERR_VD_HAS_RUNNING_OS_STR = "Error: Virtual disk has running OS on it";
	const ERR_DISK_HAS_RUNNING_OS = 159;
	const ERR_DISK_HAS_RUNNING_OS_STR = "Error: Disk has running OS on it";
	const ERR_COMMAND_NOT_SUPPURT = 160;
	const ERR_COMMAND_NOT_SUPPURT_STR = "Error: This command is not support on this produce";
	const ERR_MIGRATION_LIMIT = 161;
	const ERR_MIGRATION_LIMIT_STR = "Error: Can not migrate more than one virtual disk in each adapter";
	const ERR_SGPIO_CONTROL_NOT_SUPPORTED = 162;
	const ERR_SGPIO_CONTROL_NOT_SUPPORTED_STR = "Error: SGPIO control not support";
	const ERR_COUNT_OUT_OF_RANGE = 163;
	const ERR_COUNT_OUT_OF_RANGE_STR = "Error: Count out of range";
	const ERR_IOCTL_NO_RESOURCE = 164;
	const ERR_IOCTL_NO_RESOURCE_STR = "Error: IoControl buffer size is too big";
	const ERR_INVALID_FILE = 165;
	const ERR_INVALID_FILE_STR = "Error: Invalid file input";
	const ERR_INVALID_MICROCODE = 166;
	const ERR_INVALID_MICROCODE_STR = "Error: Invalid microcode found";
	const ERR_USER_NOT_FOUND = 167;
	const ERR_USER_NOT_FOUND_STR = "Error: User not exists";
	const ERR_USER_NOT_INUSE = 168;
	const ERR_USER_NOT_INUSE_STR = "Error: User hasn't got privilege";
	const ERR_USER_INUSE = 169;
	const ERR_USER_INUSE_STR = "Error: Other user in use";

	const ERR_DEVICE_IS_BUSY = 181;
	const ERR_DEVICE_IS_BUSY_STR = "Error: Device is busy";
	const ERR_INVALID_FLASH_DATA = 184;
	const ERR_INVALID_FLASH_DATA_STR = "Error: invalid flash data";
	const ERR_INVALID_FLASH_DESCRIPTOR = 185;
	const ERR_INVALID_FLASH_DESCRIPTOR_STR = "Error: invalid flash description";
	const ERR_NEED_RESCAN = 186;
	const ERR_NEED_RESCAN_STR = "Warning: adapter is not found, please run rescan";
	const ERR_RESCANING = 187;
	const ERR_RESCANING_STR = "Warning: system is scanning adapter, please wait";
	const ERR_NOT_SUPPORT_MIGRATE = 188;
	const ERR_NOT_SUPPORT_MIGRATE_STR = "Error: The selected migration is not supported";


        const ERR_ENTRY_OUT_OF_RANGE = 241;
        const ERR_ENTRY_OUT_OF_RANGE_STR = "Error: entry out of  range";
        const ERR_PORT_OUT_OF_RANGE = 242;
        const ERR_PORT_OUT_OF_RANGE_STR = "Error: port out of  range";
        const ERR_INVALID_NUM_REQUESTED = 243;
        const ERR_INVALID_NUM_REQUESTED_STR = "Error: invalid number requested";
        const ERR_INVALID_REQUEST_TYPE = 244;
        const ERR_INVALID_REQUEST_TYPE_STR = "Error: invalid request type";
        const ERR_INVALID_KEY_LENGTH = 245;
        const ERR_INVALID_KEY_LENGTH_STR = "Error: invalid key length";
        const ERR_NOT_OFFLINE_DISK = 246;
        const ERR_NOT_OFFLINE_DISK_STR = "Error: not offline disk";
        const ERR_KEY_MISMATCH = 247;
        const ERR_KEY_MISMATCH_STR = "Error: key mismatch";
        const ERR_PASSWORD_MISMATCH = 248;
        const ERR_PASSWORD_MISMATCH_STR = "Error: password mismatch";
        const ERR_PORT_ID_NOT_FOUND = 249;
        const ERR_PORT_ID_NOT_FOUND_STR = "Error: port id not found";
        const ERR_ENTRY_NO_KEY = 250; // the specified entry has no key.
        const ERR_ENTRY_NO_KEY_STR = "Error: the specified entry has no key.";


	public static function getErrStr($ErrorCode)
	{
		switch ($ErrorCode)
		{
			case self::ERR_GENERIC : return self::ERR_GENERIC_STR;
			case self::ERR_RAID : return self::ERR_RAID_STR;
			case self::ERR_CORE : return self::ERR_CORE_STR;
			case self::ERR_API : return self::ERR_API_STR;
			case self::ERR_NONE : return self::ERR_NONE_STR;
			case self::ERR_FAIL : return self::ERR_FAIL_STR;
			case self::ERR_UNKNOWN : return self::ERR_UNKNOWN_STR;
			case self::ERR_NO_RESOURCE : return self::ERR_NO_RESOURCE_STR;
			case self::ERR_REQ_OUT_OF_RANGE : return self::ERR_REQ_OUT_OF_RANGE_STR;
			case self::ERR_INVALID_REQUEST : return self::ERR_INVALID_REQUEST_STR;
			case self::ERR_INVALID_PARAMETER : return self::ERR_INVALID_PARAMETER_STR;
			case self::ERR_INVALID_LD_ID : return self::ERR_INVALID_LD_ID_STR;
			case self::ERR_INVALID_HD_ID : return self::ERR_INVALID_HD_ID_STR;
			case self::ERR_INVALID_EXP_ID : return self::ERR_INVALID_EXP_ID_STR;
			case self::ERR_INVALID_PM_ID : return self::ERR_INVALID_PM_ID_STR;
			case self::ERR_INVALID_BLOCK_ID : return self::ERR_INVALID_BLOCK_ID_STR;
			case self::ERR_INVALID_ADAPTER_ID : return self::ERR_INVALID_ADAPTER_ID_STR;
			case self::ERR_INVALID_RAID_MODE : return self::ERR_INVALID_RAID_MODE_STR;
			case self::ERR_INVALID_ENC_ID : return self::ERR_INVALID_ENC_ID_STR;
			case self::ERR_INVALID_BU_ID : return self::ERR_INVALID_BU_ID_STR;
			case self::ERR_INVALID_DG_ID : return self::ERR_INVALID_DG_ID_STR;
			case self::ERR_INVALID_ENC_ELEMENT_ID : return self::ERR_INVALID_ENC_ELEMENT_ID_STR;
			case self::ERR_NOT_SUPPORTED : return self::ERR_NOT_SUPPORTED_STR;
			case self::ERR_DRIVER_SENSOR : return self::ERR_DRIVER_SENSOR_STR;
			case self::ERR_INVALID_KEY_PRESENT : return self::ERR_INVALID_KEY_PRESENT_STR;
			case self::ERR_INVALID_KEY_ABSENT : return self::ERR_INVALID_KEY_ABSENT_STR;
			case self::ERR_COMMAND_PHASE_ERROR : return self::ERR_COMMAND_PHASE_ERROR_STR;
			case self::ERR_DATA_PHASE_ERROR : return self::ERR_DATA_PHASE_ERROR_STR;
			case self::ERR_STATUS_PHASE_ERROR : return self::ERR_STATUS_PHASE_ERROR_STR;
			case self::ERR_STATUS_PHASE_PHASE_ERROR : return self::ERR_STATUS_PHASE_PHASE_ERROR_STR;
			case self::ERR_STATUS_PHASE_CMD_ERROR : return self::ERR_STATUS_PHASE_CMD_ERROR_STR;

			case self::ERR_TARGET_IN_LD_FUNCTIONAL : return self::ERR_TARGET_IN_LD_FUNCTIONAL_STR;
			case self::ERR_TARGET_NO_ENOUGH_SPACE : return self::ERR_TARGET_NO_ENOUGH_SPACE_STR;
			case self::ERR_HD_IS_NOT_SPARE : return self::ERR_HD_IS_NOT_SPARE_STR;
			case self::ERR_HD_IS_SPARE : return self::ERR_HD_IS_SPARE_STR;
			case self::ERR_HD_NOT_EXIST : return self::ERR_HD_NOT_EXIST_STR;
			case self::ERR_HD_IS_ASSIGNED_ALREADY : return self::ERR_HD_IS_ASSIGNED_ALREADY_STR;
			case self::ERR_INVALID_HD_COUNT : return self::ERR_INVALID_HD_COUNT_STR;
			case self::ERR_LD_NOT_READY : return self::ERR_LD_NOT_READY_STR;
			case self::ERR_LD_NOT_EXIST : return self::ERR_LD_NOT_EXIST_STR;
			case self::ERR_LD_IS_FUNCTIONAL : return self::ERR_LD_IS_FUNCTIONAL_STR;
			case self::ERR_HAS_BGA_IN_VD : return self::ERR_HAS_BGA_IN_VD_STR;
			case self::ERR_NO_BGA_ACTIVITY : return self::ERR_NO_BGA_ACTIVITY_STR;
			case self::ERR_BGA_RUNNING : return self::ERR_BGA_RUNNING_STR;
			case self::ERR_RAID_NO_AVAILABLE_ID : return self::ERR_RAID_NO_AVAILABLE_ID_STR;
			case self::ERR_LD_NO_ATAPI : return self::ERR_LD_NO_ATAPI_STR;
			case self::ERR_INVALID_RAID6_PARITY_DISK_COUNT : return self::ERR_INVALID_RAID6_PARITY_DISK_COUNT_STR;
			case self::ERR_INVALID_BLOCK_SIZE : return self::ERR_INVALID_BLOCK_SIZE_STR;
			case self::ERR_MIGRATION_NOT_NEED : return self::ERR_MIGRATION_NOT_NEED_STR;
			case self::ERR_STRIPE_BLOCK_SIZE_MISMATCH : return self::ERR_STRIPE_BLOCK_SIZE_MISMATCH_STR;
			case self::ERR_MIGRATION_NOT_SUPPORT : return self::ERR_MIGRATION_NOT_SUPPORT_STR;
			case self::ERR_LD_NOT_FULLY_INITED : return self::ERR_LD_NOT_FULLY_INITED_STR;
			case self::ERR_LD_NAME_INVALID : return self::ERR_LD_NAME_INVALID_STR;
			case self::ERR_HD_TYPE_MISMATCH : return self::ERR_HD_TYPE_MISMATCH_STR;
			case self::ERR_HD_SECTOR_SIZE_MISMATCH : return self::ERR_HD_SECTOR_SIZE_MISMATCH_STR;
			case self::ERR_NO_LD_IN_DG : return self::ERR_NO_LD_IN_DG_STR;
			case self::ERR_HAS_LD_IN_DG : return self::ERR_HAS_LD_IN_DG_STR;
			case self::ERR_NO_ROOM_FOR_SPARE : return self::ERR_NO_ROOM_FOR_SPARE_STR;
			case self::ERR_SPARE_IS_IN_MULTI_DG : return self::ERR_SPARE_IS_IN_MULTI_DG_STR;
			case self::ERR_DG_HAS_MISSING_PD : return self::ERR_DG_HAS_MISSING_PD_STR;
			case self::ERR_LD_NOT_IMPORTABLE : return self::ERR_LD_NOT_IMPORTABLE_STR;
			case self::ERR_HAS_MIGRATION_ON_DG : return self::ERR_HAS_MIGRATION_ON_DG_STR;
			case self::ERR_HAS_BGA_IN_DG : return self::ERR_HAS_BGA_IN_DG_STR;
			case self::ERR_HD_CANNOT_SET_DOWN : return self::ERR_HD_CANNOT_SET_DOWN_STR;
			case self::ERR_HD_NOT_OFFLINE : return self::ERR_HD_NOT_OFFLINE_STR;
			case self::ERR_LD_STATUS_WRONG : return self::ERR_LD_STATUS_WRONG_STR;
			case self::ERR_LD_NOT_REPORTABLE : return self::ERR_LD_NOT_REPORTABLE_STR;
			case self::ERR_RAID_NOT_REDUNDANT : return self::ERR_RAID_NOT_REDUNDANT_STR;
			case self::ERR_MP_RUNNING : return self::ERR_MP_RUNNING_STR;
			case self::ERR_SPARE_IS_IN_USED : return self::ERR_SPARE_IS_IN_USED_STR;
			case self::ERR_INVALID_MATCH_ID : return self::ERR_INVALID_MATCH_ID_STR;
			case self::ERR_INVALID_HDCOUNT : return self::ERR_INVALID_HDCOUNT_STR;
			case self::ERR_INVALID_BGA_ACTION : return self::ERR_INVALID_BGA_ACTION_STR;
			case self::ERR_HD_IN_DIFF_CARD : return self::ERR_HD_IN_DIFF_CARD_STR;
			case self::ERR_INVALID_FLASH_TYPE : return self::ERR_INVALID_FLASH_TYPE_STR;
			case self::ERR_INVALID_FLASH_ACTION : return self::ERR_INVALID_FLASH_ACTION_STR;
			case self::ERR_TOO_FEW_EVENT : return self::ERR_TOO_FEW_EVENT_STR;
			case self::ERR_VD_HAS_RUNNING_OS : return self::ERR_VD_HAS_RUNNING_OS_STR;
			case self::ERR_DISK_HAS_RUNNING_OS : return self::ERR_DISK_HAS_RUNNING_OS_STR;
			case self::ERR_COMMAND_NOT_SUPPURT : return self::ERR_COMMAND_NOT_SUPPURT_STR;
			case self::ERR_MIGRATION_LIMIT : return self::ERR_MIGRATION_LIMIT_STR;
			//case self::ERR_INVALID_ENCACTIONTYPE : return self::ERR_INVALID_ENCACTIONTYPE_STR;
			//case self::ERR_INVALID_ENCACTION : return self::ERR_INVALID_ENCACTION_STR;
			case self::ERR_SGPIO_CONTROL_NOT_SUPPORTED : return self::ERR_SGPIO_CONTROL_NOT_SUPPORTED_STR;
			case self::ERR_COUNT_OUT_OF_RANGE : return self::ERR_COUNT_OUT_OF_RANGE_STR;
			case self::ERR_IOCTL_NO_RESOURCE : return self::ERR_IOCTL_NO_RESOURCE_STR;
			case self::ERR_INVALID_FILE : return self::ERR_INVALID_FILE_STR;
			case self::ERR_INVALID_MICROCODE : return self::ERR_INVALID_MICROCODE_STR;
			case self::ERR_USER_NOT_FOUND : return self::ERR_USER_NOT_FOUND_STR;
			case self::ERR_USER_NOT_INUSE : return self::ERR_USER_NOT_INUSE_STR;
			case self::ERR_USER_INUSE : return self::ERR_USER_INUSE_STR;
			
			case self::ERR_DEVICE_IS_BUSY : return self::ERR_DEVICE_IS_BUSY_STR;
			case self::ERR_INVALID_FLASH_DATA : return self::ERR_INVALID_FLASH_DATA_STR;
			case self::ERR_INVALID_FLASH_DESCRIPTOR : return self::ERR_INVALID_FLASH_DESCRIPTOR_STR;
			case self::ERR_NEED_RESCAN : return self::ERR_NEED_RESCAN_STR;
			case self::ERR_RESCANING : return self::ERR_RESCANING_STR ;
			case self::ERR_NOT_SUPPORT_MIGRATE : return self::ERR_NOT_SUPPORT_MIGRATE_STR;
			
                        case self::ERR_ENTRY_OUT_OF_RANGE : return self::ERR_ENTRY_OUT_OF_RANGE_STR;
                        case self::ERR_PORT_OUT_OF_RANGE : return self::ERR_PORT_OUT_OF_RANGE_STR;
                        case self::ERR_INVALID_NUM_REQUESTED : return self::ERR_INVALID_NUM_REQUESTED_STR;
                        case self::ERR_INVALID_REQUEST_TYPE : return self::ERR_INVALID_REQUEST_TYPE_STR;
                        case self::ERR_INVALID_KEY_LENGTH  : return self::ERR_INVALID_KEY_LENGTH_STR;
                        case self::ERR_NOT_OFFLINE_DISK : return self::ERR_NOT_OFFLINE_DISK_STR;
                        case self::ERR_KEY_MISMATCH : return self::ERR_KEY_MISMATCH_STR;
                        case self::ERR_PASSWORD_MISMATCH : return self::ERR_PASSWORD_MISMATCH_STR;
                        case self::ERR_PORT_ID_NOT_FOUND : return self::ERR_PORT_ID_NOT_FOUND_STR;
                        case self::ERR_ENTRY_NO_KEY : return self::ERR_ENTRY_NO_KEY_STR;

			default:
				return self::ERR_UNKNOWN_STR ;
		}
	}
}

//app types

class ScheduleSettingType
{
	const No_REPEAT = 0;
	const DAY_REPEAT = 1;
	const WEEK_REPEAT = 2;
	const MONTH_REPEAT = 3;
}

class ScheduleStatus
{
	const NOT_RUN = 0;
	const READING = 1;
	const RUN = 2;
}

class FlashResult
{
	const FLASH_SUCCESS = 1;
	const FLASH_UPLOADFAILED = 2;
	const FLASH_INVALIDFILE = 3;
	const FLASH_FILETOOLARGE = 4;
	const FLASH_GETVERSIONFAILED = 5;
}

class FlashAction
{
	const FLASH_DOWNLOAD = 0xf0;
	const FLASH_UPLOAD = 0xf;
}

class FlashType
{
	const FLASH_TYPE_CONFIG = 0;
	const FLASH_TYPE_BIN = 1;
	const FLASH_TYPE_BIOS = 2;
	const FLASH_TYPE_FIRMWARE = 3;
}

class ScheduleResultType
{
	const SUCCESS = 0;
	const FAILED = 1;
}

//scheduled bga type
class ScheduledBGAType
{
	//VD
	const LD_BGA_CONSISTENCY_CHECK = LdBgaStatus::LD_BGA_CONSISTENCY_CHECK;
	const LD_BGA_CONSISTENCY_FIX = LdBgaStatus::LD_BGA_CONSISTENCY_FIX;
	const LD_BGA_INIT_BACK = LdBgaStatus::LD_BGA_INIT_BACK;
	const LD_BGA_MIGRATION = LdBgaStatus::LD_BGA_MIGRATION;
	const LD_BGA_REBUILD = LdBgaStatus::LD_BGA_REBUILD;
	//PD
	const HD_BGA_MP = 33;

	//Disk Group
	//const DG_BGA_CONSISTENCY_CHECK = 34;
	//const DG_BGA_CONSISTENCY_FIX = 35;
	//const DG_BGA_INIT_BACK = 36;
	const DG_BGA_MIGRATION = 37;
	const DG_BGA_REBUILD = 38;

	//BBU related
	const BBU_BGA_RELEARN = 50;
	const BBU_BGA_RELEARN_STR = "Relearn";
	
	const ACCELERATOR_AUTO = 55;
	const ACCELERATOR_AUTO_STR = "Maintenance";

	const BGA_UNKNOWN_STR = "Unknown";

	public static function getBGATypeString($type)
	{
		switch ($type)
		{
			case self::LD_BGA_CONSISTENCY_CHECK :
				return LdBgaStatus::LD_BGA_CONSISTENCY_CHECK_STR;
			case self::LD_BGA_CONSISTENCY_FIX :
				return LdBgaStatus::LD_BGA_CONSISTENCY_FIX_STR;
			case self::LD_BGA_INIT_BACK :
				return LdBgaStatus::LD_BGA_INIT_BACK_STR;
			case self::LD_BGA_MIGRATION :
				return LdBgaStatus::LD_BGA_MIGRATION_STR;
			case self::LD_BGA_REBUILD :
				return LdBgaStatus::LD_BGA_REBUILD_STR;
			case self::HD_BGA_MP :
				return HdBgaStatus::HD_BGA_MP_STR;
			case self::DG_BGA_MIGRATION :
				return LdBgaStatus::LD_BGA_MIGRATION_STR;
			case self::DG_BGA_REBUILD :
				return LdBgaStatus::LD_BGA_REBUILD_STR;
			case self::BBU_BGA_RELEARN :
				return self::BBU_BGA_RELEARN_STR;
			case self::ACCELERATOR_AUTO :
				return self::ACCELERATOR_AUTO_STR;
			default:
				return self::BGA_UNKNOWN_STR;
		}
	}
}

class WeekDay
{
	const SUNDAY = 0;
	const SUNDAY_STR = 'Sunday';
	const MONDAY = 1;
	const MONDAY_STR = 'Monday';
	const TUESDAY = 2;
	const TUESDAY_STR = 'Tuesday';
	const WEDNESDAY = 3;
	const WEDNESDAY_STR = 'Wednesday';
	const THURSDAY = 4;
	const THURSDAY_STR = 'Thursday';
	const FRIDAY = 5;
	const FRIDAY_STR = 'Friday';
	const SATURDAY = 6;
	const SATURDAY_STR = 'Saturday';
	public static function getWeekDayStr($weekDay)
	{
		switch ($weekDay)
		{
			case self::SUNDAY :
				return self::SUNDAY_STR;
			case self::MONDAY  :
				return self::MONDAY_STR ;
			case self::TUESDAY  :
				return self::TUESDAY_STR ;
			case self::WEDNESDAY  :
				return self::WEDNESDAY_STR ;
			case self::THURSDAY  :
				return self::THURSDAY_STR ;
			case self::FRIDAY  :
				return self::FRIDAY_STR ;
			case self::SATURDAY  :
				return self::SATURDAY_STR ;
		}
	}
}

//user type

class UserType
{
	const ADMIN = 1;
	const ADMIN_STR = 'Administrator';
	const GUEST = 2;//0
	const GUEST_STR = 'Guest';
	const REGECT = 0;//2

	public static function getUserTypeStr($Type)
	{
		switch ($Type)
		{
			case self::ADMIN :
				return self::ADMIN_STR ;
			case self::GUEST :
				return self::GUEST_STR ;
		}
	}
}

class APIMaxSupport
{
	const MAX_HD_SUPPORTED_API = 128;
	const MAX_EXPANDER_SUPPORTED_API = 16;
	const MAX_PM_SUPPORTED_API = 16;
	const MAX_LD_SUPPORTED_API = 32;
	const MAX_DG_SUPPORTED_API = 64;
	const MAX_BLOCK_SUPPORTED_API = 512;
	const MAX_BLOCK_PER_HD_SUPPORTED_API = 16;
	const MAX_ENCLOSURE_API = 32;
	const MAX_SPARE_PD_SUPPORTED_API = 8;

	const MAX_ASE_SUPPORT_API = 8;
        const MAX_NUM_PARTITIONS = 10;
}

class AlertMsg
{
	const ASSIGNSPARE_PD_MBR = "PD has file system on it. Data may get lost if it is assigned as spare disk.\nAre you sure you want to assign it as spare disk?";
	const CLEARSPARE_PD_STOP_MP = "Clear spare will stop Media patrol on PD. Do you want to continue?";
    const LDINFO_DELETE_LD = "WARNING! ALL DATA WILL BE ERASED! Are you sure you want to delete this VD?";
	const LDINFO_DELETE_MBR = "If you want to delete the partition information if it has one, press \"OK\", or press \"Cancel\".";
    const LDINFO_STOP_MP = "Delete VD will stop Media patrol on PD. Do you want to continue?";
    const LDCHECK_STOP_MP = "Check VD will stop Media patrol on PD. Do you want to continue?";
    const LDFIX_STOP_MP = "Fix VD will stop Media patrol on PD. Do you want to continue?";
    const LDINIT_STOP_MP = "Init VD will stop Media patrol on PD. Do you want to continue?";
    const LDREBUILD_STOP_MP = "Rebuild VD will stop Media patrol on PD. Do you want to continue?";
    const LDMIGRATE_STOP_MP = "Migrate VD will stop Media patrol on PD. Do you want to continue?";
	const MIGRATE_LIMIT_ERR = "Migration source and target VD should have at least one common PD!";
	const MIGRATE_DG_LIMIT_ERR = "Migration source and target VD should have at least one common PD!";
	const PERMISSION_CHECK_FAIL = "You don't have permission to do this operation. Please login as administrator first.";
	const MIGRATE_CANCEL = "Are you sure you want to cancel the VD Migration?";
	const CREATE_CANCEL = "Are you sure you want to cancel the VD Creation?";
	const INIT_CANCEL = "Are you sure you want to cancel the VD Initialization?";
	const REBUILD_CANCEL = "Are you sure you want to cancel the VD Rebuilding?";
	const CHECK_CANCEL = "Are you sure you want to cancel the VD Consistency Check?";
	const SCHEDULE_CANCEL = "Are you sure you want to cancel BGA Schedule Time Setting?";
	const MP_CANCEL = "Are you sure you want to cancel Media Patrol?";

	const MP_FREE_PD_ERROR = "Media patrol on free disk is not allowed.";
	const CREATE_VD_FREE_PD_ERROR = "Non-free disk can not be used to create VD.";

	const DGINFO_DELETE_DG = "Are you sure you want to delete this Array?";
    const DGINFO_STOP_MP = "Delete Array will stop Media patrol on PD. Do you want to continue?";
    const DGMIGRATE_STOP_MP = "Migrate Array will stop Media patrol on PD. Do you want to continue?";
    const DGREBUILD_STOP_MP = "Rebuild Array will stop Media patrol on PD. Do you want to continue?";
    const CREATEVD_STOP_MP = "Create VD will stop Media patrol on PD. Do you want to continue?";
}

/***********************************
 * to get request parameter submited
 * by browser
 ***********************************/
function getRequestPara($Str)
{
	$RetVal = null;
	foreach ($_GET as $key=>$value)
	{
		if ($key == $Str) {
			$RetVal = $value;
		}
	}

	foreach ($_POST as $key=>$value)
	{
		if ($key == $Str) {
			$RetVal = $value;
		}
	}

	return $RetVal;
}

function getSessionPara($Str)
{
	$RetVal = null;
	foreach ($_SESSION as $key=>$value)
	{
		if ($key == $Str) {
			$RetVal = $value;
		}
	}

	return $RetVal;
}

function getCookiePara($Str)
{
	$RetVal = null;
	foreach ($_COOKIE as $key=>$value)
	{
		if ($key == $Str) {
			$RetVal = $value;
		}
	}

	return $RetVal;
}

/***********************************
 * to get the url base
 *
 ***********************************/

function getBaseURL()
{
	$url = "http://" . $_SERVER['SERVER_NAME'] . ":8845";

	$request_url = $_SERVER['REQUEST_URI'];

	// do some
	$strs = explode("/",$request_url);

	if (sizeof($strs) > 2) {
		$url .= "/" . $strs[1];
	}

	return $url . "/";
}

function getSecureBaseURL()
{
    if ($_SESSION["isHTTPsLogin"] == 1) {
        $url = "https://" . $_SERVER['SERVER_NAME'] . ":8443";
    }else {
        $url = "http://" . $_SERVER['SERVER_NAME'] . ":8845";
    }

	$request_url = $_SERVER['REQUEST_URI'];

	// do some
	$strs = explode("/",$request_url);

	if (sizeof($strs) > 2) {
		$url .= "/" . $strs[1];
	}

	return $url . "/";
}

/*
function xml_entity_encode($str)
{
	$str = str_replace("&", "&amp;", $str);
	$str = str_replace(">", "&gt;", $str);
	$str = str_replace("<", "&lt;", $str);
	$str = str_replace('"', "&quot;", $str);
	$str = str_replace("'", "&apos;", $str);

	return $str;
}
*/

function getUrlPropertyValue($str,$name,$sep = '|')
{
	$arr = explode($sep,$str);

	foreach ($arr as $entity)
	{
		$entity = trim($entity);
		$index = strpos($entity,$name);

		if ($index !== false) {
			return trim(substr($entity,$index + strlen($name) + 1));
		}
	}

	return "";
}

/*******************************
 * mru version string
 * for mru utility to display the
 * version info
 ******************************/
function get_mru_version_string()
{
	return get_version();
}

/******************************
 * format ld size and hd size
 ******************************/

function FormatSize($size,$UseThorSizePolicy=0)
{
    $size = ConvertSize($size,$UseThorSizePolicy);
	return number_format($size,1) . " GB";
}

function ConvertSize($size,$UseThorSizePolicy=0)
{
	if ($UseThorSizePolicy)	
    	$size = floor($size / UNIT_K / UNIT_K * 10) / 10;
    else
    	$size = round((float)$size / UNIT_KILO / UNIT_K * 10) / 10;
	return $size;
}

function SectorSizeToKB($sectorsize)   // 1K = 2 sector
{
    return round($sectorsize * 10 / 2 /10);
}

function compareHDPortId($hd1, $hd2)
{
	if (intval($hd1->ParentPhyID) > intval($hd2->ParentPhyID)) return 1;
	else return -1;
}

/*for convert encoding*/

define("SUPPORT_ENCODING_LIST", "ASCII,GBK,UTF-8");

$SUPPORT_ENCODING_LIST_ARRAY = explode(",", SUPPORT_ENCODING_LIST);

function inter_mb_get_encoding($str)
{
    return (mb_detect_encoding($str, SUPPORT_ENCODING_LIST));
}

function inter_mb_convert_utf8_path($path)
{
    $ret = $path;
    if(is_dir($ret)) {
        return $ret;
    } else {
        global $SUPPORT_ENCODING_LIST_ARRAY;
        foreach($SUPPORT_ENCODING_LIST_ARRAY as $coding) {
            $ret = mb_convert_encoding($path, $coding, "UTF-8");
            if($ret != false && is_dir($ret))
                return $ret;
        }
    }
    return $path;
}

/*check from localhost*/
function check_whether_from_local()
{
    if($_SERVER['SERVER_ADDR'] == "127.0.0.1") {
        return true;
    }
    return false;
}

class PHPPageName
{
	const TargetPageName = "JumpPage.php";
	const CmdPageName = "command.php";
}

class APICmd
{
    const createPackageVD = "createPackageVD";
    const deletePackageVD = "deletePackageVD";
    const savePackageVDConfig = "savePackageVDConfig";
    const packageVDBgaControl = "packageVDBgaControl";
    const initPackageVD = "initPackageVD";
    const checkPackageVD = "checkPackageVD";
    const rebuildPackageVD = "rebuildPackageVD";
    const migratePackageVD = "migratePackageVD";
    const getMigratedPackageVDSize = "getMigratedPackageVDSize";
    const AcceleratorAuto = "AcceleratorAuto";
    const hyperIntelligentInit = "hyperIntelligentInit";
    const rescanAdapter = "rescanAdapter";
    const ssdAdapterLink = "ssdAdapterLink";
    const ssdAdapterUnLink = "ssdAdapterUnLink";
    const pdAESForceOnline = "pdAESForceOnline";
    const aesPortMount = "aesPortMount";
    const aesPortDismount = "aesPortDismount";
    const aesPortEnable = "aesPortEnable";
    const aesEntryAddKey = "aesEntryAddKey";
    const aesEntryRemoveKey = "aesEntryRemoveKey";
    const aesEntryChangePWD = "aesEntryChangePWD";
    const deleteHyperDuo = "deleteHyperDuo";
    const UpdateAccVolFreeSize = "UpdateAccVolFreeSize";
    const ssdAdapterCreate = "ssdAdapterCreate";
    const deleteHyperSSD = "deleteHyperSSD";
    const calcSelectedAppSize = "calcSelectedAppSize";
    const addFileToGroup = "addFileToGroup";
    const deleteFileFromApp = "deleteFileFromApp";
    const deleteGroup = "deleteGroup";
    const saveCustomizeGroup = "saveCustomizeGroup";
    const doAcceleratorMaintain = "doAcceleratorMaintain";
	const createHyperHDD = "createHyperHDD";
	const getSSDCreateHypperMaxSize = "getSSDCreateHypperMaxSize";
	const appStopAccelerate = "appStopAccelerate";
	const appPauseAccelerate = "appPauseAccelerate";
	const appResumeAccelerate = "appResumeAccelerate";
	const getAcceleratorScanStatus = "getAcceleratorScanStatus";
	const appScan = "appScan";
	const getAcceleratingStatus = "getAcceleratingStatus";
	const appAccelerate = "appAccelerate";
	const getCreateDefaultVal = "getCreateDefaultVal";
	const getSSDVolumeAllocation = "getSSDVolumeAllocation";
	const reportVD = "reportVD";
	const ssdCreateVolume = "ssdCreateVolume";
	const getCurrentCreatePara = "getCurrentCreatePara";
	const getAllSSDStatus = "getAllSSDStatus";
	const setSSDOpLevel = "setSSDOpLevel";
	const flashBios = "flashBios";
	const ldondgbgaControl = "ldondgbgaControl";
	const saveDgConfig = "saveDgConfig";
	const createVdOnDg = "createVdOnDg";
	const createDGSubmit = "createDGSubmit";
	const createDGNext = "createDGNext";
	const deleteDG = "deleteDG";
	const migrateDG = "migrateDG";
	const rebuildDG = "rebuildDG";
	const initVdOnDg = "initVdOnDg";
	const checkVdOnDg = "checkVdOnDg";
	const deleteVdOnDg = "deleteVdOnDg";
	const saveVdOnDg = "saveVdOnDg";
	const dgbgaControl = "dgbgaControl";
	const initLD = "initLD";
	const checkLD = "checkLD";
	const quickCreateVD = "quickCreateVD";
	const quickCreateDGVD = "quickCreateDGVD";
	const createLD = "createLD";
	const deleteLD = "deleteLD";
	const bgaControl = "bgaControl";
	const migrateLD = "migrateLD";
	const rebuildLD = "rebuildLD";
	const saveLDConfig = "saveLDConfig";
	const importLD = "importLD";
	const saveHDConfig = "saveHDConfig";
	const setHDStatus = "setHDStatus";
	const saveLEDConfig = "saveLEDConfig";
	const saveENCElementConfig = "saveENCElementConfig";
	const saveHBAConfig = "saveHBAConfig";
	const clearSP = "clearSP";
	const setGlobalSP = "setGlobalSP";
	const setLDSP = "setLDSP";
	const getMigratedLDSize = "getMigratedLDSize";
	const getEventGrid = "getEventGrid";
	const clearEvents = "clearEvents";
	const saveBBUConfig = "saveBBUConfig";
	const saveBBUSchedule = "saveBBUSchedule";
	const muteAdapter = "muteAdapter";
	//pd related
	const dataScrubPd = "dataScrubPd";
	const pdbgaControl = "pdbgaControl";
	const mediaPatrolPD = "mediaPatrolPD";
	const setDedicatedSP = "setDedicatedSP";
	const wipePD = "wipePD";

	const getMigratedDgSize = "getMigratedDgSize";

	const setAESKey = "setAESKey";
	const clearAESKey = "clearAESKey";
	const enableAES = "enableAES";
	const safeRemoveAES = "safeRemoveAES";
	const getAESPrivilege = "getAESPrivilege";

	//app CMD
	const testMailSetting = 'testMailSetting';
	const testMacMailSetting = 'testMacMailSetting';
}

class Target
{
    const getPackageVDPage = "getPackageVDPage";
    const getPackageVDBGAProgress = "getPackageVDBGAProgress";
    const RebuildPackageVDPage = "RebuildPackageVDPage";
    const MigratePackageVDPage = "MigratePackageVDPage";
    const getPackageVDOperation = "getPackageVDOperation";
    const getSMARTInfo = "getSMARTInfo";
    const SubFlashPage = "SubFlashPage";
    const SubPlatoFWFlashPage = "SubPlatoFWFlashPage";
    const PlatoFWFlashPage = "PlatoFWFlashPage";
    const SSDAdapterLinkPage = "SSDAdapterLinkPage";
    const AESPDForceOnlinePage = "AESPDForceOnlinePage";
    const AESEntryAddKeyPage = "AESEntryAddKeyPage";
    const AESEntryChangePWDPage = "AESEntryChangePWDPage";
    const AESPortManagePage = "AESPortManagePage";
    const AESEntryManagePage = "AESEntryManagePage";
    const AESSettingPage = "AESSettingPage";
    const getSubAcceleratorVolume = "getSubAcceleratorVolume";
    const getSubAccelerator = "getSubAccelerator";
    const getHyperSSDDetail = "getHyperSSDDetail";
    const getSSDAdapterDetail = "getSSDAdapterDetail";
    const SSDAdapterCreatePage = "SSDAdapterCreatePage";
    const getSubFolders = "getSubFolders";
    const CustomizeWizardPage1 = "CustomizeWizardPage1";
    const CustomizeWizardPage2 = "CustomizeWizardPage2";
    const CustomizeWizardFramePage = "CustomizeWizardFramePage";
    const testPage = "testPage";
    const AcceleratorSchedulePopup = "AcceleratorSchedulePopup";
    const AcceleratorSchedule = "AcceleratorSchedule";
    const AcceleratorNewSchedule = "AcceleratorNewSchedule";
    const HyperCreatePage2 = "HyperCreatePage2";
    const getSSDVolumeAllocationBar = "getSSDVolumeAllocationBar";
    const getSSDVolumeBGAProgress = "getSSDVolumeBGAProgress";
    const getSSDVolumeDetail = "getSSDVolumeDetail";
    const getSSDStatus = "getSSDStatus";
    const getSSDDetail = "getSSDDetail";
    const getSSDVolumeMaxSize = "getSSDVolumeMaxSize";
    const SSDCreateVolumePage = "SSDCreateVolumePage";
    const AboutPage = "AboutPage";
    const LoginPage = "LoginPage";
    const LogoutPage = "LogoutPage";
    const LdListPage = "LdListPage";
    const MarvellRaidPage = "StoragePage";

    const getArrayOperation = "getArrayOperation";
    const getVdOnDgOperation = "getVdOnDgOperation";
    const getVdOperation = "getVdOperation";
    const getPdOperation = "getPdOperation";

    const CreateHypper1 = "CreateHypper1";
    const CreateHypper2 = "CreateHypper2";
    const getAccelerator = "getAccelerator";
    const getAcceleratorVol = "getAcceleratorVol";
    const getAcceleratorProg = "getAcceleratorProg";
    const getAcceleratorAuto = "getAcceleratorAuto";
    const getSystemSubPage = "getSystemSubPage";
    const getArraySubPage = "getArraySubPage";
    const getIndependentVDPage = "getIndependentVDPage";
    const getVDSubPage = "getVDSubPage";
    const getBBUSubPage = "getBBUSubPage";
    const getEventList = "getEventList";
    const getHdDetail = "getHdDetail";
    const getEnclDetail = "getEnclDetail";
    const getExpDetail = "getExpDetail";
    const getPMDetail = "getPMDetail";
    const getExpandersWithoutEncl = "getExpandersWithoutEncl";
    const getPMsWithoutEncl = "getPMsWithoutEncl";
    const getHBADetail = "getHBADetail";
    const getTreeNodes = "getTreeNodes";
    const getVdBGAProgress = "getVdBGAProgress";
    const getVdOnDgBGAProgress = "getVdOnDgBGAProgress";
    const getBBUInfo = "getBBUInfo";
    const getHDBGAProgress = "getHDBGAProgress";
    const getLdMax = "getLdMax";
    const EventsSaveFilePage = "EventsSaveFilePage";
    const SetDedicatedSparePage = "SetDedicatedSparePage";
    const InitPage = "InitPage";
    const MigrateDgPage = "MigrateDgPage";
    const CreateRaidModePage = "CreateRaidModePage";
    const QuickCreatePage = "QuickCreatePage";
    const CreateDgPage = "CreateDgPage";
    const CreateVdOnDgPage = "CreateVdOnDgPage";
    const CreatePage1 = "CreatePage1";
    const CreatePage2 = "CreatePage2";
    const MigratePage = "MigratePage";
    const MigrateVdPage = "MigrateVdPage";
    const CheckPage = "CheckPage";
    const RebuildDgPage = "RebuildDgPage";
    const RebuildPage = "RebuildPage";
    const AccountPage1 = "AccountPage1";
    const QuickCreateRaidMode = "QuickCreateRaidMode";
    const ToolsetPage = "ToolsetPage";
    const BiosFlashPage = "BiosFlashPage";
    const BiosFlashFramePage = "BiosFlashFramePage";
    const BgaSchedulePage = "BgaSchedulePage";
    const NewTimesettingPage = "NewTimesettingPage";
    const BBUSchedulePage = "BBUSchedulePage";
    const EmailSettingPage = "EmailSettingPage";
    const EmailSettingSavePage = "EmailSettingSavePage";
    const EmailSettingTestPage = "EmailSettingTestPage";
    const getArrayDynamicSubPage = "getArrayDynamicSubPage";
}

?>
