<?php

class System
{
	private $RAIDAPIVer;
	private $PHPExtAPIVer;
	private $RAIDXMLVer;
	private $RAIDSvcVer;
	private $ProductVer;
	private $MRUVer;
	private $ScheduleSupport;
	
	public function __construct()
	{
		$this->MRUVer = get_mru_version_string();
	}
	
	public function getMRUVer()
	{
		return $this->MRUVer;
	}
	
	public function setMRUVer($Version)
	{
		$this->MRUVer = $Version;
	}
	
	public function getScheduleSupport()
	{
		return $this->ScheduleSupport;
	}
	
	public function setScheduleSupport($Support)
	{
		$this->ScheduleSupport = $Support;
	}
	
	public function getRAIDAPIVer()
	{
		return $this->RAIDAPIVer;
	}
	public function setRAIDAPIVer($Version)
	{
		$this->RAIDAPIVer = $Version;
	}
	
	public function getPHPExtensionAPIVer()
	{
		return $this->PHPExtAPIVer;
	}
	public function getRAIDXMLVer()
	{
		return $this->RAIDXMLVer;
	}
	public function getRAIDServiceAPIVer()
	{
		return $this->RAIDSvcVer;
	}
	public function getProductVer()
	{
		return $this->ProductVer;
	}

	public function setSystemInfo($Info)
	{
		foreach ($Info->product as $product)
		{
			$this->setProductVersion($product);
		}
		
		foreach ($Info->php_zraidapi as $php_zraidapi)
		{
			$this->setPHPExtAPIVersion($php_zraidapi);
		}
		
		foreach ($Info->zraidapi as $zraidapi)
		{
			$this->setRAIDXMLVersion($zraidapi);
		}
		
		foreach ($Info->mvraidsvc as $mvraidsvc)
		{
			$this->setRAIDSvcVersion($mvraidsvc);
		}
	}
	
	private function setProductVersion($product)
	{
		$this->ProductVer = trim($product->Major) 
			. "." .  trim($product->Minor)
			. "." .  trim($product->OEM)
			. "." .  trim($product->Build)
			;
	}
	
	private function setPHPExtAPIVersion($php_zraidapi)
	{
		$this->PHPExtAPIVer = trim($php_zraidapi->Major) 
			. "." .  trim($php_zraidapi->Minor)
			. "." .  trim($php_zraidapi->OEM)
			. "." .  trim($php_zraidapi->Build)
			;
	}
	
	private function setRAIDXMLVersion($zraidapi)
	{
		$this->RAIDXMLVer = trim($zraidapi->Major) 
			. "." .  trim($zraidapi->Minor)
			. "." .  trim($zraidapi->OEM)
			. "." .  trim($zraidapi->Build)
			;
	}
	
	private function setRAIDSvcVersion($mvraidsvc)
	{
		$this->RAIDSvcVer = trim($mvraidsvc->Major) 
			. "." .  trim($mvraidsvc->Minor)
			. "." .  trim($mvraidsvc->OEM)
			. "." .  trim($mvraidsvc->Build)
			;
	}
}

?>