<?php
//the class for testing mail setting
class ActionTestMailSetting extends UserAction 
{
	private $userName;
	private $passwd;
	private $serverAddr;
	private $port;
	private $isSSL;
	
	protected function validatePara()
	{
		//check the http request parameters
	}
	protected function initActionPara()
	{
		$this->userName = getRequestPara('userName');
		$this->passwd = getRequestPara('passWord');
		$this->serverAddr = getRequestPara('IPAddress');
		$this->port = getRequestPara('portNum');
		$this->isSSL = getRequestPara('cSSL') ? 1 : 0;
	}
	
	private function doTestMail()
	{
		//add mail class
		include_once("../phpsrc/mail/MRUMailer.class.php");
		
		//initialize MRU mailer
		$mailer = new MRUMailer();
		$mailer->setUserName($this->userName);
		$mailer->setPasswd($this->passwd);
		$mailer->setServerAddr($this->serverAddr);
		$mailer->setPort($this->port);
		$mailer->setSSL($this->isSSL);
		
		try {
			$mailer->initMailer();
			//send out test mail
			$mailer->sendTestMail();
		}
		catch (Exception $e)
		{
			$this->xmlRet = new FailXMLRet();
			$this->xmlRet->Msg = $e->getMessage();
			$this->xmlRet->Url = "";
		}
		
		if ($this->xmlRet == null) {
			$this->xmlRet = new SuccessXMLRet();
			$this->xmlRet->Msg = gettext('Mail setting test succeeded, please save your setting.');
			$this->xmlRet->Url = "";
		}
	}
	
	protected function doAction()
	{
		$this->doTestMail();
	}
}
?>
