<?php
class PgAcceleratorNewScheduleDisplayer extends PageDisplayer {
    protected function initPage() {
        $smarty = $this->smarty;

        $type = getRequestPara('type');
        //$bgaType = getRequestPara('bgaType');
        $jobID = getRequestPara('jobID');
        $startTime= getRequestPara('startTime');
        $repeatType= getRequestPara('repeatType');
        $repeatParam1= getRequestPara('repeatParam1');
        $repeatParam2= getRequestPara('repeatParam2');

        if ($type == 'saveModify' && $cmdPara == null) {
            $da = new BGAJobDataAccess();
            $job = $da->getBGAJobByID($jobID);

            if ($job) {
                //get job info
                $startTime = $job->getSettingTime();
                $repeatParam1 = $job->getSettingDate();
                $repeatParam2 = $job->getSettingDateSupplement();
                $repeatType = $job->getSettingType();

                //format display
                $startTime = substr($startTime,0,2) . ':' . substr($startTime,2,2);
                if ($repeatType == ScheduleSettingType::No_REPEAT) {
                    $time  = strtotime($repeatParam1);
                    $repeatParam1 = date('m/d/Y',$time);
                }
            }
            else {
                $this->displayDefaultPage(Target::AcceleratorSchedule);
            }
        }


        $now = getNow();
        $nowTime = strtotime($now);
        $nowDateStr = date('m/d/Y',$nowTime);
        $nowTimeStr = date('H:i',$nowTime);
        $smarty->assign('nowDateStr',$nowDateStr);
        $smarty->assign('nowTimeStr',$nowTimeStr);

        //to generate calendar main body
        $Calendar_Part="";
        for($x=0; $x<5; $x++) {
            $Calendar_Part .= "<tr>";
            for($y=0; $y<7; $y++) {
                $Calendar_Part .= "<td class='out' id='calDay" . ($x*7+$y) . "' >.</td>";
            }
            $Calendar_Part .= "</tr>";
        }

        $Calendar_Part .= "<tr>";
        for($z=35; $z<39; $z++) $Calendar_Part .= "<td class='out' id='calDay" .  $z  . "'>.</td>";
        //var_dump($Calendar_Part);
        $smarty->assign("Calendar_Part",$Calendar_Part);


        $smarty->assign('type',$type);
        //$smarty->assign('bgaType',$bgaType);
        $smarty->assign('jobID',$jobID);
        $smarty->assign('startTime',$startTime);
        $smarty->assign('repeatType',$repeatType);
        $smarty->assign('repeatParam1',$repeatParam1);
        $smarty->assign('repeatParam2',$repeatParam2);
        $this->setPageName("XML_Accelerator_NewSchedule.tpl");
    }

}

?>