<?php
//include_once("PageDisplayer.class.php");

class PgMigratePackageVDDisplayer extends PgMigrateDisplayer
{
    protected function setDisplayInfo()
    {
        if ($this->cmdPara != null) {
            $HDs = getUrlPropertyValue($this->cmdPara,'HDs');
            $RaidMode = getUrlPropertyValue($this->cmdPara,'RaidMode');
            $NumOfParityDisk = getUrlPropertyValue($this->cmdPara,'NumOfParityDisk');

            $HDs = explode(' ',$HDs);

            $this->smarty->assign('SelectedHDs',$HDs);
            $this->smarty->assign('RaidMode',$RaidMode);
            $this->smarty->assign('NumOfParityDisk',$NumOfParityDisk);
        }

        $this->setPageName(Target::MigratePackageVDPage . ".tpl");
        //$this->smarty->assign("ScheduledBgaType",ScheduledBGAType::LD_BGA_MIGRATION);
    }
    protected function setInfo()
    {
        $smarty = $this->smarty;

        $ID = getRequestPara('ID');

        if ($ID == null) {
            $this->displayDefaultPage(Target::getSystemSubPage);
            return;
        }

        $container = new CtnPackageVDDetail();
        $container->setAdapterID($this->getAdapterID());
        $container->setLDID($ID);
        $container->toGetLDInfo();
        $container->toGetHdInfo();
        $container->toGetBlockInfo();
        $container->smartyAssign($smarty);
        $container->initContainer();

        $ldlst = $container->getBase()->getBaseClasses();
        if (!sizeof($ldlst)) {
            $VDnotExist = new LDInfo();
            $VDnotExist->ID = gettext('Not Exist');
            $VDnotExist->SizeGB = '';
            $VDnotExist->RaidMode = '';
            $smarty->assign('ldInfo',$VDnotExist);
            $smarty->assign('VDNotExist',1);
        }
        else {
            $ldDetail = array_shift($ldlst);
            $blklst = $ldDetail->getBlockList();

            if ($blklst) {
                $hds = array();
                foreach ($blklst as $aBlk)
                {
                    $aHd = $aBlk->belongHD();
                    $hds[] = $aHd;
                }

                $blk = array_shift($blklst);
                $blkSize = $blk->getSize();

                if ($hds) {
                    $filter = new HdMigrateFilter($blkSize, $hds);

                    $hdList = new CtnHdList();
                    $hdList->setAdapterID($this->getAdapterID());
                    $hdList->toGetHDInfo();
                    $hdList->toGetValidSize();
                    $hdList->toGetSpareInfo();
                    $hdList->toGetHdFreeInfo();
                    $hdList->setFilter($filter);
                    $hdList->smartyAssign($smarty);
                    $hdList->initContainer();
                }

                $HBAInfo = new HBADetail();
                $HBAInfo->setID($this->getAdapterID());
                $HBAInfo->toGetHBAInfo();
                $HBAInfo->initData();

                $hbalst = $HBAInfo->getBaseClasses();
                if ($hbalst) {
                    $hba = array_shift($hbalst);
                    //raid mode can be migrated to
                    $this->setMigrateRaidModes($hba,$ldDetail);
                }
            }
        }

        $CancelAlert = gettext(AlertMsg::MIGRATE_CANCEL)."?";
        $smarty->assign("CancelAlert",$CancelAlert);
        $smarty->assign("ID", $ID);
        $smarty->assign("HBAID",$this->getAdapterID());
    }

}
?>