<?php

abstract class HdXmlHandler extends XmlHandler
{
	
}

class HdMBRInfoXmlHandler extends HdXmlHandler
{
	public function handle($XMLRoot)
	{		
		$factory = $this->getFactory();
		if (isset($XMLRoot->MBRInfo)) {
			foreach ($XMLRoot->MBRInfo as $MBRInfo)
			{
				$id = intval($MBRInfo->HDID);
				if ($factory->hasObj($id)) {
					$HD = $factory->getObj($id);
					$HD->setMBRInfo($MBRInfo);
				}
				else {
					$HD = $this->getFactory()->createObj($id);
					$HD->setMBRInfo($MBRInfo);
				}
			}
		}
	}
}

class HdInfoXmlHandler extends HdXmlHandler
{
	public function handle($XMLRoot)
	{		
		$factory = $this->getFactory();
		if (isset($XMLRoot->HD_Info->Link)) {
			foreach ($XMLRoot->HD_Info as $HD_Info)
			{
				$id = intval($HD_Info->Link->Self->DevID);
				if ($factory->hasObj($id)) {
					$HD = $factory->getObj($id);
					$HD->setHdInfo($HD_Info);
				}
				else {
					$HD = $this->getFactory()->createObj($id);
					$HD->setHdInfo($HD_Info);
				}
			}
		}
	}
}

class HdValidSizeXmlHandler extends HdXmlHandler
{
	public function handle($XMLRoot)
	{		
		$factory = $this->getFactory();
		if (isset($XMLRoot->HD_Info)) {
			foreach ($XMLRoot->HD_Info as $HD_Info)
			{
				$id = intval($HD_Info->ID);
				if ($factory->hasObj($id)) {
					$HD = $factory->getObj($id);
					$HD->setValidSizeInfo($HD_Info);
				}
				else {
					$HD = $this->getFactory()->createObj($id);
					$HD->setValidSizeInfo($HD_Info);
				}
			}
		}
	}
}

class HdConfigXmlHandler extends HdXmlHandler
{
	public function handle($XMLRoot)
	{		
		$factory = $this->getFactory();
		if (isset($XMLRoot->Config)) {
			foreach ($XMLRoot->Config as $HD_Info)
			{
				$id = intval($HD_Info->HDID);
				if ($factory->hasObj($id)) {
					$HD = $factory->getObj($id);
					$HD->setHdConfig($HD_Info);
				}
				else 
				{
					$HD = $this->getFactory()->createObj($id);
					$HD->setHdConfig($HD_Info);
				}
			}
		}
	}
}

class HdRaidStatusXmlHandler extends HdXmlHandler 
{
	public function handle($XMLRoot)
	{
		$factory = $this->getFactory();
		
		if (isset($XMLRoot->Status->Status)) {
			foreach ($XMLRoot->Status as $HD_Info)
			{	
				$id = intval($HD_Info->HDID);
				if ($factory->hasObj($id)) {
					$HD = $factory->getObj($id);
					$HD->setHdRaidStatus($HD_Info);
				}
				else 
				{
					$HD = $this->getFactory()->createObj($id);
					$HD->setHdRaidStatus($HD_Info);
				}
			}
		}
	}
}

class HdMPStatusXmlHandler extends HdXmlHandler
{
	public function handle($XMLRoot)
	{
		$factory = $this->getFactory();
		
		if (isset($XMLRoot->Status->LoopCount)) {
			foreach ($XMLRoot->Status as $HD_Info)
			{
				$id = intval($HD_Info->ID);
				
				if ($factory->hasObj($id)) {
					$HD = $factory->getObj($id);
					$HD->setMPInfo($HD_Info);
				}
				else 
				{
					$HD = $this->getFactory()->createObj($id);
					$HD->setMPInfo($HD_Info);
				}
			}
		}
	}
}

class HdStatusXmlHandler extends HdXmlHandler
{
	public function handle($XMLRoot)
	{
		$factory = $this->getFactory();
		
		if (isset($XMLRoot->HD_BGA_Status)) {
			foreach ($XMLRoot->HD_BGA_Status as $Status)
			{
				$id = intval($Status->HDID);
				
				if ($factory->hasObj($id)) {
					$HD = $factory->getObj($id);
					$HD->setHdStatus($Status);
				}
				else 
				{
					$HD = $this->getFactory()->createObj($id);
					$HD->setHdStatus($Status);
				}
			}
		}
	}
}

?>