<?php
class ExpanderInfo extends DevInfo 
{
	public $ID;
	public $index;
	
	public $AdapterID;
	public $PhyCount;
	public $ExpChangeCount;
	public $MaxRouteIndexes;
	public $VendorID;
	public $ProductID;
	public $ProductRev;
	public $ComponentVendorID;
	public $ComponentID;
	public $ComponentRevisionID;
	
	public $RouteTableCapability;
	public $RouteTableConfiguring;
    public $hasEnclosure = 0;
    public $Enclosure;
	
	public function setExpanderInfo($Info)
	{
		$this->ID = $Info->getDeviceID();
		$this->AdapterID = $Info->getAdapterID();
		$this->Configuring = $Info->getConfiguring();
		$this->RouteTableConfigurable = $Info->getRouteTableConfigurable();
		$this->PhyCount = $Info->getPhyCount();
		$this->ExpChangeCount = $Info->getExpChangeCount();
		$this->MaxRouteIndexes = $Info->getMaxRouteIndexes();
		$this->VendorID = $Info->getVendorID();
		$this->ProductID = $Info->getProductID();
		$this->ProductRev = $Info->getProductRev();
		$this->ComponentVendorID = $Info->getComponentVendorID();
		$this->ComponentID = $Info->getComponentID();
		$this->ComponentRevisionID = $Info->getComponentRevisionID();
	}
	
	public function setExpanderDtl($Dtl)
	{	
		$this->RouteTableConfiguring = $Dtl->getConfiguring();
		$this->RouteTableCapability = $Dtl->getRouteTableConfigurable();

        //set enclosure info
        $enclosure = $Dtl->getEnclosure();
        if ($enclosure){
            $encl = new EnclInfo();
            $encl->setEnclInfo($enclosure);
            $encl->setEnclDtl($enclosure);
            $this->Enclosure = $encl;
            $this->hasEnclosure = 1;
        }
        
		$this->setConnectInfo($Dtl);
	}
}
?>