<?php
abstract class PackageVDBase extends LdBase
{
	public function toGetPackageVDHDInfo()
	{
		$this->setPackageVDHdList();
	}

	public function toGetLDInfo()
	{
		$handler = new PackageVDInfoXmlHandler();
		$this->runCommand(XMLAPICommand::MV_PackageVD_GetInfo, $handler);
	}

	public function toGetLDConfig()
	{
		$handler = new PackageVDConfigXmlHandler();
		$this->runCommand(XMLAPICommand::MV_Package_VD_GetConfig, $handler);
	}

	protected function createObject()
	{
		return new PackageVD();
	}

	private function setPackageVDHdList()
	{
		$hdlist = new HdList();
		$hdlist->setAdapterID($this->getAdapterID());
		$hdlist->toGetHDInfo();
		$hdlist->toGetHDRaidStatus();
		$hdlist->toGetHdFreeInfo();
		$hdlist->toGetMPStatus();
		$hdlist->toGetValidSize();

		$hds = $hdlist->getBaseClasses();

		//set HDs into array
		foreach ($this->BaseClasses as $pVDInfo)
		{
			//get member disks
			$memberHds = array();
			foreach ($hds as $hd)
			{
				if(in_array($hd->getDeviceID(),$pVDInfo->getPDIDs()))
				{
					$memberHds[$hd->getDeviceID()] = $hd;
				}
			}
			ksort($memberHds);
			$pVDInfo->setHDList($memberHds);

			//get dedicated spare disks
			$spareHds = array();
			foreach ($hds as $hd)
			{
				if(in_array($hd->getDeviceID(),$pVDInfo->getSparePDIDs()))
				{
					$spareHds[$hd->getDeviceID()] = $hd;
				}
			}
			ksort($spareHds);
			$pVDInfo->setSpareHDList($spareHds);
		}
	}

}
?>