<?php

class RequestSender
{	
	const REQUEST_BY_RANGE = 1;
	const REQUEST_BY_ID = 2;
	
	const INVALID_ID = 65535;
	
	protected $requestType;
	protected $startingIndexOrId;
	protected $numRequested;
	protected $numReturned;
	
	private $apiMaxNumPerTime = 128;
	protected $XMLAPICommandList = array();
	
	public function setMaxNoPerRequest($apiMaxNumPerTime)
	{
		$this->apiMaxNumPerTime = $apiMaxNumPerTime;
	}
	
	public function addCommand($xmlCmd)
	{
		$this->XMLAPICommandList[] = $xmlCmd;
	}
	
	public function runCommand($XmlApiCmd)
	{
		//
		if (strpos($XmlApiCmd->getCommand(), "requestType") === false) {
			$XmlApiCmd->issueCommand();
			return;
		}
		
		$XmlApiCmd->setCommandPara("requestType", $this->requestType);
		
		if ($this->apiMaxNumPerTime <= $this->numRequested) 
		{
			$XmlApiCmd->setCommandPara("numRequested", $this->apiMaxNumPerTime);
		}
		else 
		{
			$XmlApiCmd->setCommandPara("numRequested", $this->numRequested);
		}
		
		$lastStartNo = -1;
		$num = 0;
		$startNo = $this->startingIndexOrId;
		
		while($startNo != self::INVALID_ID)
		{
			$lastStartNo = $startNo;
			
			$XmlApiCmd->setCommandPara("startingIndexOrId", $startNo);								
			
			$startNo = self::INVALID_ID;
			
			if ($XmlApiCmd->issueCommand()) {
				$XMLRoot = $XmlApiCmd->getResult();
				
				//set error cd
				if (isset($XMLRoot->RetVal)) {
					//$this->setErrorCd(intval($XMLRoot->RetVal));
					//break;
				}
				
				if (isset($XMLRoot->RequestHeader)) {
					foreach ($XMLRoot->RequestHeader as $reqHeader)
					{
						$startNo = intval(trim($reqHeader->nextStartingIndex));							
						$num = intval(trim($reqHeader->numReturned));
						$this->numReturned += $num;
					}
					
					//deal with no return
					if ($this->numReturned >= $this->numRequested
						|| $num == 0 //nothing returned
						//|| $startNo > $lastStartNo	//may be not sequential					
						) {
						break;
					}
				}
			}
			else {
				return false;
			}
			
			if($this->requestType == self::REQUEST_BY_ID)
			{
				//once;
				break;
			}
		}
	}
	
	public function getCommandList()
	{
		return $this->XMLAPICommandList;
	}
		
	public function runAPICommands()
	{
		$startNo = $this->startingIndexOrId;
		foreach ($this->XMLAPICommandList as $XmlApiCmd)
		{
			$this->runCommand($XmlApiCmd);
		}
	}
}
?>