<?php

class ActionBBUSchedule extends UserAction 
{
	protected function validatePara()
	{
		//check the http request parameters
	}
	protected function initActionPara()
	{
	}
	
	private function doDeleteJob()
	{
		$DA = new BGAJobDataAccess();
		$DA->deleteBBUJob($this->getAdapterID());
	}
	
	private function doAddJob()
	{
		$VDID = 0;
		$bgaType = ScheduledBGAType::BBU_BGA_RELEARN;
		$cmdPara = "HBAID-" . $this->getAdapterID() . "|VDID-0";
		
		$settingType = getRequestPara('settingType');
		$settingTime = trim(getRequestPara('settingTime'));
		$settingTime = substr($settingTime,0,2) . substr($settingTime,3,2);
		//only once
		if ($settingType == ScheduleSettingType::No_REPEAT) {
			$settingDate = getRequestPara('settingDate1');
			$month = substr($settingDate,0,2);
			$day = substr($settingDate,3,2);
			$year = substr($settingDate,6,4);
			$settingDate = date('Ymd',mktime(0,0,0,$month,$day,$year));
			$settingDateSupplement = 0;
		}
		else if ($settingType == ScheduleSettingType::DAY_REPEAT) {
			$settingDate = getRequestPara('settingDate2');
			$settingDateSupplement = getRequestPara('settingDateSupplement2');
		}
		else if ($settingType == ScheduleSettingType::WEEK_REPEAT) {
			$settingDate = getRequestPara('settingDate3');
			$settingDateSupplement = getRequestPara('settingDateSupplement3');
		}
		else if ($settingType == ScheduleSettingType::MONTH_REPEAT) {
			$settingDate = getRequestPara('settingDate4');
			$settingDateSupplement = getRequestPara('settingDateSupplement4');
		}
		
		$now = getNow();
		$nowTime = strtotime($now);
		$startTime = date('YmdHi',$nowTime);
		$status = ScheduleStatus::NOT_RUN;
		$result = '0';
		$resultText = 'Not Run';
		
		$job = new BGAJob();
		
		$job->setBgaType($bgaType);
		if($bgaType == ScheduledBGAType::HD_BGA_MP)
		{
			$HDs = getUrlPropertyValue($cmdPara,'HDs');
			$job->setVDID($HDs);
		}
		else
		{
			//VD and DG
			$job->setVDID($VDID);
		}
		$job->setCmdPara($cmdPara);
		
		$job->setSettingType($settingType);
		$job->setSettingTime($settingTime);
		$job->setSettingDate($settingDate);
		$job->setSettingDateSupplement($settingDateSupplement);
		
		$job->setStartTime($startTime);
		$job->setStatus($status);
		$job->setResult($result);
		$job->setResultText($resultText);
		
		$DA = new BGAJobDataAccess();
		$jobFound = $DA->getBBUJob($this->getAdapterID());
		if($jobFound)
		{
			$DA->updateBGAJobTimeByID($jobFound->getIndex(), $job);
		}
		else 
			$JobID = $DA->addJob($job);
	}
	
	private function setSuccessResult()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = "JumpPage.php?Target=" . Target::getBBUSubPage . "&HBAID=" . getRequestPara("HBAID");
	}
	
	protected function doAction()
	{
		if(getRequestPara("actionType") == "save")
			$this->doAddJob();
		else if(getRequestPara("actionType") == "delete")
			$this->doDeleteJob();
			
		$this->setSuccessResult();
	}
}

?>