<?php
class GetSSDCreateHypperMaxSize
{
	private $ApiCmd;
	private $TplFile;
	private $ApiCmdGetChange;
	private $smarty;
	
	private $HDs;
	private $HBAID = 0;
	private $maxSize = 0;
	
	private function initPara()
	{
		$this->HDs = getRequestPara("HDs");
		$this->HBAID = getRequestPara("HBAID");
	}
	
	public function setHDIDs($hds)
	{
		$this->HDs = $hds;
	}

	public function setHBAID($HBAID)
	{
		$this->HBAID = $HBAID;
	}

	public function getMaxSize()
	{
		return $this->maxSize;
	}
	
	public function setMaxSize()
	{
		$Cmd = new XMLAPICommand();
		$Cmd->setCommand(XMLAPICommand::MV_HyperHDD_GetMaxSize);
		$Cmd->setCommandPara("AdapterID",$this->HBAID);
		$Cmd->setCommandPara("ID",$this->HDs);
		//var_dump($Cmd);
		if ($Cmd->issueCommand()) {
			$this->maxSize = intval($Cmd->getResult()->HyperFreeSize);
			$this->smarty->assign("MaxSizeGB",FormatSize($this->maxSize));
			$this->smarty->assign("MaxSize", ConvertSize($this->maxSize));
		}
	}
	
	private function setTestData()
	{
		$this->maxSize = 123333333;
		//$this->smarty->assign("MaxSizeGB",FormatSize($size));
		$this->smarty->assign("MaxSize",ConvertSize($this->maxSize));
	}
	
	public function displayResultXML()
	{
		$this->TplFile = "XML_SSDCreateMaxSize.tpl";
		if (BaseData::DebugTest) {
			$this->setTestData();
			$this->smarty->display($this->TplFile);
			return;
		}
		$this->initPara();
		$this->setMaxSize();
		$this->smarty->display($this->TplFile);
	}
	
	public function smartyAssign($smarty)
	{
		$this->smarty = $smarty;
	}
}
?>