<?php

/***********************************************
* Localization
***********************************************/

//get local string
function getLocaleStr($lang)
{
	$lang = strtolower($lang);
	switch ($lang)
	{
		case "en-us":
			return "en_US";
		case "zh-cn":
			return "zh_CN";
		case "zh-tw";
			return "zh_TW";
		case "fr-ca":
			return "fr_CA";
		case "ja":
			return "ja_JP";
		case "ja-jp":
			return "ja_JP";
		case "ko":
			return "ko";
		default:
			return "en_US";
	}
}

//get localization string from HTTP ACCEPT LANGUAGE
function getLocalizedLang()
{
	$Localized_Language = "en_US";  //default value
	$Localized_Root_Directory = "../localization";
	
	if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
		//get supported langs
		$languages = preg_split("/,/", $_SERVER['HTTP_ACCEPT_LANGUAGE'] );
		$lang_q = Array();
		foreach( $languages as $aLang ) {
			$lang_array = preg_split("/;q=/", trim( $aLang ) );
			$lang = trim( $lang_array[0] );
			if( !isset( $lang_array[1] ) )
			$q = 1;
			else
			$q = trim($lang_array[1]);
			$lang_q["$lang"] = (float)$q;
		}
		arsort($lang_q);
	
		$i = 0;
		foreach($lang_q as $lang => $q) {
			if($Localized_Language == ""){
				$lang = getLocaleStr($lang);
				if(is_dir($Localized_Root_Directory."/".$lang))
				{
					$Localized_Language = $lang;
				}
			}
		}
	}
	
	return $Localized_Language;
}

function getEncoding($lang)
{
	//need to add all the supported lang encoding.
	switch ($lang)
	{
		case "zh_CN":
			return "CP936";
		case "ja_JP":
			return "shift_jis";
		case "ko":
			return "UTF-8";
		case "fr_CA":
			return "ISO-8859-1";
		case "zh_TW":
			return "GBK";
		default:
			return "UTF-8";
	}
}

$localLang = getLocalizedLang();

//initialize gettext
define('PACKAGE', 'messages');
$_ENV["LANGUAGE"]=$localLang;
$_ENV["LANG"]=$localLang;
//setlocale(LC_ALL, $localLang . ".UTF-8");
setlocale(LC_ALL, $localLang);

bindtextdomain(PACKAGE, '../localization');
bind_textdomain_codeset(PACKAGE,"UTF-8");

unset($localLang);

?>
