/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.configurations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.configurations.ConfigurationPayload;
import pdtEditor.validation.Validator;

public class HumanPresenceStandardConfigurationPayload
extends ConfigurationPayload {
    public static final int CONFIGURATION_TYPE = 112;
    public static final String CONFIGURATION_FORMAT_STRING = "Human Presence Calibrated Configuration";
    public static final int DETECT_RANGE_MAX_SIZE = 2;
    public static final int DETECT_RANGE_MIN_SIZE = 2;
    public static final int DETECTION_TYPE_MAX_SIZE = 1;
    public static final int HINGE_HIGH_FIELD_SIZE = 2;
    public static final int HINGE_LOW_FIELD_SIZE = 2;
    public static final int PLM_MODE_ID_FIELD_SIZE = 4;
    public static final int DETECT_RANGE_MAX_DEFAULT_VALUE = 2000;
    public static final int DETECT_RANGE_MIN_DEFAULT_VALUE = 50;
    public static final int ATTENTION_DISABLE = 0;
    public static final int ATTENTION_ENABLE = 1;
    public static final int ATTENTION_FIELD_SIZE = 1;
    public static final int SCREEN_ANGLE_HIGH_FIELD_SIZE = 2;
    public static final int SCREEN_ANGLE_LOW_FIELD_SIZE = 2;
    public int detetctRangeMax;
    public int detetctRangeMin;
    public int detectionType;
    public int hingeAngleLow;
    public int hingeAngleHigh;
    public int plmModeId;
    private boolean attention;
    private int screenAngleLow;
    private int screenAngleHigh;
    private static final int[] formatIdArray = new int[]{0, 1, 2, 3, 4};
    private static final int LATEST_FORMAT_ID = formatIdArray[formatIdArray.length - 1];
    private int _formatID = LATEST_FORMAT_ID;
    private int _version = 0;

    public static int[] getAllSupportFormatId() {
        return formatIdArray;
    }

    public HumanPresenceStandardConfigurationPayload() {
    }

    public HumanPresenceStandardConfigurationPayload(HumanPresenceStandardConfigurationPayload src) {
        this._formatID = src._formatID;
        this._version = src._version;
        this.detetctRangeMax = src.detetctRangeMax;
        this.detetctRangeMin = src.detetctRangeMin;
        this.detectionType = src.detectionType;
        this.hingeAngleLow = src.hingeAngleLow;
        this.hingeAngleHigh = src.hingeAngleHigh;
        this.plmModeId = src.plmModeId;
        this.attention = src.attention;
        this.screenAngleHigh = src.screenAngleHigh;
        this.screenAngleLow = src.screenAngleLow;
    }

    public HumanPresenceStandardConfigurationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        this._formatID = formatId;
        if (this._formatID > LATEST_FORMAT_ID) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element configurationElement = reader.readNewField((String)"HumanPresenceCalibratedConfiguration", (Node)payloadXmlNode).xmlElement;
        this.detetctRangeMax = reader.readNewField((String)"DetectRangeMax", (int)2, (boolean)false, (Node)configurationElement).value;
        this.detetctRangeMin = reader.readNewField((String)"DetectRangeMin", (int)2, (boolean)false, (Node)configurationElement).value;
        if (this._formatID >= 1) {
            this.detectionType = reader.readNewField((String)"DetectionType", (int)1, (boolean)false, (Node)configurationElement).value;
        }
        if (this._formatID >= 2) {
            this.hingeAngleLow = reader.readNewField((String)"HingeAngleLow", (int)2, (boolean)false, (Node)configurationElement).value;
            this.hingeAngleHigh = reader.readNewField((String)"HingeAngleHigh", (int)2, (boolean)false, (Node)configurationElement).value;
            this.plmModeId = reader.readNewField((String)"PlmModeID", (int)4, (boolean)false, (Node)configurationElement).value;
        }
        if (this._formatID >= 3) {
            int attentionValue = reader.readNewField((String)"Attention", (int)1, (boolean)false, (Node)configurationElement).value;
            boolean bl = this.attention = attentionValue == 1;
        }
        if (this._formatID >= 4) {
            this.screenAngleLow = reader.readNewField((String)"ScreenAngleLow", (int)2, (boolean)false, (Node)configurationElement).value;
            this.screenAngleHigh = reader.readNewField((String)"ScreenAngleHigh", (int)2, (boolean)false, (Node)configurationElement).value;
        }
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element rootElement = writer.writeNewField((String)"HumanPresenceCalibratedConfiguration", (Node)parent).xmlElement;
        writer.writeNewField("DetectRangeMax", 2, this.detetctRangeMax, (Node)rootElement);
        writer.writeNewField("DetectRangeMin", 2, this.detetctRangeMin, (Node)rootElement);
        if (this._formatID >= 1) {
            writer.writeNewField("DetectionType", 1, this.detectionType, (Node)rootElement);
        }
        if (this._formatID >= 2) {
            writer.writeNewField("HingeAngleLow", 2, this.hingeAngleLow, (Node)rootElement);
            writer.writeNewField("HingeAngleHigh", 2, this.hingeAngleHigh, (Node)rootElement);
            writer.writeNewField("PlmModeID", 4, this.plmModeId, (Node)rootElement);
        }
        if (this._formatID >= 3) {
            writer.writeNewField("Attention", 1, this.attention ? 1 : 0, (Node)rootElement);
        }
        if (this._formatID >= 4) {
            writer.writeNewField("ScreenAngleLow", 2, this.screenAngleLow, (Node)rootElement);
            writer.writeNewField("ScreenAngleHigh", 2, this.screenAngleHigh, (Node)rootElement);
        }
        writer.removeSizeCounter(payloadDataLength);
    }

    public int getDetetctRangeMax() {
        return this.detetctRangeMax;
    }

    public void setDetetctRangeMax(int detetctRangeMax) {
        this.detetctRangeMax = detetctRangeMax;
    }

    public int getDetetctRangeMin() {
        return this.detetctRangeMin;
    }

    public void setDetetctRangeMin(int detetctRangeMin) {
        this.detetctRangeMin = detetctRangeMin;
    }

    public int getFormatID() {
        return this._formatID;
    }

    public void setFormatID(int _formatID) {
        this._formatID = _formatID;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int _version) {
        this._version = _version;
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    @Override
    public ConfigurationPayload clone() {
        return new HumanPresenceStandardConfigurationPayload(this);
    }

    @Override
    public String getConfigurationFormatString() {
        return CONFIGURATION_FORMAT_STRING;
    }

    @Override
    public String getConfigurationDataString() {
        return "";
    }

    @Override
    public boolean controllsBusData() {
        return false;
    }

    @Override
    public boolean controllsGpioData() {
        return false;
    }

    public int getDetectionType() {
        return this.detectionType;
    }

    public void setDetectionType(int detectionType) {
        this.detectionType = detectionType;
    }

    public int getHingeAngleLow() {
        return this.hingeAngleLow;
    }

    public void setHingeAngleLow(int hingeAngleLow) {
        this.hingeAngleLow = hingeAngleLow;
    }

    public int getHingeAngleHigh() {
        return this.hingeAngleHigh;
    }

    public void setHingeAngleHigh(int hingeAngleHigh) {
        this.hingeAngleHigh = hingeAngleHigh;
    }

    public int getPlmModeId() {
        return this.plmModeId;
    }

    public void setPlmModeId(int plmModeId) {
        this.plmModeId = plmModeId;
    }

    public boolean isAttention() {
        return this.attention;
    }

    public void setAttention(boolean attention) {
        this.attention = attention;
    }

    public int getScreenAngleLow() {
        return this.screenAngleLow;
    }

    public void setScreenAngleLow(int screenAngleLow) {
        this.screenAngleLow = screenAngleLow;
    }

    public int getScreenAngleHigh() {
        return this.screenAngleHigh;
    }

    public void setScreenAngleHigh(int screenAngleHigh) {
        this.screenAngleHigh = screenAngleHigh;
    }
}

