/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import org.eclipse.swt.events.SegmentEvent;
import org.eclipse.swt.events.SegmentListener;

class BaseTextDirectionSegmentListener
implements SegmentListener {
    private String textDirection;

    public BaseTextDirectionSegmentListener(String textDir) {
        this.textDirection = textDir;
    }

    public void getSegments(SegmentEvent event) {
        int length = event.lineText.length();
        if (length > 0) {
            event.segments = new int[2];
            event.segments[0] = 0;
            event.segments[1] = length;
            (event.segmentsChars = new char[2])[0] = this.isRTLValue(event.lineText) ? 8235 : 8234;
            event.segmentsChars[1] = 8236;
        }
    }

    private boolean isRTLValue(String stringValue) {
        if (stringValue == null || stringValue.length() == 0 || "ltr".equals(this.textDirection)) {
            return false;
        }
        if ("rtl".equals(this.textDirection)) {
            return true;
        }
        int i = 0;
        while (i < stringValue.length()) {
            if (Character.getDirectionality(stringValue.charAt(i)) == 1 || Character.getDirectionality(stringValue.charAt(i)) == 2 || Character.getDirectionality(stringValue.charAt(i)) == 6) {
                return true;
            }
            if (Character.getDirectionality(stringValue.charAt(i)) == 0) {
                return false;
            }
            ++i;
        }
        return false;
    }
}

