/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import java.util.ArrayList;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.BiMap;
import pdtEditor.Device;
import pdtEditor.IMainWindow;
import pdtEditor.InformationStore;
import pdtEditor.Luid;
import pdtEditor.gui.GuiUtils;
import pdtEditor.payloads.GpioPayload;

public class DeviceProperties {
    private static final int EDITABLE_COL = 1;
    private static final String PRODUCT_ID_ATTRIBUTE_NAME = "Product ID (Hex Value, Without 0x)";
    private static final String VENDOR_ID_ATTRIBUTE_NAME = "Vendor ID (Hex Value, Without 0x)";
    protected Shell shlProperties;
    private IMainWindow _parent = null;
    private Device _device = null;
    private boolean _modified = false;
    private Display display;
    private Table table;
    private TableEditor editor;
    private Button btnCancel;
    private Button btnOk;
    private boolean _ignoreFocusLostCallback = false;
    private Button btnHost;
    private Button btnCsme;
    private Button btnInternalAlgorithms;
    private Combo deviceType;
    private Button deviceTypeHelpButton;
    private Button btnDetachable;
    private Group grpInterrupt;
    private Group grpControl;
    private Label lblInterruptId;
    private Text txtInterruptId;
    private Label lblInterruptMode;
    private Combo cmbInterruptMode;
    private Label lblControlId;
    private Text txtControlId;
    private Label lblControlValue;
    private Text txtControlValue;
    private static BiMap<Integer, String> _gpioModes = new BiMap();

    public DeviceProperties(IMainWindow parent, Device device) {
        this._parent = parent;
        this._device = device;
    }

    public void setModified() {
        this._modified = true;
    }

    public void addLine(String key, String value) {
        TableItem item = new TableItem(this.table, 0);
        item.setText(new String[]{key, value});
    }

    public void fillData() {
        if (this._device == null) {
            return;
        }
        this.addLine(PRODUCT_ID_ATTRIBUTE_NAME, Integer.toHexString(this._device.getProductId()));
        this.addLine(VENDOR_ID_ATTRIBUTE_NAME, Integer.toHexString(this._device.getVendorId()));
        this.btnHost.setSelection(this._device.getExposeDeviceTohost());
        this.btnCsme.setSelection(this._device.getExposeDeviceToCsme());
        this.btnInternalAlgorithms.setSelection(this._device.getExposeDeviceToInternalAlgos());
        this.btnDetachable.setSelection(this._device.getDetachable());
        this.lblInterruptId.setEnabled(this.btnDetachable.getSelection());
        this.txtInterruptId.setEnabled(this.btnDetachable.getSelection());
        this.lblInterruptMode.setEnabled(this.btnDetachable.getSelection());
        this.cmbInterruptMode.setEnabled(this.btnDetachable.getSelection());
        this.lblControlId.setEnabled(this.btnDetachable.getSelection());
        this.txtControlId.setEnabled(this.btnDetachable.getSelection());
        this.lblControlValue.setEnabled(this.btnDetachable.getSelection());
        this.txtControlValue.setEnabled(this.btnDetachable.getSelection());
        if (this._device.getDetachable()) {
            this.cmbInterruptMode.setText(DeviceProperties.getModeNameById(this._device.getInterruptMode()));
            this.txtInterruptId.setText(String.valueOf(this._device.getInterruptPinNumber()));
            this.txtControlId.setText(String.valueOf(this._device.getControlId()));
            this.txtControlValue.setText(String.valueOf(this._device.getControlValue()));
        }
        boolean deviceTypeMatch = false;
        for (Device.DeviceDefaults value : Device.DeviceDefaults.values()) {
            if (this._device.getVendorId() != value.vendorID || this._device.getProductId() != value.productID) continue;
            this.deviceType.setText(value.friendlyName);
            deviceTypeMatch = true;
            break;
        }
        if (!deviceTypeMatch) {
            this.deviceType.setText(Device.DeviceDefaults.EXTERNAL_VENDR_DRIVER.friendlyName);
        }
        this.updateProperties();
        this._modified = false;
    }

    public void saveData() {
        if (this._device == null) {
            return;
        }
        if (!this.checkTableValues(null)) {
            return;
        }
        if (this.btnDetachable.getSelection()) {
            int mode;
            if (!this.validateId(this.txtInterruptId)) {
                return;
            }
            if (!this.validateId(this.txtControlId)) {
                return;
            }
            if (!this.validateValue(this.txtControlValue)) {
                return;
            }
            this._device.setInterruptPurpose(6);
            if (this.cmbInterruptMode.getSelectionIndex() < 0) {
                mode = this.validateMode();
                if (mode == -1) {
                    return;
                }
            } else {
                mode = DeviceProperties.getIdByModeName(this.cmbInterruptMode.getText().trim());
            }
            if (mode != -1) {
                this._device.setInterruptMode(mode);
            }
            int pingNumber = Integer.valueOf(this.txtInterruptId.getText());
            int controlId = Integer.valueOf(this.txtControlId.getText());
            int controlValue = Integer.valueOf(this.txtControlValue.getText());
            this._device.setInterruptPinNumber(pingNumber);
            this._device.setControlId(controlId);
            this._device.setControlValue(controlValue);
        }
        TableItem tblItmProductIdAttr = this.getItemByAtrributeName(PRODUCT_ID_ATTRIBUTE_NAME);
        TableItem tblItmVendorIdAttr = this.getItemByAtrributeName(VENDOR_ID_ATTRIBUTE_NAME);
        if (tblItmProductIdAttr != null) {
            this._device.setProductId(Integer.parseInt(tblItmProductIdAttr.getText(1), 16));
        }
        if (tblItmVendorIdAttr != null) {
            this._device.setVendorId(Integer.parseInt(tblItmVendorIdAttr.getText(1), 16));
        }
        this._device.setExposeDeviceToHost(this.btnHost.getSelection());
        this._device.setExposeDeviceToCsme(this.btnCsme.getSelection());
        this._device.setExposeDeviceToInternalAlgos(this.btnInternalAlgorithms.getSelection());
        this._device.setDetachable(this.btnDetachable.getSelection());
        this._modified = false;
        if (this._parent != null) {
            this._parent.setModified();
        }
        this.shlProperties.close();
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlProperties.open();
        this.shlProperties.layout();
        while (!this.shlProperties.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    private TableItem getItemByAtrributeName(String name) {
        for (TableItem item : this.table.getItems()) {
            if (!item.getText(0).equals(name)) continue;
            return item;
        }
        return null;
    }

    public void reportInvalidValue(String message, String attributeName, boolean changeValue, int alternativeValue) {
        TableItem tblItmAttr;
        MessageBox messageBox = new MessageBox(this.shlProperties, 33);
        messageBox.setText("Invalid value");
        messageBox.setMessage(message);
        this._ignoreFocusLostCallback = true;
        if (this.editor != null && this.editor.getEditor() != null && !this.editor.getEditor().isDisposed()) {
            this.editor.getEditor().dispose();
        }
        messageBox.open();
        this._ignoreFocusLostCallback = false;
        if (changeValue && (tblItmAttr = this.getItemByAtrributeName(attributeName)) != null) {
            tblItmAttr.setText(1, Integer.toHexString(alternativeValue));
        }
    }

    public boolean checkTableValues(String atributeToCheck) {
        if (atributeToCheck == null || atributeToCheck.equals(PRODUCT_ID_ATTRIBUTE_NAME)) {
            try {
                TableItem tblItmProductIdAttr = this.getItemByAtrributeName(PRODUCT_ID_ATTRIBUTE_NAME);
                if (tblItmProductIdAttr == null) {
                    return false;
                }
                int productID = Integer.parseInt(tblItmProductIdAttr.getText(1), 16);
                if (productID < 1 || productID > Short.MAX_VALUE) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                this.reportInvalidValue("Product ID must be a non negative integer in the range [1, " + Integer.toHexString(Short.MAX_VALUE) + "]", PRODUCT_ID_ATTRIBUTE_NAME, atributeToCheck != null, Device.DeviceDefaults.EXTERNAL_VENDR_DRIVER.productID);
                return false;
            }
        }
        if (atributeToCheck == null || atributeToCheck.equals(VENDOR_ID_ATTRIBUTE_NAME)) {
            try {
                TableItem tblItmVendorIdAttr = this.getItemByAtrributeName(VENDOR_ID_ATTRIBUTE_NAME);
                if (tblItmVendorIdAttr == null) {
                    return false;
                }
                int vendorID = Integer.parseInt(tblItmVendorIdAttr.getText(1), 16);
                if (vendorID < 1 || vendorID > Device.MAXIMAL_VENDOR_ID) {
                    throw new NumberFormatException();
                }
                if (Device.DeviceDefaults.getDeviceDefaults(this.deviceType.getText()) == Device.DeviceDefaults.EXTERNAL_VENDR_DRIVER) {
                    for (int reservedVendorId : Device.INTEL_RESERVED_VENDOR_IDS) {
                        if (vendorID != reservedVendorId) continue;
                        this.reportInvalidValue("The vendor ID you entered is reserved for use by Intel. Please choose another.", VENDOR_ID_ATTRIBUTE_NAME, atributeToCheck != null, Device.DeviceDefaults.EXTERNAL_VENDR_DRIVER.vendorID);
                        return false;
                    }
                }
            }
            catch (NumberFormatException e) {
                this.reportInvalidValue("Vendor ID must be a non negative hexadecimal number in the range [1, " + Integer.toHexString(Device.MAXIMAL_VENDOR_ID) + "]", VENDOR_ID_ATTRIBUTE_NAME, atributeToCheck != null, Device.DeviceDefaults.EXTERNAL_VENDR_DRIVER.vendorID);
                return false;
            }
        }
        return true;
    }

    public void keyPressedHandler(KeyEvent arg0) {
        int selection = this.table.getSelectionIndex();
        String atributeName = this.editor.getItem().getText(0);
        if (arg0.keyCode == 13 || arg0.keyCode == 0x1000050 || arg0.keyCode == 32) {
            if (selection < 0) {
                this.table.deselectAll();
                this.table.select(0);
            }
            if (!this.checkTableValues(atributeName)) {
                return;
            }
            this.editRow(this.table.getItem(this.table.getSelectionIndex()));
        } else if (arg0.keyCode == 0x1000001 && selection > 0) {
            if (!this.checkTableValues(atributeName)) {
                return;
            }
            if (this.editor.getEditor() != null) {
                this.editor.getEditor().dispose();
            }
            this.table.deselectAll();
            this.table.setSelection(selection - 1);
        } else if (arg0.keyCode == 0x1000002 && selection < this.table.getItemCount() - 1) {
            if (!this.checkTableValues(atributeName)) {
                return;
            }
            if (this.editor.getEditor() != null) {
                this.editor.getEditor().dispose();
            }
            this.table.deselectAll();
            this.table.setSelection(selection + 1);
        }
    }

    public void updateProperties() {
        boolean setEnabled;
        Device.DeviceDefaults deviceDefaults = Device.DeviceDefaults.getDeviceDefaults(this.deviceType.getText());
        if (deviceDefaults == null) {
            return;
        }
        boolean wasEnabled = this.table.getEnabled();
        boolean bl = setEnabled = !deviceDefaults.forceDefaults;
        if (this.editor != null && this.editor.getEditor() != null) {
            this.table.deselectAll();
            this.editor.getEditor().dispose();
            this.editor.setEditor(null);
        }
        this.table.setEnabled(setEnabled);
        if (!wasEnabled && this.table.getEnabled() || deviceDefaults.forceDefaults) {
            TableItem tblItmProductIdAttr = this.getItemByAtrributeName(PRODUCT_ID_ATTRIBUTE_NAME);
            TableItem tblItmVendorIdAttr = this.getItemByAtrributeName(VENDOR_ID_ATTRIBUTE_NAME);
            if (tblItmProductIdAttr != null) {
                tblItmProductIdAttr.setText(1, Integer.toHexString(deviceDefaults.productID));
            }
            if (tblItmVendorIdAttr != null) {
                tblItmVendorIdAttr.setText(1, Integer.toHexString(deviceDefaults.vendorID));
            }
        }
    }

    public void editRow(TableItem item) {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        if (item == null) {
            return;
        }
        Text newEditor = new Text((Composite)this.table, 0);
        newEditor.setFont(this.table.getFont());
        newEditor.setText(item.getText(1));
        newEditor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent arg0) {
                DeviceProperties.this.keyPressedHandler(arg0);
            }
        });
        newEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                Text text = (Text)DeviceProperties.this.editor.getEditor();
                DeviceProperties.this.editor.getItem().setText(1, text.getText());
                DeviceProperties.this.setModified();
            }
        });
        newEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                if (DeviceProperties.this._ignoreFocusLostCallback) {
                    return;
                }
                String atributeName = DeviceProperties.this.editor.getItem().getText(0);
                if (!DeviceProperties.this.checkTableValues(atributeName)) {
                    return;
                }
                if (((Text)DeviceProperties.this.editor.getEditor()).getText().length() == 0) {
                    ((Text)DeviceProperties.this.editor.getEditor()).setText("0");
                }
            }
        });
        newEditor.selectAll();
        newEditor.setFocus();
        this.editor.setEditor((Control)newEditor, item, 1);
    }

    protected void createContents() {
        this.shlProperties = new Shell(65760);
        this.shlProperties.setImage(SWTResourceManager.getImage(DeviceProperties.class, "/resources/Intel.ico"));
        this.shlProperties.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent arg0) {
                if (DeviceProperties.this._modified) {
                    MessageBox messageBox = new MessageBox(DeviceProperties.this.shlProperties, 296);
                    messageBox.setText("Closing without saving");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to close the window without saving?");
                    if (messageBox.open() != 32) {
                        arg0.doit = false;
                        return;
                    }
                }
            }
        });
        this.shlProperties.setText(this._device.getDeviceName() + " Properties");
        GuiUtils.setGridLayoutToComposite((Composite)this.shlProperties, 1);
        Group grpBasicProperties = GuiUtils.addGroupToComposite("Basic Properties", (Composite)this.shlProperties, 0, 4, 4, true, true, 1, 1, 3);
        Label lblTheDeviceWill = GuiUtils.addLabelToComposite("Expose this device's sensors to:", (Composite)grpBasicProperties, 0, 16384, 0x1000000, false, false, 1, 1);
        this.deviceType = GuiUtils.addComboToComposite((Composite)grpBasicProperties, 8, 4, 0x1000000, true, false, 1, 1);
        this.deviceTypeHelpButton = GuiUtils.addButtonToComposite("?", "", (Composite)grpBasicProperties, 0, 131072, 0x1000000, false, false, 1, 1);
        this.table = new Table((Composite)grpBasicProperties, 100352);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Group grpExposeDeviceTo = GuiUtils.addGroupToComposite("Expose Device To", (Composite)this.shlProperties, 0, 4, 4, true, true, 1, 1, 1);
        this.btnHost = GuiUtils.addButtonToComposite("Host", "", (Composite)grpExposeDeviceTo, 32, 16384, 0x1000000, false, false, 1, 1);
        this.btnCsme = GuiUtils.addButtonToComposite("CSME", "", (Composite)grpExposeDeviceTo, 32, 16384, 0x1000000, false, false, 1, 1);
        this.btnInternalAlgorithms = GuiUtils.addButtonToComposite("Internal Algorithms", "", (Composite)grpExposeDeviceTo, 32, 16384, 0x1000000, false, false, 1, 1);
        Group grpDetachable = GuiUtils.addGroupToComposite("Dockable Setup", (Composite)this.shlProperties, 0, 4, 4, true, true, 1, 1, 4);
        this.btnDetachable = GuiUtils.addButtonToComposite("Dockable", "", (Composite)grpDetachable, 32, 16384, 0x1000000, false, false, 4, 1);
        this.grpInterrupt = GuiUtils.addGroupToComposite("Interrupt GPIO", (Composite)grpDetachable, 0, 4, 4, true, true, 1, 1, 2);
        this.grpControl = GuiUtils.addGroupToComposite("Control GPIO", (Composite)grpDetachable, 0, 4, 4, true, true, 1, 1, 2);
        this.lblInterruptId = GuiUtils.addLabelToComposite("GPIO ID:", (Composite)this.grpInterrupt, 0, 16384, 0x1000000, false, false, 1, 1);
        this.txtInterruptId = GuiUtils.addTextToComposite((Composite)this.grpInterrupt, 2048, 4, 16384, true, false, 1, 1);
        this.lblInterruptMode = GuiUtils.addLabelToComposite("GPIO Mode:", (Composite)this.grpInterrupt, 0, 16384, 0x1000000, false, false, 1, 1);
        this.cmbInterruptMode = GuiUtils.addComboToComposite((Composite)this.grpInterrupt, 8, 4, 16384, true, false, 1, 1);
        this.lblControlId = GuiUtils.addLabelToComposite("GPIO ID:", (Composite)this.grpControl, 0, 16384, 0x1000000, false, false, 1, 1);
        this.txtControlId = GuiUtils.addTextToComposite((Composite)this.grpControl, 2048, 4, 16384, true, false, 1, 1);
        this.lblControlValue = GuiUtils.addLabelToComposite("GPIO Value:", (Composite)this.grpControl, 0, 16384, 0x1000000, false, false, 1, 1);
        this.txtControlValue = GuiUtils.addTextToComposite((Composite)this.grpControl, 2048, 4, 16384, true, false, 1, 1);
        Composite compositeShellButton = GuiUtils.addCompositeToComposite((Composite)this.shlProperties, 0, 131072, 0x1000000, false, false, 1, 1, 2);
        this.btnOk = GuiUtils.addButtonToComposite("OK", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        this.btnCancel = GuiUtils.addButtonToComposite("Cancel", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        this.txtInterruptId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DeviceProperties.this.validateId((Text)arg0.getSource());
            }
        });
        this.txtControlId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DeviceProperties.this.validateId((Text)arg0.getSource());
            }
        });
        this.txtControlValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DeviceProperties.this.validateValue((Text)arg0.getSource());
            }
        });
        this.btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DeviceProperties.this.saveData();
            }
        });
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DeviceProperties.this.shlProperties.close();
            }
        });
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent arg0) {
                DeviceProperties.this.keyPressedHandler(arg0);
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceProperties.this.editRow((TableItem)e.item);
            }
        });
        this.btnDetachable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DeviceProperties.this.lblInterruptId.setEnabled(DeviceProperties.this.btnDetachable.getSelection());
                DeviceProperties.this.txtInterruptId.setEnabled(DeviceProperties.this.btnDetachable.getSelection());
                DeviceProperties.this.lblInterruptMode.setEnabled(DeviceProperties.this.btnDetachable.getSelection());
                DeviceProperties.this.cmbInterruptMode.setEnabled(DeviceProperties.this.btnDetachable.getSelection());
                DeviceProperties.this.lblControlId.setEnabled(DeviceProperties.this.btnDetachable.getSelection());
                DeviceProperties.this.txtControlId.setEnabled(DeviceProperties.this.btnDetachable.getSelection());
                DeviceProperties.this.lblControlValue.setEnabled(DeviceProperties.this.btnDetachable.getSelection());
                DeviceProperties.this.txtControlValue.setEnabled(DeviceProperties.this.btnDetachable.getSelection());
            }
        });
        this.table.setLinesVisible(true);
        TableColumn tblclmnNewColumn = new TableColumn(this.table, 0);
        tblclmnNewColumn.setText("New Column");
        TableColumn tblclmnNewColumn_1 = new TableColumn(this.table, 0);
        tblclmnNewColumn_1.setText("New Column");
        this.editor = new TableEditor(this.table);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 50;
        this.editor.layout();
        StringBuilder rs1SupportedSensorsTypesStr = new StringBuilder();
        try {
            ArrayList<Integer> rs1SupportedSensorsTypes = Luid.getRS1SupportedSensorTypesList();
            if (rs1SupportedSensorsTypes != null) {
                for (Integer n : rs1SupportedSensorsTypes) {
                    String name = InformationStore.getInstance().getSensorTypeName(n, false);
                    if (name == null) {
                        name = InformationStore.getInstance().getSensorTypeName(n, true);
                    }
                    rs1SupportedSensorsTypesStr.append('\n' + (name != null ? name : String.valueOf(n)));
                }
                rs1SupportedSensorsTypesStr = new StringBuilder(rs1SupportedSensorsTypesStr.substring(1));
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (rs1SupportedSensorsTypesStr.length() == 0) {
            rs1SupportedSensorsTypesStr.append("<Failed to get the list of sensors>");
        }
        final String deviceTypeDescription = "(This drop-down menu is only relevant when your sensor data is being sent to a Windows OS.)\n\nIn versions of Windows prior to Windows 10 RS1, the Microsoft inbox driver responds to the presence of an unrecognized sensor type by disabling all sensors in the same device. Therefore, it is strongly recommended that you place the following sensors in a separate device, and expose that device to Windows 10 RS1 operating systems only:\n\n" + rs1SupportedSensorsTypesStr.toString() + "\n\nThese sensors, and any others that you place in an RS1-only device, will be hidden from systems running Windows 7, Windows 8.1, or pre-RS1 versions of Windows 10.\n\nAlternatively, if you have a UMDF driver of your own you'd like to use, select \"a custom UMDF driver\", and enter the Product ID and Device ID that your custom driver uses to recognize this device.";
        this.deviceTypeHelpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(DeviceProperties.this.shlProperties, 34);
                messageBox.setText("Description");
                messageBox.setMessage(deviceTypeDescription);
                messageBox.open();
            }
        });
        try {
            ArrayList<String> modeNames = DeviceProperties.getAllDeviceGpioModeNames();
            for (String mode : modeNames) {
                this.cmbInterruptMode.add(mode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.deviceType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceProperties.this.updateProperties();
            }
        });
        this.deviceType.removeAll();
        for (Device.DeviceDefaults deviceDefaults : Device.DeviceDefaults.values()) {
            this.deviceType.add(deviceDefaults.friendlyName);
        }
        this.deviceTypeHelpButton.setVisible(true);
        lblTheDeviceWill.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        this.table.setFont(SWTResourceManager.getFont("Segoe UI", 11, 0));
        int shortButtonMinWidth = GuiUtils.getButtonWidth((Control)this.btnOk);
        int n = GuiUtils.getPixelSizeHeight((Control)this.shlProperties) * 12;
        int tableItemWidth = GuiUtils.getButtonWidth((Control)this.btnOk) * 3;
        int tableItem1Width = GuiUtils.getButtonWidth((Control)this.btnOk);
        ((GridData)this.btnOk.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)this.btnCancel.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)this.table.getLayoutData()).minimumHeight = n;
        ((GridData)this.table.getLayoutData()).heightHint = n;
        Point buttonSize = this.deviceTypeHelpButton.computeSize(-1, -1);
        ((GridData)this.deviceTypeHelpButton.getLayoutData()).widthHint = buttonSize.y;
        tblclmnNewColumn.setWidth(tableItemWidth);
        tblclmnNewColumn_1.setWidth(tableItem1Width);
        this.shlProperties.setSize(this.shlProperties.computeSize(-1, -1));
        this.shlProperties.setLocation(GuiUtils.getMiddleLocation(this.shlProperties, this.display));
    }

    public int validateMode() {
        try {
            int res = Integer.valueOf(this.cmbInterruptMode.getText());
            if (res < 0 || res > GpioPayload.GPIO_MODE_FIELD_MAX_VALUE) {
                throw new NumberFormatException();
            }
            return res;
        }
        catch (NumberFormatException e2) {
            MessageBox messageBox = new MessageBox(this.shlProperties, 513);
            messageBox.setText("Invalid Mode Value");
            messageBox.setMessage("Invalid GPIO mode value. Please choose a value from the list or enter an integer in the range [0," + GpioPayload.GPIO_MODE_FIELD_MAX_VALUE + "].");
            messageBox.open();
            this.cmbInterruptMode.setFocus();
            return -1;
        }
    }

    public boolean validateId(Text targetText) {
        try {
            int res = Integer.valueOf(targetText.getText());
            if (res < 0 || res > 31) {
                throw new NumberFormatException();
            }
            return true;
        }
        catch (NumberFormatException e) {
            MessageBox messageBox = new MessageBox(this.shlProperties, 513);
            messageBox.setText("Input Error");
            messageBox.setMessage("Invalid GPIO ID value. Please enter an integer in the range [0,31].");
            messageBox.open();
            return false;
        }
    }

    public boolean validateValue(Text targetText) {
        try {
            int res = Integer.valueOf(targetText.getText());
            if (res < 0 || res > 1) {
                throw new NumberFormatException();
            }
            return true;
        }
        catch (NumberFormatException e) {
            MessageBox messageBox = new MessageBox(this.shlProperties, 513);
            messageBox.setText("Input Error");
            messageBox.setMessage("Invalid GPIO value. Please enter an integer in the range [0,1].");
            messageBox.open();
            return false;
        }
    }

    public static int getIdByPurposeName(String purposeName) {
        try {
            Integer id = InformationStore.getInstance().getGpioPurposeId(purposeName);
            if (id != null) {
                return id;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    public static String getPurposeNameById(int id) {
        try {
            return InformationStore.getInstance().getGpioPurposeName(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(id);
        }
    }

    public static String getModeNameById(int id) {
        String modeName = _gpioModes.getForward(id);
        if (null == modeName) {
            modeName = String.valueOf(id);
        }
        return modeName;
    }

    public static int getIdByModeName(String modeName) {
        try {
            return _gpioModes.getBackward(modeName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static ArrayList<String> getAllDeviceGpioModeNames() {
        ArrayList<String> modes = new ArrayList<String>();
        modes.add("Falling Edge");
        modes.add("Rising Edge");
        return modes;
    }

    static {
        _gpioModes.put(0, "Falling Edge");
        _gpioModes.put(1, "Rising Edge");
    }
}

