/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.gui.GpioInfo;
import pdtEditor.gui.GuiUtils;

public class GPIO {
    protected Shell shell;
    private Display display;
    GpioInfo _gpioInfo = null;
    private GuiUtils.WindowProperties _properties = new GuiUtils.WindowProperties(){

        @Override
        protected void onModification() {
        }
    };
    private GpioInfo _parentGpio;

    public GPIO(GpioInfo parentGpio) {
        this._parentGpio = parentGpio;
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void fillData() {
        this._gpioInfo.copyGpioInfo(this._parentGpio);
        this._properties.setModified(false);
    }

    public void saveData() {
        this._parentGpio.copyGpioInfo(this._gpioInfo);
        this._properties.setModified(false);
        this._parentGpio.setModified();
        this.shell.close();
    }

    protected void createContents() {
        int longButtonMinWidth;
        this.shell = new Shell(65760);
        this.shell.setImage(SWTResourceManager.getImage(GPIO.class, "/resources/Intel.ico"));
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent arg0) {
                if (GPIO.this._properties.isModified()) {
                    MessageBox messageBox = new MessageBox(GPIO.this.shell, 296);
                    messageBox.setText("Closing without saving");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to close the window without saving?");
                    if (messageBox.open() != 32) {
                        arg0.doit = false;
                        return;
                    }
                }
            }
        });
        this.shell.setText("Manage GPIOs");
        GuiUtils.setGridLayoutToComposite((Composite)this.shell, 1);
        try {
            this._gpioInfo = new GpioInfo(this._properties);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this._gpioInfo.drawGpioInfo(this.shell, (Composite)this.shell);
        Composite compositeShellButton = GuiUtils.addCompositeToComposite((Composite)this.shell, 0, 131072, 0x1000000, false, false, 1, 1, 2);
        Button btnSaveAndClose = GuiUtils.addButtonToComposite("Save and Close", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        Button btnCancel = GuiUtils.addButtonToComposite("Cancel", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        int shortButtonMinWidth = GuiUtils.getButtonWidth((Control)btnCancel);
        ((GridData)btnSaveAndClose.getLayoutData()).minimumWidth = longButtonMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)btnSaveAndClose) * 1.5);
        ((GridData)btnCancel.getLayoutData()).minimumWidth = shortButtonMinWidth;
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GPIO.this.shell.close();
            }
        });
        btnSaveAndClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GPIO.this.saveData();
            }
        });
        this.shell.setSize(this.shell.computeSize(-1, -1));
        this.shell.setLocation(GuiUtils.getMiddleLocation(this.shell, this.display));
    }
}

