/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.DataStore;
import pdtEditor.Sensor;
import pdtEditor.payloads.Payload;
import pdtEditor.validation.Validator;

public class GpioPayload
implements Payload {
    public static final int GPIO_PURPOSE_FIELD_SIZE = 1;
    public static final int GPIO_ID_FIELD_SIZE = 1;
    public static final int GPIO_MODE_FIELD_SIZE = 1;
    public static final int GPIO_PURPOSE_FIELD_MAX_VALUE = (int)Math.pow(2.0, 8.0) - 1;
    public static final int GPIO_ID_FIELD_MAX_VALUE = 31;
    public static final int GPIO_MODE_FIELD_MAX_VALUE = (int)Math.pow(2.0, 8.0) - 1;
    public static final int INFO_ID = 1;
    public static final int NUM_OF_GPIO_FIELD_SIZE = 2;
    ArrayList<Gpio> _gpios = new ArrayList();

    public GpioPayload(BinReader reader, Node payloadXmlNode) {
        int numOfGpios = reader.readNewField((String)"NumGPIO", (int)2, (boolean)false, (Node)payloadXmlNode).value;
        for (int i = 1; i <= numOfGpios; ++i) {
            int modeGPIO;
            int pinNumber;
            int purpose;
            Element gpioElement = reader.readNewField((String)new StringBuilder().append((String)"GPIO").append((int)i).toString(), (Node)payloadXmlNode).xmlElement;
            switch (DataStore.getInstance().getPdtFormatVersion()) {
                case 0: 
                case 1: {
                    purpose = reader.readNewField((String)"Purpose", (int)1, (boolean)false, (Node)gpioElement).value;
                    reader.readNewField("Reserved", 1, false, gpioElement);
                    pinNumber = reader.readNewField((String)"PinNumber", (int)1, (boolean)false, (Node)gpioElement).value;
                    modeGPIO = reader.readNewField((String)"ModeGPIO", (int)1, (boolean)false, (Node)gpioElement).value;
                    break;
                }
                case 2: {
                    purpose = reader.readNewField((String)"Purpose", (int)1, (boolean)false, (Node)gpioElement).value;
                    pinNumber = reader.readNewField((String)"PinNumber", (int)1, (boolean)false, (Node)gpioElement).value;
                    modeGPIO = reader.readNewField((String)"ModeGPIO", (int)1, (boolean)false, (Node)gpioElement).value;
                    reader.readNewField("Reserved", 1, false, gpioElement);
                    break;
                }
                default: {
                    reader.readNewField("Reserved", 1, false, gpioElement);
                    purpose = reader.readNewField((String)"Purpose", (int)1, (boolean)false, (Node)gpioElement).value;
                    pinNumber = reader.readNewField((String)"PinNumber", (int)1, (boolean)false, (Node)gpioElement).value;
                    modeGPIO = reader.readNewField((String)"ModeGPIO", (int)1, (boolean)false, (Node)gpioElement).value;
                }
            }
            Gpio gpio = new Gpio();
            gpio._purpose = purpose;
            gpio._pinNumber = pinNumber;
            gpio._modeGPIO = modeGPIO;
            this._gpios.add(gpio);
        }
    }

    public GpioPayload(int purpose, int pinNumber, int modeGPIO) {
        Gpio newGPIO = new Gpio();
        newGPIO._purpose = purpose;
        newGPIO._pinNumber = pinNumber;
        newGPIO._modeGPIO = modeGPIO;
        this._gpios.add(newGPIO);
    }

    public GpioPayload(ArrayList<Gpio> gpios) {
        this._gpios = gpios;
    }

    public GpioPayload(GpioPayload other) {
        for (Gpio gpio : other._gpios) {
            Gpio newGPIO = new Gpio();
            newGPIO._purpose = gpio._purpose;
            newGPIO._pinNumber = gpio._pinNumber;
            newGPIO._modeGPIO = gpio._modeGPIO;
            this._gpios.add(newGPIO);
        }
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof GpioPayload)) {
            return false;
        }
        GpioPayload other = (GpioPayload)arg0;
        return this._gpios == null && other._gpios == null || this._gpios != null && this._gpios.equals(other._gpios);
    }

    @Override
    public GpioPayload clone() {
        return new GpioPayload(this);
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        writer.writeNewField("InfoId", 1, 1, (Node)parent);
        writer.writeNewField("Reserved", 1, 0, (Node)parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("NumGPIO", 2, this._gpios.size(), (Node)parent);
        int gpioNum = 1;
        for (Gpio gpio : this._gpios) {
            Element gpioElement = writer.writeNewField((String)new StringBuilder().append((String)"GPIO").append((int)gpioNum).toString(), (Node)parent).xmlElement;
            this.appendGpioEntryXML(writer, gpioElement, gpio);
            ++gpioNum;
        }
        writer.removeSizeCounter(payloadDataLength);
    }

    private void appendGpioEntryXML(BinWriter writer, Element gpioElement, Gpio gpio) {
        switch (DataStore.getInstance().getPdtFormatVersion()) {
            case 0: 
            case 1: {
                writer.writeNewField("Purpose", 1, gpio._purpose, (Node)gpioElement);
                writer.writeNewField("Reserved", 1, 0, (Node)gpioElement);
                writer.writeNewField("PinNumber", 1, gpio._pinNumber, (Node)gpioElement);
                writer.writeNewField("ModeGPIO", 1, gpio._modeGPIO, (Node)gpioElement);
                break;
            }
            case 2: {
                writer.writeNewField("Purpose", 1, gpio._purpose, (Node)gpioElement);
                writer.writeNewField("PinNumber", 1, gpio._pinNumber, (Node)gpioElement);
                writer.writeNewField("ModeGPIO", 1, gpio._modeGPIO, (Node)gpioElement);
                writer.writeNewField("Reserved", 1, 0, (Node)gpioElement);
                break;
            }
            default: {
                writer.writeNewField("Reserved", 1, 0, (Node)gpioElement);
                writer.writeNewField("Purpose", 1, gpio._purpose, (Node)gpioElement);
                writer.writeNewField("PinNumber", 1, gpio._pinNumber, (Node)gpioElement);
                writer.writeNewField("ModeGPIO", 1, gpio._modeGPIO, (Node)gpioElement);
            }
        }
    }

    public String getGPIOsString() {
        return String.valueOf(this._gpios.size());
    }

    public ArrayList<Gpio> getGpios() {
        return this._gpios;
    }

    public void clearGPios() {
        this._gpios.clear();
    }

    public void addGpio(int purpose, int pinNumber, int modeNumber) {
        Gpio gpio = new Gpio();
        gpio._purpose = purpose;
        gpio._pinNumber = pinNumber;
        gpio._modeGPIO = modeNumber;
        this._gpios.add(gpio);
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    public int hashCode() {
        return super.hashCode();
    }

    public class Gpio {
        private int _purpose;
        private int _pinNumber;
        private int _modeGPIO;

        public int getPurpose() {
            return this._purpose;
        }

        public int getPinNumber() {
            return this._pinNumber;
        }

        public int getModeGPIO() {
            return this._modeGPIO;
        }

        public boolean equals(Object arg0) {
            if (arg0 == null || !(arg0 instanceof Gpio)) {
                return false;
            }
            Gpio other = (Gpio)arg0;
            return this._purpose == other._purpose && this._pinNumber == other._pinNumber && this._modeGPIO == other._modeGPIO;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

