/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.common.files.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.List;

public class JsonSerializer {
    public static <T> String serialize(T t) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(t);
    }

    public static <T> T deserialize(String json, Class<T> clazz) throws IOException {
        ObjectMapper mapper = new ObjectMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        Object t = mapper.readValue(json, clazz);
        return (T)t;
    }

    public static <T> List<T> deserializeAsList(String json, Class<T> clazz) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        CollectionType customClassCollection = mapper.getTypeFactory().constructCollectionType(List.class, clazz);
        List t = (List)mapper.readValue(json, (JavaType)customClassCollection);
        return t;
    }
}

