<?php
class Encl extends SASDevice 
{
	private $ID;
	private $LogicalID;
	private $AdapterID;
	private $Status;
	private $DeviceType;
	private $RevisionLevel;
	private $VendorID;
	private $ProductID;
	private $WarnBit;
	private $VoltageType;
	private $CurSpeedcode;
	private $CurSpeed;
	private $Temperature;
	private $ExpanderCount;
	private $ExpanderIDs = array();
	private $ExpanderList = array();
	private $PMIDs = array();
	private $PMList = array();
	private $ElementList = array();
	
	public function __construct()
	{
		$this->setDevType(DeviceType::DEVICE_TYPE_ENCLOSURE);
	}
		
	public function getLogicalID()
	{
		return $this->LogicalID;
	}
	public function setLogicalID($ID)
	{
		$this->LogicalID = $ID;
	}
	
	public function getDeviceType()
	{
		return $this->DeviceType;
	}
	public function setDeviceType($DeviceType)
	{
		$this->DeviceType = $DeviceType;
	}
	
	public function setAdapterID($AdapterID)
	{
		$this->AdapterID = $AdapterID;
	}
	public function getAdapterID()
	{
		return $this->AdapterID;
	}
	
	public function setProductRevision($ProductRevision)
	{
		$this->RevisionLevel = $ProductRevision;
	}
	public function getProductRevision()
	{
		return $this->RevisionLevel;
	}
	
	public function setVendorId($VendorId)
	{
		$this->VendorID = $VendorId;
	}
	public function getVendorId()
	{
		return $this->VendorID;
	}
	
	public function setProductId($ProductId)
	{
		$this->ProductID = $ProductId;
	}
	public function getProductId()
	{
		return $this->ProductID;
	}
	
	public function setExpanderCount($ExpanderCount)
	{
		$this->ExpanderCount = $ExpanderCount;
	}
	public function getExpanderCount()
	{
		return $this->ExpanderCount;
	}
	
	public function setExpanderIDs($ExpanderIDs)
	{
		$this->ExpanderIDs = $ExpanderIDs;
	}
	public function getExpanderIDs()
	{
		return $this->ExpanderIDs;
	}
	
	public function setPMIDs($PMIDs)
	{
		$this->PMIDs = $PMIDs;
	}
	public function getPMIDs()
	{
		return $this->PMIDs;
	}
	
	public function setStatus($Status)
	{
		$this->Status = $Status;
	}
	public function getStatus()
	{
		return $this->Status;
	}
	
	public function isSAS()
	{
		return false;
	}
	
	public function setWarnBit($WarnBit)
	{
		$this->WarnBit = $WarnBit;
	}
	public function getWarnBit()
	{
		return $this->VolLWT;
	}
	
	public function setVoltageType($VoltageType)
	{
		$this->VoltageType = $VoltageType;
	}
	public function getVoltageType()
	{
		return $this->VoltageType;
	}
	
	public function setCurSpeed($CurSpeed)
	{
		$this->CurSpeed = $CurSpeed;
	}
	public function getCurSpeed()
	{
		return $this->CurSpeed;
	}
	
	public function setCurSpeedcode($CurSpeedcode)
	{
		$this->CurSpeedcode = $CurSpeedcode;
	}
	public function getCurSpeedcode()
	{
		return $this->CurSpeedcode;
	}
	
	public function setTemperature($Temperature)
	{
		$this->Temperature = $Temperature;
	}
	public function getTemperature()
	{
		return $this->Temperature;
	}
	/*
	public function setElementInfoList($Info)
	{
		$ElementFlag = 0;
		if (isset($Info->Type)) {
			$ElementFlag = trim($Info->Type) . trim($Info->ElementID);
			if (isset($this->ElementList[$ElementFlag])) {
				//$ElementDtl = $this->ElementList[$ElementFlag];
			} else {
				$this->ElementList[$ElementFlag] = array();
			}
			
			$this->ElementList[$ElementFlag]['Type'] = trim($Info->Type);//gettext(ENCElementType::GetTypeStr(trim($Info->Type)));
			
			if (isset($Info->ElementID)) {
				$ElementFlag = trim($Info->Type) . trim($Info->ElementID);
				$this->ElementList[$ElementFlag]['ElementID'] = trim($Info->ElementID);
				//$this->ElementList[$ElementFlag] = $ElementDtl;
			}
			
			if (isset($Info->Status)) {
				$this->ElementList[$ElementFlag]['Status'] = trim($Info->Status);//gettext(ENCElementStatus::getENCElementStatus(trim($Info->Type),trim($Info->Status)));
			}
			
			if (isset($Info->WarnBit)) {
				$this->ElementList[$ElementFlag]['WarnBit'] = trim($Info->WarnBit);
			}
			if (isset($Info->VoltageType)) {
				$this->ElementList[$ElementFlag]['VoltageType'] = trim($Info->VoltageType);
			}
			if (isset($Info->CurSpeedcode)) {
				$this->ElementList[$ElementFlag]['CurSpeedcode'] = trim($Info->CurSpeedcode);
			}
			if (isset($Info->CurSpeed)) {
				$this->ElementList[$ElementFlag]['CurSpeed'] = trim($Info->CurSpeed);
			}
			if (isset($Info->Temperature)) {
				$this->ElementList[$ElementFlag]['$Temperature'] = trim($Info->Temperature);
			}
		}
	}
	
	public function setElementCfgList($Info)
	{
		$ElementFlag = 0;
		$ElementDtl = array();
		if (isset($Info->Type)) {
			$ElementFlag = trim($Info->Type) . trim($Info->ElementID);
			if (isset($this->ElementList[$ElementFlag])) {
				//$ElementDtl = $this->ElementList[$ElementFlag];
			} else {
				$this->ElementList[$ElementFlag] = array();
			}
			if (isset($Info->highWarningThreshold)) {
				$this->ElementList[$ElementFlag]['highCriticalThreshold'] = trim($Info->highCriticalThreshold);
			}
			if (isset($Info->highWarningThreshold)) {
				$this->ElementList[$ElementFlag]['highWarningThreshold'] = trim($Info->highWarningThreshold);
			}
			if (isset($Info->lowCriticalThreshold)) {
				$this->ElementList[$ElementFlag]['lowCriticalThreshold'] = trim($Info->lowCriticalThreshold);
			}
			if (isset($Info->lowWarningThreshold)) {
				$this->ElementList[$ElementFlag]['lowWarningThreshold'] = trim($Info->lowWarningThreshold);
			}
			//$this->ElementList[$ElementFlag] = $ElementDtl;
		}
	}*/
	
	public function getElementList()
	{
		return $this->ElementList;
	}
	
	public function setElementList($ElementList)
	{
		$this->ElementList = $ElementList;
	}
	
	public function addElement($ele)
	{
		$this->ElementList[] = $ele;
	}
	
	public function getExpanderList()
	{
		return $this->ExpanderList;
	}
	
	public function setExpanderList($ExpList)
	{
		$this->ExpanderList = $ExpList;
	}
	
	public function addExpander($exp)
	{
		$this->ExpanderList[$exp->getDeviceID()] = $exp;
	}
	
	public function getPMList()
	{
		return $this->PMList;
	}
	
	public function setPMList($PMList)
	{
		$this->PMList = $PMList;
	}
	
	public function addPM($pm)
	{
		$this->PMList[$pm->getDeviceID()] = $pm;
	}
	
	public function setEnclInfo($Info)
	{	
		//if (isset($Info->ExpanderIDs)) {
		//	$this->setExpanderIDs(trim($Info->ExpanderIDs));
		//}
		if (isset($Info->Link)) {
			foreach ($Info->Link as $Link)
			{
				$this->setTopologyLink($Link);
			}
		}
		if (isset($Info->AdapterID)) {
			$this->setAdapterID(trim($Info->AdapterID));
		}
		
 		if (isset($Info->Status)) {
 			$this->setStatus(trim($Info->Status));//(gettext(ENCStatus::GetStatusStr(trim($Info->Status))));
 		}
		
		if (isset($Info->Link->Self->DevID)) {
			$this->setDeviceID(trim($Info->Link->Self->DevID));
		} elseif (isset($Info->ID)) {                //for simulate enclosure
			$this->setDeviceID(trim($Info->ID));
		}
		
		if (isset($Info->LogicalID)) {
			$this->setLogicalID(dechex(trim($Info->LogicalID))); //TODO
		}
		
		if (isset($Info->VendorID)) {
			$this->setVendorId(trim($Info->VendorID));
		}
		
		if (isset($Info->ProductID)) {
			$this->setProductId(trim($Info->ProductID));
		}
		
		if (isset($Info->RevisionLevel)) {
			$this->setProductRevision(trim($Info->RevisionLevel));
		}
		
		if (isset($Info->ExpanderCount)) {
			$this->setExpanderCount(trim($Info->ExpanderCount));
		}
	}
}

?>