<?php
class CtnSSDAdapterList extends Container {
    private $toGetSSDAdapterCount = false;
    private $toGetSSDAdapterInfo = false;

    public function toGetSSDAdapterCount() {
        $this->toGetSSDAdapterCount = true;
    }

    public function toGetSSDAdapterInfo() {
        $this->toGetSSDAdapterInfo = true;
    }
    
    protected function setBase() {
        $this->base = new SSDAdapterList();

        if ($this->toGetSSDAdapterInfo) {
            $this->base->toGetSSDAdapterInfo();
        }
    }

    protected function setDataToPage() {
        $SSDAdapterList = array();
        $baseclasses = $this->base->getBaseClasses();
        foreach ($baseclasses as $ssd) {
            $ssdInfo = new SSDAdapterInfo();
            $ssdInfo->setSSDAdapterInfo($ssd);
            $SSDAdapterList[$ssdInfo->ID] = $ssdInfo;
        }

        ksort($SSDAdapterList);

        $this->setInfo($SSDAdapterList);
        $this->smarty->assign("SSDAdapterList",$SSDAdapterList);
    }

    protected function displayXML() {
        //won't be used
    }
}

?>
