<?php

class AdapterFeature
{
	public $isThor = 0;
	public $isOdin = 0;
	public $isOdin2 = 0;
	public $isLoki = 0;
	public $isVanir = 0;
	
	public $supportRAID = 1;
	public $supportExp = 0;
	public $supportPM = 0;
	public $supportEncl = 1;
	public $supportDG = 0;
	
	public $supportMediaPatrol = 0;
	public $supportDataScrub = 0;
	
	public $supportForegroundInit = 0;
	public $supportBackgroundInit = 0;
	public $supportSyncronization = 0;
	public $supportRebuild = 0;
	public $supportMigrate = 0;
	
	public $supportMuiltBgaRate = 0;
	public $supportCopyback = 0;
	//public $supportFirmware = 0;
	public $supportBIOSVersion = 1;
	public $supportSetDedicatedPD = 0;
	public $supportOptimizeCpuEfficiency = 0;
	public $supportModuleConsolidate = 0;
	public $supportAdvancedNameLength = 1;
	public $supportDownloadBIOS = 0;
	public $supportAdaptiveCache = 0;
	public $supportImportVD = 0;
	public $supportSameTypePDsForCreate = 0;
	public $supportBBU = 0;
	public $supportAlarm = 0;
	public $supportAes = 0;
	public $supportSpare = 0;
	public $supportSchedule = 0;
	public $supportBGA = 0;
	public $canSetCreateSize = 0;
	public $supportVDReadCache = 0;
	public $supportVDWriteCache = 0;
    public $supportHybridSwitch = 0;
	public $supportHDSmart = 0;
	public $supportVDRounding = 0;
	public $supportHDSetFree = 0;
	public $supportSPC4 = 0;
	public $supportHDWriteCache = 0;
	public $supportLDRaidHyperHDD = 0;
	public $isSSDAdapter = 0;
    public $supportBGARateChange = 1;
    public $supportMultiSSDForHyperDuo = 0;
    public $supportIntelligentKeep = 0;
    public $maxVDPerDG = 1;
    public $supportPackageVD=0;
	
	private function __construct(){}
	
	public static function getInstance($id = 0)
	{
		$instance = new AdapterFeature();
		
		$hbaInfo = HBAFactory::getInstance($id);
		
		if (! $hbaInfo) {
			return;
		}

        $instance->maxVDPerDG = $hbaInfo->getMaxVDPerDG();
		$instance->supportBGARateChange = $hbaInfo->supportBGARateChange();
		$instance->isSSDAdapter = $hbaInfo->isSSDAdapter();
		$instance->supportLDRaidHyperHDD = $hbaInfo->supportLDRaidHyperHDD();
		$instance->supportHDWriteCache = $hbaInfo->supportHDWriteCache();
		$instance->supportBGA = $hbaInfo->supportBGA();
		$instance->supportRAID = $hbaInfo->supportRAID();
		$instance->supportExp =  $hbaInfo->getMaxExpander();		
		$instance->supportPM = $hbaInfo->getMaxPM();		
		$instance->supportDG = $hbaInfo->getDiskGroupSupport();
        if (($hbaInfo->getMaxVDPerDG() <= 1) && $instance->supportDG)
            $instance->supportPackageVD = 1;//should be disabled for common version
		$instance->supportSameTypePDsForCreate = $hbaInfo->supportSameTypePDsForCreate();
		$instance->supportBBU = $hbaInfo->supportBBU();
		$instance->supportSPC4 = $hbaInfo->supportSPC4();
                $instance->supportMultiSSDForHyperDuo = $hbaInfo->supportMultiSSDForHyperDuo();
                $instance->supportIntelligentKeep = $hbaInfo->supportIntelligentKeep();
                
		if ($instance->isSSDAdapter) $instance->supportSPC4  = 1; //set ssd adapter can upload as default?
		
		if ($instance->supportDG) {
			$instance->supportSetDedicatedPD=1;
			$instance->supportDataScrub = 1;
		}
		
		if(($hbaInfo->getDevID() != 0)){
			$ID = dechex($hbaInfo->getDevID());
			//Thor  61
			//Odin  6320 6440 OdinII 6480
			//Loki  8480
			//Vanir 94xx
			$prefix = intval(substr($ID, 0, 2));
			$postfix = intval(substr($ID, 2, 2));
			if( $prefix ==  61){
				$instance->isThor = 1;
			} else if ($prefix >= 63 && $prefix <= 64) {
				$instance->isOdin = 1;
				if ($postfix >= 80) {
					$instance->isOdin2 = 1;
				}
			} else if ($prefix >= 81 && $prefix <= 84) {
				$instance->isLoki = 1;
			} else if ($prefix >= 94){
				$instance->isVanir = 1;
			}
			
			if ($prefix < 63) {
                if (!$instance->supportPackageVD)
				    $instance->canSetCreateSize = 1;
			}
			
			if ($instance->isThor) {
				$instance->supportAdvancedNameLength = 0;
				$instance->supportBIOSVersion = 0;
			}
			
			if (!$instance->isThor) {//Odin | Vanir | Loki
				$instance->supportMuiltBgaRate = 1;
			}
			
			if ($instance->isLoki) {
				//$instance->supportFirmware = 1;
				$instance->supportImportVD = 1;
			}
            if ($instance->supportBBU){
                $instance->supportAdaptiveCache = 1;
            }//for bug #906
		}
		
		if ($hbaInfo->supportBiosOption()) {
			$instance->supportDownloadBIOS = 1;
		}

		if ($hbaInfo->supportOptimizeCpuEfficiency()) {
			$instance->supportOptimizeCpuEfficiency = 1;
		}
		
		if ($hbaInfo->supportModuleConsolidate()) {
			$instance->supportModuleConsolidate = 1;
		}

		if ($hbaInfo->supportAlarm()) {
			$instance->supportAlarm = 1;
		}

		if ($hbaInfo->supportCopyback()) {
			$instance->supportCopyback = 1;
		}

		if ($hbaInfo->supportMediaPatrol()) {
			$instance->supportMediaPatrol = 1;
		}
		
		if ($hbaInfo->supportMigration()) {
			$instance->supportMigrate = 1;
		}
        
		if ($hbaInfo->supportForegroundInit()) {
			$instance->supportForegroundInit = 1;
		}
		
		if ($hbaInfo->supportBackgroundInit()) {
			$instance->supportBackgroundInit = 1;
		}
		
		if ($hbaInfo->supportSyncronization()) {
			$instance->supportSyncronization = 1;
		}
		
		if ($hbaInfo->supportRebuild()) {
			$instance->supportRebuild = 1;
		}
		
		if($hbaInfo->supportCrypto())
		{
			$instance->supportAes = 1;
		}
		if($hbaInfo->supportSchedule())
		{
			$instance->supportSchedule = 1;
		}
		
		if($hbaInfo->supportSpare())
		{
			$instance->supportSpare = 1;
		}
		
		if ($hbaInfo->supportVDWriteCache()) {
			$instance->supportVDWriteCache = 1;
		}
		
		if ($hbaInfo->supportVDReadCache()) {
			$instance->supportVDReadCache = 1;
		}

		if ($hbaInfo->supportHybridSwitch()) {
			$instance->supportHybridSwitch = 1;
		}

		if ($hbaInfo->supportHDSmart()) {
			$instance->supportHDSmart = 1;
		}
		
		if ($hbaInfo->supportVDRounding()) {
			$instance->supportVDRounding = 1;
		}
		
		if($hbaInfo->supportHDSetFree()){
			$instance->supportHDSetFree = 1;
		}
		
		return $instance;
	}
	
	public function isSupportExp()
	{
		return $this->supportExp;
	}
	
	public function isSupportPM()
	{
		return $this->supportPM;
	}
	
	public function isSupportEncl()
	{
		return $this->supportEncl;
	}
	
	public function isSupportDG()
	{
		return $this->supportDG;
	}
	
	public function isSupportMediaPatrol()
	{
		return $this->supportMediaPatrol;
	}
	
	public function isSupportMigrate()
	{
		return $this->supportMigrate;
	}
	
	public function isSupportAES()
	{
		return $this->supportAes;
	}
	
	public function isThor()
	{
		return $this->isThor;
	}
}

class HBAFactory
{
	private static $instances = array();
	
	public static function getInstance($id = 0)
	{
		if (! sizeof(self::$instances)) {
			self::initialze();
		}
		
		if (isset(self::$instances[$id])) {
			return self::$instances[$id];
		}
		else 
			return false;
	}
	
	private static function initialze()
	{
		//initialze it
		$HBAList = new HBAList();
		$HBAList->toGetHBAInfo();
		$HBAList->initData();
		
		$HBAs = $HBAList->getBaseClasses();
		
		foreach ($HBAs as $hba)
		{
			self::$instances[$hba->getDeviceID()] = $hba;
		}
	}
	
	public static function getAllInstance()
	{
		if (! sizeof(self::$instances)) {
			self::initialze();
		}
		
		return self::$instances;
	}
}


class SSDAdapterFactory
{
	private static $instances = array();

	public static function getInstance($id = 0)
	{
		if (! sizeof(self::$instances)) {
			self::initialze();
		}

		if (isset(self::$instances[$id])) {
			return self::$instances[$id];
		}
		else
			return false;
	}

	private static function initialze()
	{
		//initialze it
		$SSDAdapterList = new SSDAdapterList();
		$SSDAdapterList->toGetSSDAdapterInfo();
		$SSDAdapterList->initData();

		$SSDAdapters = $SSDAdapterList->getBaseClasses();

		foreach ($SSDAdapters as $adapter)
		{
			self::$instances[$adapter->getDeviceID()] = $adapter;
		}
	}

	public static function getAllInstance()
	{
		if (! sizeof(self::$instances)) {
			self::initialze();
		}

		return self::$instances;
	}
}

?>