<?php
class SystemDetail extends BaseData
{
	
	public function toGetAPIVer()
	{
		$XMLApiCmd = new XMLAPICommand();
		$XMLApiCmd->setCommand(XMLAPICommand::ZA_Module_GetInfo);
		
		$this->XMLAPICommandList['setSysInfo'] = $XMLApiCmd;
	}
	
	public function toGetSysInfo()
	{
		$XMLApiCmd = new XMLAPICommand();
		$XMLApiCmd->setCommand(XMLAPICommand::MV_API_Info);
		
		$this->XMLAPICommandList['setAPIVer'] = $XMLApiCmd;
	}
	
	protected function prepareAPICommands()
	{
		
	}
	
	protected function setAPIVer($data)
	{
		$XMLRoot = $data;
		
		if ($this->BaseClasses) {
			$Sys = $this->BaseClasses[0];
			$Sys->setRAIDAPIVer(trim($XMLRoot->API_Version));
			$Sys->setScheduleSupport(trim($XMLRoot->ScheduleSupport));
		}
		else {
			$Sys = new System();
			$Sys->setRAIDAPIVer(trim($XMLRoot->API_Version));
			$Sys->setScheduleSupport(trim($XMLRoot->ScheduleSupport));
			$this->BaseClasses[] = $Sys;
		}
	}
	
	protected function setSysInfo($data)
	{
		$XMLRoot = $data;
		if ($this->BaseClasses) {
			$Sys = $this->BaseClasses[0];
			$Sys->setSystemInfo($XMLRoot);
			
		}
		else {
			$Sys = new System();
			$Sys->setSystemInfo($XMLRoot);
			$this->BaseClasses[] = $Sys;
		}
	}
	
	protected function setDataToBaseClass()
	{
		
	}

	public function loadTestData()
	{
		$Path = "../phpsrc/baseclass/testdata/sysdtl/";
		$Files = array("ZA_Module_GetInfo","MV_API_Version");

		foreach ($Files as $File)
		{
			foreach ($this->XMLAPICommandList as $APICmd)
			{
				if (strpos($APICmd->getCommand(),$File)) {
					$data = simplexml_load_file($Path . $File . ".xml");
					
					$this->setAPIVer($data);	
					$this->setSysInfo($data);	
				}	
			}
		}
	}
}
?>