<?php
class CtnHyperSSDList extends Container {

    private $toGetHyperSSDInfo = false;

    public function toGetHyperSSDInfo() {
        $this->toGetHyperSSDInfo = true;
    }

    protected function setBase() {
        $this->base = new HyperSSDList();
        $this->base->setAdapterID($this->getAdapterID());

        if ($this->toGetHyperSSDInfo) {
            $this->base->toGetHyperSSDInfo();
        }
    }

    protected function setDataToPage() {
        $HyperSSDList = array();
        $baseclasses = $this->base->getBaseClasses();
        foreach ($baseclasses as $hyper) {
           // if ($hyper->isHyperSSD()) {  //only display hyperssd, not all partitions
                $hyperInfo = new HyperSSDInfo();
                $hyperInfo->setHyperSSDInfo($hyper);
                $HyperSSDList[$hyperInfo->ID] = $hyperInfo;
           // }
        }

        ksort($HyperSSDList);

        $this->setInfo($HyperSSDList);
        $this->smarty->assign("HyperSSDList",$HyperSSDList);
    }

    protected function displayXML() {
        //won't be used
    }
}

?>
