<?php

class CtnAcceleratorSubDisplayer extends CtnAcceleratorStatusDisplayer {
    protected function initPage() {

        $smarty = $this->smarty;

        $selectedVolName = getRequestPara("volName");

        $this->handlerAppStatusByVol($selectedVolName);

        $appList = array();
        foreach ($this->applications as $app) {
            $appInfo = new ApplicationInfo();
            $appInfo->setRunningStatus($this->accStatus->isDefragging());
            $appInfo->setApplicationListInfo($app);
            $appList[] = $appInfo;
        }

        $smarty->assign("appList", $appList);
        $smarty->assign("appCount", sizeof($appList));
        $smarty->assign("noApp", (sizeof($appList)==0)?1:0);

        $hasOperationRunning = 0;
        $noValidVolume = 0;
        $volList = new CtnAccelerateVolumeList();//Hyper HDD Volumes
        $volList->smartyAssign($smarty);
        $volList->initContainer();
        $vols = $volList->getInfos();

        $selectedVolume = "";
        foreach ($vols as $vol) {
            if (strtoupper($vol->DisplayVolumeName) == strtoupper($selectedVolName)) {
                $selectedVolume = $vol;
                break;
            }
        }

        if ($selectedVolume != ""){
                $isRebuildingVolume = $selectedVolume->isRebuilding;
                $this->hasOperationRunning |= $isRebuildingVolume;

                $smarty->assign("isRebuildingVolume", $isRebuildingVolume);
                $smarty->assign("hasOperationRunning", $this->hasOperationRunning);

                //$this->smarty->assign("selectedVolName",$selectedVolName);
                $this->smarty->assign("SelectedVolume",$selectedVolume);


                $disableAcc = $this->hasOperationRunning || $noValidVolume;
                $smarty->assign("disableAcc", $disableAcc); //disable auto/fix/submit
        }

        $this->setPageName("XML_Accelerator_subPage.tpl");
    }

}
?>
