<?php
class HD extends SASDevice
{
	//private $ID;
	private $HD_SSD_Type;
	private $Size;
	private $AdapterID = GET_ALL;
	private $PIOMode;		/* max PIOMode */
	private $MDMAMode;		/* Max MDMA mode */
	private $UDMAMode;		/* Max UDMA mode */
	private $FirmWareVersion;
	private $FeatureSupport;	/* Support 1.5G, 3G, TCQ, NCQ, and etc, MV_BIT related */
	private $Type;
	private $Model;
	private $WWN;
	private $SerialNo;
	
	private $ValidSize;
	private $HasMBR;
	
	//config
	private $WriteCacheOn;
	//private $SMARTOn;
	//private $Online;
        private $crypto;
        private $aesPercentage;
	
	/**/
	private $CurrentPIOMode;	/* Current PIO mode */
	private $CurrentMDMAMode;	/* Current MDMA mode */
	private $CurrentUDMAMode;	/* Current UDMA mode */
	
	//private $FeatureEnable;		/* Match with FeatureSupport */
	
	//spare
	private $HDRaidStatus;
	private $DedicatedDGID;
	
	//free
	private $IsFree = 1 ; 	// 0 : not free ^0 : free
	
	private $TransfersProtocol;
	
	private $Speed;
	
	private $ConnectionType;/* DC_XXX, ConnectionType & DeviceType in new driver to replace Type above */
	private $DeviceType;/* DT_XXX */
	private $CanLogicalUsed;/*check whether this device can be used to create/rebuild/migrate or not*/
	
	//media patrol
	private $MPState = 0;
	private $MPPercentage = 0;
	
	//bga status
	private $Percentage;
	private $Bga;
	private $BgaState;
	private $Status;
	
	private $ActivityLEDStatus;
	private $LocateLEDStatus;
	private $ErrorLEDStatus;
	
 	private $BlockList = array();
    //for oem lenovo
    private $Fru;
    private $Mfa;
    private $Lenovo_8S_l2_PN;
    private $Lenovo_8S_SN;
    private $PD_status;

	public function getAesPercentage()
	{
		return $this->aesPercentage;
	}

	public function isSSD()
	{
		return ($this->HD_SSD_Type != 0);
	}
	
	public function getSSDType() 
	{
		return $this->HD_SSD_Type;
	}
	
 	public function setBlockList($BlockList)
	{
		$this->BlockList = $BlockList;
	}
	public function getBlockList()
	{
		return $this->BlockList;
	}
	
	public function addBlock($blk)
	{
		$this->BlockList[$blk->getID()] = $blk;
		$blk->linkHD($this);
	}
	
	public function hasBlock($id)
	{
		if (isset($this->BlockList[$id])) {
			return true;
		}
		
		return false;
	}
	
	public function setDedicatedDGID($DedicatedDGID)
	{
		$this->DedicatedDGID = $DedicatedDGID;
	}
	public function getDedicatedDGID()
	{
		return $this->DedicatedDGID;
	}
	
	public function setBgaState($BgaState)
	{
		$this->BgaState = $BgaState;
	}
	public function getBgaState()
	{
		return $this->BgaState;
	}
	
	public function setBga($Bga)
	{
		$this->Bga = $Bga;
	}
	public function getBga()
	{
		return $this->Bga;
	}
	
	public function setPercentage($Percentage)
	{
		$this->Percentage = $Percentage;
	}
	public function getPercentage()
	{
		return $this->Percentage;
	}

	public function setMPPercentage($MPPercentage)
	{
		$this->MPPercentage = $MPPercentage;
	}
	public function getMPPercentage()
	{
		return $this->MPPercentage;
	}
	
	public function setMPState($MPState)
	{
		$this->MPState = $MPState;
	}
	public function getMPState()
	{
		return $this->MPState;
	}
	
	public function canLogicalUsed()
	{
		return $this->CanLogicalUsed;
	}
	public function setCanLogicalUsed($CanLogicalUsed)
	{
		$this->CanLogicalUsed = $CanLogicalUsed;
	}
	
	public function getConnectionType()
	{
		return $this->ConnectionType;
	}
	public function setConnectionType($ConnectionType)
	{
		$this->ConnectionType = $ConnectionType;
	}
	
	public function getDeviceType()
	{
		return $this->DeviceType;
	}
	public function setDeviceType($DeviceType)
	{
		$this->DeviceType = $DeviceType;
	}
	
	public function setSpeed($Speed)
	{
		$this->Speed = $Speed;
	}
	
	public function getSpeed()
	{
		return $this->Speed;
	}
	
	public function setLEDStatus($Status)
	{
		$this->LocateLEDStatus = $Status;
	}
	
	public function getLEDStatus()
	{
		return $this->LocateLEDStatus;
	}
	
	public function getTransfersProtocol()
	{
		return $this->TransfersProtocol;
	}
	
	public function __construct()
	{
		$this->setDevType(DeviceType::DEVICE_TYPE_HD);//need modify
	}
	
	public function isFree()
	{
		return $this->IsFree;
	}
	
	public function setFree()
	{
		$this->IsFree = 1;
	}
	
	public function setNotFree()
	{
		$this->IsFree = 0;
	}
	
	public function setRaidStatus($status)
	{
		$this->HDRaidStatus = $status;
	}
	
	
	public function isForeign()
	{
		return ($this->HDRaidStatus & HdStatus::HD_STATUS_FOREIGN);
	}
	
	public function isSpare()
	{
		return ($this->HDRaidStatus & HdStatus::HD_STATUS_SPARE)
			|| ($this->HDRaidStatus & HdStatus::HD_STATUS_DEDICATED_SPARE);
	}
	
	public function isMP()
	{
		return ($this->HDRaidStatus & HdStatus::HD_STATUS_MP);
	}
	
	public function isSmartChecking()
	{
		return ($this->HDRaidStatus & HdStatus::HD_STATUS_SMARTCHECKING );
	}
	
	public function isGlobalSpare()
	{
		return ($this->HDRaidStatus & HdStatus::HD_STATUS_SPARE);
	}
	
	public function isDedicatedSpare()
	{
		return ($this->HDRaidStatus & HdStatus::HD_STATUS_DEDICATED_SPARE);
	}
	
	//config
	public function getCrypto()
	{
		return $this->crypto;
	}

	public function isWriteCacheOn()
	{
		return $this->WriteCacheOn;
	}
	
	public function setWriteCache($cacheon)
	{
		$this->WriteCacheOn = $cacheon;
	}
	
	//hd type
	public function isSATA()
	{
		//return (DCType::DC_ATA & $this->ConnectionType) && (DCType::DC_SERIAL & $this->ConnectionType);
		//return $this->Type & HdType::HD_TYPE_SATA;
		return (DCType::getDCTypeStr($this->ConnectionType) == "SATA");
	}
	
	public function isPATA()
	{
		//return (DCType::DC_ATA & $this->ConnectionType) && (DCType::DC_PARALLEL & $this->ConnectionType);
		//return $this->Type & HdType::HD_TYPE_PATA ;
		return (DCType::getDCTypeStr($this->ConnectionType) == "PATA");
	}
	/*
	public function isATAPI()
	{
		//if ($this->useExtension)
		return (DCType::DC_ATAPI & $this->ConnectionType);
		//return $this->Type & HdType::HD_TYPE_ATAPI ;
	}
	*/
	
	public function isCDDVD()
	{
		return (DTType::DT_CD_DVD == $this->DeviceType);
		//return $this->Type & HdType::HD_TYPE_TAPE ;
	}
	
	public function isTAPE()
	{
		return (DTType::DT_SEQ_ACCESS == $this->DeviceType);
		//return $this->Type & HdType::HD_TYPE_TAPE ;
	}
	
	public function isEnclosure()
	{
		return (DTType::DT_ENCLOSURE == $this->DeviceType);
		//return $this->Type & HdType::HD_TYPE_TAPE ;
	}
	
	public function isSAS()
	{
		//return (DCType::DC_SCSI & $this->ConnectionType) && (DCType::DC_SERIAL & $this->ConnectionType);
		//return $this->Type & HdType::HD_TYPE_SAS ;
		return (DCType::getDCTypeStr($this->ConnectionType) == "SAS");
	}
	
	public function supportNCQ()
	{
		return $this->FeatureSupport & HdFeature::HD_FEATURE_NCQ;
	}
	public function supportTCQ()
	{
		return $this->FeatureSupport & HdFeature::HD_FEATURE_TCQ;
	}
	public function support1_5G()
	{
		return $this->FeatureSupport & HdFeature::HD_FEATURE_1_5G;
	}
	public function support3G()
	{
		return $this->FeatureSupport & HdFeature::HD_FEATURE_3G;
	}
	public function support6G()
	{
		return $this->FeatureSupport & HdFeature::HD_FEATURE_6G;
	}
	public function support12G()
	{
		return $this->FeatureSupport & HdFeature::HD_FEATURE_12G;
	}
	public function supportWRITE_CACHE()
	{
		return $this->FeatureSupport & HdFeature::HD_FEATURE_WRITE_CACHE ;
	}
	
	public function support48BITS()
	{
		return $this->FeatureSupport & HdFeature::HD_FEATURE_48BITS ;
	}
	
	public function supportSMART()
	{
		return $this->FeatureSupport & HdFeature::HD_FEATURE_SMART ;
	}
	
	/*
	public function isNCQEnable()
	{
		return $this->FeatureEnable & HdFeature::HD_FEATURE_NCQ;
	}
	
	public function isTCQEnable()
	{
		return $this->FeatureEnable & HdFeature::HD_FEATURE_TCQ;
	}
	*/
	
	public function is1_5GEnable()
	{
		return ($this->Speed == HdSpeed::HD_SPEED_1_5G);
	}
	
	public function is3GEnable()
	{
		return ($this->Speed == HdSpeed::HD_SPEED_3G);
	}
	
	public function is6GEnable()
	{
		return ($this->Speed == HdSpeed::HD_SPEED_6G);
	}
	
	public function is12GEnable()
	{
		return ($this->Speed == HdSpeed::HD_SPEED_12G);
	}
	
	/*
	public function isWRITE_CACHEEnable()
	{
		return $this->FeatureEnable & HdFeature::HD_FEATURE_WRITE_CACHE ;
	}
	
	public function is48BITSEnable()
	{
		return $this->FeatureEnable & HdFeature::HD_FEATURE_48BITS ;
	}
	
	public function isSMARTEnable()
	{
		return $this->FeatureEnable & HdFeature::HD_FEATURE_SMART ;
	}
	*/
	
	public function getFeatureSupport()
	{
		return $this->FeatureSupport;
	}
	public function setFeatureSupport($FeatureSupport)
	{
		$this->FeatureSupport = $FeatureSupport;
	}
	
	/*
	public function getFeatureEnable()
	{
		return $this->FeatureEnable;
	}
	public function setFeatureEnable($FeatureEnable)
	{
		$this->FeatureEnable = $FeatureEnable;
	}
	*/
	
	public function getModel()
	{
		return $this->Model;
	}
	public function setModel($Model)
	{
		$this->Model = $Model;
	}

	public function getWWN()
	{
		return $this->WWN;
	}
	public function setWWN($WWN)
	{
		$this->WWN = $WWN;
	}
	
	
	public function getSerialNo()
	{
		return $this->SerialNo;
	}
	public function setSerialNo($SerialNo)
	{
		$this->SerialNo = $SerialNo;
	}
	
	public function getFirmWareVersion()
	{
		return $this->FirmWareVersion;
	}
	public function setFirmWareVersion($FirmWareVersion)
	{
		$this->FirmWareVersion = $FirmWareVersion;
	}
	
	public function setAdapterID($AdapterID)
	{
		$this->AdapterID = $AdapterID;
	}
	public function getAdapterID()
	{
		return $this->AdapterID;
	}
	
	public function setPIOMode($PIOMode)
	{
		$this->PIOMode = $PIOMode;
	}
	public function getPIOMode()
	{
		return $this->PIOMode;
	}
	
	public function setMDMAMode($MDMAMode)
	{
		$this->MDMAMode = $MDMAMode;
	}
	public function getMDMAMode()
	{
		return $this->MDMAMode;
	}
	
	public function setUDMAMode($UDMAMode)
	{
		$this->UDMAMode = $UDMAMode;
	}
	public function getUDMAMode()
	{
		return $this->UDMAMode;
	}
	
	public function setCurrentPIOMode($CurrentPIOMode)
	{
		$this->CurrentPIOMode = $CurrentPIOMode;
	}
	public function getCurrentPIOMode()
	{
		return $this->CurrentPIOMode;
	}
	
	public function setCurrentMDMAMode($CurrentMDMAMode)
	{
		$this->CurrentMDMAMode = $CurrentMDMAMode;
	}
	public function getCurrentMDMAMode()
	{
		return $this->CurrentMDMAMode;
	}
	
	public function setCurrentUDMAMode($CurrentUDMAMode)
	{
		$this->CurrentUDMAMode = $CurrentUDMAMode;
	}
	public function getCurrentUDMAMode()
	{
		return $this->CurrentUDMAMode;
	}
	
	public function setSize($Size)
	{
		$this->Size = $Size;
	}
	public function getSize()
	{
		return $this->Size;
	}
	
	public function isOffline()
	{
		return $this->HDRaidStatus & HdStatus::HD_STATUS_OFFLINE;
	}
	
	public function isAssigned()
	{
		return $this->HDRaidStatus & HdStatus::HD_STATUS_ASSIGNED;
	}
	
	public function setStatus($Status)
	{
		$this->Status = $Status;
	}
	public function getStatus()
	{
		return $this->Status;
	}
	
	public function setType($Type)
	{
		$this->Type = $Type;
	}
	public function getType()
	{
		return $this->Type;
	}
	
	public function setHasMBR($HasMBR)
	{
		$this->HasMBR = $HasMBR;
	}
	public function getHasMBR()
	{
		return $this->HasMBR;
	}
	
	public function setValidSize($ValidSize)
	{
		$this->ValidSize = $ValidSize;
	}
	public function getValidSize()
	{
		return $this->ValidSize;
	}

    //for oem lenovo
	public function getFru()
	{
		return $this->Fru;
	}
	public function getMfa()
	{
		return $this->Mfa;
	}
	public function getLenovo_8S_l2_PN()
	{
		return $this->Lenovo_8S_l2_PN;
	}
	public function getLenovo_8S_SN()
	{
		return $this->Lenovo_8S_SN;
	}
	public function getPD_status()
	{
		return $this->PD_status;
	}
    //

	public function setMBRInfo($Info)
	{
		if (isset($Info->HDID)) {
			$this->setDeviceID(intval(trim($Info->HDID)));
		}
		if (isset($Info->hasMBR)) {
			$this->HasMBR = $Info->hasMBR;
		}
	}
	
	public function setValidSizeInfo($Info)
	{
		if (isset($Info->ID)) {
			$this->setDeviceID(trim($Info->ID));
		}
		
		if (isset($Info->AdapterID)) {
			$this->setAdapterID(trim($Info->AdapterID));
		}
		
		if (isset($Info->Size)) {			
			$this->ValidSize = floatval(trim($Info->Size));
		}
	}
	
	public function setHdRaidStatus($Info)
	{
		if (isset($Info->Status)) {
			$this->setRaidStatus(intval(trim($Info->Status)));
		}
		if (isset($Info->HDID)) {
			$this->setDeviceID(intval(trim($Info->HDID)));
		}
		if (isset($Info->DGID)) {
			$this->DedicatedDGID = trim($Info->DGID);
		}
	}
	
	public function setHdInfo($Info)
	{
		foreach ($Info->Link as $Link)
		{
			$this->setTopologyLink($Link);
		}
		
		/*
 		if (isset($Info->Status)) {
 			$this->Status = trim($Info->Status);
 		}
 		*/
		
 		if (isset($Info->HD_SSD_Type)) {
 			$this->HD_SSD_Type = trim($Info->HD_SSD_Type);
 		}
 		if (isset($Info->Size)) {
 			$this->Size = floatval(trim($Info->Size));
 		}
 		if (isset($Info->AdapterID)) {
 			$this->AdapterID = trim($Info->AdapterID);
 		}
 		if (isset($Info->HDType)) {
 			$this->Type = trim($Info->HDType);
 			//echo $this->Type;
 		}
 		if (isset($Info->PIOMode)) {
 			$this->PIOMode = trim($Info->PIOMode);
 		}
 		if (isset($Info->MDMAMode)) {
 			$this->MDMAMode = trim($Info->MDMAMode);
 		}
 		if (isset($Info->UDMAMode)) {
 			$this->UDMAMode = trim($Info->UDMAMode);
 		}
 		
 		if (isset($Info->SerialNo)) {
 			$this->SerialNo = trim($Info->SerialNo);
 		}
 		
 		if (isset($Info->Model)) {
 			$this->Model = trim($Info->Model);
 		}
 		
 		if (isset($Info->FeatureSupport)) {
 			$this->FeatureSupport = trim($Info->FeatureSupport);
 		}
 		
 		if (isset($Info->FWVersion)) {
 			$this->FirmWareVersion = trim($Info->FWVersion);
 		}
 		
 		if (isset($Info->WWN)) {
 			$this->WWN = trim($Info->WWN);
 		}
 		
 		//current modes
 		if (isset($Info->CurrentPIOMode)) {
 			$this->CurrentPIOMode = trim($Info->CurrentPIOMode);
 		}
 		if (isset($Info->CurrentMDMAMode)) {
 			$this->CurrentMDMAMode = trim($Info->CurrentMDMAMode);
 		}
 		if (isset($Info->CurrentUDMAMode)) {
 			$this->CurrentUDMAMode = trim($Info->CurrentUDMAMode);
 		}
 		
 		if (isset($Info->ConnectionType)) {
 			$this->ConnectionType = trim($Info->ConnectionType);
 		}
 		if (isset($Info->DeviceType)) {
 			$this->DeviceType = trim($Info->DeviceType);
 		}
 		if (isset($Info->CanLogicalUsed)) {
 			$this->CanLogicalUsed = trim($Info->CanLogicalUsed);
 		}
 		
 		//LED
 		if (isset($Info->ActivityLEDStatus)) {
 			$this->ActivityLEDStatus = trim($Info->ActivityLEDStatus);
 		}
 		if (isset($Info->LocateLEDStatus)) {
 			$this->LocateLEDStatus = trim($Info->LocateLEDStatus);
 		}
 		if (isset($Info->ErrorLEDStatus)) {
 			$this->ErrorLEDStatus = trim($Info->ErrorLEDStatus);
 		}
 		/*
 		if (isset($Info->FeatureEnable)) {
 			$this->FeatureEnable = trim($Info->FeatureEnable);
 		}
 		*/
 		//set name
 		$this->setName($this->Model . " " . $this->SerialNo);

        //for oem lenovo
 		if (isset($Info->Fru)) {
 			$this->Fru = trim($Info->Fru);
 		}
 		if (isset($Info->Mfa)) {
 			$this->Mfa = trim($Info->Mfa);
 		}
 		if (isset($Info->Lenovo_8S_l2_PN)) {
 			$this->Lenovo_8S_l2_PN = trim($Info->Lenovo_8S_l2_PN);
 		}
 		if (isset($Info->Lenovo_8S_SN)) {
 			$this->Lenovo_8S_SN = trim($Info->Lenovo_8S_SN);
 		}
 		if (isset($Info->PD_status)) {
 			$this->PD_status = trim($Info->PD_status);
 		}
	}
	
	public function setHdConfig($config)
	{
//		private $WriteCacheOn;
		//private $SMARTOn;
		//private $Online;
		if (isset($config->HDID)) {
			$this->setDeviceID(trim($config->HDID));
		}
		if (isset($config->WriteCacheOn)) {
			$this->WriteCacheOn = trim($config->WriteCacheOn);
		}
		if (isset($config->DriveSpeed)) {
			$this->Speed = trim($config->DriveSpeed);
		}
		if (isset($config->crypto)) {
			$this->crypto = trim($config->crypto);
		}
                if (isset($config->Percentage)) {
			$this->aesPercentage = trim($config->Percentage);
		}
	}
	
	public function setMPInfo($status)
	{
		if (isset($status->HDID)) {
			$this->setDeviceID(trim($status->HDID));
		}
		if (isset($status->Percentage)) {
			$this->MPPercentage = trim($status->Percentage);
		}
		if (isset($status->Status)) {
			$this->MPState = trim($status->Status);
		}
	}
	
	public function setHdStatus($status)
	{
		if (isset($status->HDID)) {
			$this->setDeviceID(trim($status->HDID));
		}
		if (isset($status->Percentage)) {
			$this->Percentage = trim($status->Percentage);
		}
		
		if (isset($status->Bga)) {
			$this->Bga = trim($status->Bga);
		}
		
		if (isset($status->Status)) {
			$this->Status = trim($status->Status);
		}
		
		//bga state
		if (isset($status->BgaStatus)) {
			$this->BgaState = trim($status->BgaStatus);
		}
	}
}

?>