<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
*/

/**
 * Description of AESPortListXmlHandlerclass
 *
 * @author hank
 */
class AESPortListXmlHandler extends XmlHandler {
    public function handle($XMLRoot) {
        $factory = $this->getFactory();
        if (isset($XMLRoot->aes_entry_info) && !empty($XMLRoot->aes_entry_info)) {
            foreach($XMLRoot->aes_entry_info as $info) {
                foreach($info->aes_port as $port) {
                    $newPort = null;
                    $id = intval($port->port_id);
                    if ($this->getFactory()->hasObj($id)) {
                        $newPort = $this->getFactory()->getObj($id);
                    }
                    else {
                        $newPort = $this->getFactory()->createObj($id);
                    }
                    $newPort->setPortId($id);
                    if(isset($port->entry)) {
                        $entryId = intval($port->entry);
                        if($entryId != 0xff) {
                            $newPort->setMounted(1);
                            $newPort->getEntryInfo()->setEntryId($entryId);
                        }
                        else {
                            $newPort->setMounted(0);
                        }
                    }
                }
            }
        }
    }
}
?>
