<?php
class CtnLdOnDgList extends Container
{
	private $toGetLDInfo = false;
	private $toGetLDStatus = false;
	
	public function toGetLDInfo()
	{
		$this->toGetLDInfo = true;
	}
	
	public function toGetLDStatus()
	{
		$this->toGetLDStatus = true;
	}
	
	protected function setBase()
	{
		$this->base = new LdOnDgList();
		if ($this->toGetLDInfo) {
			$this->base->toGetLDInfo();
		}
		if ($this->toGetLDStatus) {
			$this->base->toGetLDStatus();
		}
	}

	
	public function displayXML()
	{
		$this->display("XML_LdList.tpl");
	}
	
	protected function setDataToPage()
	{
		$LdList = array();
		$HasBga = 0;
		$baseclasses = $this->base->getBaseClasses();
		foreach ($baseclasses as $LD)
		{
			$ldInfo = new LdOnDgInfo();
			$ldInfo->setLdOnDgInfo($LD);
			if ($ldInfo->Bga && $ldInfo->BgaStateInt == LdBgaState::LD_BGA_STATE_RUNNING) {
				$HasBga = 1;
			}
			//var_dump($ldInfo);
			$LdList[$ldInfo->ID] = $ldInfo;
		}
		
		ksort($LdList);
		$this->setInfo($LdList);
		$this->smarty->assign("LdList",$LdList);
		$this->smarty->assign("HasBga",$HasBga);
	}
}

?>