<?php
class CtnSystemDiskList extends Container {

    private $toGetSystemDiskInfo = false;

    public function toGetSystemDiskInfo() {
        $this->toGetSystemDiskInfo = true;
    }

    protected function setBase() {
        $this->base = new SystemDiskList();

        if ($this->toGetSystemDiskInfo) {
            $this->base->toGetSystemDiskForHyperSSD();
        }
    }

    protected function setDataToPage() {
        $SystemDiskList = array();
        $baseclasses = $this->base->getBaseClasses();
        foreach ($baseclasses as $disk) {
            $diskInfo = new SystemDiskInfo();
            $diskInfo->setSystemDiskInfo($disk);
            $SystemDiskList[$diskInfo->DiskNumber] = $diskInfo;
        }

        ksort($SystemDiskList);

        $this->setInfo($SystemDiskList);
        $this->smarty->assign("SystemDiskList",$SystemDiskList);
    }

    protected function displayXML() {
        //won't be used
    }
}

?>
