<?php
class TreeImg
{
    const System = "System.gif";
    const Service = "service.gif";
    const Adapter = "Adapter_icon.gif";
    const SSDAdapter = "SSD_Adapter_icon.gif";
    const Enclosure = "Enclosure.gif";
    const Expander = "Expander.gif";
    const BBU = "BBU.gif";
    const PM = "PM.gif";
    const AES = "AES.gif";
    const Email = "email.jpeg";
    const Acount = "account.gif";
    const Schedule = "schedule_node.gif";
}

class CtnTreeDisplayer extends CtnDisplayer {
    private $reqParams;

    protected function initPage(){
        $params = getRequestPara('reqNodes');

        if (trim($params) == "") {
            $params == "0_0_1|0_2_1|1_2_1";
        }

        $this->reqParams = preg_split('/\|/', trim($params));

        include_once("../phpsrc/MRUTree.php");
        $this->generateTree();

        $this->setPageName("XML_Tree.tpl");
    }

    protected function getID($type, $id)
    {
        return $type * 10 + $id;
    }

    private function setNodeExpandInfo($mruNode)
    {
        $id = $mruNode->getID();
        $type = $mruNode->getNodeType();
        $exp = EXPAND_TYPE_UNEXPAND;


        if($type == MRUTreeNodeType::ENC_LEAF
            || $type == MRUTreeNodeType::HD_LEAF
            || $type == MRUTreeNodeType::HDONARRAY_LEAF
            || $type == MRUTreeNodeType::VDONARRAY_LEAF
            //|| $type == MRUTreeNodeType::VD_LEAF
            || $type == MRUTreeNodeType::HDONVD_LEAF
            || $type == MRUTreeNodeType::BBU_LEAF
            || $type == MRUTreeNodeType::PM_LEAF
            || $type == MRUTreeNodeType::AES_LEAF
            || $type == MRUTreeNodeType::RAID_SERVICE_LEAF
            || $type == MRUTreeNodeType::FLASH_SERVICE_LEAF
            || $type == MRUTreeNodeType::CREATE_HYPPER_LEAF
            || $type == MRUTreeNodeType::SSD_SERVICE_LEAF
            || $type == MRUTreeNodeType::SCHEDULE_SETTING_LEAF
            || $type == MRUTreeNodeType::EMAIL_SETTING_LEAF
            || $type == MRUTreeNodeType::ACCOUNT_MANAGER_LEAF
            || $type == MRUTreeNodeType::HYPER_SSD_LEAF
        )
        {
            $exp = EXPAND_TYPE_CANNOTEXPAND;
        }else if(trim(getRequestPara('reqNodes')) == "")
        {
            if ($type == MRUTreeNodeType::SSD_VOLUME_LEAF)
            $exp = EXPAND_TYPE_UNEXPAND;
            else
            $exp = EXPAND_TYPE_EXPAND;
        }
        else{
            foreach ($this->reqParams as $nodeInfo)
            {
                if(trim($nodeInfo) == "")
                {
                    continue;
                }
                list($nid, $ntype, $nexpand) = explode("_", $nodeInfo);
                if ($nid == $id && $ntype == $type) {
                    $exp = $nexpand;
                    break;
                }
            }
        }

        switch ($exp)
        {
            case EXPAND_TYPE_EXPAND:
                $mruNode->expand();
                break;
            case EXPAND_TYPE_UNEXPAND:
                $mruNode->unExpand();
                break;
            case EXPAND_TYPE_CANNOTEXPAND:
                $mruNode->cannotExpand();
                break;
            default:
                //do nothing
            }
        }

        private function generatePackageVD($hbaid,$adpNode)
        {
            $smarty = $this->smarty;

            $ldList = new CtnPackageVDList();
            $ldList->setAdapterID($hbaid);
            $ldList->toGetLDInfo();
            $ldList->toGetLDStatus();
            $ldList->toGetBlockInfo();
            $ldList->toGetHDInfo();
            $ldList->smartyAssign($smarty);
            $ldList->initContainer();
            $allLds = $ldList->getInfos();

            $packageVDs= array();
            foreach ($allLds as $ld)
            {
                if($ld->AdapterID == $hbaid)
                {
                    $packageVDs[] = $ld;
                }
            }

            if ($packageVDs) {
                $packageVDsNode = new MRUTreeNode("", "Virtual Disks", "tip", "", $hbaid,
                    MRUTreeNodeType::VD_TITLE_LEAF,$hbaid);
                $this->setNodeExpandInfo($packageVDsNode);
                if (! $packageVDs) {
                    $packageVDsNode->cannotExpand();
                }
                else {
                    if ($packageVDsNode->getExpandTypeIndex() == EXPAND_TYPE_CANNOTEXPAND) {
                        $packageVDsNode->expand();
                    }
                }
                $adpNode->addChild($packageVDsNode);

                if ($packageVDsNode->getExpandTypeIndex() == EXPAND_TYPE_EXPAND) {
                    foreach ($packageVDs as $ld)
                    {
                            $ldid = $ld->ID;
                            $ldname = $ld->Name;
                            $ldNode = new MRUTreeNode($ld->LDImg, "Virtual Disk" . " ". $ldid . ": (" . $ldname . ")", "tip",
                                $this->getDetailUrl(Target::getPackageVDPage . "&ID=" . $ldid . "&HBAID=" . $hbaid), $ldid,
                                MRUTreeNodeType::VD_LEAF,$hbaid);
                            $this->setNodeExpandInfo($ldNode);
                            $packageVDsNode->addChild($ldNode);
                            if ($ldNode->getExpandTypeIndex() == EXPAND_TYPE_EXPAND) {
                                $IDs = array();
                                $hdList = array();
                                $tempList = array_merge($ld->HDList, $ld->spareHDList);
                                foreach ($tempList as $HD)
                                {
                                    if (! in_array($HD->ID, $IDs)) {
                                        $hdList[] = $HD;
                                        $IDs[] = $HD->ID;
                                    }
                                }

                                foreach ($hdList as $hd)
                                {
                                    $pdid = $hd->ID;
                                    $portId = $hd->ParentPhyID;
                                    $nodeStr = "Physical Disk: ";

                                    $parentDev = $hd->ParentTypeInt;
                                    $parentId = $hd->ParentID;
                                    if ($parentDev == DeviceType::DEVICE_TYPE_PORT ) {
                                        $nodeStr .= "port ". $portId;
                                    } elseif ($parentDev == DeviceType::DEVICE_TYPE_EXPANDER) {
                                        $nodeStr .= "Exp " . $parentId . " port " . $portId;
                                    } elseif ($parentDev == DeviceType::DEVICE_TYPE_ENCLOSURE ) {
                                        $nodeStr .= "Encl " . $parentId . " port " . $portId;
                                    } elseif ($parentDev == DeviceType::DEVICE_TYPE_PM  ) {
                                        $nodeStr .= "PM " . $parentId . " port " . $portId;
                                    }

                                    $hdNode = new MRUTreeNode($hd->HDImg, $nodeStr, "tip",
                                        $this->getDetailUrl(Target::getHdDetail . "&ID=" . $pdid . "&HBAID=" . $hbaid), $pdid + $ldid*128,
                                        MRUTreeNodeType::HDONVD_LEAF,$hbaid);
                                    $this->setNodeExpandInfo($hdNode);
                                    $ldNode->addChild($hdNode);
                                }
                            }
                    }
                }
                
            }
        }
        
        private function generateDG($hbaid,$adpNode)
        {
            $smarty = $this->smarty;

            $ctnDgList = new CtnDgList();
            $ctnDgList->setAdapterID($hbaid);
            $ctnDgList->toGetDGInfo();
            $ctnDgList->smartyAssign($smarty);
            $ctnDgList->initContainer();

            $dglist = $ctnDgList->getInfos();

            //		$dgsNode =
            //			new MRUTreeNode("", "Arrays", "tip", "", 0, MRUTreeNodeType::ARRAY_TITLE_LEAF);
            //		$this->setNodeExpandInfo($dgsNode);
            //		if (!$dglist) {
            //			$dgsNode->cannotExpand();
            //		}
            //		$adpNode->addChild($dgsNode);

            foreach ($dglist as $dg)
            {
                $id = $dg->ID;
                $name = $dg->Name;
                $dgNode =
                new MRUTreeNode($dg->DGImg, "Array" . " ". $id . ": (" . $name . ")", "tip",
                    $this->getDetailUrl(Target::getArraySubPage . "&ID=" . $id . "&HBAID=" . $hbaid), $id,
                    MRUTreeNodeType::ARRAY_LEAF,$hbaid);
                $this->setNodeExpandInfo($dgNode);
                //$dgsNode->addChild($dgNode);
                $adpNode->addChild($dgNode);

                //			$vdsNode = new MRUTreeNode("", "Virtual Disks", "tip", "", 0,
                //				MRUTreeNodeType::VDONARRAY_TITLE_LEAF);
                //			$this->setNodeExpandInfo($vdsNode);
                //			if (! $dg->LDList) {
                //				$vdsNode->cannotExpand();
                //			}
                //			$dgNode->addChild($vdsNode);
                //			if ($vdsNode->getExpandTypeIndex() == EXPAND_TYPE_EXPAND) {
                foreach ($dg->LDList as $vd)
                {
                    $vdid = $vd->ID;
                    $vdname = $vd->Name;
                    $vdNode = new MRUTreeNode($vd->LDImg, "Virtual Disk" . " ". $vdid . ": (" . $vdname . ")",
                         "tip",$this->getDetailUrl(Target::getVDSubPage . "&ID=" . $vdid . "&HBAID=" . $hbaid), $vdid,
                        MRUTreeNodeType::VDONARRAY_LEAF,$hbaid);
                    $this->setNodeExpandInfo($vdNode);
                    $dgNode->addChild($vdNode);
                    //$vdsNode->addChild($vdNode);
                }
                //			}

            $hdsNode = new MRUTreeNode("", "Physical Disks", "tip", "", $id,
                MRUTreeNodeType::HDONARRAY_TITLE_LEAF,$hbaid);
            $this->setNodeExpandInfo($hdsNode);
            $IDs = array();
            $hdList = array();
            $tempList = array_merge($dg->HDList, $dg->spareHDList);
            foreach ($tempList as $HD)
            {
                if (! in_array($HD->ID, $IDs)) {
                    $hdList[] = $HD;
                    $IDs[] = $HD->ID;
                }
            }

            if (! $hdList) {
                $hdsNode->cannotExpand();
            }
            else
            {
                //in case previous state is no HD
                if ($hdsNode->getExpandTypeIndex() == EXPAND_TYPE_CANNOTEXPAND) {
                    $hdsNode->expand();
                }
            }
            $dgNode->addChild($hdsNode);
            if ($hdsNode->getExpandTypeIndex() == EXPAND_TYPE_EXPAND) {
                foreach ($hdList as $hd)
                {
                    $pdid = $hd->ID;

                    $portId = $hd->ParentPhyID;
                    $nodeStr = "Physical Disk: ";

                    $parentDev = $hd->ParentTypeInt;
                    $parentId = $hd->ParentID;
                    if ($parentDev == DeviceType::DEVICE_TYPE_PORT ) {
                        $nodeStr .= "port ". $portId;
                    } elseif ($parentDev == DeviceType::DEVICE_TYPE_EXPANDER) {
                        $nodeStr .= "Exp " . $parentId . " port " . $portId;
                    } elseif ($parentDev == DeviceType::DEVICE_TYPE_ENCLOSURE ) {
                        $nodeStr .= "Encl " . $parentId . " port " . $portId;
                    } elseif ($parentDev == DeviceType::DEVICE_TYPE_PM  ) {
                        $nodeStr .= "PM " . $parentId . " port " . $portId;
                    }

                    $hdNode = new MRUTreeNode($hd->HDImg, $nodeStr, "tip",
                        $this->getDetailUrl(Target::getHdDetail . "&ID=" . $pdid . "&HBAID=" . $hbaid), $pdid,
                        MRUTreeNodeType::HDONARRAY_LEAF,$hbaid);
                    $this->setNodeExpandInfo($hdNode);
                    $hdsNode->addChild($hdNode);
                }
            }
            }
        }

        private function generateForeignVD($hbaid, $adpNode)
        {
            $smarty = $this->smarty;

            $vdList = new CtnLDList();
            $vdList->setAdapterID($hbaid);
            $vdList->toGetLDInfo();
            $vdList->toGetLDStatus();
            $vdList->toGetBlockInfo();
            $vdList->toGetHDInfo();
            $vdList->smartyAssign($smarty);
            $vdList->initContainer();
            $allvds = $vdList->getInfos();

            $vdsForeign = array();
            foreach ($allvds as $vd)
            {
                if($vd->AdapterID == $hbaid && ($vd->isForeign || $vd->isImportable || $vd->isNotImportable))
                {
                    $vdsForeign[] = $vd;
                }
            }
            if (sizeof($vdsForeign)) {
                $vdsNotOnDgNode = new MRUTreeNode("", "Foreign Virtual Disks", "tip", "", $hbaid,
                    MRUTreeNodeType::VDONARRAY_TITLE_LEAF,$hbaid); //?
                $this->setNodeExpandInfo($vdsNotOnDgNode);
                if (! $vdsForeign) {
                    $vdsNotOnDgNode->cannotExpand();
                }
                else
                {
                    //
                    if ($vdsNotOnDgNode->getExpandTypeIndex() == EXPAND_TYPE_CANNOTEXPAND) {
                        $vdsNotOnDgNode->expand();
                    }
                }
                $adpNode->addChild($vdsNotOnDgNode);
                if ($vdsNotOnDgNode->getExpandTypeIndex() == EXPAND_TYPE_EXPAND) {
                    foreach ($vdsForeign as $vd)
                    {
                        $vdid = $vd->ID;
                        $vdname = $vd->Name;
                        $vdNode = new MRUTreeNode($vd->LDImg, "Virtual Disk" . " ". $vdid . ": (" . $vdname . ")", "tip",
                            $this->getDetailUrl(Target::getIndependentVDPage . "&ID=" . $vdid . "&HBAID=" . $hbaid), $vdid,
                            MRUTreeNodeType::VD_LEAF,$hbaid);
                        $this->setNodeExpandInfo($vdNode);
                        $vdsNotOnDgNode->addChild($vdNode);
                        if ($vdNode->getExpandTypeIndex() == EXPAND_TYPE_EXPAND) {
                            foreach ($vd->Adapters as $adapter)
                            {
                                $hds = $this->sortHDByPortId($adapter->HDs);
                                foreach ($hds as $hd)
                                {
                                    $pdid = $hd->ID;

                                    $portId = $hd->ParentPhyID;
                                    $nodeStr = "Physical Disk: ";

                                    $parentDev = $hd->ParentTypeInt;
                                    $parentId = $hd->ParentID;
                                    if ($parentDev == DeviceType::DEVICE_TYPE_PORT ) {
                                        $nodeStr .= "port ". $portId;
                                    } elseif ($parentDev == DeviceType::DEVICE_TYPE_EXPANDER) {
                                        $nodeStr .= "Exp " . $parentId . " port " . $portId;
                                    } elseif ($parentDev == DeviceType::DEVICE_TYPE_ENCLOSURE ) {
                                        $nodeStr .= "Encl " . $parentId . " port " . $portId;
                                    } elseif ($parentDev == DeviceType::DEVICE_TYPE_PM  ) {
                                        $nodeStr .= "PM " . $parentId . " port " . $portId;
                                    }

                                    $hdNode = new MRUTreeNode(HdStatus::HD_STATUS_ASSIGNED_IMG, $nodeStr, "tip",
                                        $this->getDetailUrl(Target::getHdDetail . "&ID=" . $pdid . "&HBAID=" . $hbaid), $pdid + $vdid*128,
                                        MRUTreeNodeType::HDONVD_LEAF,$hbaid);
                                    $this->setNodeExpandInfo($hdNode);
                                    $vdNode->addChild($hdNode);
                                }
                            }
                        }
                    }
                }
            }
        }

        private function generateSSDVolume($hbaid, $adpNode)
        {
            $smarty = $this->smarty;

            $volumeDtl = new CtnSSDVolumeDetail();
            $volumeDtl->setAdapterID($hbaid);
            $volumeDtl->toGetSSDVolumeInfo();
            $volumeDtl->toGetBlockInfo();
            $volumeDtl->toGetHDInfo();
            $volumeDtl->smartyAssign($smarty);
            $volumeDtl->initContainer();
            $volume = $volumeDtl->getInfos();

            if ($volume){
                $vdid = 0;
                $volumeNode = new MRUTreeNode($volume->VolumeImg, "Volume", "tip",
                    $this->getDetailUrl(Target::getSSDVolumeDetail . "&ID=0" . "&HBAID=" . $hbaid), "",
                    MRUTreeNodeType::SSD_VOLUME_LEAF,$hbaid);
                $this->setNodeExpandInfo($volumeNode);
                $adpNode->addChild($volumeNode);
                foreach ($volume->Adapters as $adapter)
                {
                    foreach ($adapter->HDs as $hd)
                    {
                        $pdid = $hd->ID;
                        $pdDisplayStr = "Module" . " ". $pdid;
                        $pdDisplayImg = "SSD_" . HdStatus::HD_STATUS_ASSIGNED_IMG;

                        $hdNode = new MRUTreeNode($pdDisplayImg, $pdDisplayStr, "tip",
                            $this->getDetailUrl(Target::getSSDDetail . "&ID=" . $pdid . "&HBAID=" . $hbaid), $pdid + $vdid*128,
                            MRUTreeNodeType::HDONVD_LEAF,$hbaid);
                        $this->setNodeExpandInfo($hdNode);
                        $volumeNode->addChild($hdNode);
                    }
                }

            }
        }

        private function generateHyper($hbaid, $adpNode)
        {
            $smarty = $this->smarty;

            $vdList = new CtnLDList();
            $vdList->setAdapterID($hbaid);
            $vdList->toGetLDInfo();
            $vdList->toGetLDStatus();
            $vdList->toGetBlockInfo();
            $vdList->toGetHDInfo();
            $vdList->toGetHyper(); //get hyper ssd
            $vdList->smartyAssign($smarty);
            $vdList->initContainer();
            $Hypers = $vdList->getInfos();

            if ($Hypers) {
                $hyperRootNode =  new MRUTreeNode("", "HyperDuos", "tip", "", $hbaid,
                    MRUTreeNodeType::HYPER_TITLE_LEAF,$hbaid);
                $this->setNodeExpandInfo($hyperRootNode);

                $adpNode->addChild($hyperRootNode);
                if ($hyperRootNode->getExpandTypeIndex() == EXPAND_TYPE_EXPAND) {
                    foreach ($Hypers as $hyper)
                    {
                        $hyperid = $hyper->ID;
                        $hypername = $hyper->Name;
                        $hyperNode = new MRUTreeNode($hyper->LDImg, "HyperDuo" . " ". $hyperid . ": (" . $hypername . ")", "tip",
                            $this->getDetailUrl(Target::getIndependentVDPage . "&ID=" . $hyperid . "&HBAID=" . $hbaid), $hyperid,
                            MRUTreeNodeType::VD_LEAF,$hbaid);
                        $this->setNodeExpandInfo($hyperNode);
                        $hyperRootNode->addChild($hyperNode);
                        if ($hyperNode->getExpandTypeIndex() == EXPAND_TYPE_EXPAND) {
                            foreach ($hyper->Adapters as $adapter)
                            {
                                $hds = $this->sortHDByPortId($adapter->HDs);
                                foreach ($hds as $hd)
                                {
                                    $pdid = $hd->ID;
                                    $portId = $hd->ParentPhyID;
                                    $nodeStr = "Physical Disk: ";

                                    $parentDev = $hd->ParentTypeInt;
                                    $parentId = $hd->ParentID;
                                    if ($parentDev == DeviceType::DEVICE_TYPE_PORT ) {
                                        $nodeStr .= "port ". $portId;
                                    } elseif ($parentDev == DeviceType::DEVICE_TYPE_EXPANDER) {
                                        $nodeStr .= "Exp " . $parentId . " port " . $portId;
                                    } elseif ($parentDev == DeviceType::DEVICE_TYPE_ENCLOSURE ) {
                                        $nodeStr .= "Encl " . $parentId . " port " . $portId;
                                    } elseif ($parentDev == DeviceType::DEVICE_TYPE_PM  ) {
                                        $nodeStr .= "PM " . $parentId . " port " . $portId;
                                    }

                                    $hdNode = new MRUTreeNode(HdStatus::HD_STATUS_ASSIGNED_IMG, $nodeStr, "tip",
                                        $this->getDetailUrl(Target::getHdDetail . "&ID=" . $pdid . "&HBAID=" . $hbaid), $pdid + $hyperid*128,
                                        MRUTreeNodeType::HDONVD_LEAF,$hbaid);
                                    $this->setNodeExpandInfo($hdNode);
                                    $hyperNode->addChild($hdNode);
                                }
                            }
                        }

                    }
                }
            }

        }


        private function generateVDOnly($hbaid, $adpNode)
        {
            $smarty = $this->smarty;

            $vdList = new CtnLDList();
            $vdList->setAdapterID($hbaid);
            $vdList->toGetLDInfo();
            $vdList->toGetLDStatus();
            $vdList->toGetBlockInfo();
            $vdList->toGetHDInfo();
            $vdList->smartyAssign($smarty);
            $vdList->initContainer();
            $allvds = $vdList->getInfos();

            $vdsNotOnDg = array();
            foreach ($allvds as $vd)
            {
                if($vd->AdapterID == $hbaid)
                {
                    $vdsNotOnDg[] = $vd;
                }
            }

            if ($vdsNotOnDg) {
                $vdsNotOnDgNode = new MRUTreeNode("", "Virtual Disks", "tip", "", $hbaid,
                    MRUTreeNodeType::VD_TITLE_LEAF,$hbaid);
                $this->setNodeExpandInfo($vdsNotOnDgNode);
                if (! $vdsNotOnDg) {
                    $vdsNotOnDgNode->cannotExpand();
                }
                else {
                    if ($vdsNotOnDgNode->getExpandTypeIndex() == EXPAND_TYPE_CANNOTEXPAND) {
                        $vdsNotOnDgNode->expand();
                    }
                }
                $adpNode->addChild($vdsNotOnDgNode);
                if ($vdsNotOnDgNode->getExpandTypeIndex() == EXPAND_TYPE_EXPAND) {
                    foreach ($vdsNotOnDg as $vd)
                    {
                        if ($vd->isHyperHDD) {
                            $hyper = $vd;
                            $hyperid = $hyper->ID;
                            $hypername = $hyper->Name;
                            $hyperNode = new MRUTreeNode($hyper->LDImg, "HyperDuo" . ": (" . $hypername . ")", "tip",
                                $this->getDetailUrl(Target::getIndependentVDPage . "&ID=" . $hyperid . "&HBAID=" . $hbaid), $hyperid,
                                MRUTreeNodeType::VD_LEAF,$hbaid);
                            $this->setNodeExpandInfo($hyperNode);
                            $vdsNotOnDgNode->addChild($hyperNode);
                            if ($hyperNode->getExpandTypeIndex() == EXPAND_TYPE_EXPAND) {
                                foreach ($hyper->Adapters as $adapter)
                                {
                                    $hds = $this->sortHDByPortId($adapter->HDs);
                                    foreach ($hds as $hd)
                                    {
                                        $pdid = $hd->ID;
                                        $portId = $hd->ParentPhyID;
                                        if ($hd->IsSSD)
                                        $img = (HdStatus::HD_SSD_STATUS_ASSIGNED_IMG);
                                        else
                                        $img = (HdStatus::HD_STATUS_ASSIGNED_IMG);
                                        $nodeStr = "Physical Disk: ";

                                        $parentDev = $hd->ParentTypeInt;
                                        $parentId = $hd->ParentID;
                                        if ($parentDev == DeviceType::DEVICE_TYPE_PORT ) {
                                            $nodeStr .= "port ". $portId;
                                        } elseif ($parentDev == DeviceType::DEVICE_TYPE_EXPANDER) {
                                            $nodeStr .= "Exp " . $parentId . " port " . $portId;
                                        } elseif ($parentDev == DeviceType::DEVICE_TYPE_ENCLOSURE ) {
                                            $nodeStr .= "Encl " . $parentId . " port " . $portId;
                                        } elseif ($parentDev == DeviceType::DEVICE_TYPE_PM  ) {
                                            $nodeStr .= "PM " . $parentId . " port " . $portId;
                                        }

                                        $hdNode = new MRUTreeNode($img, $nodeStr, "tip",
                                            $this->getDetailUrl(Target::getHdDetail . "&ID=" . $pdid . "&HBAID=" . $hbaid), $pdid + $hyperid*128,
                                            MRUTreeNodeType::HDONVD_LEAF,$hbaid);
                                        $this->setNodeExpandInfo($hdNode);
                                        $hyperNode->addChild($hdNode);
                                    }
                                }
                            }


                        } else {
                            $vdid = $vd->ID;
                            $vdname = $vd->Name;
                            $vdNode = new MRUTreeNode($vd->LDImg, "Virtual Disk" . " ". $vdid . ": (" . $vdname . ")", "tip",
                                $this->getDetailUrl(Target::getIndependentVDPage . "&ID=" . $vdid . "&HBAID=" . $hbaid), $vdid,
                                MRUTreeNodeType::VD_LEAF,$hbaid);
                            $this->setNodeExpandInfo($vdNode);
                            $vdsNotOnDgNode->addChild($vdNode);
                            if ($vdNode->getExpandTypeIndex() == EXPAND_TYPE_EXPAND) {
                                foreach ($vd->Adapters as $adapter)
                                {
                                    $hds = $this->sortHDByPortId($adapter->HDs);
                                    foreach ($hds as $hd)
                                    {
                                        $pdid = $hd->ID;
                                        $portId = $hd->ParentPhyID;
                                        if ($hd->IsSSD)
                                        $img = (HdStatus::HD_SSD_STATUS_ASSIGNED_IMG);
                                        else
                                        $img = (HdStatus::HD_STATUS_ASSIGNED_IMG);
                                        $nodeStr = "Physical Disk: ";

                                        $parentDev = $hd->ParentTypeInt;
                                        $parentId = $hd->ParentID;
                                        if ($parentDev == DeviceType::DEVICE_TYPE_PORT ) {
                                            $nodeStr .= "port ". $portId;
                                        } elseif ($parentDev == DeviceType::DEVICE_TYPE_EXPANDER) {
                                            $nodeStr .= "Exp " . $parentId . " port " . $portId;
                                        } elseif ($parentDev == DeviceType::DEVICE_TYPE_ENCLOSURE ) {
                                            $nodeStr .= "Encl " . $parentId . " port " . $portId;
                                        } elseif ($parentDev == DeviceType::DEVICE_TYPE_PM  ) {
                                            $nodeStr .= "PM " . $parentId . " port " . $portId;
                                        }

                                        $hdNode = new MRUTreeNode($img, $nodeStr, "tip",
                                            $this->getDetailUrl(Target::getHdDetail . "&ID=" . $pdid . "&HBAID=" . $hbaid), $pdid + $vdid*128,
                                            MRUTreeNodeType::HDONVD_LEAF,$hbaid);
                                        $this->setNodeExpandInfo($hdNode);
                                        $vdNode->addChild($hdNode);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

    /*private function generateAES($hbaid, $adpNode)
    {
        $smarty = $this->smarty;

        $AESList = new CtnAESConfigList();
        $AESList->setAdapterID($hbaid);
        $AESList->toGetAESConfig();
        $AESList->smartyAssign($smarty);
        $AESList->initContainer();
        $AESs = $AESList->getInfos();

        if(sizeof($AESs))
        {
            $aesNodes = new MRUTreeNode("", "AESes", "tip", "", $hbaid,
                    MRUTreeNodeType::AES_TITLE_LEAF, $hbaid);
            $this->setNodeExpandInfo($aesNodes);
            $adpNode->addChild($aesNodes);

            if($aesNodes->getExpandTypeIndex() == EXPAND_TYPE_EXPAND)
            {
                foreach ($AESs as $aes)
                {
                    $aesNode = new MRUTreeNode("", "AES " . $aes->ID, "tip",
                        $this->getDetailUrl(Target::getAESDetail . "&ID=" . $aes->ID . "&HBAID=" . $hbaid),
                    $aes->ID,
                    MRUTreeNodeType::AES_LEAF, $hbaid);
                    $this->setNodeExpandInfo($aesNode);
                    $aesNodes->addChild($aesNode);
                }
            }
        }
    }*/

        private function generateSSDAdapter($hbaid, $adpNode)
        {
            $smarty = $this->smarty;

            $adpFeature = AdapterFeature::getInstance($hbaid);

            $this->generateSSDVolume($hbaid, $adpNode);

            $ssdList = new CtnSSDList();
            $ssdList->setAdapterID($hbaid);
            $ssdList->toGetSSDInfo();
            $ssdList->smartyAssign($smarty);
            $ssdList->initContainer();
            $ssds = $ssdList->getInfos();

            $ssdNodes = new MRUTreeNode("", "Modules", "tip", "", $hbaid,
                MRUTreeNodeType::HD_TITLE_LEAF,$hbaid);
            $this->setNodeExpandInfo($ssdNodes);
            if (! $ssds) {
                $ssdNodes->cannotExpand();
            }
            else {
                if ($ssdNodes->getExpandTypeIndex() == EXPAND_TYPE_CANNOTEXPAND) {
                    $ssdNodes->expand();
                }
            }
            $adpNode->addChild($ssdNodes);
            if($ssdNodes->getExpandTypeIndex() == EXPAND_TYPE_EXPAND)
            {
                foreach ($ssds as $ssd)
                {
                    $ssdid = $ssd->ID;

                    $ssdNode = new MRUTreeNode($ssd->SSDImg, "Module " . " ". $ssdid, "tip",
                        $this->getDetailUrl(Target::getSSDDetail . "&ID=" . $ssdid . "&HBAID=" . $hbaid), $ssdid,
                        MRUTreeNodeType::HD_LEAF,$hbaid);
                    $this->setNodeExpandInfo($ssdNode);
                    $ssdNodes->addChild($ssdNode);
                }
            }
        }

        private function sortHDByPortId($hds)
        {
            usort($hds, "compareHDPortId");
            return $hds;
        }

        private function addHDNode($hbaid,$hd,$parentNodes)
        {
            $pdid = $hd->ID;
            $portId = $hd->ParentPhyID;
            $nodeStr = "Physical Disk: ";

            $parentDev = $hd->ParentTypeInt;
            $parentId = $hd->ParentID;
            if ($parentDev == DeviceType::DEVICE_TYPE_PORT ) {
                $nodeStr .= "port ". $portId;
            } elseif ($parentDev == DeviceType::DEVICE_TYPE_EXPANDER) {
                $nodeStr .= "port " . $portId;
            } elseif ($parentDev == DeviceType::DEVICE_TYPE_ENCLOSURE ) {
                $nodeStr .= "port " . $portId;
            } elseif ($parentDev == DeviceType::DEVICE_TYPE_PM  ) {
                $nodeStr .= "port " . $portId;
            } elseif ($parentDev == DeviceType::DEVICE_TYPE_I2C_ENCLOSURE  ) {
                $nodeStr .= "port " . $portId;
            }

            $pdNode = new MRUTreeNode($hd->HDImg, $nodeStr, "tip",
                $this->getDetailUrl(Target::getHdDetail . "&ID=" . $pdid . "&HBAID=" . $hbaid), $pdid,
                MRUTreeNodeType::HD_LEAF,$hbaid);
            $this->setNodeExpandInfo($pdNode);
            $parentNodes->addChild($pdNode);
        }

        private function getExpanders($hbaid)
        {
            $smarty = $this->smarty;

            $expList = new CtnExpanderList();
            $expList->setAdapterID($hbaid);
            $expList->toGetExpInfo();
            $expList->smartyAssign($smarty);
            $expList->initContainer();
            return $expList->getInfos();
        }

        private function getPMs($hbaid)
        {
            $smarty = $this->smarty;

            $pmList = new CtnPMList();
            $pmList->setAdapterID($hbaid);
            $pmList->toGetPMInfo();
            $pmList->smartyAssign($smarty);
            $pmList->initContainer();
            return $pmList->getInfos();
        }

        private function getHDs($hbaid)
        {
            $smarty = $this->smarty;

            $hdList = new CtnHdList();
            $hdList->setAdapterID($hbaid);
            $hdList->toGetHdInfo();
            //$hdList->toGetHdFreeInfo();
            $hdList->toGetSpareInfo();
            $hdList->smartyAssign($smarty);
            $hdList->initContainer();
            $hds = $hdList->getInfos();
            $hds = $this->sortHDByPortId($hds);
            return $hds;
        }

        private function addExpanderNode($hbaid,$exp,$parentNode,$expsToExp,$hdsToExp)
        {
            $expid = $exp->ID;
            $portId = $exp->ParentPhyID;
            $nodeStr = "Expander: port [" . $portId . "]";
            $expNode = new MRUTreeNode(TreeImg::Expander, $nodeStr, "tip",
                $this->getDetailUrl(Target::getExpDetail . "&ID=" . $expid . "&HBAID=" . $hbaid), $expid,
                MRUTreeNodeType::EXP_LEAF,$hbaid);
            $this->setNodeExpandInfo($expNode);
            $parentNode->addChild($expNode);

            foreach ($expsToExp as $exptoexp)
            {
                $parentId = $exptoexp->ParentID;
                if ($parentId == $expid) {
                    $this->addExpanderNode($hbaid,$exptoexp,$expNode,$expsToExp,$hdsToExp);
                }
            }
            
            foreach ($hdsToExp as $hd)
            {
                $parentId = $hd->ParentID;
                if ($parentId == $expid) {
                    $this->addHDNode($hbaid,$hd,$expNode);
                }
            }

        }

        private function generateAdapter($hbaid, $adpNode)
        {
            $smarty = $this->smarty;

            $adpFeature = AdapterFeature::getInstance($hbaid);
            if($adpFeature->supportRAID) {

                if($adpFeature->supportDG)
                {
                    if(!$adpFeature->supportPackageVD) {
                        $this->generateDG($hbaid, $adpNode);
                        $this->generateForeignVD($hbaid, $adpNode);
                    }else{
                        $this->generatePackageVD($hbaid, $adpNode);
                    }
                }
                else
                {
                    //$this->generateHyper($hbaid, $adpNode);
                    $this->generateVDOnly($hbaid, $adpNode);
                }
            }

            $Exps = $this->getExpanders($hbaid);  //--Expanders
            $PMs = $this->getPMs($hbaid);         //--PMs
            $hds = $this->getHDs($hbaid);         //--HDs

            $hdsToHBA = array();
            $hdsToExp = array();
            $hdsToPM  = array();
            $i = 0;
            $j = 0;
            $k = 0;

            $pdNodes = new MRUTreeNode("", "Physical Devices", "tip", "", $hbaid,
                MRUTreeNodeType::HD_TITLE_LEAF,$hbaid);
            $this->setNodeExpandInfo($pdNodes);
            $adpNode->addChild($pdNodes);

            if ($hds){
                foreach ($hds as $hd)
                {
                    $hdid = $hd->ID;
                    $parentDev = $hd->ParentTypeInt;
                    if ($parentDev == DeviceType::DEVICE_TYPE_PORT ) {
                        $hdsToHBA[$i++] = $hd;
                    } elseif ($parentDev == DeviceType::DEVICE_TYPE_EXPANDER) {
                        $hdsToExp[$j++] = $hd;
                    } elseif ($parentDev == DeviceType::DEVICE_TYPE_ENCLOSURE ) {
                        $hdsToExp[$j++] = $hd;//ENCLOSURE ???
                    } elseif ($parentDev == DeviceType::DEVICE_TYPE_PM  ) {
                        $hdsToPM[$k++] = $hd;
                    } elseif ($parentDev == DeviceType::DEVICE_TYPE_I2C_ENCLOSURE) {
                        $hdsToHBA[$i++] = $hd;
                    }
                }
            }

            $expsToHBA = array();
            $expsToExp = array();
            if ($Exps){
                foreach ($Exps as $exp)
                {
                    $parentDev = $exp->ParentTypeInt;
                    if ($parentDev == DeviceType::DEVICE_TYPE_PORT ) {
                        $expsToHBA[$i++] = $exp;
                    } elseif ($parentDev == DeviceType::DEVICE_TYPE_EXPANDER) {
                        $expsToExp[$i++] = $exp;
                    }
                }
            }

            //generate topology
            if ($Exps){
                foreach ($expsToHBA as $exp)
                {
                    $this->addExpanderNode($hbaid,$exp,$pdNodes,$expsToExp,$hdsToExp);
//                    $expid = $exp->ID;
//                    $portId = $exp->ParentPhyID;
//                    $nodeStr = "Expander: port " . $portId;
//                    $expNode = new MRUTreeNode(TreeImg::Expander, $nodeStr, "tip",
//                        $this->getDetailUrl(Target::getExpDetail . "&ID=" . $expid . "&HBAID=" . $hbaid), $expid,
//                        MRUTreeNodeType::EXP_LEAF,$hbaid);
//                    $this->setNodeExpandInfo($expNode);
//                    $pdNodes->addChild($expNode);
//
//                    foreach ($expsToExp as $exptoexp)
//                    {
//                        $parentId = $exp->ParentID;
//                        if ($parentId == $expid) {
//
//                        }
//                    }
//                    if (!$hdsToExp) continue;
//                    foreach ($hdsToExp as $hd)
//                    {
//                        $parentId = $hd->ParentID;
//                        if ($parentId == $expid) {
//                            $this->addHDNode($hbaid,$hd,$expNode);
//                        }
//                    }
                }
            }

            if ($PMs){
                foreach ($PMs as $pm)
                {
                    $pmid = $pm->ID;
                    $portId = $pm->ParentPhyID;
                    $nodeStr = "Port Multiplier: port " . $portId;
                    $pmNode = new MRUTreeNode(TreeImg::PM, $nodeStr, "tip",
                        $this->getDetailUrl(Target::getPMDetail . "&ID=" . $pmid . "&HBAID=" . $hbaid), $pmid,
                        MRUTreeNodeType::PM_LEAF,$hbaid);
                    $this->setNodeExpandInfo($pmNode);
                    $pdNodes->addChild($pmNode);

                    if (!$hdsToPM) continue;
                    foreach ($hdsToPM as $hd)
                    {
                        $parentId = $hd->ParentID;
                        if ($parentId == $pmid) {
                            $this->addHDNode($hbaid,$hd,$pmNode);
                        }
                    }
                }
            }

            if ($hdsToHBA){
                foreach ($hdsToHBA as $hd)
                {
                    $this->addHDNode($hbaid,$hd,$pdNodes);
                }
            }

        /*if ($adpFeature->isSupportAES()) {
            //add AES related
            $this->generateAES($hbaid, $adpNode);
         } */

            //add BBU related
            $bbuList = new CtnBBUDetail();
            $bbuList->setAdapterID($hbaid);
            $bbuList->toGetBBUInfo();
            $bbuList->smartyAssign($smarty);
            $bbuList->initContainer();
            $bbu = $bbuList->getInfos();
            if ($bbu){
                $bbuid = $bbu->ID;
                $bbuNodes = new MRUTreeNode(TreeImg::BBU, "Battery Backup Unit", "tip",
                    //TODO
                    $this->getDetailUrl(Target::getBBUSubPage . "&HBAID=" . $hbaid), $bbuid,
                    MRUTreeNodeType::BBU_LEAF,$hbaid);
                $this->setNodeExpandInfo($bbuNodes);
                //if ($adpNode->getExpandTypeIndex() == EXPAND_TYPE_EXPAND) {
                $adpNode->addChild($bbuNodes);
                //}
            }
        }

        private function generateTree()
        {
            $smarty = $this->smarty;
            $hbaId = 0;

            include_once("../phpsrc/customization.php");
            
            $rootNode = new MRUTreeNode(TreeImg::System ,Customize::OEMSTR . " Storage Management","tip",
            "JumpPage.php?Target=getSystemSubPage",0,MRUTreeNodeType::SYSTEM_LEAF);

            $node1Img = "";
            $node1 = new MRUTreeNode("" , "Service", "tip","",
                $hbaId,MRUTreeNodeType::STORAGE_SERVICE_LEAF);

            $node2 = new MRUTreeNode("" , "Device","tip","",
                $hbaId,MRUTreeNodeType::STORAGE_SETTING_LEAF);

            $node3 = new MRUTreeNode("" , "Management","tip","",
                $hbaId,MRUTreeNodeType::MANAGE_SERVICE_LEAF);

        /*$volList = new CtnAccelerateVolumeList();//Hyper HDD Volumes
        $volList->smartyAssign($smarty);
        $volList->initContainer();
        $vols = $volList->getInfos();*/

            $flashServiceSupport = new FlashServiceSupport();
            if ($flashServiceSupport->getFlashServiceSupport()){
                $rootNode->addChild($node1);
                $this->setNodeExpandInfo($node1);
                $this->generateStorageService($node1);
            }

            $rootNode->addChild($node2);
            $this->setNodeExpandInfo($node2);
            $this->generateDevices($node2);

            $rootNode->addChild($node3);
            $this->setNodeExpandInfo($node3);
            $this->generateManagementService($node3);

            //get
            DrawTree($rootNode, $smarty);
        }


        private function generateDevices($parentNode)
        {
            $smarty = $this->smarty;

            $HBAList = new CtnHBAList();
            $HBAList->toGetHBAInfo();
            $HBAList->smartyAssign($smarty);
            $HBAList->initContainer();
            $hbalist = $HBAList->getInfos();

            foreach ($hbalist as $hbaInfo) {
                $hbaId = $hbaInfo->ID;
                $hbaDisplayStr = "Adapter";
                $hbaImage = TreeImg::Adapter;
                if ($hbaInfo->isSSDAdapter) {
                    $hbaDisplayStr = "High Performance PCIe SSD";
                    $hbaImage = TreeImg::SSDAdapter;
                }
                $node =
                new MRUTreeNode($hbaImage , $hbaDisplayStr . " " . $hbaId,
                            "tip",
                    $this->getDetailUrl(Target::getHBADetail . "&ID=" . $hbaId),
                    $hbaId,MRUTreeNodeType::ADAPTER_LEAF);
                $this->setNodeExpandInfo($node);
                $parentNode->addChild($node);
                //$hbasNode->addChild($node);
                if($node->getExpandTypeIndex() != EXPAND_TYPE_UNEXPAND) {
                    if ($hbaInfo->isSSDAdapter) {
                        $this->generateSSDAdapter($hbaId, $node);
                    }else {
                        $this->generateAdapter($hbaId, $node);
                    }
                }
            }

            $SSDAdapterList = new CtnSSDAdapterList();
            $SSDAdapterList->toGetSSDAdapterInfo();
            $SSDAdapterList->smartyAssign($smarty);
            $SSDAdapterList->initContainer();
            $ssdAdapterlist = $SSDAdapterList->getInfos();

            foreach ($ssdAdapterlist as $ssdAdapterInfo) {
                $hbaId = $ssdAdapterInfo->ID;
                $displayStr = "SSD Adapter";
                $hbaImage = TreeImg::Adapter;
                $node =
                new MRUTreeNode($hbaImage , $displayStr . " " . $hbaId,
                            "tip",
                    $this->getDetailUrl(Target::getSSDAdapterDetail . "&ID=" . $hbaId),
                    $hbaId,MRUTreeNodeType::SSD_ADAPTER_LEAF);
                $this->setNodeExpandInfo($node);
                $parentNode->addChild($node);

                if($node->getExpandTypeIndex() != EXPAND_TYPE_UNEXPAND) {
                    $this->generatePlatoSSDAdapter($hbaId, $node);
                }
            }
        }

        private function generatePlatoSSDAdapter($hbaid, $adpNode) {
            $smarty = $this->smarty;

            $hyperSSDList = new CtnHyperSSDList();
            $hyperSSDList->setAdapterID($hbaid);
            $hyperSSDList->toGetHyperSSDInfo();
            $hyperSSDList->smartyAssign($smarty);
            $hyperSSDList->initContainer();
            $hyperSSDs = $hyperSSDList->getInfos();

            if($adpNode->getExpandTypeIndex() == EXPAND_TYPE_EXPAND) {
                foreach ($hyperSSDs as $hyper) {
                    $hyperid = $hyper->ID;

                    $hyperNode = new MRUTreeNode($hyper->HyperImg, "HyperSSD  " . " ". $hyperid, "tip",
                        $this->getDetailUrl(Target::getHyperSSDDetail . "&ID=" . $hyperid . "&HBAID=" . $hbaid), $hyperid,
                        MRUTreeNodeType::HYPER_SSD_LEAF,$hbaid);
                    $this->setNodeExpandInfo($hyperNode);
                    $adpNode->addChild($hyperNode);
                }
            }

        }


        private function generateStorageService($parentNode)
        {
            $smarty = $this->smarty;

            $node1 = new MRUTreeNode(TreeImg::Service , "RAID Service",
                "tip",
                "",
                0,MRUTreeNodeType::RAID_SERVICE_LEAF );
            $this->setNodeExpandInfo($node1);

        /*$node2 = new MRUTreeNode("" , "Flash Service", "tip","",
                        0,MRUTreeNodeType::STORAGE_SERVICE_LEAF);*/

            $node2Str = "HyperDuo Service";
            $SSDAdapterList = new CtnSSDAdapterList();
            $SSDAdapterList->toGetSSDAdapterInfo();
            $SSDAdapterList->smartyAssign($smarty);
            $SSDAdapterList->initContainer();
            $ssdAdapterlist = $SSDAdapterList->getInfos();
            if (sizeof($ssdAdapterlist)) {
                $node2Str = "HyperSSD Service";
            }

            $node2 = new MRUTreeNode(TreeImg::Service , $node2Str,
                                "tip",
                $this->getDetailUrl(Target::getAccelerator),
                0,MRUTreeNodeType::FLASH_SERVICE_LEAF);
            $this->setNodeExpandInfo($node2);

            $parentNode->addChild($node2);

            $node3 = new MRUTreeNode(TreeImg::Service , "SSD Service",
                "tip",
                "",
                0,MRUTreeNodeType::SSD_SERVICE_LEAF);
            $this->setNodeExpandInfo($node3);

            //$parentNode->addChild($node1);
            //$parentNode->addChild($node3);

        /*$this->generateRaidService($node1);
        $this->generateFlashService($node2);
        $this->generateSSDService($node3);*/
            //$this->generateFlashService($node2);

        }

        private function generateFlashService($parentNode)
        {
            $node1 = new MRUTreeNode(TreeImg::Service , "Flash Service",
                "tip",
                $this->getDetailUrl(Target::getAccelerator),
                0,MRUTreeNodeType::FLASH_SERVICE_LEAF);
            $this->setNodeExpandInfo($node1);

            $node2 = new MRUTreeNode(TreeImg::Service , "Create Hyper",
                "tip",
                $this->getDetailUrl(Target::CreateHypper1),
                0,MRUTreeNodeType::CREATE_HYPPER_LEAF);
            $this->setNodeExpandInfo($node2);

            $parentNode->addChild($node1);
            $parentNode->addChild($node2);
        }

        private function generateStorageSetting($parentNode)
        {
            $node1 = new MRUTreeNode("" , "RAID Setting",
                "tip",
                "",
                0,MRUTreeNodeType::RAID_SETTING_LEAF );
            $this->setNodeExpandInfo($node1);

            $node2 = new MRUTreeNode("" , "Flash Setting",
                "tip",
                "",
                0,MRUTreeNodeType::FLASH_SETTING_LEAF);
            $this->setNodeExpandInfo($node2);

            $parentNode->addChild($node1);
            $parentNode->addChild($node2);

            $this->generateRaidSetting($node1);
            //$this->generateFlashSetting($node2);

        }

        private function generateStorageDevice($parentNode)
        {
            $node1 = new MRUTreeNode("" , "RAID Device",
                "tip",
                "",
                0,MRUTreeNodeType::RAID_DEVICE_LEAF );
            $this->setNodeExpandInfo($node1);

            $node2 = new MRUTreeNode("" , "Flash Device",
                "tip",
                "",
                0,MRUTreeNodeType::FLASH_DEVICE_LEAF );
            $this->setNodeExpandInfo($node2);

            $node3 = new MRUTreeNode("" , "SSD Device",
                "tip",
                "",
                0,MRUTreeNodeType::FLASH_DEVICE_LEAF );
            $this->setNodeExpandInfo($node3);

            $parentNode->addChild($node1);
            $parentNode->addChild($node2);
            $parentNode->addChild($node3);

            $this->generateRaidDevice($node1);
            //$this->generateFlashDevice($node2);

        }

        private function generateManagementService($parentNode)
        {
            $node1 = new MRUTreeNode(TreeImg::Acount, "Account Management",
                "tip",
                $this->getDetailUrl(Target::AccountPage1),
                0,MRUTreeNodeType::ACCOUNT_MANAGER_LEAF );
            $this->setNodeExpandInfo($node1);
            $parentNode->addChild($node1);
						if(constant('MAC_LOCAL_MAIL_SUPPORT') == 0){
            $node2 = new MRUTreeNode(TreeImg::Email, "Email Notify Setting",
                "tip",
                $this->getDetailUrl(Target::EmailSettingPage),
                0,MRUTreeNodeType::EMAIL_SETTING_LEAF );
            $this->setNodeExpandInfo($node2);

            $parentNode->addChild($node2);
          	}

            $SysDtl = new CtnSystemDetail();
            $SysDtl->toGetAPIVer();
            $SysDtl->toGetSysInfo();
            $SysDtl->smartyAssign($this->smarty);
            $SysDtl->initContainer();
            $sysInfo = $SysDtl->getBase()->getBaseClasses();
            if ($sysInfo && $sysInfo[0]->getScheduleSupport()) {
                $node3 = new MRUTreeNode(TreeImg::Schedule , "BGA Schedule Setting",
                    "tip",
                    $this->getDetailUrl(Target::BgaSchedulePage),
                    0,MRUTreeNodeType::SCHEDULE_SETTING_LEAF);
                $this->setNodeExpandInfo($node3);
                $parentNode->addChild($node3);
            }

        }

        private function generateManagementLog($parentNode)
        {

        }

        private function generateRaidSetting($parentNode)
        {
            $smarty = $this->smarty;
            //add adapter...
            $HBAList = new CtnHBAList();
            $HBAList->toGetHBAInfo();
            $HBAList->smartyAssign($smarty);
            $HBAList->initContainer();
            $hbalist = $HBAList->getInfos();
            //
            //		$hbasNode = new MRUTreeNode("" ,"Adapters","tip","",0,MRUTreeNodeType::ADAPTER_TITLE_LEAF);
            //		$rootNode->addChild($hbasNode);
            //		$this->setNodeExpandInfo($hbasNode);
            //		if (! $hbalist) {
            //			$hbasNode->cannotExpand();
            //		}
            //
            //		if($hbasNode->getExpandTypeIndex() == EXPAND_TYPE_EXPAND)
            //		{
            foreach ($hbalist as $hbaInfo)
            {
                $hbaId = $hbaInfo->ID;
                $hbaDisplayStr = "Adapter";
                $hbaImage = TreeImg::Adapter;

                $node =
                new MRUTreeNode($hbaImage , $hbaDisplayStr . " " . $hbaId,
                        "tip",
                    $this->getDetailUrl(Target::getHBADetail . "&ID=" . $hbaId),
                    $hbaId,MRUTreeNodeType::ADAPTER_LEAF);
                $this->setNodeExpandInfo($node);
                $parentNode->addChild($node);
                //$hbasNode->addChild($node);
                if($node->getExpandTypeIndex() != EXPAND_TYPE_UNEXPAND)
                {
                    $this->generateAdapterVirtualDevice($hbaId, $node);
                }
            }
            //		}

        }

        private function generateAdapterVirtualDevice($hbaid, $adpNode)
        {

            $smarty = $this->smarty;

            $adpFeature = AdapterFeature::getInstance($hbaid);
            if($adpFeature->supportRAID) {
                if($adpFeature->supportDG)
                {
                    $this->generateDG($hbaid, $adpNode);
                    $this->generateForeignVD($hbaid, $adpNode);
                }
                else
                {
                    $this->generateVDOnly($hbaid, $adpNode);
                }
            }
        }

        private function generateFlashSetting($parentNode)
        {
            $smarty = $this->smarty;
            //add adapter...
            $HBAList = new CtnHBAList();
            $HBAList->toGetHBAInfo();
            $HBAList->smartyAssign($smarty);
            $HBAList->initContainer();
            $hbalist = $HBAList->getInfos();

            foreach ($hbalist as $hbaInfo)
            {
                $hbaId = $hbaInfo->ID;
                $hbaDisplayStr = "Adapter";
                $hbaImage = TreeImg::Adapter;
                if ($hbaInfo->isSSDAdapter){
                    $hbaDisplayStr = "High Performance PCIe SSD";
                    $hbaImage = TreeImg::SSDAdapter;
                }
                $node =
                new MRUTreeNode($hbaImage , $hbaDisplayStr . " " . $hbaId,
                    "tip",
                    "",
                    $hbaId,MRUTreeNodeType::ADAPTER_LEAF);
                $this->setNodeExpandInfo($node);
                $parentNode->addChild($node);

            }

        }

        private function generateSSDService($parentNode)
        {

        }

        private function generateRaidDevice($parentNode)
        {
            //add adapter...
            $HBAList = new CtnHBAList();
            $HBAList->toGetHBAInfo();
            $HBAList->smartyAssign($this->smarty);
            $HBAList->initContainer();
            $hbalist = $HBAList->getInfos();

            foreach ($hbalist as $hbaInfo)
            {
                $hbaId = $hbaInfo->ID;
                $hbaDisplayStr = "Adapter";
                $hbaImage = TreeImg::Adapter;

                $adpNode =
                new MRUTreeNode($hbaImage , $hbaDisplayStr . " " . $hbaId,
                        "tip",
                    $this->getDetailUrl(Target::getHBADetail . "&ID=" . $hbaId),
                    $hbaId,MRUTreeNodeType::ADAPTER_LEAF);
                $this->setNodeExpandInfo($adpNode);
                $parentNode->addChild($adpNode);

                $this->generateHD($hbaId,$adpNode);
                $this->generateEncl($hbaId,$adpNode);

            }

        }

        private function generateHD($hbaid,$parentNode)
        {
            // Physical Device
            $smarty = $this->smarty;

            $hdList = new CtnHdList();
            $hdList->setAdapterID($hbaid);
            $hdList->toGetHdInfo();
            $hdList->toGetHdFreeInfo();
            $hdList->toGetSpareInfo();
            $hdList->smartyAssign($smarty);
            $hdList->initContainer();
            $hds = $hdList->getInfos();

            $hds = $this->sortHDByPortId($hds);

            foreach ($hds as $hd)
            {
                $pdid = $hd->ID;
                $portId = $hd->ParentPhyID;
                $nodeStr = "Physical Disk: ";

                $parentDev = $hd->ParentTypeInt;
                $parentId = $hd->ParentID;
                if ($parentDev == DeviceType::DEVICE_TYPE_PORT ) {
                    $nodeStr .= "port ". $portId;
                } elseif ($parentDev == DeviceType::DEVICE_TYPE_EXPANDER) {
                    $nodeStr .= "Exp " . $parentId . " port " . $portId;
                } elseif ($parentDev == DeviceType::DEVICE_TYPE_ENCLOSURE ) {
                    $nodeStr .= "Encl " . $parentId . " port " . $portId;
                } elseif ($parentDev == DeviceType::DEVICE_TYPE_PM  ) {
                    $nodeStr .= "PM " . $parentId . " port " . $portId;
                }

                $hdNode = new MRUTreeNode($hd->HDImg, $nodeStr, "tip",
                    $this->getDetailUrl(Target::getHdDetail . "&ID=" . $pdid . "&HBAID=" . $hbaid), $pdid,
                    MRUTreeNodeType::HD_LEAF,$hbaid);
                $this->setNodeExpandInfo($hdNode);
                $parentNode->addChild($hdNode);
            }

        }

        private function generateEncl($hbaid,$parentNode)
        {
            //Enclosure
            $encList = new CtnEnclList();
            $encList->setAdapterID($hbaid);
            $encList->toGetEnclInfo();
            $encList->toGetEnclPMInfo();
            $encList->toGetEnclExpanderInfo();
            $encList->smartyAssign($this->smarty);
            $encList->initContainer();
            $enclosures = $encList->getInfos();

            if (sizeof($enclosures)) {
                foreach ($enclosures as $enc)
                {
                    $encid = $enc->ID;
                    if ($encid != 0xFFFF)
                    {
                        $encNode = new MRUTreeNode(TreeImg::Enclosure , "Enclosure" . " ". $encid, "tip",
                            $this->getDetailUrl(Target::getEnclDetail . "&ID=" . $encid . "&HBAID=" . $hbaid), $encid,
                            MRUTreeNodeType::ENC_LEAF,$hbaid);
                        $this->setNodeExpandInfo($encNode);
                        $parentNode->addChild($encNode);
                    }
                    else
                    {
                        if ($enc->hasExpander){
                            $encNode = new MRUTreeNode(TreeImg::Expander , "Expanders", "tip",
                                $this->getDetailUrl(Target::getExpandersWithoutEncl . "&HBAID=" . $hbaid), $encid,
                                MRUTreeNodeType::EXP_LEAF,$hbaid);
                            $this->setNodeExpandInfo($encNode);
                            $parentNode->addChild($encNode);
                        }
                        if ($enc->hasPM){
                            $encNode = new MRUTreeNode(TreeImg::PM , "Port Multipliers", "tip",
                                $this->getDetailUrl(Target::getPMsWithoutEncl . "&HBAID=" . $hbaid), $encid,
                                MRUTreeNodeType::PM_LEAF,$hbaid);
                            $this->setNodeExpandInfo($encNode);
                            $parentNode->addChild($encNode);
                        }
                    }
                }
            }
        }

        private function getDetailUrl($paras)
        {
            //return "$paras";
            return PHPPageName::TargetPageName . "?Target=" . $paras;
        }
    }

    ?>