<?php
class ExpanderDevice extends SASDevice 
{
	private $AdapterID;
	private $Configuring;
	private $RouteTableConfigurable;
	private $PhyCount;
	private $ExpChangeCount;
	private $MaxRouteIndexes;
	private $VendorID;
	private $ProductID;
	private $ProductRev;
	private $ComponentVendorID;
	private $ComponentID;
	private $ComponentRevisionID;
	
	private $EnclosureID;
	private $Enclosure;
	
	public function __construct()
	{
		$this->setDevType(DeviceType::DEVICE_TYPE_EXPANDER);
	}
	
	public function isSAS()
	{
		return true;
	}

	public function setEnclosure($enc)
	{
		$this->Enclosure = $enc;
	}

    public function getEnclosure()
    {
        return $this->Enclosure;
    }
	//public function setDeviceID()
	//{
		
	//}
	
	public function setAdapterID($AdapterID)
	{
		$this->AdapterID = $AdapterID;
	}
	public function getAdapterID()
	{
		return $this->AdapterID;
	}
	
	public function setConfiguring($Configuring)
	{
		$this->Configuring = $Configuring;
	}
	public function getConfiguring()
	{
		return $this->Configuring;
	}
	
	public function setRouteTableConfigurable($RouteTableConfigurable)
	{
		$this->RouteTableConfigurable = $RouteTableConfigurable;
	}
	public function getRouteTableConfigurable()
	{
		return $this->RouteTableConfigurable;
	}
	
	public function setPhyCount($PhyCount)
	{
		$this->PhyCount = $PhyCount;
	}
	public function getPhyCount()
	{
		return $this->PhyCount;
	}
	
	public function setExpChangeCount($ExpChangeCount)
	{
		$this->ExpChangeCount = $ExpChangeCount;
	}
	public function getExpChangeCount()
	{
		return $this->ExpChangeCount;
	}
	
	public function setMaxRouteIndexes($MaxRouteIndexes)
	{
		$this->MaxRouteIndexes = $MaxRouteIndexes;
	}
	public function getMaxRouteIndexes()
	{
		return $this->MaxRouteIndexes;
	}
	
	public function setVendorID($VendorID)
	{
		$this->VendorID = $VendorID;
	}
	public function getVendorID()
	{
		return $this->VendorID;
	}
	
	public function setProductID($ProductID)
	{
		$this->ProductID = $ProductID;
	}
	public function getProductID()
	{
		return $this->ProductID;
	}
	
	public function setProductRev($ProductRev)
	{
		$this->ProductRev = $ProductRev;
	}
	public function getProductRev()
	{
		return $this->ProductRev;
	}
	
	public function setComponentVendorID($ComponentVendorID)
	{
		$this->ComponentVendorID = $ComponentVendorID;
	}
	public function getComponentVendorID()
	{
		return $this->ComponentVendorID;
	}
	
	public function setComponentID($ComponentID)
	{
		$this->ComponentID = $ComponentID;
	}
	public function getComponentID()
	{
		return $this->ComponentID;
	}
	
	public function setComponentRevisionID($ComponentRevisionID)
	{
		$this->ComponentRevisionID = $ComponentRevisionID;
	}
	public function getComponentRevisionID()
	{
		return $this->ComponentRevisionID;
	}
	
	public function setEnclosureID($EnclosureID)
	{
		$this->EnclosureID = $EnclosureID;
	}
	
	public function getEnclosureID()
	{
		return $this->EnclosureID;
	}
	
	public function setExpanderInfo($Info)
	{
		
		foreach ($Info->Link as $Link)
		{
			$this->setTopologyLink($Link);
		}
		
		foreach ($Info->Link as $Link)
		{
			foreach ($Link->Self as $self)
			{
				if (isset($self->EnclosureID)) {
					$this->EnclosureID = trim($self->EnclosureID);
				}
			}
		}
		
		if(isset($Info->AdapterID))
		{
			$this->AdapterID = trim($Info->AdapterID);
		}
		if(isset($Info->Configuring))
		{
			$this->Configuring = trim($Info->Configuring);
		}
		if(isset($Info->RouteTableConfigurable))
		{
			$this->RouteTableConfigurable = trim($Info->RouteTableConfigurable);
		}
		if(isset($Info->PhyCount))
		{
			$this->PhyCount = trim($Info->PhyCount);
		}
		if(isset($Info->ExpChangeCount))
		{
			$this->ExpChangeCount = trim($Info->ExpChangeCount);
		}
		if(isset($Info->MaxRouteIndexes))
		{
			$this->MaxRouteIndexes = trim($Info->MaxRouteIndexes);
		}
		if(isset($Info->VendorID))
		{
			$this->VendorID = (trim($Info->VendorID));
		}
		if(isset($Info->ProductID))
		{
			$this->ProductID = (trim($Info->ProductID));
		}
		if(isset($Info->ProductRev))
		{
			$this->ProductRev = (trim($Info->ProductRev));
		}
		if(isset($Info->ComponentVendorID))
		{
			$this->ComponentVendorID = dechex(trim($Info->ComponentVendorID));
		}
		if(isset($Info->ComponentID))
		{
			$this->ComponentID = dechex(trim($Info->ComponentID));
		}
		if(isset($Info->ComponentRevisionID))
		{
			$this->ComponentRevisionID = (trim($Info->ComponentRevisionID));
		}
	}
}
?>