//bga listen used to run bga percentage from 1% to 99%. ie can not set td.width 0%
//bga use td.width to show percentage. any string display in process bar will devide with percentage and add to td.
var BGAListen = new Object();

BGAListen.aLDIDs = new Array();
BGAListen.aTables = new Array();
BGAListen.arrayLength = 0;
BGAListen.xml = null;
BGAListen.canRefresh = true;

//draw BGA LD percentage
BGAListen.drawLDBGA=function(oTable,sBga,sBgaState,iPercentage)
{
    if (iPercentage < 1) {
        iPercentage = 1;
    }
    if (iPercentage > 99) {
        iPercentage = 99;
    }
    var sCaption;
    if (sBgaState.match("0"))
        sCaption = sBga+" "+iPercentage + "%";
    else
        sCaption = sBga+" "+sBgaState + " "+iPercentage + "%";
    var iLeft = Math.round(sCaption.length * iPercentage / 100);
    var oLeftTD = oTable.firstChild.firstChild.childNodes.item(0);
    oLeftTD.firstChild.nodeValue = sCaption.substr(0,iLeft);
    oLeftTD.width = "" + iPercentage + "%";
    var oRightTD = oTable.cfirstChild.firstChild.childNodes.item(1);
    oRightTD.width = "" + (100-iPercentage) + "%";
    oRightTD.firstChild.nodeValue = sCaption.substr(iLeft);
}

//add LD id which has BGA action
BGAListen.addListen = function(sLDID,oTable,sBga,sBgaState,iPercentage)
{
    if (oTable.tagName=="TABLE")
    {
        BGAListen.aLDIDs[BGAListen.arrayLength] = sLDID;
        BGAListen.aTables[BGAListen.arrayLength] = oTable;
        BGAListen.arrayLength++;
        BGAListen.drawLDBGA(oTable,sBga,sBgaState,iPercentage);
    }
}

BGAListen.removeListen = function(sLDID)
{
    var i;
    for (i=0;i<BGAListen.arrayLength;i++)
    {
        if (sLDID == BGAListen.aLDIDs[i])
        {
            BGAListen.arrayLength--;
            BGAListen.aLDIDs[i]=null;
            BGAListen.aLDIDs = BGAListen.aLDIDs.splice(i,1);
            BGAListen.aTables[i]=null;
            BGAListen.aTables = BGAListen.aTables.splice(i,1);
            break;
        }
    }
}

//change BGA LD percentage
BGAListen.changeLDBGA=function(sLDID,sBga,sBgaState,iPercentage)
{
    for(var i=0;i<BGAListen.arrayLength;i++)
    {
        if (BGAListen.aLDIDs[i]==sLDID)
        {
            var oObject = BGAListen.aTables[i];
            if (sBga.match("0") && oObject.tagName=="TABLE")
            {
                BGAListen.removeListen(sLDID);
                oObject.parentNode.replaceChild(textFactory.getNewOne(),oObject);
                bgaFactory.returnBack(oObject);
            }
            else
            {
                BGAListen.drawLDBGA(oObject,sBga,sBgaState,iPercentage);
            }
            break;
        }
    }
}

BGAListen.setXMLresult = function()
{
    var sLDID,sBga,iPercentage,sBgaState;
    var i;
    ScriptDebug.writeLine(BGAListen.canRefresh);
    if (BGAListen.xml != null && BGAListen.canRefresh)
    {
        BGAListen.canRefresh = false;
        var LDXMLs=BGAListen.xml.responseXML.getElementsByTagName("LDInfo");
        for (i = 0;i<LDXMLs.length;i++)
        {
            sLDID=LDXMLs[i].getElementsByTagName("ID")[0].firstChild.nodeValue;
            sBga = LDXMLs[i].getElementsByTagName("Bga")[0].firstChild.nodeValue;
            iPercentage=parseInt(LDXMLs[i].getElementsByTagName("BgaPercentage")[0].firstChild.nodeValue);
            sBgaState = LDXMLs[i].getElementsByTagName("BgaState")[0].firstChild.nodeValue;
            if (!sBga.match("0"))
            {
                BGAListen.changeLDBGA(sLDID,sBga,sBgaState,iPercentage);
            }
            else
            {
                BGAListen.changeLDBGA(sLDID,"0","0",0);
            }
        }
        BGAListen.canRefresh = true;
    }
    ContentLoader.returnBack(BGAListen.xml);
}

BGAListen.loop = function()
{
    if (BGAListen.arrayLength > 0)
    {
        var urlPath = "command.php?ra="+RefreshControl.getSeq()+"&function=getLdList";
        ContentLoader.loadXMLDoc(BGAListen,urlPath);
    }
}