/*
 * Decompiled with CFR 0.152.
 */
package packaging;

import binTools.BinWriter;
import binTools.Common;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PdtPackage {
    private static final int DONT_CARE_VALUE = -1;
    public static int FIRST_HEADER = -1;
    public static String SECOND_HEADER = "MPDT";
    private ArrayList<PdtEntry> _pdtEntries = new ArrayList();
    private boolean _exportXml = false;

    public void writePackage(String path) {
        BinWriter writer = new BinWriter(true);
        try {
            writer.writeNewField("FirstHeader", 4, FIRST_HEADER, (Node)writer.getHeadElement());
            writer.writeNewField("SecondHeader", 4, SECOND_HEADER, (Node)writer.getHeadElement());
            Common.Field totalSize = writer.writeNewField("TotalSize", 4, 0, (Node)writer.getHeadElement());
            int fileNum = 1;
            for (PdtEntry pdt : this._pdtEntries) {
                Element pdtFileElement = writer.writeNewField((String)new StringBuilder().append((String)"PdtFile").append((int)fileNum++).toString(), (Node)writer.getHeadElement()).xmlElement;
                if (this._pdtEntries.size() > 1) {
                    writer.writeNewField("NumberOfPlatformIds", 4, pdt.platformIds.size(), (Node)pdtFileElement);
                    int i = 1;
                    for (Integer platformId : pdt.platformIds) {
                        writer.writeNewField("PlatformId" + i++, 4, platformId, (Node)pdtFileElement);
                    }
                } else {
                    writer.writeNewField("NumberOfPlatformIds", 4, 1, (Node)pdtFileElement);
                    writer.writeNewField("PlatformId", 4, -1, (Node)pdtFileElement);
                }
                int zeroPaddingSize = (4 - pdt.content.length % 4) % 4;
                int size = zeroPaddingSize + pdt.content.length;
                writer.writeNewField("Size", 4, size, (Node)pdtFileElement);
                writer.writeNewField("PdtFileContent", pdtFileElement);
                byte[] zeroPadding = new byte[zeroPaddingSize];
                writer.writeBinarydata(pdt.content);
                writer.writeBinarydata(zeroPadding);
            }
            writer.updateData(totalSize, writer.getBinarySize());
            writer.createBin(path);
            System.out.println("The PDT package has been created successfuly at '" + path + "'.");
            if (this._exportXml) {
                writer.exportXML(path + ".xml");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void buildPackage(String defXmlPath) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            File defXml = new File(defXmlPath);
            Document defXmlDoc = dBuilder.parse(defXml);
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression xpr = xpath.compile("//pdtPackage/PdtFile");
            NodeList pdtFiles = (NodeList)xpr.evaluate(defXmlDoc, XPathConstants.NODESET);
            for (int i = 0; i < pdtFiles.getLength(); ++i) {
                if (pdtFiles.item(i).getNodeType() != 1 || !pdtFiles.item(i).getNodeName().equals("PdtFile")) continue;
                Element pdtFileElement = (Element)pdtFiles.item(i);
                ArrayList<Integer> platformIds = new ArrayList<Integer>();
                NodeList platformIdElements = pdtFileElement.getChildNodes();
                for (int j = 0; j < platformIdElements.getLength(); ++j) {
                    int platformIdVal;
                    if (platformIdElements.item(j).getNodeType() != 1 || !platformIdElements.item(j).getNodeName().equals("PlatformId")) continue;
                    Element platformIdElement = (Element)platformIdElements.item(j);
                    try {
                        platformIdVal = Integer.valueOf(platformIdElement.getTextContent());
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Invalid platfrom ID: " + platformIdElement.getTextContent());
                        e.printStackTrace();
                        return;
                    }
                    platformIds.add(platformIdVal);
                }
                String pdtPath = pdtFileElement.getAttribute("PdtPath");
                this.addPdt(platformIds, pdtPath);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public void addPdt(ArrayList<Integer> platformIds, String filePath) {
        byte[] content;
        for (PdtEntry entry : this._pdtEntries) {
            for (Integer platformId : entry.platformIds) {
                if (!platformIds.contains(platformId)) continue;
                throw new RuntimeException("All platform ids must be different. Duplicated id: " + platformId);
            }
        }
        Path path = Paths.get(filePath, new String[0]);
        try {
            content = Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
        PdtEntry entry = new PdtEntry();
        entry.platformIds = platformIds;
        entry.content = content;
        this._pdtEntries.add(entry);
    }

    public void setExportXml(boolean export) {
        this._exportXml = export;
    }

    private static class PdtEntry {
        ArrayList<Integer> platformIds;
        byte[] content;

        private PdtEntry() {
        }
    }
}

