/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.XmlExporter;
import com.intel.sensing.fdk.model.dao.DaoFactory;
import com.intel.sensing.fdk.model.dao.ProjectDao;
import com.intel.sensing.fdk.model.dao.SelectedSensorsDao;
import com.intel.sensing.fdk.model.entity.ProjectEntity;
import com.intel.sensing.fdk.model.entity.SelectedItemsDataEntity;
import com.intel.sensing.fdk.model.entity.SelectedSensorsEntity;
import com.intel.sensing.fdk.model.entity.SensorDataEntity;
import com.intel.sensing.fdk.model.utils.ISSProjectUtils;
import dbgConfig.DbgConfig;
import entity.SensorEntity;
import entity.SensorEntityUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.TransformerException;
import manager.sensor.SensorData;
import manager.sensor.SensorDataManager;
import manager.utils.ManagerEnums;
import org.w3c.dom.Node;
import packaging.NvarPackage;
import pdtEditor.Device;
import pdtEditor.Logger;
import pdtEditor.Luid;
import pdtEditor.PDTExternalInfo;
import pdtEditor.PdtFile;
import pdtEditor.PdtReader;
import pdtEditor.PdtWriter;
import pdtEditor.Sensor;

public class DataStore {
    private static DataStore _instance = null;
    public static final int MIN_SUPPORTED_PDT_VERSION = 0;
    public static final int MAX_SUPPORTED_PDT_VERSION = 5;
    public static final int PDT_CURRENT_FORMAT_VERSION = 5;
    public static final int SENSOR_INFO_PDT_TYPE = 1;
    private static final String PDT_CONTENT_XML_FILE_NAME = "PDT_content.xml";
    private DbgConfig _dbgConfig;
    private ArrayList<PdtFile> _pdtFiles = new ArrayList();
    private PdtFile _currentPdtFile = null;
    private ArrayList<Sensor> _globalSensors = null;
    private int _pdtFormatVersion = 5;
    private Device _currentDevice = null;
    private File _xmlOutFile = null;
    private Integer _lastCheckedPdtVersion = null;
    private RunType _runType = RunType.STAND_ALONE;
    private ManagerEnums.ExecutionEnvironments _fdkExcutionEnv = null;
    private PDTExternalInfo _externalInfo = null;

    public static DataStore getInstance() {
        if (_instance == null) {
            _instance = new DataStore();
        }
        return _instance;
    }

    private DataStore() {
        this._globalSensors = new ArrayList();
        this.clearData();
    }

    public void initPDTExternalInfo(String xmlPath) {
        if (this._externalInfo == null) {
            this._externalInfo = new PDTExternalInfo();
        }
        if (xmlPath != null) {
            this._externalInfo.setPdtExternalInfoDocPath(xmlPath);
        }
    }

    public PDTExternalInfo getPDTExternalInfo() {
        return this._externalInfo;
    }

    public int getPdtFormatVersion() {
        return this._pdtFormatVersion;
    }

    public void setPdtFormatVersion(int version, FlowResults flowRes) {
        if (version > this._pdtFormatVersion) {
            Logger.instance().log("Upgrading the PDT from format " + this._pdtFormatVersion + " to format " + version + ".");
            for (PdtFile pdtFile : this._pdtFiles) {
                if (flowRes == null) {
                    flowRes = new FlowResults();
                }
                pdtFile.onPdtFormatVersionUpdate(this._pdtFormatVersion, version, flowRes);
            }
            if (flowRes != null) {
                Logger.instance().log("PDT format complete" + (flowRes.hasErrors ? ", but there were errors." : (flowRes.hasWarnings ? ", but there were warnings." : "d successfully.")));
            }
        }
        this._pdtFormatVersion = version;
    }

    public boolean isPdtFormatVersionSupportEditing() {
        return this.getPdtFormatVersion() == 5;
    }

    public ArrayList<PdtFile> getPdtFiles() {
        return this._pdtFiles;
    }

    public void setCurrentPdtFile(PdtFile pdtFile) {
        this._currentPdtFile = pdtFile;
    }

    public PdtFile getCurrentPdtFile() {
        return this._currentPdtFile;
    }

    public PdtFile getPdtOfDevice(Device device) {
        for (PdtFile pdtFile : this._pdtFiles) {
            if (!pdtFile.hasDevice(device)) continue;
            return pdtFile;
        }
        return null;
    }

    public boolean addPdtFile(PdtFile pdtFile) {
        boolean newPdtFile = false;
        if (!this._pdtFiles.contains(pdtFile)) {
            this._pdtFiles.add(pdtFile);
            newPdtFile = true;
        }
        this.setCurrentPdtFile(pdtFile);
        return newPdtFile;
    }

    public void removePdtFile(PdtFile pdtFile) {
        this._pdtFiles.remove(pdtFile);
        this.setCurrentPdtFile(null);
    }

    public void removeDuplicatedGlobalSensors() {
        ArrayList<Sensor> sensors = new ArrayList<Sensor>();
        for (Sensor sensor : this._globalSensors) {
            sensors.add(sensor);
        }
        this._globalSensors.clear();
        for (Sensor sensor : sensors) {
            if (this._globalSensors.contains(sensor)) continue;
            this._globalSensors.add(sensor);
        }
    }

    public ArrayList<Sensor> getGlobalSensors() {
        this.removeDuplicatedGlobalSensors();
        return this._globalSensors;
    }

    public ArrayList<Device> getDevicesOfSensor(Sensor sensor) {
        ArrayList<Device> res = new ArrayList<Device>();
        for (Device device : this.getDevices()) {
            if (!device.getSensors().contains(sensor)) continue;
            res.add(device);
        }
        return res;
    }

    public void replaceSensor(Sensor oldSensor, Sensor newSensor) {
        if (this._globalSensors.contains(oldSensor)) {
            this._globalSensors.set(this._globalSensors.lastIndexOf(oldSensor), newSensor.clone());
        }
        for (PdtFile pdtFile : this._pdtFiles) {
            pdtFile.replaceSensor(oldSensor, newSensor);
        }
    }

    public void addGlobalSensor(Sensor sensor) {
        if (this._globalSensors.contains(sensor)) {
            return;
        }
        this._globalSensors.add(sensor);
    }

    public ArrayList<Device> getDevices() {
        ArrayList<Device> devices = new ArrayList<Device>();
        for (PdtFile pdtFile : this._pdtFiles) {
            devices.addAll(pdtFile.getDevices());
        }
        return devices;
    }

    public ArrayList<Device> getDevicesOfCurrentPdt() {
        if (this._currentPdtFile == null) {
            return this.getDevices();
        }
        return this._currentPdtFile.getDevices();
    }

    public static Node getChildNodeByName(Node parent, String name) {
        Node curr = parent.getFirstChild();
        while (true) {
            if (curr.getNodeName().equals(name)) {
                return curr;
            }
            Node nextSibil = curr.getNextSibling();
            if (nextSibil == null) break;
            curr = nextSibil;
        }
        throw new RuntimeException("corrupted XML file: Missing " + name + " Tag.");
    }

    public void checkPDTFormatVersion(int version) {
        if (version < 0 || version > 5) {
            String supportedFormatsText = Integer.compare(0, 5) == 0 ? " 0" : "s 0 through 5";
            throw new UnsupportedOperationException("This editor only supports PDT files of format version" + supportedFormatsText + ". The selected file either is not a PDT file or is in the unrecognized format version " + version + ".");
        }
        if (this._lastCheckedPdtVersion != null && version != this._lastCheckedPdtVersion) {
            throw new UnsupportedOperationException("All the PDT files must have the same format version.");
        }
        this._lastCheckedPdtVersion = version;
    }

    public int addDevice(Device device) {
        this._currentPdtFile.addDevice(device);
        if (this._currentPdtFile.getDevices().size() == 1) {
            this._currentDevice = this._currentPdtFile.getDevices().get(0);
        }
        return this._currentPdtFile.getDevices().size() - 1;
    }

    public int addDevice(PdtFile pdt, Device device) {
        this._currentPdtFile = pdt;
        return this.addDevice(device);
    }

    public ArrayList<Sensor> getAllPhysicalSensors() {
        ArrayList<Sensor> res = new ArrayList<Sensor>();
        if (this.getCurrentDevice() != null) {
            res.addAll(this.getCurrentDevice().getPhysicalSensors());
        }
        return res;
    }

    public ArrayList<Sensor> getAllAlgorithms() {
        ArrayList<Sensor> res = new ArrayList<Sensor>();
        if (this.getCurrentDevice() != null) {
            res.addAll(this.getCurrentDevice().getAlgorithms());
        }
        return res;
    }

    public boolean isSensorExists(Luid luid) {
        for (Device device : this.getDevices()) {
            ArrayList<Sensor> sensors = device.getSensors();
            for (Sensor sensor : sensors) {
                if (!sensor.getLuid().equals(luid)) continue;
                return true;
            }
        }
        return false;
    }

    public void setCurrentDevice(Device device) {
        this._currentDevice = device;
    }

    public void setCurrentDevice(int position) {
        this._currentDevice = position < 0 ? null : this._currentPdtFile.getDevices().get(position);
    }

    public Device createNewDefaultDevice() {
        return this._currentPdtFile.getDevices().get(this.addDevice(new Device(Device.DeviceDefaults.INTEL_BASELINE_SENSORS.productID, Device.DeviceDefaults.INTEL_BASELINE_SENSORS.vendorID, 1, 0, this)));
    }

    public Device getCurrentDevice() {
        if (this._currentDevice == null) {
            if (this._currentPdtFile.getDevices().size() == 0) {
                this._currentDevice = this.createNewDefaultDevice();
            } else {
                this._currentPdtFile.getDevices().get(0);
            }
        }
        return this._currentDevice;
    }

    public void removeDevice(int position) {
        this._currentPdtFile.getDevices().remove(position);
    }

    public void clearData() {
        this._currentDevice = null;
        this._globalSensors.clear();
        for (PdtFile pdtfile : this._pdtFiles) {
            try {
                if (pdtfile.getPath() == null) continue;
                pdtfile.unlock();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        this._pdtFiles.clear();
        this.setCurrentPdtFile(null);
        this._pdtFormatVersion = 5;
        this._lastCheckedPdtVersion = null;
        this._dbgConfig = null;
        this._xmlOutFile = null;
    }

    public void setXmlDestPath(File file) {
        this._xmlOutFile = file;
    }

    public void exportPdtXml(XmlExporter exporter) throws TransformerException {
        if (this._xmlOutFile != null) {
            if (this._xmlOutFile.isDirectory()) {
                if (this._xmlOutFile.exists()) {
                    exporter.exportXML(this._xmlOutFile.getPath() + File.separator + PDT_CONTENT_XML_FILE_NAME);
                }
            } else {
                exporter.exportXML(this._xmlOutFile.getAbsolutePath());
            }
        }
    }

    private void loadPdtContent(PdtFile pdtFile, BinReader reader) throws TransformerException {
        byte pdtFormatVersion = reader.getSubFile(0, 1, null, null)[0];
        this.checkPDTFormatVersion(pdtFormatVersion);
        PdtReader pdtReader = new PdtReader(reader, pdtFile);
        try {
            pdtReader.parsePdtContent();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.exportPdtXml(reader);
        }
    }

    public void loadFromPdtBin(PdtFile pdtFile, byte[] content) throws IOException {
        pdtFile.unlock();
        pdtFile.accessAttempt();
        boolean newPdt = this.addPdtFile(pdtFile);
        try {
            BinReader reader = new BinReader(true, "ISH");
            if (content != null) {
                reader.setBinary(content);
            } else {
                reader.loadBinary(pdtFile.getPath());
            }
            pdtFile.lock();
            this.loadPdtContent(pdtFile, reader);
        }
        catch (UnsupportedOperationException e) {
            if (newPdt) {
                this.removePdtFile(pdtFile);
            }
            throw e;
        }
        catch (Exception e) {
            if (newPdt) {
                this.removePdtFile(pdtFile);
            }
            throw new RuntimeException(e);
        }
        if (pdtFile.getDevices().size() > 0) {
            this.setCurrentDevice(0);
        }
    }

    public void loadFromPdtBin(PdtFile pdtFile) throws IOException {
        this.loadFromPdtBin(pdtFile, null);
    }

    public void loadDebugConfig(DbgConfig dbgConf) throws UnsupportedOperationException {
        System.out.println("Loading debug configurations...");
        try {
            dbgConf.readDbgConfig(dbgConf.readFile());
            this.setDbgConfigData(dbgConf);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("Cannot load and parse the debug configurations file.");
        }
    }

    public void setNVARPackageXml(String NvarPackagePath) {
        File inputForXmlExportFile = new File(NvarPackagePath);
        File xmlDirectory = new File(inputForXmlExportFile.getPath() + "_XML_files");
        xmlDirectory.mkdir();
        this.setXmlDestPath(xmlDirectory);
    }

    public void loadNVARPAckage(String path) throws IOException, TransformerException {
        NvarPackage nvarPackage = new NvarPackage();
        nvarPackage.setBinPath(path);
        nvarPackage.readNvarPackage();
        byte[] pdtContent = nvarPackage.getPdtContent();
        byte[] traceConfigContent = nvarPackage.getDebugConfContent();
        if (pdtContent != null) {
            PdtFile newPdtFile = new PdtFile(path);
            this.loadFromPdtBin(newPdtFile, pdtContent);
        }
        if (traceConfigContent != null) {
            DbgConfig traceConf = new DbgConfig();
            if (this._xmlOutFile != null && this._xmlOutFile.exists() && this._xmlOutFile.isDirectory()) {
                traceConf.setXmlPath(this._xmlOutFile.getPath() + File.separator + "trace_config.xml");
            }
            traceConf.readDbgConfig(traceConf.readBinaryData(traceConfigContent));
            this.setDbgConfigData(traceConf);
        }
    }

    public void saveToPdtBin(PdtFile pdtFile) throws IOException, TransformerException {
        pdtFile.unlock();
        pdtFile.accessAttempt();
        this.setCurrentPdtFile(pdtFile);
        BinWriter writer = new BinWriter(true, "ISH");
        new PdtWriter(writer, pdtFile).writePdtContent();
        writer.createBin(pdtFile.getPath());
        pdtFile.lock();
        this.exportPdtXml(writer);
        System.out.println("A PDT file has been saved at: " + pdtFile.getPath());
    }

    public void setDbgConfigData(DbgConfig data) {
        this._dbgConfig = data;
    }

    public DbgConfig getDbgConfigData() {
        return this._dbgConfig;
    }

    public void importSensors(String path, boolean removeNonImportedSensors, PdtFile pdtFile, Device device) {
        if (new File(path).getName().toLowerCase().endsWith("json")) {
            this.importSensorsFromJson(path, removeNonImportedSensors, pdtFile, device);
        } else {
            this.importSensorsFromXml(path, removeNonImportedSensors, pdtFile, device);
        }
    }

    public void importSensorsFromXml(String path, boolean removeNonImportedSensors, PdtFile pdtFile, Device device) {
        try {
            ArrayList sensorsData = SensorDataManager.getSensorsInfoFromFiles((String)path, null);
            SensorData.DataComparator comparator = new SensorData.DataComparator();
            Collections.sort(sensorsData, comparator);
            ArrayList<Luid> keepList = new ArrayList<Luid>();
            if (pdtFile == null) {
                pdtFile = this._currentPdtFile;
            }
            List<SensorEntity> sensorEntityList = SensorEntityUtils.convertSensorDataListToSensorEntityList(sensorsData);
            for (SensorEntity sensorEntity : sensorEntityList) {
                keepList.add(new Luid(sensorEntity));
                Sensor sensor = new Sensor(sensorEntity);
                Device defaultDevice = this.getCurrentDevice() != null ? this.getCurrentDevice() : this.getDevices().get(0);
                pdtFile.addImportedSensorToDevice(sensor, device != null ? device : defaultDevice, true);
            }
            if (removeNonImportedSensors) {
                pdtFile.deleteAllOtherSensors(keepList);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void importSensorsFromJson(String path, boolean removeNonImportedSensors, PdtFile pdtFile, Device device) {
        try {
            SelectedSensorsDao dao = (SelectedSensorsDao)DaoFactory.getDao(SelectedSensorsDao.class);
            String projectJsonPath = new File(path).getParent() + File.separator + "project.json";
            ProjectEntity pe = ((ProjectDao)DaoFactory.getDao(ProjectDao.class)).getEntityByFilePath(projectJsonPath);
            String projPath = new File(path).getParent();
            List userModules = ISSProjectUtils.getUserModulesForExternal((String)projPath);
            SelectedSensorsEntity entity = dao.getEntityByFilePath(path, pe, userModules);
            List entityList = entity.getSelectedItems();
            ArrayList<Luid> keepList = new ArrayList<Luid>();
            if (pdtFile == null) {
                pdtFile = this._currentPdtFile;
            }
            for (SelectedItemsDataEntity selectedItem : entityList) {
                if (!(selectedItem instanceof SensorDataEntity)) continue;
                SensorDataEntity sensorData = (SensorDataEntity)selectedItem;
                SensorEntity sensorEntity = SensorEntityUtils.convertSensorDataEntityToSensorEntity(sensorData);
                keepList.add(new Luid(sensorEntity));
                Sensor sensor = new Sensor(sensorEntity);
                Device defaultDevice = this.getCurrentDevice() != null ? this.getCurrentDevice() : this.getDevices().get(0);
                pdtFile.addImportedSensorToDevice(sensor, device != null ? device : defaultDevice, true);
            }
            if (removeNonImportedSensors) {
                pdtFile.deleteAllOtherSensors(keepList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void setRunType(RunType runType) {
        this._runType = runType;
    }

    public RunType getRunType() {
        return this._runType;
    }

    public boolean isFdkRun() {
        return this._runType == RunType.FDK_EDIT_PDT || this._runType == RunType.FDK_RUN_PROJECT;
    }

    public void setFdkExcutionEnv(ManagerEnums.ExecutionEnvironments exEnv) {
        this._fdkExcutionEnv = exEnv;
    }

    public ManagerEnums.ExecutionEnvironments getFdkExcutionEnv() {
        return this._fdkExcutionEnv;
    }

    public static class FlowResults {
        public boolean hasWarnings = false;
        public boolean hasErrors = false;
    }

    public static enum RunType {
        STAND_ALONE,
        FDK_EDIT_PDT,
        FDK_RUN_PROJECT;

    }
}

