/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import java.util.concurrent.CancellationException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.IMainWindow;
import pdtEditor.PDTExternalInfo;
import pdtEditor.PdtPropertiesTable;
import pdtEditor.gui.GuiUtils;
import resources.CustomSpinner;

public class Properties {
    protected Shell shlPdtFileProperties;
    private DataStore _dataStore = null;
    private IMainWindow _parent = null;
    private CustomSpinner formatVersion;
    private CustomSpinner dataVersion;
    private boolean _modified = false;
    private Display display;
    private Button btnUpgradeFormat;
    private TabItem tbtmAdvanced;
    private Button btnEnableThecontinue;
    private Text pdtDescription;

    public static void main(String[] args) {
        try {
            Properties window = new Properties(null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Properties(DataStore dataStore, IMainWindow parent) {
        this._dataStore = dataStore;
        this._parent = parent;
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlPdtFileProperties.open();
        this.shlPdtFileProperties.layout();
        while (!this.shlPdtFileProperties.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void setModified() {
        this._modified = true;
    }

    public void fillData() {
        PDTExternalInfo externalInfo;
        if (this._dataStore == null || this._dataStore.getCurrentPdtFile() == null) {
            return;
        }
        this.formatVersion.setSelection(this._dataStore.getPdtFormatVersion());
        this.dataVersion.setSelection(this._dataStore.getCurrentPdtFile().getSkuId());
        PdtPropertiesTable pdtProperties = this._dataStore.getCurrentPdtFile().getPdtPropertiesTable();
        if (pdtProperties != null) {
            this.pdtDescription.setText(pdtProperties.getPdtDescription());
        }
        this.setFormatUpgradeAvalability();
        if (this.tbtmAdvanced != null && !this.tbtmAdvanced.isDisposed() && (externalInfo = DataStore.getInstance().getPDTExternalInfo()) != null) {
            try {
                PDTExternalInfo.ExternalPreferences preferences = externalInfo.loadExternalPreferences();
                if (preferences != null && this.btnEnableThecontinue != null && !this.btnEnableThecontinue.isDisposed()) {
                    this.btnEnableThecontinue.setSelection(preferences.allowContinueOnCritical);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this._modified = false;
    }

    public void saveData() {
        if (this._dataStore == null || this._dataStore.getCurrentPdtFile() == null) {
            return;
        }
        if (this._parent.getOpenedSensorModifiers().size() > 0) {
            MessageBox messageBox = new MessageBox(this.shlPdtFileProperties, 200);
            messageBox.setText("Opened Sensor Modifiers");
            messageBox.setMessage("In order to save the new PDT properties, all the sensor modifiers must be closed. Would you like to close them?");
            if (messageBox.open() == 64) {
                try {
                    this._parent.closeAllSensorModifiers();
                }
                catch (CancellationException e) {
                    return;
                }
            } else {
                return;
            }
        }
        try {
            this._dataStore.setPdtFormatVersion(this.formatVersion.getSelection(), null);
        }
        catch (UnsupportedOperationException e) {
            MessageBox messageBox = new MessageBox(this.shlPdtFileProperties, 33);
            messageBox.setText("PDT Format Upgrade Failure");
            String message = "The following errors prevent the PDT format upgrade:\n";
            message = message + e.getMessage();
            messageBox.setMessage(message);
            messageBox.open();
            return;
        }
        this._dataStore.getCurrentPdtFile().setSkuId(this.dataVersion.getSelection());
        PdtPropertiesTable pdtProperties = this._dataStore.getCurrentPdtFile().getPdtPropertiesTable();
        if (pdtProperties == null) {
            pdtProperties = new PdtPropertiesTable();
            this._dataStore.getCurrentPdtFile().addBdtObject(pdtProperties);
        }
        pdtProperties.setPdtDescription(this.pdtDescription.getText());
        if (this.tbtmAdvanced != null && !this.tbtmAdvanced.isDisposed()) {
            PDTExternalInfo pdtExternalInfo;
            PDTExternalInfo.ExternalPreferences preferences = new PDTExternalInfo.ExternalPreferences();
            if (this.btnEnableThecontinue != null && !this.btnEnableThecontinue.isDisposed()) {
                preferences.allowContinueOnCritical = this.btnEnableThecontinue.getSelection();
            }
            if ((pdtExternalInfo = DataStore.getInstance().getPDTExternalInfo()) != null) {
                try {
                    pdtExternalInfo.writeExternalPreferencesXml(preferences);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this._modified = false;
        this._parent.setModified();
        this._parent.refresh();
        this.shlPdtFileProperties.close();
    }

    public void setFormatUpgradeAvalability() {
        if (this.formatVersion.getSelection() < 5) {
            this.btnUpgradeFormat.setVisible(true);
        } else {
            this.btnUpgradeFormat.setVisible(false);
        }
    }

    protected void createContents() {
        this.shlPdtFileProperties = new Shell(65760);
        this.shlPdtFileProperties.setImage(SWTResourceManager.getImage(Properties.class, "/resources/Intel.ico"));
        this.shlPdtFileProperties.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent arg0) {
                if (Properties.this._modified) {
                    MessageBox messageBox = new MessageBox(Properties.this.shlPdtFileProperties, 296);
                    messageBox.setText("Closing without saving");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to close the window without saving?");
                    if (messageBox.open() != 32) {
                        arg0.doit = false;
                        return;
                    }
                }
            }
        });
        this.shlPdtFileProperties.setText("Properties");
        GuiUtils.setGridLayoutToComposite((Composite)this.shlPdtFileProperties, 2);
        Color tabFolderColor = new Color((Device)Display.getCurrent(), 0, 0, 0);
        TabFolder tabFolder = new TabFolder((Composite)this.shlPdtFileProperties, 0);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        tabFolder.setBackground(tabFolderColor);
        GuiUtils.setGridLayoutToComposite((Composite)tabFolder, 1);
        tabFolderColor.dispose();
        TabItem pdtProperties = new TabItem(tabFolder, 0);
        pdtProperties.setText("PDT File");
        Group grpBasicProperties = new Group((Composite)tabFolder, 0);
        pdtProperties.setControl((Control)grpBasicProperties);
        grpBasicProperties.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpBasicProperties.setText("Basic Properties");
        grpBasicProperties.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        GuiUtils.setGridLayoutToComposite((Composite)grpBasicProperties, 3);
        Label lblFormatVersion = new Label((Composite)grpBasicProperties, 0);
        lblFormatVersion.setText("PDT File Format Version:");
        lblFormatVersion.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.formatVersion = new CustomSpinner((Composite)grpBasicProperties, 2048, this.shlPdtFileProperties);
        this.formatVersion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                Properties.this.setModified();
            }
        });
        this.formatVersion.setMaximum(255);
        this.formatVersion.setEnabled(false);
        GridData gdFormatVersion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdFormatVersion.widthHint = GuiUtils.getButtonWidth((Control)this.shlPdtFileProperties);
        this.formatVersion.setLayoutData(gdFormatVersion);
        Label lblDataversion = new Label((Composite)grpBasicProperties, 0);
        lblDataversion.setText("Vendor-defined Data Version:");
        lblDataversion.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.dataVersion = new CustomSpinner((Composite)grpBasicProperties, 2048, this.shlPdtFileProperties);
        this.dataVersion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                Properties.this.setModified();
            }
        });
        this.dataVersion.setMaximum(255);
        GridData gdDataVersion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdDataVersion.widthHint = GuiUtils.getButtonWidth((Control)this.shlPdtFileProperties);
        this.dataVersion.setLayoutData(gdDataVersion);
        Label lblPdtDescription = new Label((Composite)grpBasicProperties, 0);
        lblPdtDescription.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblPdtDescription.setText("Description:");
        this.pdtDescription = new Text((Composite)grpBasicProperties, 2048);
        this.pdtDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                Properties.this.setModified();
            }
        });
        this.pdtDescription.setLayoutData((Object)new GridData(4, 16384, false, false, 2, 1));
        this.pdtDescription.setTextLimit(50);
        this.btnUpgradeFormat = new Button((Composite)grpBasicProperties, 0);
        this.btnUpgradeFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Properties.this.formatVersion.setSelection(5);
                Properties.this.setModified();
                Properties.this.setFormatUpgradeAvalability();
            }
        });
        this.btnUpgradeFormat.setText("Upgrade PDT Format To The Lastest Version (5)");
        this.btnUpgradeFormat.setVisible(false);
        this.btnUpgradeFormat.setLayoutData((Object)new GridData(4, 1024, false, true, 3, 3));
        if (DataStore.getInstance().isFdkRun()) {
            this.tbtmAdvanced = new TabItem(tabFolder, 0);
            this.tbtmAdvanced.setText("Advanced");
            Composite composite = new Composite((Composite)tabFolder, 0);
            this.tbtmAdvanced.setControl((Control)composite);
            GuiUtils.setGridLayoutToComposite(composite, 1);
            this.btnEnableThecontinue = new Button(composite, 32);
            this.btnEnableThecontinue.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Properties.this.setModified();
                }
            });
            this.btnEnableThecontinue.setText("Allow me to continue even if there are critical issues.");
            this.btnEnableThecontinue.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            Label lblEnableContinueNote = new Label(composite, 0);
            lblEnableContinueNote.setText("Clicking \"Continue\" when your project has critical issues will cause\r\nfirmware instability and unexpected behavior.");
            lblEnableContinueNote.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        }
        Button btnOk = new Button((Composite)this.shlPdtFileProperties, 0);
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Properties.this.saveData();
            }
        });
        btnOk.setText("OK");
        GridData gdBtnOk = new GridData(131072, 0x1000000, true, false, 1, 1);
        gdBtnOk.widthHint = GuiUtils.getButtonWidth((Control)this.shlPdtFileProperties);
        btnOk.setLayoutData((Object)gdBtnOk);
        Button btnCancel = new Button((Composite)this.shlPdtFileProperties, 0);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Properties.this.shlPdtFileProperties.close();
            }
        });
        btnCancel.setText("Cancel");
        GridData gdBtnCancel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdBtnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shlPdtFileProperties);
        btnCancel.setLayoutData((Object)gdBtnCancel);
        this.shlPdtFileProperties.setSize((int)((double)lblFormatVersion.computeSize((int)-1, (int)-1).x * 3.5), lblFormatVersion.computeSize((int)-1, (int)-1).x * 3);
        this.shlPdtFileProperties.setLocation(GuiUtils.getMiddleLocation(this.shlPdtFileProperties, this.display));
    }
}

