/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.persistence.cache.Impl;

import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.common.utils.ManagerFileUtils;
import com.intel.sensing.fdk.model.persistence.cache.api.ModuleCacheManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class InstalledModuleCacheManager
extends ModuleCacheManager {
    private static InstalledModuleCacheManager _instance;
    private static final Path installedBaseDir;

    static {
        installedBaseDir = Paths.get(ManagerFileUtils.getInstalledModulesDir(), new String[0]);
    }

    private InstalledModuleCacheManager(Path baseDir) throws ISSException, IOException {
        super(baseDir, true, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InstalledModuleCacheManager init() throws ISSException, IOException {
        if (_instance != null) return _instance;
        Class<InstalledModuleCacheManager> clazz = InstalledModuleCacheManager.class;
        synchronized (InstalledModuleCacheManager.class) {
            if (_instance != null) return _instance;
            _instance = new InstalledModuleCacheManager(installedBaseDir);
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    @Override
    public List<String> generateAllModulePathList() throws IOException {
        List packageList = Files.list(installedBaseDir).filter(f -> f != null && Files.isDirectory(f, new LinkOption[0])).collect(Collectors.toList());
        List libList = packageList.stream().flatMap(p -> Arrays.stream(p.toFile().listFiles())).filter(file -> file != null && file.exists() && file.isDirectory()).filter(file -> file.getName().equals("lib")).map(file -> file.toPath()).collect(Collectors.toList());
        ArrayList<Path> modulePathList = new ArrayList<Path>();
        for (Path path : libList) {
            this.getModulePaths(path, modulePathList, 0);
        }
        List<String> ret = modulePathList.stream().map(p -> p.toString()).collect(Collectors.toList());
        return ret;
    }

    private int getModulePaths(Path root, ArrayList<Path> allModules, int searchDepth) {
        File rootFile = root.toFile();
        if (rootFile == null || !rootFile.exists() || !rootFile.isDirectory() || searchDepth > 2) {
            return searchDepth - 1;
        }
        Path moduleFilePath = root.resolve("module.json");
        if (moduleFilePath.toFile().exists()) {
            allModules.add(root);
        } else {
            File[] fileArray = rootFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.getModulePaths(file.toPath(), allModules, searchDepth + 1);
                ++n2;
            }
        }
        return searchDepth - 1;
    }
}

