//
//  hwInterfacePci.h
//  SimpleDriver
//
//  Created by Egor Pomozov on 07.12.14.
//  Copyright (c) 2014 Aquantia Corp. All rights reserved.
//
//  Linux-specific parts split from SimpleControl.h
//
#ifndef hwInterfacePci_
#define hwInterfacePci_

enum DeviceParamters
{
  hotunplugParam = 1,
  memAccess64Param,
  refCounterValue,
  mdioAqSemReg, // 32'v0zyyyyyy - 1'v aquire semaphore value, 5'zz - offset, 24'yyyyyy - reg address
  mdioRelSemReg, // 32'v0zyyyyyy - 1'v release semaphore value, 5'zz - offset, 24'yyyyyy - reg address
  mdioClauseReg, // 32'v0zyyyyyy - 1'v clause45 value, 5'zz - offset, 24'yyyyyy - reg address
  mdioReadOpReg, // 32'wvzyyyyyy - 2'w - operation bit value, 1'v - write bit value, 5'zz - offset, 24'yyyyyy - reg address
  mdioWriteOpReg, // 32'wvzyyyyyy - 2'w - operation bit value, 1'v - write bit value, 5'zz - offset, 24'yyyyyy - reg address
  mdioAddrOpReg, // 32'wvzyyyyyy - 2'w - operation bit value, 1'v - write bit value, 5'zz - offset, 24'yyyyyy - reg address
  mdioExecOpReg, // 32'wvzyyyyyy - 2'w - operation bit value, 1'v - write bit value, 5'zz - offset, 24'yyyyyy - reg address
  mdioBusyReg, // 32'v00zyyyyyy - 1'v - busy bit value, 5'zz - offset, 24'yyyyyy - reg address
  mdioPhyReg, // 32'0zzyyyyyy - 5'zz - offset, 24'yyyyyy - reg address
  mdioMmdReg, // 32'0zzyyyyyy - 5'zz - offset, 24'yyyyyy - reg address
  mdioAddrReg, // 32'0zzyyyyyy - 5'zz - offset, 24'yyyyyy - reg address - for clause 45
  mdioReadValueReg, // 32'0zzyyyyyy - 5'zz - offset, 24'yyyyyy - reg address
  mdioWriteValueReg, // 32'0zzyyyyyy - 5'zz - offset, 24'yyyyyy - reg address
  mdioTimeoutMs, // 32'0000yyyy - 16'yyyy - timeout value in ms
  mdioEnableReg, // 32'v0zyyyyyy - 1'v enable semaphore value, 5'zz - offset, 24'yyyyyy - reg address
  mdioDisableReg, // 32'v0zyyyyyy - 1'v enable semaphore value, 5'zz - offset, 24'yyyyyy - reg address
  MDIO_PARAMETERS
};

#endif
