/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * aQuantia Corporation Network Driver
 * Copyright (C) 2019-2020 aQuantia Corporation. All rights reserved
 */

/* File hw_atl2_llh_internal.h: Preprocessor definitions
 * for Atlantic registers.
 */

#ifndef HW_ATL2_LLH_INTERNAL_H
#define HW_ATL2_LLH_INTERNAL_H


/* RX timestamp_req_desc{D} [1:0] Bitfield Definitions
 */
#define HW_ATL2_RPF_TIMESTAMP_REQ_DESCD_ADR(descr) (0x00005B08 + (descr) * 0x20)
#define HW_ATL2_RPF_TIMESTAMP_REQ_DESCD_MSK 0x00030000
#define HW_ATL2_RPF_TIMESTAMP_REQ_DESCD_MSKN 0xFFFCFFFF
#define HW_ATL2_RPF_TIMESTAMP_REQ_DESCD_SHIFT 16
#define HW_ATL2_RPF_TIMESTAMP_REQ_DESCD_WIDTH 2
#define HW_ATL2_RPF_TIMESTAMP_REQ_DESCD_DEFAULT 0x0

/* RX pif_rpf_rss_hash_type_i Bitfield Definitions
 */
#define HW_ATL2_RPF_PIF_RPF_RSS_HASH_TYPEI_ADR 0x000054C8
#define HW_ATL2_RPF_PIF_RPF_RSS_HASH_TYPEI_MSK 0x000001FF
#define HW_ATL2_RPF_PIF_RPF_RSS_HASH_TYPEI_MSKN 0xFFFFFE00
#define HW_ATL2_RPF_PIF_RPF_RSS_HASH_TYPEI_SHIFT 0
#define HW_ATL2_RPF_PIF_RPF_RSS_HASH_TYPEI_WIDTH 9


/* rx rpf_new_rpf_en bitfield definitions
 * preprocessor definitions for the bitfield "rpf_new_rpf_en_i".
 * port="pif_rpf_new_rpf_en_i
 */

/* register address for bitfield rpf_new_rpf_en */
#define HW_ATL2_RPF_NEW_EN_ADR 0x00005104
/* bitmask for bitfield rpf_new_rpf_en */
#define HW_ATL2_RPF_NEW_EN_MSK 0x00000800
/* inverted bitmask for bitfield rpf_new_rpf_en */
#define HW_ATL2_RPF_NEW_EN_MSKN 0xfffff7ff
/* lower bit position of bitfield rpf_new_rpf_en */
#define HW_ATL2_RPF_NEW_EN_SHIFT 11
/* width of bitfield rpf_new_rpf_en */
#define HW_ATL2_RPF_NEW_EN_WIDTH 1
/* default value of bitfield rpf_new_rpf_en */
#define HW_ATL2_RPF_NEW_EN_DEFAULT 0x0


/* rx l2_uc_req_tag0{f}[5:0] bitfield definitions
 * preprocessor definitions for the bitfield "l2_uc_req_tag0{f}[7:0]".
 * parameter: filter {f} | stride size 0x8 | range [0, 37]
 * port="pif_rpf_l2_uc_req_tag0[5:0]"
 */

/* register address for bitfield l2_uc_req_tag0{f}[2:0] */
#define HW_ATL2_RPFL2UC_TAG_ADR(filter) (0x00005114 + (filter) * 0x8)
/* bitmask for bitfield l2_uc_req_tag0{f}[2:0] */
#define HW_ATL2_RPFL2UC_TAG_MSK 0x0FC00000
/* inverted bitmask for bitfield l2_uc_req_tag0{f}[2:0] */
#define HW_ATL2_RPFL2UC_TAG_MSKN 0xF03FFFFF
/* lower bit position of bitfield l2_uc_req_tag0{f}[2:0] */
#define HW_ATL2_RPFL2UC_TAG_SHIFT 22
/* width of bitfield l2_uc_req_tag0{f}[2:0] */
#define HW_ATL2_RPFL2UC_TAG_WIDTH 6
/* default value of bitfield l2_uc_req_tag0{f}[2:0] */
#define HW_ATL2_RPFL2UC_TAG_DEFAULT 0x0

/* rpf_l2_bc_req_tag[5:0] bitfield definitions
 * preprocessor definitions for the bitfield "rpf_l2_bc_req_tag[5:0]".
 * port="pifrpf_l2_bc_req_tag_i[5:0]"
 */

/* register address for bitfield rpf_l2_bc_req_tag */
#define HW_ATL2_RPF_L2_BC_TAG_ADR 0x000050F0
/* bitmask for bitfield rpf_l2_bc_req_tag */
#define HW_ATL2_RPF_L2_BC_TAG_MSK 0x0000003F
/* inverted bitmask for bitfield rpf_l2_bc_req_tag */
#define HW_ATL2_RPF_L2_BC_TAG_MSKN 0xffffffc0
/* lower bit position of bitfield rpf_l2_bc_req_tag */
#define HW_ATL2_RPF_L2_BC_TAG_SHIFT 0
/* width of bitfield rpf_l2_bc_req_tag */
#define HW_ATL2_RPF_L2_BC_TAG_WIDTH 6
/* default value of bitfield rpf_l2_bc_req_tag */
#define HW_ATL2_RPF_L2_BC_TAG_DEFAULT 0x0


/* rx rpf_rss_red1_data_[4:0] bitfield definitions
 * preprocessor definitions for the bitfield "rpf_rss_red1_data[4:0]".
 * port="pif_rpf_rss_red1_data_i[4:0]"
 */

/* register address for bitfield rpf_rss_red1_data[4:0] */
#define HW_ATL2_RPF_RSS_REDIR_ADR(TC, INDEX) (0x00006200 + \
					(0x100 * !!(TC > 3)) + (INDEX) * 4)
/* bitmask for bitfield rpf_rss_red1_data[4:0] */
#define HW_ATL2_RPF_RSS_REDIR_MSK(TC)  (0x00000001F << (5 * ((TC) % 4)))
/* lower bit position of bitfield rpf_rss_red1_data[4:0] */
#define HW_ATL2_RPF_RSS_REDIR_SHIFT(TC) (5 * ((TC) % 4))
/* width of bitfield rpf_rss_red1_data[4:0] */
#define HW_ATL2_RPF_RSS_REDIR_WIDTH 5
/* default value of bitfield rpf_rss_red1_data[4:0] */
#define HW_ATL2_RPF_RSS_REDIR_DEFAULT 0x0


/* rx vlan_req_tag0{f}[3:0] bitfield definitions
 * preprocessor definitions for the bitfield "vlan_req_tag0{f}[3:0]".
 * parameter: filter {f} | stride size 0x4 | range [0, 15]
 * port="pif_rpf_vlan_req_tag0[3:0]"
 */

/* register address for bitfield vlan_req_tag0{f}[3:0] */
#define HW_ATL2_RPF_VL_TAG_ADR(filter) (0x00005290 + (filter) * 0x4)
/* bitmask for bitfield vlan_req_tag0{f}[3:0] */
#define HW_ATL2_RPF_VL_TAG_MSK 0x0000F000
/* inverted bitmask for bitfield vlan_req_tag0{f}[3:0] */
#define HW_ATL2_RPF_VL_TAG_MSKN 0xFFFF0FFF
/* lower bit position of bitfield vlan_req_tag0{f}[3:0] */
#define HW_ATL2_RPF_VL_TAG_SHIFT 12
/* width of bitfield vlan_req_tag0{f}[3:0] */
#define HW_ATL2_RPF_VL_TAG_WIDTH 4
/* default value of bitfield vlan_req_tag0{f}[3:0] */
#define HW_ATL2_RPF_VL_TAG_DEFAULT 0x0


/* rx etype_req_tag0{f}[2:0] bitfield definitions
 * preprocessor definitions for the bitfield "etype_req_tag0{f}[2:0]".
 * parameter: filter {f} | stride size 0x4 | range [0, 15]
 * port="pif_rpf_etype_req_tag0[2:0]"
 */

/* register address for bitfield etype_req_tag0{f}[2:0] */
#define HW_ATL2_RPF_ET_TAG_ADR(filter) (0x00005340 + (filter) * 0x8)
/* bitmask for bitfield etype_req_tag0{f}[2:0] */
#define HW_ATL2_RPF_ET_TAG_MSK 0x00000007
/* inverted bitmask for bitfield etype_req_tag0{f}[2:0] */
#define HW_ATL2_RPF_ET_TAG_MSKN 0xFFFFFFF8
/* lower bit position of bitfield etype_req_tag0{f}[2:0] */
#define HW_ATL2_RPF_ET_TAG_SHIFT 0
/* width of bitfield etype_req_tag0{f}[2:0] */
#define HW_ATL2_RPF_ET_TAG_WIDTH 3
/* default value of bitfield etype_req_tag0{f}[2:0] */
#define HW_ATL2_RPF_ET_TAG_DEFAULT 0x0

/* RX l3_l4_en{F} Bitfield Definitions
 * Preprocessor definitions for the bitfield "l3_l4_en{F}".
 * Parameter: filter {F} | stride size 0x4 | range [0, 7]
 * PORT="pif_rpf_l3_l4_en_i[0]"
 */

/* Register address for bitfield l3_l4_en{F} */
#define HW_ATL2_RPF_L3_L4_ENF_ADR(filter) (0x00005380u + (filter) * 0x4)
/* Bitmask for bitfield l3_l4_en{F} */
#define HW_ATL2_RPF_L3_L4_ENF_MSK 0x80000000u
/* Inverted bitmask for bitfield l3_l4_en{F} */
#define HW_ATL2_RPF_L3_L4_ENF_MSKN 0x7FFFFFFFu
/* Lower bit position of bitfield l3_l4_en{F} */
#define HW_ATL2_RPF_L3_L4_ENF_SHIFT 31
/* Width of bitfield l3_l4_en{F} */
#define HW_ATL2_RPF_L3_L4_ENF_WIDTH 1
/* Default value of bitfield l3_l4_en{F} */
#define HW_ATL2_RPF_L3_L4_ENF_DEFAULT 0x0

/* RX l3_v6_en{F} Bitfield Definitions
 * Preprocessor definitions for the bitfield "l3_v6_en{F}".
 * Parameter: filter {F} | stride size 0x4 | range [0, 7]
 * PORT="pif_rpf_l3_v6_en_i[0]"
 */
/* Register address for bitfield l3_v6_en{F} */
#define HW_ATL2_RPF_L3_V6_ENF_ADR(filter) (0x00005380u + (filter) * 0x4)
/* Bitmask for bitfield l3_v6_en{F} */
#define HW_ATL2_RPF_L3_V6_ENF_MSK 0x40000000u
/* Inverted bitmask for bitfield l3_v6_en{F} */
#define HW_ATL2_RPF_L3_V6_ENF_MSKN 0xBFFFFFFFu
/* Lower bit position of bitfield l3_v6_en{F} */
#define HW_ATL2_RPF_L3_V6_ENF_SHIFT 30
/* Width of bitfield l3_v6_en{F} */
#define HW_ATL2_RPF_L3_V6_ENF_WIDTH 1
/* Default value of bitfield l3_v6_en{F} */
#define HW_ATL2_RPF_L3_V6_ENF_DEFAULT 0x0

/* RX l3_sa{F}_en Bitfield Definitions
 * Preprocessor definitions for the bitfield "l3_sa{F}_en".
 * Parameter: filter {F} | stride size 0x4 | range [0, 7]
 * PORT="pif_rpf_l3_sa_en_i[0]"
 */

/* Register address for bitfield l3_sa{F}_en */
#define HW_ATL2_RPF_L3_SAF_EN_ADR(filter) (0x00005380u + (filter) * 0x4)
/* Bitmask for bitfield l3_sa{F}_en */
#define HW_ATL2_RPF_L3_SAF_EN_MSK 0x20000000u
/* Inverted bitmask for bitfield l3_sa{F}_en */
#define HW_ATL2_RPF_L3_SAF_EN_MSKN 0xDFFFFFFFu
/* Lower bit position of bitfield l3_sa{F}_en */
#define HW_ATL2_RPF_L3_SAF_EN_SHIFT 29
/* Width of bitfield l3_sa{F}_en */
#define HW_ATL2_RPF_L3_SAF_EN_WIDTH 1
/* Default value of bitfield l3_sa{F}_en */
#define HW_ATL2_RPF_L3_SAF_EN_DEFAULT 0x0

/* RX l3_da{F}_en Bitfield Definitions
 * Preprocessor definitions for the bitfield "l3_da{F}_en".
 * Parameter: filter {F} | stride size 0x4 | range [0, 7]
 * PORT="pif_rpf_l3_da_en_i[0]"
 */

/* Register address for bitfield l3_da{F}_en */
#define HW_ATL2_RPF_L3_DAF_EN_ADR(filter) (0x00005380u + (filter) * 0x4)
/* Bitmask for bitfield l3_da{F}_en */
#define HW_ATL2_RPF_L3_DAF_EN_MSK 0x10000000u
/* Inverted bitmask for bitfield l3_da{F}_en */
#define HW_ATL2_RPF_L3_DAF_EN_MSKN 0xEFFFFFFFu
/* Lower bit position of bitfield l3_da{F}_en */
#define HW_ATL2_RPF_L3_DAF_EN_SHIFT 28
/* Width of bitfield l3_da{F}_en */
#define HW_ATL2_RPF_L3_DAF_EN_WIDTH 1
/* Default value of bitfield l3_da{F}_en */
#define HW_ATL2_RPF_L3_DAF_EN_DEFAULT 0x0

/* RX l4_sp{F}_en Bitfield Definitions
 * Preprocessor definitions for the bitfield "l4_sp{F}_en".
 * Parameter: filter {F} | stride size 0x4 | range [0, 7]
 * PORT="pif_rpf_l4_sp_en_i[0]"
 */

/* Register address for bitfield l4_sp{F}_en */
#define HW_ATL2_RPF_L4_SPF_EN_ADR(filter) (0x00005380u + (filter) * 0x4)
/* Bitmask for bitfield l4_sp{F}_en */
#define HW_ATL2_RPF_L4_SPF_EN_MSK 0x08000000u
/* Inverted bitmask for bitfield l4_sp{F}_en */
#define HW_ATL2_RPF_L4_SPF_EN_MSKN 0xF7FFFFFFu
/* Lower bit position of bitfield l4_sp{F}_en */
#define HW_ATL2_RPF_L4_SPF_EN_SHIFT 27
/* Width of bitfield l4_sp{F}_en */
#define HW_ATL2_RPF_L4_SPF_EN_WIDTH 1
/* Default value of bitfield l4_sp{F}_en */
#define HW_ATL2_RPF_L4_SPF_EN_DEFAULT 0x0

/* RX l4_dp{F}_en Bitfield Definitions
 * Preprocessor definitions for the bitfield "l4_dp{F}_en".
 * Parameter: filter {F} | stride size 0x4 | range [0, 7]
 * PORT="pif_rpf_l4_dp_en_i[0]"
 */

/* Register address for bitfield l4_dp{F}_en */
#define HW_ATL2_RPF_L4_DPF_EN_ADR(filter) (0x00005380u + (filter) * 0x4)
/* Bitmask for bitfield l4_dp{F}_en */
#define HW_ATL2_RPF_L4_DPF_EN_MSK 0x04000000u
/* Inverted bitmask for bitfield l4_dp{F}_en */
#define HW_ATL2_RPF_L4_DPF_EN_MSKN 0xFBFFFFFFu
/* Lower bit position of bitfield l4_dp{F}_en */
#define HW_ATL2_RPF_L4_DPF_EN_SHIFT 26
/* Width of bitfield l4_dp{F}_en */
#define HW_ATL2_RPF_L4_DPF_EN_WIDTH 1
/* Default value of bitfield l4_dp{F}_en */
#define HW_ATL2_RPF_L4_DPF_EN_DEFAULT 0x0

/* RX l4_prot{F}_en Bitfield Definitions
 * Preprocessor definitions for the bitfield "l4_prot{F}_en".
 * Parameter: filter {F} | stride size 0x4 | range [0, 7]
 * PORT="pif_rpf_l4_prot_en_i[0]"
 */

/* Register address for bitfield l4_prot{F}_en */
#define HW_ATL2_RPF_L4_PROTF_EN_ADR(filter) (0x00005380u + (filter) * 0x4)
/* Bitmask for bitfield l4_prot{F}_en */
#define HW_ATL2_RPF_L4_PROTF_EN_MSK 0x02000000u
/* Inverted bitmask for bitfield l4_prot{F}_en */
#define HW_ATL2_RPF_L4_PROTF_EN_MSKN 0xFDFFFFFFu
/* Lower bit position of bitfield l4_prot{F}_en */
#define HW_ATL2_RPF_L4_PROTF_EN_SHIFT 25
/* Width of bitfield l4_prot{F}_en */
#define HW_ATL2_RPF_L4_PROTF_EN_WIDTH 1
/* Default value of bitfield l4_prot{F}_en */
#define HW_ATL2_RPF_L4_PROTF_EN_DEFAULT 0x0

/* RX l3_arp{F}_en Bitfield Definitions
 * Preprocessor definitions for the bitfield "l3_arp{F}_en".
 * Parameter: filter {F} | stride size 0x4 | range [0, 7]
 * PORT="pif_rpf_l3_arp_en_i[0]"
 */

/* Register address for bitfield l3_arp{F}_en */
#define HW_ATL2_RPF_L3_ARPF_EN_ADR(filter) (0x00005380u + (filter) * 0x4)
/* Bitmask for bitfield l3_arp{F}_en */
#define HW_ATL2_RPF_L3_ARPF_EN_MSK 0x01000000u
/* Inverted bitmask for bitfield l3_arp{F}_en */
#define HW_ATL2_RPF_L3_ARPF_EN_MSKN 0xFEFFFFFFu
/* Lower bit position of bitfield l3_arp{F}_en */
#define HW_ATL2_RPF_L3_ARPF_EN_SHIFT 24
/* Width of bitfield l3_arp{F}_en */
#define HW_ATL2_RPF_L3_ARPF_EN_WIDTH 1
/* Default value of bitfield l3_arp{F}_en */
#define HW_ATL2_RPF_L3_ARPF_EN_DEFAULT 0x0

/* RX l3_l4_rxq{F}_en Bitfield Definitions
 * Preprocessor definitions for the bitfield "l3_l4_rxq{F}_en".
 * Parameter: filter {F} | stride size 0x4 | range [0, 7]
 * PORT="pif_rpf_l3_l4_rxq_en_i[0]"
 */

/* Register address for bitfield l3_l4_RXq{F}_en */
#define HW_ATL2_RPF_L3_L4_RXQF_EN_ADR(filter) (0x00005380u + (filter) * 0x4)
/* Bitmask for bitfield l3_l4_RXq{F}_en */
#define HW_ATL2_RPF_L3_L4_RXQF_EN_MSK 0x00800000u
/* Inverted bitmask for bitfield l3_l4_RXq{F}_en */
#define HW_ATL2_RPF_L3_L4_RXQF_EN_MSKN 0xFF7FFFFFu
/* Lower bit position of bitfield l3_l4_RXq{F}_en */
#define HW_ATL2_RPF_L3_L4_RXQF_EN_SHIFT 23
/* Width of bitfield l3_l4_RXq{F}_en */
#define HW_ATL2_RPF_L3_L4_RXQF_EN_WIDTH 1
/* Default value of bitfield l3_l4_RXq{F}_en */
#define HW_ATL2_RPF_L3_L4_RXQF_EN_DEFAULT 0x0

/* RX l3_l4_mng_RXq{F} Bitfield Definitions
 * Preprocessor definitions for the bitfield "l3_l4_mng_RXq{F}".
 * Parameter: filter {F} | stride size 0x4 | range [0, 7]
 * PORT="pif_rpf_l3_l4_mng_rxq_i[0]"
 */

/* Register address for bitfield l3_l4_mng_rxq{F} */
#define HW_ATL2_RPF_L3_L4_MNG_RXQF_ADR(filter) (0x00005380u + (filter) * 0x4)
/* Bitmask for bitfield l3_l4_mng_rxq{F} */
#define HW_ATL2_RPF_L3_L4_MNG_RXQF_MSK 0x00400000u
/* Inverted bitmask for bitfield l3_l4_mng_rxq{F} */
#define HW_ATL2_RPF_L3_L4_MNG_RXQF_MSKN 0xFFBFFFFFu
/* Lower bit position of bitfield l3_l4_mng_rxq{F} */
#define HW_ATL2_RPF_L3_L4_MNG_RXQF_SHIFT 22
/* Width of bitfield l3_l4_mng_rxq{F} */
#define HW_ATL2_RPF_L3_L4_MNG_RXQF_WIDTH 1
/* Default value of bitfield l3_l4_mng_rxq{F} */
#define HW_ATL2_RPF_L3_L4_MNG_RXQF_DEFAULT 0x0

/* RX l3_l4_act{F}[2:0] Bitfield Definitions
 * Preprocessor definitions for the bitfield "l3_l4_act{F}[2:0]".
 * Parameter: filter {F} | stride size 0x4 | range [0, 7]
 * PORT="pif_rpf_l3_l4_act0_i[2:0]"
 */

/* Register address for bitfield l3_l4_act{F}[2:0] */
#define HW_ATL2_RPF_L3_L4_ACTF_ADR(filter) (0x00005380u + (filter) * 0x4)
/* Bitmask for bitfield l3_l4_act{F}[2:0] */
#define HW_ATL2_RPF_L3_L4_ACTF_MSK 0x00070000u
/* Inverted bitmask for bitfield l3_l4_act{F}[2:0] */
#define HW_ATL2_RPF_L3_L4_ACTF_MSKN 0xFFF8FFFFu
/* Lower bit position of bitfield l3_l4_act{F}[2:0] */
#define HW_ATL2_RPF_L3_L4_ACTF_SHIFT 16
/* Width of bitfield l3_l4_act{F}[2:0] */
#define HW_ATL2_RPF_L3_L4_ACTF_WIDTH 3
/* Default value of bitfield l3_l4_act{F}[2:0] */
#define HW_ATL2_RPF_L3_L4_ACTF_DEFAULT 0x0

/* RX l3_l4_rxq{F}[4:0] Bitfield Definitions
 * Preprocessor definitions for the bitfield "l3_l4_rxq{F}[4:0]".
 * Parameter: filter {F} | stride size 0x4 | range [0, 7]
 * PORT="pif_rpf_l3_l4_rxq0_i[4:0]"
 */

/* Register address for bitfield l3_l4_rxq{F}[4:0] */
#define HW_ATL2_RPF_L3_L4_RXQF_ADR(filter) (0x00005380u + (filter) * 0x4)
/* Bitmask for bitfield l3_l4_rxq{F}[4:0] */
#define HW_ATL2_RPF_L3_L4_RXQF_MSK 0x00001F00u
/* Inverted bitmask for bitfield l3_l4_rxq{F}[4:0] */
#define HW_ATL2_RPF_L3_L4_RXQF_MSKN 0xFFFFE0FFu
/* Lower bit position of bitfield l3_l4_rxq{F}[4:0] */
#define HW_ATL2_RPF_L3_L4_RXQF_SHIFT 8
/* Width of bitfield l3_l4_rxq{F}[4:0] */
#define HW_ATL2_RPF_L3_L4_RXQF_WIDTH 5
/* Default value of bitfield l3_l4_rxq{F}[4:0] */
#define HW_ATL2_RPF_L3_L4_RXQF_DEFAULT 0x0

/* RX rpf_l3_v6_sa{F}_dw{D}[1F:0] Bitfield Definitions
 * Preprocessor definitions for the bitfield "rpf_l3_v6_sa{F}_dw{D}[1F:0]".
 * Parameter: filter {F} | stride size 0x10 | range [0, 7]
 * Parameter: dword {D} | stride size 0x4 | range [0, 3]
 * PORT="pif_rpf_l3_v6_sa{F}_dw0[1F:0]"
 */

/* Register address for bitfield rpf_l3_v6_sa{F}_dw{D}[1F:0] */
#define HW_ATL2_RPF_L3_SA_DW_ADR(filter, dword) \
	(0x00006400u + (filter) * 0x10 + (dword) * 0x4)

/* RX rpf_l3_v6_da{F}_dw{D}[1F:0] Bitfield Definitions
 * Preprocessor definitions for the bitfield "rpf_l3_v6_da{F}_dw{D}[1F:0]".
 * Parameter: filter {F} | stride size 0x10 | range [0, 7]
 * Parameter: dword {D} | stride size 0x4 | range [0, 3]
 * PORT="pif_rpf_l3_v6_da{F}_dw{D}[1F:0]"
 */

/* Register address for bitfield rpf_l3_v6_da{F}_dw{D}[1F:0] */
#define HW_ATL2_RPF_L3_DA_DW_ADR(filter, dword) \
	(0x00006480u + (filter) * 0x10 + (dword) * 0x4)

/* RX rpf_l3_cmd{F}[1F:0] Bitfield Definitions
 * Preprocessor definitions for the bitfield "rpf_l3_cmd{F}[1F:0]".
 * Parameter: filter {F} | stride size 0x4 | range [0, 7]
 * PORT="pif_rpf_l3_v6_cmd{F}[1F:0]"
 */

/* Register address for bitfield rpf_l3_cmd{F}[1F:0] */
#define HW_ATL2_RPF_L3_CMD_ADR(filter) (0x00006500u + (filter) * 0x4)
/* Bitmask for bitfield rpf_l3_v6_cmd{F}[F:0] */
#define HW_ATL2_RPF_L3_CMD_MSK 0xFF7FFFFFu
/* Inverted bitmask for bitfield rpf_l3_cmd{F}[1F:0] */
#define HW_ATL2_RPF_L3_CMD_MSKN 0x00800000u
/* Lower bit position of bitfield rpf_l3_cmd{F}[1F:0] */
#define HW_ATL2_RPF_L3_CMD_SHIFT 0
/* Width of bitfield rpf_l3_cmd{F}[1F:0] */
#define HW_ATL2_RPF_L3_CMD_WIDTH 32
/* Default value of bitfield rpf_l3_cmd{F}[1F:0] */
#define HW_ATL2_RPF_L3_CMD_DEFAULT 0x0

/* RX rpf_l3_v6_v4_select Bitfield Definitions
 * Preprocessor definitions for the bitfield "rpf_l3_v6_v4_select".
 * PORT="pif_rpf_l3_v6_v4_select"
 */

/* Register address for bitfield rpf_l3_v6_cmd{F}[F:0] */
#define HW_ATL2_RPF_L3_V6_V4_SELECT_ADR 0x00006500u
/* Bitmask for bitfield pif_rpf_l3_v6_v4_select*/
#define HW_ATL2_RPF_L3_V6_V4_SELECT_MSK 0x00800000u
/* Inverted bitmask for bitfield pif_rpf_l3_v6_v4_select */
#define HW_ATL2_RPF_L3_V6_V4_SELECT_MSKN 0xFF7FFFFFu
/* Lower bit position of bitfield pif_rpf_l3_v6_v4_select */
#define HW_ATL2_RPF_L3_V6_V4_SELECT_SHIFT 23
/* Width of bitfield pif_rpf_l3_v6_v4_select */
#define HW_ATL2_RPF_L3_V6_V4_SELECT_WIDTH 1
/* Default value of bitfield pif_rpf_l3_v6_v4_select*/
#define HW_ATL2_RPF_L3_V6_V4_SELECT_DEFAULT 0x0

/* RX rpf_l3_v4_req_tag{F}[2:0] Bitfield Definitions
 * Preprocessor definitions for the bitfield "rpf_l3_v4_req_tag{F}[2:0]".
 * Parameter: filter {F} | stride size 0x4 | range [0, 7]
 * PORT="pif_rpf_l3_v4_req_tag0[2:0]"
 */

/* Register address for bitfield rpf_l3_v4_req_tag{F}[2:0] */
#define HW_ATL2_RPF_L3_V4_TAG_ADR(filter) (0x00006500u + (filter) * 0x4)
/* Bitmask for bitfield rpf_l3_v4_req_tag{F}[2:0] */
#define HW_ATL2_RPF_L3_V4_TAG_MSK 0x00000070u
/* Inverted bitmask for bitfield rpf_l3_v4_req_tag{F}[2:0] */
#define HW_ATL2_RPF_L3_V4_TAG_MSKN 0xFFFFFF8Fu
/* Lower bit position of bitfield rpf_l3_v4_req_tag{F}[2:0] */
#define HW_ATL2_RPF_L3_V4_TAG_SHIFT 4
/* Width of bitfield rpf_l3_v4_req_tag{F}[2:0] */
#define HW_ATL2_RPF_L3_V4_TAG_WIDTH 3
/* Default value of bitfield rpf_l3_v4_req_tag{F}[2:0] */
#define HW_ATL2_RPF_L3_V4_TAG_DEFAULT 0x0

/* RX rpf_l3_v6_req_tag{F}[2:0] Bitfield Definitions
 * Preprocessor definitions for the bitfield "rpf_l3_v6_req_tag{F}[2:0]".
 * Parameter: filter {F} | stride size 0x4 | range [0, 7]
 * PORT="pif_rpf_l3_v6_req_tag0[2:0]"
 */

/* Register address for bitfield rpf_l3_v6_req_tag{F}[2:0] */
#define HW_ATL2_RPF_L3_V6_TAG_ADR(filter) (0x00006500u + (filter) * 0x4)
/* Bitmask for bitfield rpf_l3_v6_req_tag{F}[2:0] */
#define HW_ATL2_RPF_L3_V6_TAG_MSK 0x00700000
/* Inverted bitmask for bitfield rpf_l3_v6_req_tag{F}[2:0] */
#define HW_ATL2_RPF_L3_V6_TAG_MSKN 0xFF8FFFFFu
/* Lower bit position of bitfield rpf_l3_v6_req_tag{F}[2:0] */
#define HW_ATL2_RPF_L3_V6_TAG_SHIFT 20
/* Width of bitfield rpf_l3_v6_req_tag{F}[2:0] */
#define HW_ATL2_RPF_L3_V6_TAG_WIDTH 3
/* Default value of bitfield rpf_l3_v6_req_tag{F}[2:0] */
#define HW_ATL2_RPF_L3_V6_TAG_DEFAULT 0x0

/* RX rpf_l4_cmd{F}[2:0] Bitfield Definitions
 * Preprocessor definitions for the bitfield "rpf_l4_cmd{F}[2:0]".
 * Parameter: filter {F} | stride size 0x4 | range [0, 7]
 * PORT="pif_rpf_l4_cmd{F}[2:0]"
 */

/* Register address for bitfield rpf_l4_cmd{F}[2:0] */
#define HW_ATL2_RPF_L4_CMD_ADR(filter) (0x00006520u + (filter) * 0x4)
/* Bitmask for bitfield rpf_l4_cmd{F}[2:0] */
#define HW_ATL2_RPF_L4_CMD_MSK 0x00000007u
/* Inverted bitmask for bitfield rpf_l4_cmd{F}[2:0] */
#define HW_ATL2_RPF_L4_CMD_MSKN 0xFFFFFFF8u
/* Lower bit position of bitfield rpf_l4_cmd{F}[2:0] */
#define HW_ATL2_RPF_L4_CMD_SHIFT 0
/* Width of bitfield rpf_l4_cmd{F}[2:0]*/
#define HW_ATL2_RPF_L4_CMD_WIDTH 3
/* Default value of bitfield rpf_l4_cmd{F}[2:0] */
#define HW_ATL2_RPF_L4_CMD_DEFAULT 0x0

/* RX rpf_l4_req_tag{F}[2:0] Bitfield Definitions
 * Preprocessor definitions for the bitfield "rpf_l4_tag{F}[2:0]".
 * Parameter: filter {F} | stride size 0x4 | range [0, 7]
 * PORT="pif_rpf_l4_tag{F}[2:0]"
 */

/* Register address for bitfield rpf_l4_tag{F}[2:0] */
#define HW_ATL2_RPF_L4_TAG_ADR(filter) (0x00006520u + (filter) * 0x4)
/* Bitmask for bitfield rpf_l4_tag{F}[2:0] */
#define HW_ATL2_RPF_L4_TAG_MSK 0x00000070u
/* Inverted bitmask for bitfield rpf_l4_tag{F}[2:0] */
#define HW_ATL2_RPF_L4_TAG_MSKN 0xFFFFFF8Fu
/* Lower bit position of bitfield rpf_l4_tag{F}[2:0] */
#define HW_ATL2_RPF_L4_TAG_SHIFT 4
/* Width of bitfield rpf_l4_tag{F}[2:0]*/
#define HW_ATL2_RPF_L4_TAG_WIDTH 3
/* Default value of bitfield rpf_l4_tag{F}[2:0] */
#define HW_ATL2_RPF_L4_TAG_DEFAULT 0x0

/* RX l4_prot{F}[2:0] Bitfield Definitions
 * Preprocessor definitions for the bitfield "l4_prot{F}[2:0]".
 * Parameter: filter {F} | stride size 0x4 | range [0, 7]
 * PORT="pif_rpf_l4_prot0_i[2:0]"
 */

/* Register address for bitfield l4_prot{F}[2:0] */
#define HW_ATL2_RPF_L4_PROTF_ADR(filter) (0x00005380u + (filter) * 0x4)
/* Bitmask for bitfield l4_prot{F}[2:0] */
#define HW_ATL2_RPF_L4_PROTF_MSK 0x00000007u
/* Inverted bitmask for bitfield l4_prot{F}[2:0] */
#define HW_ATL2_RPF_L4_PROTF_MSKN 0xFFFFFFF8u
/* Lower bit position of bitfield l4_prot{F}[2:0] */
#define HW_ATL2_RPF_L4_PROTF_SHIFT 0
/* Width of bitfield l4_prot{F}[2:0] */
#define HW_ATL2_RPF_L4_PROTF_WIDTH 3
/* Default value of bitfield l4_prot{F}[2:0] */
#define HW_ATL2_RPF_L4_PROTF_DEFAULT 0x0

/* RX rx_q{Q}_tc_map[2:0] Bitfield Definitions
 * Preprocessor definitions for the bitfield "rx_q{Q}_tc_map[2:0]".
 * Parameter: Queue {Q} | bit-level stride | range [0, 31]
 * PORT="pif_rx_q0_tc_map_i[2:0]"
 */

/* Register address for bitfield rx_q{Q}_tc_map[2:0] */
#define HW_ATL2_RX_Q_TC_MAP_ADR(queue) \
	(((queue) < 32) ? 0x00005900 + ((queue) / 8) * 4 : 0)
/* Lower bit position of bitfield rx_q{Q}_tc_map[2:0] */
#define HW_ATL2_RX_Q_TC_MAP_SHIFT(queue) \
	(((queue) < 32) ? ((queue) * 4) % 32 : 0)
/* Width of bitfield rx_q{Q}_tc_map[2:0] */
#define HW_ATL2_RX_Q_TC_MAP_WIDTH 3
/* Default value of bitfield rx_q{Q}_tc_map[2:0] */
#define HW_ATL2_RX_Q_TC_MAP_DEFAULT 0x0

#define HW_ATL2_RDM_RX_DESC_RD_REQ_LIMIT_ADR 0x00005A04

/* TX desc{D}_ts_wrb_en Bitfield Definitions
 */
#define HW_ATL2_TDM_DESCD_TS_WRB_EN_ADR(descriptor) \
	(0x00007C08 + (descriptor) * 0x40)
#define HW_ATL2_TDM_DESCD_TS_WRB_EN_MSK 0x00040000
#define HW_ATL2_TDM_DESCD_TS_WRB_EN_MSKN 0xFFFBFFFF
#define HW_ATL2_TDM_DESCD_TS_WRB_EN_SHIFT 18
#define HW_ATL2_TDM_DESCD_TS_WRB_EN_WIDTH 1
#define HW_ATL2_TDM_DESCD_TS_WRB_EN_DEFAULT 0x0

/* TX desc{D}_ts_en Bitfield Definitions
 */
#define HW_ATL2_TDM_DESCD_TS_EN_ADR(descriptor) \
	(0x00007C08 + (descriptor) * 0x40)
#define HW_ATL2_TDM_DESCD_TS_EN_MSK 0x00020000
#define HW_ATL2_TDM_DESCD_TS_EN_MSKN 0xFFFDFFFF
#define HW_ATL2_TDM_DESCD_TS_EN_SHIFT 17
#define HW_ATL2_TDM_DESCD_TS_EN_WIDTH 1
#define HW_ATL2_TDM_DESCD_TS_EN_DEFAULT 0x0

/* TX desc{D}_avb_en Bitfield Definitions
 */
#define HW_ATL2_TDM_DESCD_AVB_EN_ADR(descriptor) \
	(0x00007C08 + (descriptor) * 0x40)
#define HW_ATL2_TDM_DESCD_AVB_EN_MSK 0x00010000
#define HW_ATL2_TDM_DESCD_AVB_EN_MSKN 0xFFFEFFFF
#define HW_ATL2_TDM_DESCD_AVB_EN_SHIFT 16
#define HW_ATL2_TDM_DESCD_AVB_EN_WIDTH 1
#define HW_ATL2_TDM_DESCD_AVB_EN_DEFAULT 0x0


/* tx tx_buffer_clk_gate_en bitfield definitions
 * preprocessor definitions for the bitfield "tx_buffer_clk_gate_en".
 * port="pif_tpb_tx_buffer_clk_gate_en_i"
 */

/* register address for bitfield tx_buffer_clk_gate_en */
#define HW_ATL2_TPB_TX_BUF_CLK_GATE_EN_ADR 0x00007900
/* bitmask for bitfield tx_buffer_clk_gate_en */
#define HW_ATL2_TPB_TX_BUF_CLK_GATE_EN_MSK 0x00000020
/* inverted bitmask for bitfield tx_buffer_clk_gate_en */
#define HW_ATL2_TPB_TX_BUF_CLK_GATE_EN_MSKN 0xffffffdf
/* lower bit position of bitfield tx_buffer_clk_gate_en */
#define HW_ATL2_TPB_TX_BUF_CLK_GATE_EN_SHIFT 5
/* width of bitfield tx_buffer_clk_gate_en */
#define HW_ATL2_TPB_TX_BUF_CLK_GATE_EN_WIDTH 1
/* default value of bitfield tx_buffer_clk_gate_en */
#define HW_ATL2_TPB_TX_BUF_CLK_GATE_EN_DEFAULT 0x0

/* tx data_tc{t}_credit_max[b:0] bitfield definitions
 * preprocessor definitions for the bitfield "data_tc{t}_credit_max[b:0]".
 * parameter: tc {t} | stride size 0x4 | range [0, 7]
 * port="pif_tps_data_tc0_credit_max_i[11:0]"
 */

/* register address for bitfield data_tc{t}_credit_max[b:0] */
#define HW_ATL2_TPS_DATA_TCTCREDIT_MAX_ADR(tc) (0x00007110 + (tc) * 0x4)
/* bitmask for bitfield data_tc{t}_credit_max[b:0] */
#define HW_ATL2_TPS_DATA_TCTCREDIT_MAX_MSK 0x0fff0000
/* inverted bitmask for bitfield data_tc{t}_credit_max[b:0] */
#define HW_ATL2_TPS_DATA_TCTCREDIT_MAX_MSKN 0xf000ffff
/* lower bit position of bitfield data_tc{t}_credit_max[b:0] */
#define HW_ATL2_TPS_DATA_TCTCREDIT_MAX_SHIFT 16
/* width of bitfield data_tc{t}_credit_max[b:0] */
#define HW_ATL2_TPS_DATA_TCTCREDIT_MAX_WIDTH 12
/* default value of bitfield data_tc{t}_credit_max[b:0] */
#define HW_ATL2_TPS_DATA_TCTCREDIT_MAX_DEFAULT 0x0

/* tx data_tc{t}_weight[8:0] bitfield definitions
 * preprocessor definitions for the bitfield "data_tc{t}_weight[8:0]".
 * parameter: tc {t} | stride size 0x4 | range [0, 7]
 * port="pif_tps_data_tc0_weight_i[8:0]"
 */

/* register address for bitfield data_tc{t}_weight[8:0] */
#define HW_ATL2_TPS_DATA_TCTWEIGHT_ADR(tc) (0x00007110 + (tc) * 0x4)
/* bitmask for bitfield data_tc{t}_weight[8:0] */
#define HW_ATL2_TPS_DATA_TCTWEIGHT_MSK 0x000001ff
/* inverted bitmask for bitfield data_tc{t}_weight[8:0] */
#define HW_ATL2_TPS_DATA_TCTWEIGHT_MSKN 0xfffffe00
/* lower bit position of bitfield data_tc{t}_weight[8:0] */
#define HW_ATL2_TPS_DATA_TCTWEIGHT_SHIFT 0
/* width of bitfield data_tc{t}_weight[8:0] */
#define HW_ATL2_TPS_DATA_TCTWEIGHT_WIDTH 9
/* default value of bitfield data_tc{t}_weight[8:0] */
#define HW_ATL2_TPS_DATA_TCTWEIGHT_DEFAULT 0x0

/* TX TDM AVB Prefetch Delay Value Register 0 Definitions
 */
#define HW_ATL2_TX_TDM_AVB_PREFETCH_DELAY_VALUE0_ADR(queue) \
	(0x00007C24u + (queue) * 0x40)

/* tx interrupt moderation control register definitions
 * Preprocessor definitions for TX Interrupt Moderation Control Register
 * Base Address: 0x00007c28
 * Parameter: queue {Q} | stride size 0x4 | range [0, 31]
 */

#define HW_ATL2_TX_INTR_MODERATION_CTL_ADR(queue) (0x00007c28u + (queue) * 0x40)

/* TX tx_data_rd_req_limit[7:0] Bitfield Definitions
 */
#define HW_ATL2_TDM_TX_DATA_RD_REQ_LIMIT_ADR 0x00007B04
#define HW_ATL2_TDM_TX_DATA_RD_REQ_LIMIT_MSK 0x0000FF00
#define HW_ATL2_TDM_TX_DATA_RD_REQ_LIMIT_MSKN 0xFFFF00FF
#define HW_ATL2_TDM_TX_DATA_RD_REQ_LIMIT_SHIFT 8
#define HW_ATL2_TDM_TX_DATA_RD_REQ_LIMIT_WIDTH 8
#define HW_ATL2_TDM_TX_DATA_RD_REQ_LIMIT_DEFAULT 0x10

/* TX tx_desc_rd_req_limit[4:0] Bitfield Definitions
 */
#define HW_ATL2_TDM_TX_DESC_RD_REQ_LIMIT_ADR 0x00007B04
#define HW_ATL2_TDM_TX_DESC_RD_REQ_LIMIT_MSK 0x0000001F
#define HW_ATL2_TDM_TX_DESC_RD_REQ_LIMIT_MSKN 0xFFFFFFE0
#define HW_ATL2_TDM_TX_DESC_RD_REQ_LIMIT_SHIFT 0
#define HW_ATL2_TDM_TX_DESC_RD_REQ_LIMIT_WIDTH 5
#define HW_ATL2_TDM_TX_DESC_RD_REQ_LIMIT_DEFAULT 0x8

/* global microprocessor scratch pad definitions */
#define HW_ATL2_GLB_CPU_SCRATCH_SCP_ADR(scratch_scp) \
	(0x00000300u + (scratch_scp) * 0x4)

#define HW_ATL2_RX_CTRL_ADDR_BEGIN_FL3L4   0x00005380
#define HW_ATL2_RX_SRCA_ADDR_BEGIN_FL3L4   0x000053B0
#define HW_ATL2_RX_DESTA_ADDR_BEGIN_FL3L4  0x000053D0

#define HW_ATL2_RX_GET_ADDR_CTRL_FL3L4(location)  \
	(HW_ATL2_RX_CTRL_ADDR_BEGIN_FL3L4 + ((location) * 0x4))
#define HW_ATL2_RX_GET_ADDR_SRCA_FL3L4(location)  \
	(HW_ATL2_RX_SRCA_ADDR_BEGIN_FL3L4 + ((location) * 0x4))
#define HW_ATL2_RX_GET_ADDR_DESTA_FL3L4(location) \
	(HW_ATL2_RX_DESTA_ADDR_BEGIN_FL3L4 + ((location) * 0x4))

#define HW_ATL2_TIMESTAMPGENERATOR1_ADR 0x00000CA0u
#define HW_ATL2_PTPRESET_MSK 0x00000001
#define HW_ATL2_PTMRESET_MSK 0x00000002
#define HW_ATL2_PTPCLOCKENABLE_MSK 0x00000004
#define HW_ATL2_PTMCLOCKENABLE_MSK 0x00000008
#define HW_ATL2_PTPRESET_SHIFT 0
#define HW_ATL2_PTMRESET_SHIFT 1
#define HW_ATL2_PTPCLOCKENABLE_SHIFT 2
#define HW_ATL2_PTMCLOCKENABLE_SHIFT 3

#define HW_ATL2_TIMESTAMPGENERATOR2_ADR 0x00000CA4u
#define HW_ATL2_SETPTPTIMERCOUNTERS_MSK 0x00000001
#define HW_ATL2_SUBTRACTPTPTIMERCOUNTERS_MSK 0x00000002
#define HW_ATL2_ADDPTPTIMERCOUNTERS_MSK 0x00000004
#define HW_ATL2_SETPTMTIMERCOUNTERS_MSK 0x00000008
#define HW_ATL2_SUBTRACTPTMTIMERCOUNTERS_MSK 0x00000010
#define HW_ATL2_ADDPTMTIMERCOUNTERS_MSK 0x00000020
#define HW_ATL2_PTPLOADPERCLOCKINCREMENTVALUE_MSK 0x00000040
#define HW_ATL2_PTMLOADPERCLOCKINCREMENTVALUE_MSK 0x00000080
#define HW_ATL2_PTPDIGITALCLOCKREAD_MSK 0x00000100
#define HW_ATL2_PTMDIGITALCLOCKREAD_MSK 0x00000200
#define HW_ATL2_SETPTPTIMERCOUNTERS_SHIFT 0
#define HW_ATL2_SUBTRACTPTPTIMERCOUNTERS_SHIFT 1
#define HW_ATL2_ADDPTPTIMERCOUNTERS_SHIFT 2
#define HW_ATL2_SETPTMTIMERCOUNTERS_SHIFT 3
#define HW_ATL2_SUBTRACTPTMTIMERCOUNTERS_SHIFT 4
#define HW_ATL2_ADDPTMTIMERCOUNTERS_SHIFT 5
#define HW_ATL2_PTPLOADPERCLOCKINCREMENTVALUE_SHIFT 6
#define HW_ATL2_PTMLOADPERCLOCKINCREMENTVALUE_SHIFT 7
#define HW_ATL2_PTPDIGITALCLOCKREAD_SHIFT 8
#define HW_ATL2_PTMDIGITALCLOCKREAD_SHIFT 9

#define HW_ATL2_TSGPTPGPIOCTRL_ADR 0x00000CC4u
#define HW_ATL2_PTPENCLOCKEVENTOUTPUT_MSK 0x00000001
#define HW_ATL2_PTPENCLOCKEVENTOUTPUT_SHIFT 0
#define HW_ATL2_PTPCLOCKEVENTOUTPUTMODE_MSK 0x00000006
#define HW_ATL2_PTPCLOCKEVENTOUTPUTMODE_SHIFT 1
#define HW_ATL2_PTPSETBITPOSITION_MSK 0x000000f8
#define HW_ATL2_PTPSETBITPOSITION_SHIFT 3
#define HW_ATL2_PTMENCLOCKEVENTOUTPUT_MSK 0x00000100
#define HW_ATL2_PTMENCLOCKEVENTOUTPUT_SHIFT 8
#define HW_ATL2_PTMCLOCKEVENTOUTPUTMODE_MSK 0x00000600
#define HW_ATL2_PTMCLOCKEVENTOUTPUTMODE_SHIFT 9
#define HW_ATL2_PTMSETBITPOSITION_MSK 0x0000f800
#define HW_ATL2_PTMSETBITPOSITION_SHIFT 11
#define HW_ATL2_PTPENINPUTEVENTMON_MSK 0x00010000
#define HW_ATL2_PTPENINPUTEVENTMON_SHIFT 16
#define HW_ATL2_PTPINPUTEVENTMONMODE_MSK 0x00060000
#define HW_ATL2_PTPINPUTEVENTMONMODE_SHIFT 17
#define HW_ATL2_PTMENINPUTEVENTMON_MSK 0x00080000
#define HW_ATL2_PTMENINPUTEVENTMON_SHIFT 19
#define HW_ATL2_PTMINPUTEVENTMONMODE_MSK 0x00300000
#define HW_ATL2_PTMINPUTEVENTMONMODE_SHIFT 20
#define HW_ATL2_PTPGPIOUPDATEMODE_MSK 0x00c00000
#define HW_ATL2_PTPGPIOUPDATEMODE_SHIFT 22
#define HW_ATL2_PTMGPIOUPDATEMODE_MSK 0x03000000
#define HW_ATL2_PTMGPIOUPDATEMODE_SHIFT 24

/* Register address for bitfield Modify PTP fractional Nano-second counter value 1 */
#define HW_ATL2_MODIFYPTPFRACTIONALNANOSECONDCOUNTERVALUE1_ADR 0x00000CA8
/* Register address for bitfield Modify PTM Nano-second counter value 0 */
#define HW_ATL2_MODIFYPTPNANOSECONDCOUNTERVALUE0_ADR 0x00000CAC
/* Register address for bitfield Modify PTM Nano-second counter value 1 */
#define HW_ATL2_MODIFYPTPNANOSECONDCOUNTERVALUE1_ADR 0x00000CB0

/* Register address for bitfield Modify PTP fractional Nano-second counter value 1 */
#define HW_ATL2_MODIFYPTMFRACTIONALNANOSECONDCOUNTERVALUE1_ADR 0x00000CF8
/* Register address for bitfield Modify PTM Nano-second counter value 0 */
#define HW_ATL2_MODIFYPTMNANOSECONDCOUNTERVALUE0_ADR 0x00000CFC
/* Register address for bitfield Modify PTM Nano-second counter value 1 */
#define HW_ATL2_MODIFYPTMNANOSECONDCOUNTERVALUE1_ADR 0x00000D00

/* Register address for bitfield Modify PTP counter increment value */
#define  HW_ATL2_PTPCOUNTERINCREMENTVALUE_ADR 0x00000CB4

/* Register address for bitfield Modify PTM counter increment value */
#define  HW_ATL2_PTMCOUNTERINCREMENTVALUE_ADR 0x00000D04

/* Register address for bitfield digital clock nanosecond count bits 31:0 */
#define HW_ATL2_PTPCLOCKNANOSECONDCOUNTBIT_LSW_ADR 0x00000CBC

/* Register address for bitfield digital clock nanosecond count bits 63:32 */
#define HW_ATL2_PTPCLOCKNANOSECONDCOUNTBIT_MSW_ADR 0x00000CC0

/* Register address for bitfield PTM digital clock nanosecond count bits 31:0 */
#define HW_ATL2_PTMCLOCKNANOSECONDCOUNTBIT_LSW_ADR 0x00000D0C

/* Register address for bitfield PTM digital clock nanosecond count bits 63:32 */
#define HW_ATL2_PTMCLOCKNANOSECONDCOUNTBIT_MSW_ADR 0x00000D10

/* Register address for bitfield TSG PTP GPIO event timestamp nanosecond bits 31:0 */
#define HW_ATL2_PTPGPIOEVENTTS_LSW_ADR 0x00000CD0

/* Register address for bitfield TSG PTP GPIO event timestamp nanosecond bits 63:32 */
#define HW_ATL2_PTPGPIOEVENTTS_MSW_ADR 0x00000CD4

/* Register address for bitfield TSG PTM GPIO event timestamp nanosecond bits 31:0 */
#define HW_ATL2_PTMGPIOEVENTTS_LSW_ADR 0x00000D0C

/* Register address for bitfield TSG PTM GPIO event timestamp nanosecond bits 63:32 */
#define HW_ATL2_PTMGPIOEVENTTS_MSW_ADR 0x00000D10

/* PCIE Extended tag enable Bitfield Definitions
 */
#define HW_ATL2_PHI_EXTENDED_TAG_EN_ADR 0x00001000
#define HW_ATL2_PHI_EXTENDED_TAG_EN_MSK 0x00000020
#define HW_ATL2_PHI_EXTENDED_TAG_EN_MSKN 0xFFFFFFDF
#define HW_ATL2_PHI_EXTENDED_TAG_EN_SHIFT 5
#define HW_ATL2_PHI_EXTENDED_TAG_EN_WIDTH 1
#define HW_ATL2_PHI_EXTENDED_TAG_EN_DEFAULT 0x0

/* PCI core control register */
#define HW_ATL2_PCI_REG_CONTROL6_ADR 0x1014u

/* Launch time control register */
#define HW_ATL2_LT_CTRL_ADR 0x00007a1c

#define HW_ATL2_LT_CTRL_AVB_LEN_CMP_TRSHLD_MSK 0xFFFF0000
#define HW_ATL2_LT_CTRL_AVB_LEN_CMP_TRSHLD_SHIFT 16

#define HW_ATL2_LT_CTRL_CLK_RATIO_MSK 0x0000FF00
#define HW_ATL2_LT_CTRL_CLK_RATIO_SHIFT 8
#define HW_ATL2_LT_CTRL_CLK_RATIO_QUATER_SPEED 4
#define HW_ATL2_LT_CTRL_CLK_RATIO_HALF_SPEED 2
#define HW_ATL2_LT_CTRL_CLK_RATIO_FULL_SPEED 1

#define HW_ATL2_LT_CTRL_25G_MODE_SUPPORT_MSK 0x00000008
#define HW_ATL2_LT_CTRL_25G_MODE_SUPPORT_SHIFT 3

#define HW_ATL2_LT_CTRL_LINK_SPEED_MSK 0x00000007
#define HW_ATL2_LT_CTRL_LINK_SPEED_SHIFT 0

/* FPGA VER register */
#define HW_ATL2_FPGA_VER_ADR 0x000000f4
#define HW_ATL2_FPGA_VER_U32(mj, mi, bl, rv) ( \
	((mj & 0xff) << 24) | \
	((mi & 0xff) << 16)  | \
	((bl & 0xff) << 8 ) | \
	((rv & 0xff) <<0 ))

/* ahb_mem_addr{f}[31:0] Bitfield Definitions
 * Preprocessor definitions for the bitfield "ahb_mem_addr{f}[31:0]".
 * Parameter: filter {f} | stride size 0x10 | range [0, 127]
 * PORT="ahb_mem_addr{f}[31:0]"
 */

/* Register address for bitfield ahb_mem_addr{f}[31:0] */
#define HW_ATL2_RPF_ACT_RSLVR_REQ_TAG_ADR(filter) (0x00014000u + (filter) * 0x10)
/* Bitmask for bitfield ahb_mem_addr{f}[31:0] */
#define HW_ATL2_RPF_ACT_RSLVR_REQ_TAG_MSK 0xFFFFFFFFu
/* Inverted bitmask for bitfield ahb_mem_addr{f}[31:0] */
#define HW_ATL2_RPF_ACT_RSLVR_REQ_TAG_MSKN 0x00000000u
/* Lower bit position of bitfield ahb_mem_addr{f}[31:0] */
#define HW_ATL2_RPF_ACT_RSLVR_REQ_TAG_SHIFT 0
/* Width of bitfield ahb_mem_addr{f}[31:0] */
#define HW_ATL2_RPF_ACT_RSLVR_REQ_TAG_WIDTH 31
/* Default value of bitfield ahb_mem_addr{f}[31:0] */
#define HW_ATL2_RPF_ACT_RSLVR_REQ_TAG_DEFAULT 0x0

/* Register address for bitfield ahb_mem_addr{f}[31:0] */
#define HW_ATL2_RPF_ACT_RSLVR_TAG_MASK_ADR(filter) (0x00014004u + (filter) * 0x10)
/* Bitmask for bitfield ahb_mem_addr{f}[31:0] */
#define HW_ATL2_RPF_ACT_RSLVR_TAG_MASK_MSK 0xFFFFFFFFu
/* Inverted bitmask for bitfield ahb_mem_addr{f}[31:0] */
#define HW_ATL2_RPF_ACT_RSLVR_TAG_MASK_MSKN 0x00000000u
/* Lower bit position of bitfield ahb_mem_addr{f}[31:0] */
#define HW_ATL2_RPF_ACT_RSLVR_TAG_MASK_SHIFT 0
/* Width of bitfield ahb_mem_addr{f}[31:0] */
#define HW_ATL2_RPF_ACT_RSLVR_TAG_MASK_WIDTH 31
/* Default value of bitfield ahb_mem_addr{f}[31:0] */
#define HW_ATL2_RPF_ACT_RSLVR_TAG_MASK_DEFAULT 0x0

/* Register address for bitfield ahb_mem_addr{f}[31:0] */
#define HW_ATL2_RPF_ACT_RSLVR_ACTN_ADR(filter) (0x00014008u + (filter) * 0x10)
/* Bitmask for bitfield ahb_mem_addr{f}[31:0] */
#define HW_ATL2_RPF_ACT_RSLVR_ACTN_MSK 0x000007FFu
/* Inverted bitmask for bitfield ahb_mem_addr{f}[31:0] */
#define HW_ATL2_RPF_ACT_RSLVR_ACTN_MSKN 0xFFFFF800u
/* Lower bit position of bitfield ahb_mem_addr{f}[31:0] */
#define HW_ATL2_RPF_ACT_RSLVR_ACTN_SHIFT 0
/* Width of bitfield ahb_mem_addr{f}[31:0] */
#define HW_ATL2_RPF_ACT_RSLVR_ACTN_WIDTH 10
/* Default value of bitfield ahb_mem_addr{f}[31:0] */
#define HW_ATL2_RPF_ACT_RSLVR_ACTN_DEFAULT 0x0

/* rpf_rec_tab_en[15:0] Bitfield Definitions
 * Preprocessor definitions for the bitfield "rpf_rec_tab_en[15:0]".
 * PORT="pif_rpf_rec_tab_en[15:0]"
 */
/* Register address for bitfield rpf_rec_tab_en[15:0] */
#define HW_ATL2_RPF_REC_TAB_EN_ADR 0x00006ff0u
/* Bitmask for bitfield rpf_rec_tab_en[15:0] */
#define HW_ATL2_RPF_REC_TAB_EN_MSK 0x0000FFFFu
/* Inverted bitmask for bitfield rpf_rec_tab_en[15:0] */
#define HW_ATL2_RPF_REC_TAB_EN_MSKN 0xFFFF0000u
/* Lower bit position of bitfield rpf_rec_tab_en[15:0] */
#define HW_ATL2_RPF_REC_TAB_EN_SHIFT 0
/* Width of bitfield rpf_rec_tab_en[15:0] */
#define HW_ATL2_RPF_REC_TAB_EN_WIDTH 16
/* Default value of bitfield rpf_rec_tab_en[15:0] */
#define HW_ATL2_RPF_REC_TAB_EN_DEFAULT 0x0


/* Register address for firmware shared input buffer */
#define HW_ATL2_MIF_SHARED_BUFFER_IN_ADR(dword) (0x00012000U + (dword) * 0x4U)
/* Register address for firmware shared output buffer */
#define HW_ATL2_MIF_SHARED_BUFFER_OUT_ADR(dword) (0x00013000U + (dword) * 0x4U)

/* pif_host_finished_buf_wr_i Bitfield Definitions
 * Preprocessor definitions for the bitfield "pif_host_finished_buf_wr_i".
 * PORT="pif_host_finished_buf_wr_i"
 */
/* Register address for bitfield rpif_host_finished_buf_wr_i */
#define HW_ATL2_MIF_HOST_FINISHED_WRITE_ADR 0x00000e00u
/* Bitmask for bitfield pif_host_finished_buf_wr_i */
#define HW_ATL2_MIF_HOST_FINISHED_WRITE_MSK 0x00000001u
/* Inverted bitmask for bitfield pif_host_finished_buf_wr_i */
#define HW_ATL2_MIF_HOST_FINISHED_WRITE_MSKN 0xFFFFFFFEu
/* Lower bit position of bitfield pif_host_finished_buf_wr_i */
#define HW_ATL2_MIF_HOST_FINISHED_WRITE_SHIFT 0
/* Width of bitfield pif_host_finished_buf_wr_i */
#define HW_ATL2_MIF_HOST_FINISHED_WRITE_WIDTH 1
/* Default value of bitfield pif_host_finished_buf_wr_i */
#define HW_ATL2_MIF_HOST_FINISHED_WRITE_DEFAULT 0x0


/* pif_mcp_finished_buf_rd_i Bitfield Definitions
 * Preprocessor definitions for the bitfield "pif_mcp_finished_buf_rd_i".
 * PORT="pif_mcp_finished_buf_rd_i"
 */
/* Register address for bitfield pif_mcp_finished_buf_rd_i */
#define HW_ATL2_MIF_MCP_FINISHED_READ_ADR 0x00000e04u
/* Bitmask for bitfield pif_mcp_finished_buf_rd_i */
#define HW_ATL2_MIF_MCP_FINISHED_READ_MSK 0x00000001u
/* Inverted bitmask for bitfield pif_mcp_finished_buf_rd_i */
#define HW_ATL2_MIF_MCP_FINISHED_READ_MSKN 0xFFFFFFFEu
/* Lower bit position of bitfield pif_mcp_finished_buf_rd_i */
#define HW_ATL2_MIF_MCP_FINISHED_READ_SHIFT 0
/* Width of bitfield pif_mcp_finished_buf_rd_i */
#define HW_ATL2_MIF_MCP_FINISHED_READ_WIDTH 1
/* Default value of bitfield pif_mcp_finished_buf_rd_i */
#define HW_ATL2_MIF_MCP_FINISHED_READ_DEFAULT 0x0

/* Register address for bitfield pif_mcp_boot_reg */
#define HW_ATL2_MIF_BOOT_REG_ADR 0x00003040u

#define HW_ATL2_MCP_HOST_REQ_INT_READY BIT(0)

#define HW_ATL2_MCP_HOST_REQ_INT_ADR 0x00000F00u
#define HW_ATL2_MCP_HOST_REQ_INT_SET_ADR 0x00000F04u
#define HW_ATL2_MCP_HOST_REQ_INT_CLR_ADR 0x00000F08u

#endif /* HW_ATL2_LLH_INTERNAL_H */
