/*
 * Decompiled with CFR 0.152.
 */
package manager.configure;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import manager.configure.Platform;
import manager.utils.ManagerFileUtils;

@XmlRootElement(name="FDKPlatformConfiguration")
public class ISSPlatformConfiguration {
    public static final String CONFIG_FILL_NAME = "platform.xml";
    private static final String PLATFORM_CONFIGURE_ERROR = "Platform.xml not existed or parse error";
    private static ISSPlatformConfiguration sConfig;
    @XmlAttribute
    private String version = "unKnonwn";
    @XmlElement(name="platform")
    private List<Platform> platforms;

    public List<Platform> getSupportedPlatforms() {
        return this.platforms;
    }

    public Platform getPlatformByName(String name) {
        for (Platform platform : this.platforms) {
            if (!platform.getName().toLowerCase().equals(name.toLowerCase())) continue;
            return platform;
        }
        return null;
    }

    public String[] getPlatformNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Platform platform : this.platforms) {
            names.add(platform.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public String[] getPlatformExternalNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Platform platform : this.platforms) {
            if (platform.isDeprecated()) continue;
            names.add(platform.getExternalName());
        }
        return names.toArray(new String[names.size()]);
    }

    public Platform getPlatformByValue(double value) {
        for (Platform platform : this.platforms) {
            if (!platform.equalsValue(value)) continue;
            return platform;
        }
        return null;
    }

    public Platform getPlatformByIssVersion(String issStr) {
        for (Platform platform : this.platforms) {
            if (!platform.getIssVersion().equals(issStr)) continue;
            return platform;
        }
        return null;
    }

    public Platform getPlatformByExternalName(String externalName) {
        for (Platform platform : this.platforms) {
            if (!platform.getExternalName().toLowerCase().equals(externalName.toLowerCase())) continue;
            return platform;
        }
        return null;
    }

    public String dump() {
        String s = "*** start of platform configuration ***\n";
        s = String.valueOf(s) + "version=" + this.version + "\n";
        for (Platform plat : this.platforms) {
            s = String.valueOf(s) + plat.dump() + "\n";
        }
        s = String.valueOf(s) + "*** end of platform configuration ***\n";
        return s;
    }

    public static String getConfigFile() throws Exception {
        String folder = ManagerFileUtils.FDK_ECLIPSE_CONFIG_FOLDER();
        return String.valueOf(folder) + File.separator + CONFIG_FILL_NAME;
    }

    public static String getConfigFile(String configfilepath) throws Exception {
        String folder = configfilepath;
        return String.valueOf(folder) + File.separator + CONFIG_FILL_NAME;
    }

    public static ISSPlatformConfiguration getInstance() throws Exception {
        if (sConfig == null) {
            ISSPlatformConfiguration.init(ISSPlatformConfiguration.getConfigFile());
        }
        return sConfig;
    }

    public static ISSPlatformConfiguration getInstance(String configfilepath) throws Exception {
        if (configfilepath != null && !configfilepath.isEmpty()) {
            ISSPlatformConfiguration.init(ISSPlatformConfiguration.getConfigFile(configfilepath));
        }
        return sConfig;
    }

    private static void init(String configFile) throws Exception {
        try (FileInputStream xmlInput = null;){
            try {
                JAXBContext jc = JAXBContext.newInstance(ISSPlatformConfiguration.class, Platform.class);
                xmlInput = new FileInputStream(configFile);
                sConfig = (ISSPlatformConfiguration)jc.createUnmarshaller().unmarshal(xmlInput);
            }
            catch (Exception e) {
                throw new Exception(PLATFORM_CONFIGURE_ERROR);
            }
        }
    }
}

