<?php

class ActionSaveCustomizeGroup extends ActionAcceleratorGroupBase {
    private $groupName;
    private $selectedPaths;
    private $volume;

    protected function validatePara() {
    }

    protected function initActionPara() {
        $this->groupName = getRequestPara("groupName");
        $this->selectedPaths = getRequestPara("selectedPaths");
        $this->volume = getRequestPara("volume");
    }

    public function doSave() {
        //add group
        $appDA = new ApplicationDataAccess();

        //check name TODO
        if ($appDA->findByAppNameAndVolume($this->groupName,$this->volume) != null) {
            $this->setGroupExistCmdXmlRetFail();
        } else {
            $newApp = new Application();
            $newApp->setAppName($this->groupName);
            $newApp->setAppType(AppType::TYPE_CUSTOM);
            $newApp->setVolume($this->volume);
            $appDA->addApp($newApp);

            $app = $appDA->findByAppNameAndVolume($this->groupName,$this->volume);
            $appid = $app->getKeyId();

            //add files to group
            $appFileDA = new ApplicationFileDataAccess();
            $paths = explode("|", $this->selectedPaths);

            foreach ($paths as $path) {
                $appFile = new ApplicationFile();
                $appFile->setAppID($appid);
                $appFile->setFilePath($path);
                $appFileDA->addFileForApp($appFile);
            }

            //update app, calculate size
            $this->updateApplication($appid);
            
            $this->setCmdXmlRetSuccess();

        }
    }

    private function setGroupExistCmdXmlRetFail() {
        $this->xmlRet = new FailXMLRet();
        $this->xmlRet->Url = "";

        $Err = "Group named \"".$this->groupName."\" already exist, please use another name!";
        $this->xmlRet->Msg = $Err;
    }

    private function setCmdXmlRetSuccess() {
        $this->xmlRet = new SuccessXMLRet();
        $this->xmlRet->Msg = "";
        $this->xmlRet->Url = "JumpPage.php?Target=" . Target::getAccelerator;
    }

    protected function doAction() {
        if (parent::checkAccStatus())
            $this->doSave();
        else
            parent::setGroupActionCmdXmlRetFail();
    }
}

?>
