<?php

class AccelerateVolumeInfo {

    public $VolumeChar;
    public $VolumeName;
    public $DisplayVolumeName;
    public $HyperPartitionSize;
    public $HyperPartitionSizeKB;
    public $RemainHyperPartionSize;
    public $RemainHyperPartionSizeKB;
    public $RemainHyperPartionSizeKBStr;
    public $AviliableSSDSizeKB;  // * watermark
    public $AviliableSSDSizeKBStr;
    public $FixedSize=0;
    public $FixedSizeKB;
    public $FixedSizeKBStr;
    public $FixedPercentage=0;
    public $ReservedSizeKB=0; //commom file for tmp
    public $ReservedSizeKBStr;
    public $ReservedPercentage=0;
    public $FreeSizeKB;
    public $FreeSizeKBStr;
    public $FreePercentage=0;
    public $AutoSizeKB;
    public $AutoSizeKBStr;
    public $AutoPercentage=0;
    public $RebuildPercentage;
    public $RebuildStatusStr;
    public $WaterMark;
    public $isRebuilding=0;

    public function setVolumeInfo($volume) {
        $volName = $volume->getVolumeName();
        $this->DisplayVolumeName = strtoupper($volName);
        $volName = str_replace("\\\\", "\\", $volName);
        $this->VolumeName = str_replace("\\", "\\\\", $volName);
        $this->VolumeChar = mb_substr( $this->VolumeName, 0,1);
        $this->HyperPartitionSizeKB = floor($volume->getHyperPartitionSize());
        $this->HyperPartitionSize = FormatSize($volume->getHyperPartitionSize());
        $this->RemainHyperPartionSize = FormatSize($volume->getRemainHyperPartionSize());
        $this->RemainHyperPartionSizeKB = floor($volume->getRemainHyperPartionSize());
        $this->RemainHyperPartionSizeKBStr = number_format($volume->getRemainHyperPartionSize());
        $this->RebuildPercentage = $volume->getRebuildPercentage();
        $this->WaterMark = $volume->getWaterMark();
        $this->AviliableSSDSizeKB = floor($this->HyperPartitionSizeKB * $this->WaterMark/100);
        $this->AviliableSSDSizeKBStr = number_format($this->AviliableSSDSizeKB);
        $this->ReservedSizeKB = $volume->getReservedSize();
        
        $appDA = new ApplicationDataAccess();

        //add common file size to reserved ssd size
        $commonApps = $appDA->findByTypeAndVolume(AppType::TYPE_COMMON_FILE, $this->VolumeName);
        if (sizeof($commonApps)){
            $commonApp = array_shift($commonApps);
            $this->ReservedSizeKB += floor($commonApp->getTotalSize());
            $this->ReservedSizeKBStr = number_format($this->ReservedSizeKB);
        }
        if ($this->ReservedSizeKB != 0 && $this->AviliableSSDSizeKB != 0) {
            $this->ReservedPercentage = ($this->ReservedSizeKB/$this->AviliableSSDSizeKB) * 100;
            if ($this->ReservedPercentage > 100) $this->ReservedPercentage = 100;
        }
        $this->ReservedPercentage = number_format($this->ReservedPercentage,0);

        if ($this->ReservedPercentage < 100) {
            $fixedApps = $appDA->findByTypeAndVolume(AppType::TYPE_FIXED,$this->VolumeName);
            $fixedSize = 0;
            $fixedAccedSize = 0;
            foreach ($fixedApps as $app) {
                if (!($app->getAppType() & AppType::TYPE_COMMON_FILE))
                    $fixedSize += intval($app->getTotalSize());
            }
            if (($this->ReservedSizeKB+$fixedSize) >= $this->AviliableSSDSizeKB)
                    $fixedSize = $this->AviliableSSDSizeKB - $this->ReservedSizeKB;
            $this->FixedSize = floor($fixedSize);
            $this->FixedSizeKB = floor($fixedSize);
            $this->FixedSizeKBStr = number_format($fixedSize,0);

            if ($this->FixedSize != 0 && $this->AviliableSSDSizeKB != 0) {
                $this->FixedPercentage = ($this->FixedSize/$this->AviliableSSDSizeKB) * 100;
                if ($this->FixedPercentage > 100) $this->FixedPercentage = 100 - $this->ReservedPercentage;
            }
            $this->FixedPercentage = number_format($this->FixedPercentage,0);

            //$this->FreeSizeKB = $this->RemainHyperPartionSizeKB;
            //$this->AutoSizeKB = $this->AviliableSSDSizeKB - $this->ReservedSizeKB - $this->FixedSizeKB - $this->FreeSizeKB;
            if (($this->ReservedPercentage+$this->FixedPercentage) < 100) {
                $autoApps = $appDA->findByTypeAndVolume(AppType::TYPE_AUTO, $this->VolumeName);
                $autoSize = 0;
                foreach ($autoApps as $app) {
                    $autoSize += intval($app->getTotalSize());
                }
                if (($this->ReservedSizeKB+$this->FixedSizeKB+$autoSize) >= $this->AviliableSSDSizeKB)
                        $autoSize = $this->AviliableSSDSizeKB - $this->ReservedSizeKB - $this->FixedSizeKB;
                $this->AutoSizeKB = floor($autoSize);
                $this->AutoSizeKBStr = number_format($autoSize,0);

                if ($this->AutoSizeKB != 0 && $this->AviliableSSDSizeKB != 0) {
                    $this->AutoPercentage = ($this->AutoSizeKB/$this->AviliableSSDSizeKB) * 100;
                }
                $this->AutoPercentage = number_format($this->AutoPercentage,0);


                $tmpSize=0;
                if ($autoSize < $this->AutoSizeKB) {
                    $tmpSize = $this->AutoSizeKB - floor($autoSize);
                    $this->AutoSizeKB = $autoSize;
                }
                $this->FreeSizeKB = $this->AviliableSSDSizeKB - $this->ReservedSizeKB - $this->FixedSizeKB - $this->AutoSizeKB;
                if ($this->FreeSizeKB < 0) $this->FreeSizeKB = 0;
                $this->FreeSizeKBStr = number_format($this->FreeSizeKB,0);

                $this->FreePercentage = 100 - $this->ReservedPercentage - $this->FixedPercentage - $this->AutoPercentage;
            }

        }

        //$this->AutoSizeKBStr = number_format($this->AutoSizeKB,0);
        //$percentage = $this->ReservedPercentage + $this->FixedPercentage + $this->FreePercentage;
        //if ($percentage < 100)
        //    $this->AutoPercentage = 100 - $percentage;
        
        if ($this->RebuildPercentage == 0 )
            $this->RebuildStatusStr = gettext("N/A");
        else if ($this->RebuildPercentage == 100)
            $this->RebuildStatusStr = gettext("Done");
        else {
            $this->isRebuilding = 1;
            $this->RebuildStatusStr = "Rebuilding " . $this->RebuildPercentage . "%";
        }
    }



}


?>